/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.service.impl;

import cn.gtmap.common.core.support.mybatis.mapper.EntityMapper;
import cn.gtmap.common.core.support.mybatis.page.model.Page;
import cn.gtmap.common.core.support.mybatis.page.repository.Repo;
import cn.gtmap.common.service.BaseService;
import cn.gtmap.common.utils.AnnotationsUtils;
import cn.gtmap.common.utils.ClassUtils;
import com.alibaba.fastjson.JSON;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class BaseServiceImpl<E, ID>
implements BaseService<E, ID> {
    @Autowired
    public EntityMapper entryMapper;
    @Autowired
    public Repo repository;
    private Class<E> entityClass = ClassUtils.getGenericParameter0(this.getClass());

    @Override
    public E findById(ID id) {
        if (id != null) {
            return this.entryMapper.selectByPrimaryKey(this.entityClass, id);
        }
        return null;
    }

    @Override
    public E findByForeignId(String id) {
        if (id != null) {
            return this.entryMapper.selectByForeignKey(this.entityClass, id);
        }
        return null;
    }

    @Override
    public E findByForeignId(String id, String value) {
        if (StringUtils.isNotBlank((CharSequence)id) && StringUtils.isNotBlank((CharSequence)value)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(id, value);
            List<E> list = this.findListByForeignId(map);
            if (CollectionUtils.isNotEmpty(list)) {
                return list.get(0);
            }
        }
        return null;
    }

    @Override
    public <E> List<E> findListByForeignId(Map map) {
        if (map != null) {
            return this.entryMapper.selectListByForeignKey(this.entityClass, map);
        }
        return null;
    }

    @Override
    public <E> List<E> findListByForeignId(String id, String value) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{id}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{value})) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(id, value);
            return this.findListByForeignId(map);
        }
        return null;
    }

    @Override
    public HashMap findMapById(ID id) throws Exception {
        HashMap map = new HashMap();
        if (id != null && StringUtils.isNotBlank((CharSequence)id.toString())) {
            E proj = this.findById(id);
            String jsonStr = JSON.toJSONString(proj);
            map = (HashMap)JSON.parseObject((String)jsonStr, HashMap.class);
        }
        return map;
    }

    @Override
    public HashMap findMapByForeignId(String fkId) throws Exception {
        HashMap map = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)fkId)) {
            E proj = this.findByForeignId(fkId);
            String jsonStr = JSON.toJSONString(proj);
            map = (HashMap)JSON.parseObject((String)jsonStr, HashMap.class);
        }
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insert(E obj) {
        if (obj != null) {
            this.entryMapper.insert(obj);
        }
    }

    @Override
    public void save(E obj) {
        this.insert(obj);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(E obj) {
        if (obj != null) {
            this.entryMapper.updateByPrimaryKey(obj);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delete(E obj) {
        if (obj != null) {
            String id = AnnotationsUtils.getIdKeyValue(obj).toString();
            this.entryMapper.deleteByPrimaryKey(this.entityClass, id);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteById(ID id) {
        if (id != null) {
            this.entryMapper.deleteByPrimaryKey(this.entityClass, id);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByForeignKey(Map map) {
        if (map != null) {
            boolean isOk = true;
            for (Object key : map.keySet()) {
                if (map.get(key) != null && !StringUtils.isBlank((CharSequence)MapUtils.getString((Map)map, key))) continue;
                isOk = false;
                break;
            }
            if (isOk) {
                this.entryMapper.deleteByForeignKey(this.entityClass, map);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByForeignKey(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(key, value);
            this.deleteByForeignKey(map);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByIds(String ids) {
        if (ids != null) {
            String[] id = ids.toString().split(",");
            for (int i = 0; i < id.length; ++i) {
                this.entryMapper.deleteByPrimaryKey(this.entityClass, id[i]);
            }
        }
    }

    @Override
    public <T> Page<T> getPage(String statement, String paramString, Pageable pageable) throws Exception {
        HashMap map = new HashMap();
        if (StringUtils.isNotBlank((CharSequence)paramString)) {
            paramString = URLDecoder.decode(paramString, "UTF-8");
            map.putAll(JSON.parseObject((String)paramString));
        }
        return this.repository.selectPaging(statement, map, pageable);
    }

    @Override
    public <T> List<T> getHashMapList(String statement, HashMap map) throws Exception {
        return this.repository.selectList(statement, map);
    }

    @Override
    public <T> T getHashMap(String statement, HashMap map) throws Exception {
        return this.repository.selectOne(statement, map);
    }

    public <T> T BaseServiceImpl(String statement, HashMap map) throws Exception {
        return this.repository.selectOne(statement, map);
    }
}

