/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.utils;

import cn.gtmap.common.OracleOpera.TableData;
import cn.gtmap.common.OracleOpera.TableField;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateSqlUtil {
    private static String DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    public static String DATABASE_URL = "jdbc:oracle:thin:@10.5.0.176:1521:szgt";
    public static String DATABASE_USER = "gtis_bl";
    public static String DATABASE_PASSWORD = "gtis";
    public static String filePath = "d:/gtis_bl.sql";
    public static List<String> tableNameList;
    private static Connection con;

    private static Connection getConnection() {
        try {
            Class.forName(DRIVER_CLASS);
            con = DriverManager.getConnection(DATABASE_URL, DATABASE_USER, DATABASE_PASSWORD);
            return con;
        }
        catch (Exception ex) {
            System.out.println("2:" + ex.getMessage());
            return con;
        }
    }

    public static void main(String[] args) throws Exception {
        GenerateSqlUtil.createSqlFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSqlFile() throws Exception {
        List<TableData> tableDataList = GenerateSqlUtil.getTableDataList();
        if (CollectionUtils.isNotEmpty(tableDataList)) {
            GenerateSqlUtil.createFiles(filePath);
            File file = new File(filePath);
            BufferedWriter output = new BufferedWriter(new FileWriter(file));
            try {
                output.write("declare tableExist number;");
                output.newLine();
                output.write("begin");
                output.newLine();
                output.newLine();
                for (TableData tableData : tableDataList) {
                    String tmp;
                    TableField tableField;
                    int i;
                    output.write("select count(1) into tableExist from user_tables where table_name='" + tableData.getDATANAME() + "';");
                    output.newLine();
                    output.write("if tableExist=0 then");
                    output.newLine();
                    output.write("execute immediate");
                    output.newLine();
                    output.write("'CREATE TABLE " + tableData.getDATANAME() + "(");
                    output.newLine();
                    List<TableField> fieldList = tableData.getFieldList();
                    if (CollectionUtils.isNotEmpty(fieldList)) {
                        for (i = 0; i < fieldList.size(); ++i) {
                            tableField = fieldList.get(i);
                            tmp = tableField.getCOLUMN_NAME() + " ";
                            tmp = "NUMBER".equals(tableField.getTYPE()) && StringUtils.isBlank((CharSequence)tableField.getPRECISION()) ? tmp + "INTEGER" : tmp + tableField.getTYPE();
                            if ("VARCHAR2".equals(tableField.getTYPE())) {
                                tmp = tmp + "(" + tableField.getLENGTH() + ")";
                            } else if ("NUMBER".equals(tableField.getTYPE()) && StringUtils.isNotBlank((CharSequence)tableField.getPRECISION())) {
                                tmp = "0".equals(tableField.getSCALE()) ? tmp + "(" + tableField.getPRECISION() + ")" : tmp + "(" + tableField.getPRECISION() + "," + tableField.getSCALE() + ")";
                            }
                            if ("N".equals(tableField.getNULLABLE())) {
                                tmp = tmp + " not null";
                            }
                            if (StringUtils.isNotBlank((CharSequence)tableField.getDEFAULT())) {
                                tmp = StringUtils.contains((CharSequence)tableField.getDEFAULT(), (CharSequence)"'") ? tmp + " default '" + tableField.getDEFAULT() + "'" : tmp + " default " + tableField.getDEFAULT() + "";
                            }
                            if (i < fieldList.size() - 1) {
                                tmp = tmp + ",";
                            }
                            output.write(tmp);
                            output.newLine();
                        }
                    }
                    output.write(")';");
                    output.newLine();
                    if (CollectionUtils.isNotEmpty(fieldList)) {
                        for (i = 0; i < fieldList.size(); ++i) {
                            tableField = fieldList.get(i);
                            if (StringUtils.isNotBlank((CharSequence)tableField.getCOMMENTS())) {
                                output.write("execute immediate");
                                output.newLine();
                                output.write("'comment on column " + tableData.getDATANAME() + "." + tableField.getCOLUMN_NAME() + " is ''" + tableField.getCOMMENTS() + "''';");
                                output.newLine();
                            }
                            if (!"Y".equals(tableField.getISPK())) continue;
                            output.write("execute immediate");
                            output.newLine();
                            output.write("'alter table " + tableData.getDATANAME() + " add constraint PK_" + tableData.getDATANAME() + "_ID primary key (" + tableField.getCOLUMN_NAME() + ")';");
                            output.newLine();
                        }
                    }
                    output.write("else");
                    output.newLine();
                    if (CollectionUtils.isNotEmpty(fieldList)) {
                        output.write("declare columnExist number;");
                        output.newLine();
                        output.write("begin");
                        output.newLine();
                        for (i = 0; i < fieldList.size(); ++i) {
                            tableField = fieldList.get(i);
                            output.write("select count(1) into columnExist from user_tab_cols where table_name='" + tableData.getDATANAME() + "' and column_name='" + tableField.getCOLUMN_NAME() + "';");
                            output.newLine();
                            output.write("if columnExist=0 then");
                            output.newLine();
                            output.write("execute immediate");
                            output.newLine();
                            tmp = "'ALTER TABLE " + tableData.getDATANAME() + " ADD " + tableField.getCOLUMN_NAME() + " ";
                            tmp = "NUMBER".equals(tableField.getTYPE()) && StringUtils.isBlank((CharSequence)tableField.getPRECISION()) ? tmp + "INTEGER" : tmp + tableField.getTYPE();
                            if ("VARCHAR2".equals(tableField.getTYPE())) {
                                tmp = tmp + "(" + tableField.getLENGTH() + ")";
                            } else if ("NUMBER".equals(tableField.getTYPE()) && StringUtils.isNotBlank((CharSequence)tableField.getPRECISION())) {
                                tmp = "0".equals(tableField.getSCALE()) ? tmp + "(" + tableField.getPRECISION() + ")" : tmp + "(" + tableField.getPRECISION() + "," + tableField.getSCALE() + ")";
                            }
                            if ("N".equals(tableField.getNULLABLE())) {
                                tmp = tmp + " not null";
                            }
                            if (StringUtils.isNotBlank((CharSequence)tableField.getDEFAULT())) {
                                tmp = StringUtils.contains((CharSequence)tableField.getDEFAULT(), (CharSequence)"'") ? tmp + " default '" + tableField.getDEFAULT() + "'" : tmp + " default " + tableField.getDEFAULT() + "";
                            }
                            tmp = tmp + "';";
                            output.write(tmp);
                            output.newLine();
                            output.write("execute immediate");
                            output.newLine();
                            output.write("'comment on column " + tableData.getDATANAME() + "." + tableField.getCOLUMN_NAME() + " is ''" + tableField.getCOMMENTS() + "''';");
                            output.newLine();
                            if ("Y".equals(tableField.getISPK())) {
                                output.write("execute immediate");
                                output.newLine();
                                output.write("'alter table " + tableData.getDATANAME() + " add constraint PK_" + tableData.getDATANAME() + "_ID primary key (" + tableField.getCOLUMN_NAME() + ")';");
                                output.newLine();
                            }
                            output.write("end if;");
                            output.newLine();
                        }
                        output.write("end;");
                        output.newLine();
                    }
                    output.write("end if;");
                    output.newLine();
                    output.newLine();
                }
                output.write("end;");
                output.newLine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                output.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<TableData> getTableDataList() throws Exception {
        ArrayList<TableData> tableDataList = new ArrayList<TableData>();
        try {
            GenerateSqlUtil.getConnection();
            if (CollectionUtils.isEmpty(tableNameList)) {
                Statement stmt = con.createStatement();
                String sql = "select t.TABLE_NAME,t1.COMMENTS from user_TABLES t,user_tab_comments t1 where t.table_name=t1.table_name order by t.table_name";
                ResultSet rsTables = stmt.executeQuery(sql);
                while (rsTables.next()) {
                    try {
                        String tableName = rsTables.getString("TABLE_NAME");
                        String tableAlias = GenerateSqlUtil.initString(rsTables.getString("COMMENTS"));
                        TableData tableData = GenerateSqlUtil.initTableData(tableName, tableAlias);
                        tableDataList.add(tableData);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                for (String tableName : tableNameList) {
                    Statement stmt = con.createStatement();
                    String sql = "select t.comments from user_tab_comments t where t.table_name='" + StringUtils.upperCase((String)tableName) + "'";
                    ResultSet rsTables = stmt.executeQuery(sql);
                    while (rsTables.next()) {
                        try {
                            String tableAlias = GenerateSqlUtil.initString(rsTables.getString("COMMENTS"));
                            TableData tableData = GenerateSqlUtil.initTableData(tableName, tableAlias);
                            tableDataList.add(tableData);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            con.close();
        }
        return tableDataList;
    }

    private static TableData initTableData(String tableName, String tableAlias) {
        TableData tableData = new TableData();
        try {
            tableData.setDATANAME(tableName);
            tableData.setCOMMENTS(tableAlias);
            ArrayList<TableField> fieldList = new ArrayList<TableField>();
            String fieldsql = " select a.TABLE_NAME,a.COLUMN_NAME,b.comments,a.DATA_LENGTH,a.DATA_TYPE,a.DATA_PRECISION,a.DATA_SCALE, decode(c.column_name,null,'N','Y') as PRIMARY,a.NULLABLE,a.DATA_DEFAULT from all_tab_columns a  left join all_col_comments b on a.Table_Name=b.table_Name and a.column_name=b.column_name left join  ( select a.constraint_name, a.column_name from user_cons_columns a, user_constraints b where a.constraint_name = b.constraint_name      and b.constraint_type = 'P'      and a.table_name = '" + tableName + "' ) c on c.column_name=a.column_name  where    a.Table_Name='" + tableName + "'  and a.owner=b.owner   and a.owner='" + DATABASE_USER.toUpperCase() + "' order by a.COLUMN_ID";
            Statement fieldstmt = con.createStatement();
            ResultSet rs = fieldstmt.executeQuery(fieldsql);
            while (rs.next()) {
                TableField tableField = new TableField();
                tableField.setCOLUMN_NAME(rs.getString("COLUMN_NAME"));
                tableField.setCOMMENTS(GenerateSqlUtil.initString(rs.getString("COMMENTS")));
                tableField.setISPK(rs.getString("PRIMARY"));
                tableField.setLENGTH(rs.getString("DATA_LENGTH"));
                tableField.setPRECISION(rs.getString("DATA_PRECISION"));
                tableField.setSCALE(rs.getString("DATA_SCALE"));
                tableField.setNULLABLE(rs.getString("NULLABLE"));
                tableField.setTYPE(rs.getString("DATA_TYPE"));
                tableField.setDEFAULT(rs.getString("DATA_DEFAULT"));
                fieldList.add(tableField);
            }
            tableData.setFieldList(fieldList);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tableData;
    }

    private static String initString(String comments) {
        if (StringUtils.isBlank((CharSequence)comments)) {
            comments = "";
        }
        comments = StringUtils.replace((String)comments, (String)" ", (String)"");
        comments = StringUtils.replace((String)comments, (String)"\u3000", (String)"");
        comments = StringUtils.replace((String)comments, (String)"\n", (String)"");
        comments = StringUtils.replace((String)comments, (String)"\r", (String)"");
        return comments;
    }

    private static Boolean createFiles(String path) {
        Boolean flag = false;
        File file = null;
        if (!(path.equals("") && path == null || (file = new File(path)).exists())) {
            if (file.isDirectory()) {
                file.mkdirs();
            } else {
                File fileDir = new File(file.getParent());
                fileDir.mkdirs();
                System.out.println("\u4e0a\u5c42\u6587\u4ef6\u5939\uff1a " + fileDir);
                try {
                    flag = file.createNewFile();
                    System.out.println("\u6587\u4ef6\u540d\u79f0\uff1a" + file);
                }
                catch (IOException e) {
                    System.out.println("\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff1a" + e.getLocalizedMessage());
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    static {
        con = null;
    }
}

