/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.core.support.freemarker;

import cn.gtmap.common.utils.Charsets;
import cn.gtmap.common.utils.HtmlUtils;
import freemarker.core.Environment;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FmUtils {
    static BeansWrapper wrapper;

    public static <T> T unwrap(Object obj) throws TemplateModelException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof TemplateModel) {
            return (T)wrapper.unwrap((TemplateModel)obj);
        }
        return (T)obj;
    }

    public static TemplateModel wrap(Object obj) throws TemplateModelException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof TemplateModel) {
            return (TemplateModel)obj;
        }
        return wrapper.wrap(obj);
    }

    public static <T> T getVar(Environment env, String key) throws TemplateModelException {
        return FmUtils.unwrap(env.getVariable(key));
    }

    public static <T> T getVar(Environment env, String key, T def) throws TemplateModelException {
        T value = FmUtils.getVar(env, key);
        return value == null ? def : value;
    }

    public static void setVar(Environment env, String key, Object value) throws TemplateModelException {
        env.setVariable(key, FmUtils.wrap(value));
    }

    public static void delVar(Environment env, String ... keys) throws TemplateModelException {
        for (String key : keys) {
            env.getCurrentNamespace().remove(key);
        }
    }

    public static <T> T getParam(Map params, String key) throws TemplateModelException {
        TemplateModel model = (TemplateModel)params.get(key);
        if (model == null) {
            return null;
        }
        return FmUtils.unwrap(model);
    }

    public static String getString(Map params, String key) throws TemplateModelException {
        TemplateModel model = (TemplateModel)params.get(key);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateScalarModel) {
            return ((TemplateScalarModel)model).getAsString();
        }
        if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber().toString();
        }
        return model.toString();
    }

    public static Integer getInteger(Map params, String key) throws TemplateModelException {
        TemplateModel model = (TemplateModel)params.get(key);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber().intValue();
        }
        try {
            return Integer.valueOf(model instanceof TemplateScalarModel ? ((TemplateScalarModel)model).getAsString() : model.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static Boolean getBoolean(Map params, String key) throws TemplateModelException {
        TemplateModel model = (TemplateModel)params.get(key);
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateBooleanModel) {
            return ((TemplateBooleanModel)model).getAsBoolean();
        }
        if (model instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)model).getAsNumber().intValue() != 0;
        }
        return BooleanUtils.toBooleanObject((String)(model instanceof TemplateScalarModel ? ((TemplateScalarModel)model).getAsString() : model.toString()));
    }

    public static boolean getBoolean(Map params, String key, boolean def) throws TemplateModelException {
        Boolean value = FmUtils.getBoolean(params, key);
        return value == null ? def : value;
    }

    public static String getString(Map params, String key, String def) throws TemplateModelException {
        String value = FmUtils.getString(params, key);
        return StringUtils.isEmpty((CharSequence)value) ? def : value;
    }

    public static void includeTpl(String tplName, Map<String, Object> params, Environment env) throws IOException, TemplateException {
        if (!CollectionUtils.isEmpty(params)) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                env.setVariable(entry.getKey(), FmUtils.wrap(entry.getValue()));
            }
        }
        env.include(tplName, Charsets.UTF8, true);
        if (!CollectionUtils.isEmpty(params)) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                FmUtils.delVar(env, entry.getKey());
            }
        }
    }

    public static String renderBody(TemplateDirectiveBody body) throws IOException, TemplateException {
        if (body == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        body.render((Writer)sw);
        return sw.toString();
    }

    public static void append(StringBuilder sb, String key, Object value) {
        if (value != null) {
            sb.append(" ").append(key).append("=\"").append(value).append("\"");
        }
    }

    public static void appendE(StringBuilder sb, String key, Object value) {
        if (value != null) {
            sb.append(" ").append(key).append("=\"").append(HtmlUtils.escape(value)).append("\"");
        }
    }

    public static void appendUE(StringBuilder sb, String key, Object value) throws TemplateModelException {
        if (value != null) {
            sb.append(" ").append(key).append("=\"").append(HtmlUtils.escape(FmUtils.unwrap(value))).append("\"");
        }
    }
}

