/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.core.support.datasource;

import cn.gtmap.common.core.support.datasource.DataSource;
import cn.gtmap.common.core.support.datasource.DynamicDataSourceHolder;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceAspect {
    public void intercept(JoinPoint point) throws Exception {
        Class<?> target = point.getTarget().getClass();
        MethodSignature signature = (MethodSignature)point.getSignature();
        for (Class<?> clazz : target.getInterfaces()) {
            this.resolveDataSource(clazz, signature.getMethod());
        }
        this.resolveDataSource(target, signature.getMethod());
    }

    private void resolveDataSource(Class<?> clazz, Method method) {
        try {
            Method m;
            Class<?>[] types = method.getParameterTypes();
            if (clazz.isAnnotationPresent(DataSource.class)) {
                DataSource source = clazz.getAnnotation(DataSource.class);
                DynamicDataSourceHolder.setDataSource(source.value());
            }
            if ((m = clazz.getMethod(method.getName(), types)) != null && m.isAnnotationPresent(DataSource.class)) {
                DataSource source = m.getAnnotation(DataSource.class);
                DynamicDataSourceHolder.setDataSource(source.value());
            }
        }
        catch (Exception e) {
            System.out.println(clazz + ":" + e.getMessage());
        }
    }
}

