/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.core.ex;

import cn.gtmap.common.core.ex.Sourceable;
import cn.gtmap.common.utils.HtmlUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Source
implements Sourceable,
Serializable {
    public static int LINE = 8;
    public static final String CALL_LINK = "http://localhost:8091/?message=%s:%s:%s";
    private static final long serialVersionUID = 1338916470790937007L;
    private String title;
    private String description;
    private String file;
    private List<String> lines = Collections.emptyList();
    private int lineNumber;
    private int columNumber;

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    @Override
    public List<String> getLines() {
        return this.lines;
    }

    public void setLines(List<String> lines) {
        this.lines = lines;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getColumNumber() {
        return this.columNumber;
    }

    public void setColumNumber(int columNumber) {
        this.columNumber = columNumber;
    }

    public List<String> getViewLines() {
        int len = this.lines.size();
        if (len == 0) {
            return Collections.emptyList();
        }
        int from = this.lineNumber - LINE > 0 && this.lineNumber <= len ? this.lineNumber - LINE : 1;
        int to = this.lineNumber + LINE < len ? this.lineNumber + LINE : len;
        ArrayList list = Lists.newArrayList();
        for (int i = from; i <= to; ++i) {
            String line = this.lines.get(i - 1);
            String link = String.format(CALL_LINK, this.file, i, i == this.lineNumber ? this.columNumber : 1);
            list.add("<div class=\"line" + (i == this.lineNumber ? " error" : "") + "\"><span class=\"lineNumber\">" + i + "</span><pre><a href=\"" + link + "\" onclick=\"return cl(this);\">&nbsp;" + HtmlUtils.escape(line) + "</a></pre></div>");
        }
        return list;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

