/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.common.OracleOpera;

import cn.gtmap.common.OracleOpera.TableData;
import cn.gtmap.common.OracleOpera.TableField;
import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTable {
    private static final String entityPath = "d://cn/gtmap/busi/model/";
    private static final String packagePath = "cn.gtmap.busi.model";
    private static final String DRIVER_CLASS = "oracle.jdbc.driver.OracleDriver";
    private static final String DATABASE_URL = "jdbc:oracle:thin:@127.0.0.1:1521:orcl";
    private static final String DATABASE_USER = "gtis_test";
    private static final String DATABASE_PASSWORD = "gtis_test";
    private static Connection con = null;
    private static HashMap<String, String> fieldTypeMap = new HashMap();

    public static Connection getConnection() {
        try {
            Class.forName(DRIVER_CLASS);
            con = DriverManager.getConnection(DATABASE_URL, "gtis_test", "gtis_test");
            return con;
        }
        catch (Exception ex) {
            System.out.println("2:" + ex.getMessage());
            return con;
        }
    }

    public static void main(String[] args) throws SQLException {
        fieldTypeMap = OracleTable.initFieldTypeMap();
        HashMap<String, String> tableMap = new HashMap<String, String>();
        tableMap.put("SQ_REL_BDCDJ_GD", "\u4e0d\u52a8\u4ea7\u767b\u8bb0\u4fe1\u606f\u8868");
        tableMap.put("SQ_BDCDJ", "\u52d8\u6d4b\u5b9a\u754c\u6210\u679c\u8868");
        OracleTable.createEntityOrXmlByTableMap(false, tableMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createAllEntityOrXml(boolean createXml) throws SQLException {
        ArrayList<TableData> tableDataList = new ArrayList<TableData>();
        try {
            OracleTable.getConnection();
            Statement stmt = con.createStatement();
            String sql = "select t.TABLE_NAME,t1.COMMENTS from user_TABLES t,user_tab_comments t1 where t.table_name=t1.table_name  order by t.table_name";
            System.out.println(sql);
            ResultSet rsTables = stmt.executeQuery(sql);
            while (rsTables.next()) {
                try {
                    String tableName = rsTables.getString("TABLE_NAME");
                    String tableAlias = OracleTable.initString(rsTables.getString("COMMENTS"));
                    if (StringUtils.startsWith((CharSequence)tableName, (CharSequence)"C")) break;
                    TableData tableData = OracleTable.initTableData(tableName, tableAlias);
                    tableDataList.add(tableData);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println(JSON.toJSONString(tableDataList));
            if (createXml) {
                OracleTable.initList2Xml(tableDataList);
            }
            OracleTable.initList2Entity(tableDataList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            con.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createEntityOrXmlByTableMap(boolean createXml, HashMap<String, String> tableMap) throws SQLException {
        ArrayList<TableData> tableDataList = new ArrayList<TableData>();
        try {
            OracleTable.getConnection();
            for (Map.Entry<String, String> entry : tableMap.entrySet()) {
                String tableName = entry.getKey();
                String tableAlias = OracleTable.initString(entry.getValue());
                TableData tableData = OracleTable.initTableData(tableName, tableAlias);
                tableDataList.add(tableData);
                System.out.println(JSON.toJSONString(tableDataList));
            }
            if (createXml) {
                OracleTable.initList2Xml(tableDataList);
            }
            OracleTable.initList2Entity(tableDataList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            con.close();
        }
    }

    public static TableData initTableData(String tableName, String tableAlias) {
        TableData tableData = new TableData();
        try {
            tableData.setDATANAME(tableName);
            tableData.setCOMMENTS(tableAlias);
            tableData.setVO_NAME("cn.gtmap.busi.model." + OracleTable.getLowerTableName(tableName, true));
            ArrayList<TableField> fieldList = new ArrayList<TableField>();
            String fieldsql = " select a.TABLE_NAME,a.COLUMN_NAME,b.comments,a.DATA_LENGTH,a.DATA_TYPE,a.DATA_PRECISION,a.DATA_SCALE, decode(c.column_name,null,'N','Y') as PRIMARY,a.NULLABLE from all_tab_columns a  left join all_col_comments b on a.Table_Name=b.table_Name and a.column_name=b.column_name left join  ( select a.constraint_name, a.column_name from user_cons_columns a, user_constraints b where a.constraint_name = b.constraint_name      and b.constraint_type = 'P'      and a.table_name = '" + tableName + "' " + ") c on c.column_name=a.column_name " + " where  " + "  a.Table_Name='" + tableName + "' " + " and a.owner=b.owner  " + " and a.owner='" + "gtis_test".toUpperCase() + "'" + " order by a.COLUMN_ID";
            System.out.println(fieldsql);
            Statement fieldstmt = con.createStatement();
            ResultSet rs = fieldstmt.executeQuery(fieldsql);
            while (rs.next()) {
                Integer length;
                TableField tableField = new TableField();
                tableField.setCOLUMN_NAME(rs.getString("COLUMN_NAME"));
                tableField.setCOMMENTS(OracleTable.initString(rs.getString("COMMENTS")));
                tableField.setISPK(rs.getString("PRIMARY"));
                tableField.setLENGTH(rs.getString("DATA_LENGTH"));
                tableField.setPRECISION(rs.getString("DATA_PRECISION"));
                tableField.setSCALE(rs.getString("DATA_SCALE"));
                tableField.setNULLABLE(rs.getString("NULLABLE"));
                tableField.setTYPE(rs.getString("DATA_TYPE"));
                if (StringUtils.equalsIgnoreCase((CharSequence)tableField.getTYPE(), (CharSequence)"VARCHAR2") && StringUtils.equalsIgnoreCase((CharSequence)tableField.getISPK(), (CharSequence)"N") && StringUtils.isNotBlank((CharSequence)tableField.getLENGTH()) && (length = Integer.valueOf(Integer.parseInt(tableField.getLENGTH()))) < 2000) {
                    tableField.setLENGTH(String.valueOf(length * 2));
                }
                fieldList.add(tableField);
            }
            tableData.setFieldList(fieldList);
            System.out.println(tableName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tableData;
    }

    public static void initList2Xml(List<TableData> tableDataList) {
        Document document = DocumentHelper.createDocument();
        Element rootEle = DocumentHelper.createElement((String)"REPORT");
        rootEle.addAttribute("FRNAME", "\u5efa\u8bbe\u7528\u5730\u62a5\u4ef6\u4ea4\u6362\u683c\u5f0f");
        rootEle.addAttribute("PATH", "/");
        rootEle.addAttribute("REPORTNAME", "");
        rootEle.addAttribute("VERSION", "7.0");
        document.setRootElement(rootEle);
        if (tableDataList != null && !tableDataList.isEmpty()) {
            for (int i = 0; i < tableDataList.size(); ++i) {
                try {
                    TableData tableData = tableDataList.get(i);
                    Element dataEle = DocumentHelper.createElement((String)"DATA");
                    Class<TableData> objClass = TableData.class;
                    Field[] fields = objClass.getDeclaredFields();
                    for (int j = 0; j < fields.length; ++j) {
                        Field field = fields[j];
                        if (StringUtils.equalsIgnoreCase((CharSequence)field.getName(), (CharSequence)"fieldList")) continue;
                        Method method = objClass.getDeclaredMethod("get" + field.getName(), new Class[0]);
                        Object objvalue = method.invoke((Object)tableData, new Object[0]);
                        dataEle.addAttribute(field.getName(), objvalue == null ? "" : objvalue.toString());
                    }
                    Element fieldEle = DocumentHelper.createElement((String)"FIELDS");
                    List<TableField> fieldList = tableData.getFieldList();
                    if (fieldList != null && !fieldList.isEmpty()) {
                        for (int j = 0; j < fieldList.size(); ++j) {
                            TableField tableField = fieldList.get(j);
                            Element columnEle = DocumentHelper.createElement((String)"COLUMN");
                            Class<TableField> fieldClass = TableField.class;
                            Field[] fieldFields = fieldClass.getDeclaredFields();
                            for (int k = 0; k < fieldFields.length; ++k) {
                                Field field = fieldFields[k];
                                Method method = fieldClass.getDeclaredMethod("get" + field.getName(), new Class[0]);
                                Object objvalue = method.invoke((Object)tableField, new Object[0]);
                                columnEle.addAttribute(field.getName(), objvalue == null ? "" : objvalue.toString());
                            }
                            fieldEle.add(columnEle);
                        }
                    }
                    dataEle.add(fieldEle);
                    Element rowEle = DocumentHelper.createElement((String)"ROWDATA");
                    String sql = "select t.* from " + tableData.getDATANAME();
                    Statement fieldstmt = con.createStatement();
                    ResultSet rs = fieldstmt.executeQuery(sql);
                    while (rs.next()) {
                        for (int j = 0; j < fieldList.size(); ++j) {
                            TableField tableField = fieldList.get(j);
                            String value = rs.getString(tableField.getCOLUMN_NAME());
                            if (StringUtils.isBlank((CharSequence)value)) {
                                value = "";
                            }
                            rowEle.addAttribute(tableField.getCOLUMN_NAME(), value);
                        }
                    }
                    dataEle.add(rowEle);
                    rootEle.add(dataEle);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        System.out.println(document.asXML());
    }

    public static void initList2Entity(List<TableData> tableDataList) {
        if (tableDataList != null && !tableDataList.isEmpty()) {
            for (int i = 0; i < tableDataList.size(); ++i) {
                FileOutputStream fileOutputStream;
                String filePath;
                StringBuffer javaContentBuffer;
                String entityName;
                TableData tableData;
                try {
                    tableData = tableDataList.get(i);
                    entityName = StringUtils.replace((String)tableData.getVO_NAME(), (String)"cn.gtmap.busi.model.", (String)"");
                    javaContentBuffer = new StringBuffer();
                    javaContentBuffer.append("package cn.gtmap.busi.model;\n");
                    javaContentBuffer.append("\n");
                    javaContentBuffer.append("import javax.persistence.Id;\n");
                    javaContentBuffer.append("import javax.persistence.Table;\n");
                    javaContentBuffer.append("import java.io.Serializable;\n");
                    javaContentBuffer.append("import java.math.BigDecimal;\n");
                    javaContentBuffer.append("import java.util.Date;\n");
                    javaContentBuffer.append("\n");
                    javaContentBuffer.append("/**\n");
                    javaContentBuffer.append(" * " + tableData.getCOMMENTS() + "\n");
                    javaContentBuffer.append(" */\n");
                    javaContentBuffer.append("@Table(name = \"" + tableData.getDATANAME() + "\")\n");
                    javaContentBuffer.append("public class " + entityName + " implements Serializable {\n");
                    StringBuffer javaFunctionBuffer = new StringBuffer();
                    List<TableField> fieldList = tableData.getFieldList();
                    if (fieldList != null && !fieldList.isEmpty()) {
                        for (int j = 0; j < fieldList.size(); ++j) {
                            TableField tableField = fieldList.get(j);
                            if (StringUtils.equalsIgnoreCase((CharSequence)tableField.getISPK(), (CharSequence)"Y")) {
                                javaContentBuffer.append("    @Id\n");
                            }
                            String fieldType = fieldTypeMap.get(tableField.getTYPE());
                            if (StringUtils.equalsIgnoreCase((CharSequence)tableField.getTYPE(), (CharSequence)"NUMBER") && (StringUtils.equalsIgnoreCase((CharSequence)tableField.getSCALE(), (CharSequence)"0") || StringUtils.isBlank((CharSequence)tableField.getSCALE()))) {
                                fieldType = fieldTypeMap.get("INTEGER");
                            }
                            String lowerColumnName = OracleTable.getLowerColumnName(tableField.getCOLUMN_NAME(), true);
                            javaContentBuffer.append("    private " + fieldType + " " + lowerColumnName + ";");
                            if (StringUtils.isNotBlank((CharSequence)tableField.getCOMMENTS())) {
                                javaContentBuffer.append("//" + tableField.getCOMMENTS());
                            }
                            javaContentBuffer.append("\n\n");
                            String method = OracleTable.getLowerColumnName(tableField.getCOLUMN_NAME(), false);
                            String functionName = tableField.getCOLUMN_NAME().substring(0, 1) + lowerColumnName.substring(1, lowerColumnName.length());
                            javaFunctionBuffer.append("    public " + fieldType + " get" + functionName + "() {\n");
                            javaFunctionBuffer.append("        return " + lowerColumnName + ";\n");
                            javaFunctionBuffer.append("    }\n");
                            javaFunctionBuffer.append("\n");
                            javaFunctionBuffer.append("    public void set" + functionName + "(" + fieldType + " " + lowerColumnName + ") {\n");
                            javaFunctionBuffer.append("        this." + lowerColumnName + " = " + lowerColumnName + ";\n");
                            javaFunctionBuffer.append("    }\r\n");
                            javaFunctionBuffer.append("\n");
                        }
                    }
                    javaContentBuffer.append(javaFunctionBuffer);
                    javaContentBuffer.append("}");
                    System.out.println(javaContentBuffer.toString());
                    String filePath2 = entityPath + entityName + ".java";
                    OracleTable.createFiles(filePath2);
                    FileOutputStream fileOutputStream2 = new FileOutputStream(filePath2);
                    fileOutputStream2.write(javaContentBuffer.toString().getBytes("UTF-8"));
                    fileOutputStream2.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    tableData = tableDataList.get(i);
                    entityName = StringUtils.replace((String)tableData.getVO_NAME(), (String)"cn.gtmap.busi.model.", (String)"");
                    javaContentBuffer = new StringBuffer();
                    javaContentBuffer.append("package cn.gtmap.busi.model;\n");
                    javaContentBuffer.append("\n");
                    javaContentBuffer.append("import cn.gtmap.common.core.support.mybatis.mapper.Example;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.model.*;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.service.*;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.service.impl.*;\n");
                    javaContentBuffer.append("import cn.gtmap.common.service.*;\n");
                    javaContentBuffer.append("import cn.gtmap.common.service.impl.*;\n");
                    javaContentBuffer.append("import com.alibaba.fastjson.JSON;\n");
                    javaContentBuffer.append("import org.apache.commons.lang.StringUtils;\n");
                    javaContentBuffer.append("import org.springframework.data.domain.Pageable;\n");
                    javaContentBuffer.append("import org.springframework.stereotype.Component;\n");
                    javaContentBuffer.append("import java.util.*;\n");
                    javaContentBuffer.append("\n");
                    javaContentBuffer.append("/**\n");
                    javaContentBuffer.append(" * " + tableData.getCOMMENTS() + "\n");
                    javaContentBuffer.append(" */\n");
                    javaContentBuffer.append("public interface " + entityName + "Service  extends BaseService<" + entityName + ", String> {\n");
                    javaContentBuffer.append("}");
                    System.out.println(javaContentBuffer.toString());
                    filePath = entityPath + entityName + "Service.java";
                    OracleTable.createFiles(filePath);
                    fileOutputStream = new FileOutputStream(filePath);
                    fileOutputStream.write(javaContentBuffer.toString().getBytes("UTF-8"));
                    fileOutputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    tableData = tableDataList.get(i);
                    entityName = StringUtils.replace((String)tableData.getVO_NAME(), (String)"cn.gtmap.busi.model.", (String)"");
                    javaContentBuffer = new StringBuffer();
                    javaContentBuffer.append("package cn.gtmap.busi.service.impl;\n");
                    javaContentBuffer.append("\n");
                    javaContentBuffer.append("import cn.gtmap.common.core.support.mybatis.mapper.Example;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.model.*;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.service.*;\n");
                    javaContentBuffer.append("import cn.gtmap.busi.service.impl.*;\n");
                    javaContentBuffer.append("import cn.gtmap.common.service.*;\n");
                    javaContentBuffer.append("import cn.gtmap.common.service.impl.*;\n");
                    javaContentBuffer.append("import com.alibaba.fastjson.JSON;\n");
                    javaContentBuffer.append("import org.apache.commons.lang.StringUtils;\n");
                    javaContentBuffer.append("import org.springframework.data.domain.Pageable;\n");
                    javaContentBuffer.append("import org.springframework.stereotype.Component;\n");
                    javaContentBuffer.append("import java.util.*;\n");
                    javaContentBuffer.append("\n");
                    javaContentBuffer.append("/**\n");
                    javaContentBuffer.append(" * " + tableData.getCOMMENTS() + "\n");
                    javaContentBuffer.append(" */\n");
                    javaContentBuffer.append("@Component\n");
                    javaContentBuffer.append("public class " + entityName + "ServiceImpl extends BaseServiceImpl<" + entityName + ", String> implements " + entityName + "Service {\n");
                    javaContentBuffer.append("}");
                    System.out.println(javaContentBuffer.toString());
                    filePath = entityPath + entityName + "ServiceImpl.java";
                    OracleTable.createFiles(filePath);
                    fileOutputStream = new FileOutputStream(filePath);
                    fileOutputStream.write(javaContentBuffer.toString().getBytes("UTF-8"));
                    fileOutputStream.close();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String initString(String comments) {
        if (StringUtils.isBlank((CharSequence)comments)) {
            comments = "";
        }
        comments = StringUtils.replace((String)comments, (String)" ", (String)"");
        comments = StringUtils.replace((String)comments, (String)"\u3000", (String)"");
        comments = StringUtils.replace((String)comments, (String)"\n", (String)"");
        comments = StringUtils.replace((String)comments, (String)"\r", (String)"");
        return comments;
    }

    public static String getLowerTableName(String upperColumnName, boolean isRemoveTS) {
        if (isRemoveTS) {
            if (upperColumnName.startsWith("T_")) {
                upperColumnName = upperColumnName.replaceFirst("T_", "");
            }
            if (upperColumnName.startsWith("S_")) {
                upperColumnName = upperColumnName.replaceFirst("S_", "");
            }
            if (upperColumnName.startsWith("SB_")) {
                upperColumnName = upperColumnName.replaceFirst("SB_", "");
            }
        }
        String lowerColumnName = upperColumnName.toLowerCase();
        if (upperColumnName.indexOf("_") > -1) {
            lowerColumnName = "";
            String[] _Arrays = upperColumnName.substring(1, upperColumnName.length()).split("_");
            lowerColumnName = lowerColumnName + upperColumnName.substring(0, 1);
            lowerColumnName = lowerColumnName + _Arrays[0].toLowerCase();
            for (int i = 1; i < _Arrays.length; ++i) {
                lowerColumnName = lowerColumnName + _Arrays[i].substring(0, 1) + _Arrays[i].substring(1, _Arrays[i].length()).toLowerCase();
            }
        }
        return lowerColumnName;
    }

    public static String getLowerColumnName(String upperColumnName, boolean isRemove_) {
        String lowerColumnName = upperColumnName.toLowerCase();
        if (isRemove_ && upperColumnName.indexOf("_") > -1) {
            lowerColumnName = "";
            String[] _Arrays = upperColumnName.split("_");
            lowerColumnName = lowerColumnName + _Arrays[0].toLowerCase();
            for (int i = 1; i < _Arrays.length; ++i) {
                lowerColumnName = lowerColumnName + _Arrays[i].substring(0, 1) + _Arrays[i].substring(1, _Arrays[i].length()).toLowerCase();
            }
        }
        BigDecimal bigDecimal = new BigDecimal(0);
        return lowerColumnName;
    }

    public static HashMap<String, String> initFieldTypeMap() {
        HashMap<String, String> fieldTypeMap = new HashMap<String, String>();
        fieldTypeMap.put("VARCHAR2", "String");
        fieldTypeMap.put("DATE", "Date");
        fieldTypeMap.put("NUMBER", "BigDecimal");
        fieldTypeMap.put("FLOAT", "BigDecimal");
        fieldTypeMap.put("CLOB", "byte[]");
        fieldTypeMap.put("INTEGER", "Integer");
        fieldTypeMap.put("CHAR", "String");
        fieldTypeMap.put("TIMESTAMP(6)", "Date");
        return fieldTypeMap;
    }

    public static Boolean createFiles(String path) {
        Boolean flag = false;
        File file = null;
        if (!path.equals("") || path != null) {
            file = new File(path);
            if (!file.exists()) {
                if (file.isDirectory()) {
                    file.mkdirs();
                } else {
                    File fileDir = new File(file.getParent());
                    fileDir.mkdirs();
                    System.out.println("\u4e0a\u5c42\u6587\u4ef6\u5939\uff1a " + fileDir);
                    try {
                        flag = file.createNewFile();
                        System.out.println("\u6587\u4ef6\u540d\u79f0\uff1a" + file);
                    }
                    catch (IOException e) {
                        System.out.println("\u521b\u5efa\u6587\u4ef6\u5931\u8d25\uff1a" + e.getLocalizedMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                System.out.println("\u3010" + path + "\u3011\uff1a" + "\u8be5\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728");
            }
        }
        return flag;
    }
}

