/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.pkg.container;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.lingala.zip4j.ZipFile;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.ofdrw.core.basicStructure.ofd.DocBody;
import org.ofdrw.core.basicStructure.ofd.OFD;
import org.ofdrw.core.basicType.ST_Loc;
import org.ofdrw.pkg.container.DocDir;
import org.ofdrw.pkg.container.VirtualContainer;

public class OFDDir
extends VirtualContainer {
    public static final String OFDFileName = "OFD.xml";
    private int maxDocIndex = 0;

    public static OFDDir newOFD() {
        try {
            Path tempDirectory = Files.createTempDirectory("ofd-tmp-", new FileAttribute[0]);
            return new OFDDir(tempDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("\u65e0\u6cd5\u521b\u5efaOFD\u865a\u62df\u5bb9\u5668\u5de5\u4f5c\u7a7a\u95f4\uff0c\u539f\u56e0\uff1a" + e.getMessage(), e);
        }
    }

    public OFDDir(Path fullDir) throws IllegalArgumentException {
        super(fullDir);
        this.initContainer();
    }

    private void initContainer() {
        File fullDirFile = new File(this.getSysAbsPath());
        File[] files = fullDirFile.listFiles();
        if (files != null) {
            for (File f : files) {
                String numb;
                int num;
                if (!f.getName().startsWith("Doc_") || this.maxDocIndex > (num = Integer.parseInt(numb = f.getName().replace("Doc_", "")))) continue;
                this.maxDocIndex = num + 1;
            }
        }
    }

    public OFD getOfd() throws FileNotFoundException, DocumentException {
        Element obj = this.getObj(OFDFileName);
        return new OFD(obj);
    }

    public OFDDir setOfd(OFD ofd) {
        this.putObj(OFDFileName, (Element)ofd);
        return this;
    }

    public DocDir newDoc() {
        String name = "Doc_" + this.maxDocIndex;
        ++this.maxDocIndex;
        return this.obtainContainer(name, DocDir::new);
    }

    public DocDir obtainDoc(int index) {
        String name = "Doc_" + index;
        if (index >= this.maxDocIndex) {
            this.maxDocIndex = index + 1;
        }
        return this.obtainContainer(name, DocDir::new);
    }

    public DocDir getDocByIndex(int index) throws FileNotFoundException {
        String name = "Doc_" + index;
        return this.getContainer(name, DocDir::new);
    }

    public DocDir getDocDir(String name) throws FileNotFoundException {
        return this.getContainer(name, DocDir::new);
    }

    public DocDir obtainDocDefault() {
        if (this.exit(OFDFileName)) {
            try {
                OFD ofd = this.getOfd();
                DocBody docBody = ofd.getDocBody();
                if (docBody != null) {
                    ST_Loc docRoot = docBody.getDocRoot();
                    return this.obtainContainer(docRoot.parent(), DocDir::new);
                }
            }
            catch (FileNotFoundException | DocumentException e) {
                throw new RuntimeException("OFD.xml \u6587\u4ef6\u89e3\u6790\u5931\u8d25");
            }
        }
        return this.obtainDoc(0);
    }

    public void jar(OutputStream outStream) throws IOException {
        if (outStream == null) {
            throw new IllegalArgumentException("\u751f\u6210OFD\u6587\u4ef6\u8f93\u51fa\u6d41\uff08outStream\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.flush();
        ZipOutputStream zip = new ZipOutputStream(outStream);
        FileTime fileTime = FileTime.fromMillis(System.currentTimeMillis());
        this.zip(this.getSysAbsPath(), "", fileTime, zip);
        zip.finish();
        outStream.flush();
    }

    private void zip(String workDirPath, String dir, FileTime fileTime, ZipOutputStream zip) throws IOException {
        File[] files = new File(workDirPath).listFiles();
        if (files == null) {
            throw new RuntimeException("\u76ee\u5f55\u4e2d\u6ca1\u6709\u4efb\u4f55\u6587\u4ef6\u65e0\u6cd5\u6253\u5305");
        }
        for (File f : files) {
            String entryName = f.getName();
            if (dir != null && !"".equals(dir)) {
                entryName = dir + entryName;
            }
            if (f.isDirectory()) {
                entryName = entryName + "/";
            }
            this.putEntry(zip, fileTime, entryName);
            if (f.isDirectory()) {
                this.zip(f.getAbsolutePath(), entryName, fileTime, zip);
                continue;
            }
            this.writeStream(zip, f);
        }
    }

    private void writeStream(ZipOutputStream zip, File f) throws IOException {
        try (BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(f));){
            int i;
            byte[] buffer = new byte[1024];
            while ((i = ((InputStream)fileStream).read(buffer)) > 0) {
                zip.write(buffer, 0, i);
            }
            zip.flush();
            zip.closeEntry();
        }
    }

    private void putEntry(ZipOutputStream zip, FileTime fileTime, String entryName) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        entry.setCreationTime(fileTime);
        entry.setLastAccessTime(fileTime);
        entry.setLastModifiedTime(fileTime);
        zip.putNextEntry(entry);
    }

    public void jar(Path filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("\u751f\u6210OFD\u6587\u4ef6\u8def\u5f84\uff08fileName\uff09\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Files.exists(filePath, new LinkOption[0])) {
            Files.delete(filePath);
        }
        this.flush();
        String fullOfFilePath = filePath.toAbsolutePath().toString();
        this.zip(this.getSysAbsPath(), fullOfFilePath);
    }

    private void zip(String workDirPath, String fullOfFilePath) throws IOException {
        ZipFile ofdFile = new ZipFile(fullOfFilePath);
        File[] files = new File(workDirPath).listFiles();
        if (files == null) {
            throw new RuntimeException("\u76ee\u5f55\u4e2d\u6ca1\u6709\u4efb\u4f55\u6587\u4ef6\u65e0\u6cd5\u6253\u5305");
        }
        for (File f : files) {
            if (f.isDirectory()) {
                ofdFile.addFolder(f);
                continue;
            }
            ofdFile.addFile(f);
        }
    }
}

