/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.layout.element.canvas;

import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import org.ofdrw.core.basicStructure.pageObj.layer.PageBlockType;
import org.ofdrw.core.basicStructure.pageObj.layer.block.CT_PageBlock;
import org.ofdrw.core.basicStructure.pageObj.layer.block.ImageObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.PathObject;
import org.ofdrw.core.basicStructure.pageObj.layer.block.TextObject;
import org.ofdrw.core.basicType.ST_Array;
import org.ofdrw.core.basicType.ST_Box;
import org.ofdrw.core.basicType.ST_ID;
import org.ofdrw.core.graph.pathObj.AbbreviatedData;
import org.ofdrw.core.graph.pathObj.CT_Path;
import org.ofdrw.core.pageDescription.color.color.CT_Color;
import org.ofdrw.core.pageDescription.drawParam.LineCapType;
import org.ofdrw.core.pageDescription.drawParam.LineJoinType;
import org.ofdrw.core.text.TextCode;
import org.ofdrw.core.text.text.CT_Text;
import org.ofdrw.core.text.text.Direction;
import org.ofdrw.core.text.text.Weight;
import org.ofdrw.font.Font;
import org.ofdrw.layout.element.canvas.CanvasState;
import org.ofdrw.layout.element.canvas.ClipFactory;
import org.ofdrw.layout.element.canvas.DrawParamCache;
import org.ofdrw.layout.element.canvas.FontSetting;
import org.ofdrw.layout.element.canvas.MeasureBody;
import org.ofdrw.layout.element.canvas.TextAlign;
import org.ofdrw.layout.element.canvas.TextMeasureTool;
import org.ofdrw.layout.element.canvas.TextMetrics;
import org.ofdrw.layout.engine.ResManager;

public class DrawContext
implements Closeable {
    private CT_PageBlock container;
    private AtomicInteger maxUnitID;
    private ResManager resManager;
    private CT_Path workPathObj = null;
    private AbbreviatedData pathData = null;
    private ST_Box boundary;
    private CanvasState state;
    private LinkedList<CanvasState> stack;

    private DrawContext() {
    }

    public DrawContext(CT_PageBlock container, ST_Box boundary, AtomicInteger maxUnitID, ResManager resManager) {
        this.container = container;
        this.boundary = boundary;
        this.maxUnitID = maxUnitID;
        this.resManager = resManager;
        this.state = new CanvasState();
        this.stack = new LinkedList();
    }

    private CT_Path newPathWithCtx() {
        CT_Path path = (CT_Path)new CT_Path().setBoundary(this.boundary.clone());
        if (this.state.ctm != null) {
            path.setCTM(this.state.ctm);
        }
        if (this.state.clipFactory != null) {
            path.setClips(this.state.clipFactory.clips());
        }
        if (this.state.globalAlpha != null) {
            path.setAlpha(Integer.valueOf((int)(255.0 * this.state.globalAlpha)));
        }
        return path;
    }

    public DrawContext beginPath() {
        if (this.workPathObj != null) {
            this.flush2Canvas();
            this.workPathObj = null;
        }
        this.workPathObj = this.newPathWithCtx();
        this.pathData = new AbbreviatedData();
        return this;
    }

    public DrawContext closePath() {
        if (this.workPathObj == null) {
            return this;
        }
        this.pathData.close();
        return this;
    }

    public DrawContext clip() {
        if (this.workPathObj == null) {
            return this;
        }
        if (this.state.clipFactory == null) {
            this.state.clipFactory = new ClipFactory();
        }
        if (this.state.ctm != null) {
            this.state.clipFactory.setCtm(this.state.ctm.clone());
        }
        this.state.clipFactory.setData(this.pathData.clone());
        return this;
    }

    public DrawContext moveTo(double x, double y) {
        if (this.workPathObj == null) {
            this.beginPath();
        }
        this.pathData.moveTo(x, y);
        return this;
    }

    public DrawContext lineTo(double x, double y) {
        if (this.workPathObj == null) {
            return this;
        }
        this.pathData.lineTo(x, y);
        return this;
    }

    public DrawContext quadraticCurveTo(double cpx, double cpy, double x, double y) {
        if (this.workPathObj == null) {
            return this;
        }
        this.pathData.quadraticBezier(cpx, cpy, x, y);
        return this;
    }

    public DrawContext bezierCurveTo(double cp1x, double cp1y, double cp2x, double cp2y, double x, double y) {
        if (this.workPathObj == null) {
            return this;
        }
        this.pathData.cubicBezier(cp1x, cp1y, cp2x, cp2y, x, y);
        return this;
    }

    public DrawContext arc(double a, double b, double angle, boolean large, boolean sweep, double x, double y) {
        if (this.workPathObj == null) {
            return this;
        }
        this.pathData.arc(a, b, angle % 360.0, large ? 1 : 0, sweep ? 1 : 0, x, y);
        return this;
    }

    public DrawContext arc(double x, double y, double r, double sAngle, double eAngle, boolean counterclockwise) {
        if (this.workPathObj == null) {
            return this;
        }
        double x1 = x + r * Math.cos(sAngle * Math.PI / 180.0);
        double y1 = y + r * Math.sin(sAngle * Math.PI / 180.0);
        this.moveTo(x1, y1);
        double angle = eAngle - sAngle;
        if (angle == 360.0) {
            this.pathData.arc(r, r, angle, 1, counterclockwise ? 1 : 0, x - r, y).arc(r, r, angle, 1, counterclockwise ? 1 : 0, x1, y1);
        } else {
            double x2 = x + r * Math.cos(eAngle * Math.PI / 180.0);
            double y2 = y + r * Math.sin(eAngle * Math.PI / 180.0);
            this.pathData.arc(r, r, angle, angle > 180.0 ? 1 : 0, counterclockwise ? 1 : 0, x2, y2);
        }
        return this;
    }

    public DrawContext arc(double x, double y, double r, double sAngle, double eAngle) {
        return this.arc(x, y, r, sAngle, eAngle, true);
    }

    public DrawContext rect(double x, double y, double width, double height) {
        if (this.workPathObj == null) {
            this.beginPath();
        }
        this.pathData.moveTo(x, y).lineTo(x + width, y).lineTo(x + width, y + height).lineTo(x, y + height).close();
        return this;
    }

    public DrawContext fillRect(double x, double y, double width, double height) {
        this.beginPath();
        this.rect(x, y, width, height).fill();
        this.flush2Canvas();
        return this;
    }

    public DrawContext strokeRect(double x, double y, double width, double height) {
        this.beginPath();
        this.rect(x, y, width, height).stroke();
        this.flush2Canvas();
        return this;
    }

    public DrawContext stroke() {
        if (this.workPathObj == null) {
            return this;
        }
        ((CT_Path)this.workPathObj.setLineWidth(Double.valueOf(this.state.lineWidth))).setStroke(Boolean.valueOf(true));
        if (this.state.strokeColor != null) {
            this.workPathObj.setStrokeColor(CT_Color.rgb((int[])this.state.strokeColor));
        }
        return this;
    }

    public DrawContext fill() {
        if (this.workPathObj == null) {
            return this;
        }
        this.workPathObj.setFill(Boolean.valueOf(true));
        if (this.state.fillColor != null) {
            this.workPathObj.setFillColor(CT_Color.rgb((int[])this.state.fillColor));
        }
        return this;
    }

    public DrawContext scale(double scalewidth, double scaleheight) {
        if (this.state.ctm == null) {
            this.state.ctm = ST_Array.unitCTM();
        }
        ST_Array scale = new ST_Array(new Serializable[]{Double.valueOf(scalewidth), Integer.valueOf(0), Integer.valueOf(0), Double.valueOf(scaleheight), Integer.valueOf(0), Integer.valueOf(0)});
        this.state.ctm = scale.mtxMul(this.state.ctm);
        if (this.workPathObj != null) {
            this.workPathObj.setCTM(this.state.ctm);
        }
        return this;
    }

    public DrawContext rotate(double angle) {
        if (this.state.ctm == null) {
            this.state.ctm = ST_Array.unitCTM();
        }
        double alpha = angle * Math.PI / 180.0;
        ST_Array r = new ST_Array(new Serializable[]{Double.valueOf(Math.cos(alpha)), Double.valueOf(Math.sin(alpha)), Double.valueOf(-Math.sin(alpha)), Double.valueOf(Math.cos(alpha)), Integer.valueOf(0), Integer.valueOf(0)});
        this.state.ctm = r.mtxMul(this.state.ctm);
        if (this.workPathObj != null) {
            this.workPathObj.setCTM(this.state.ctm);
        }
        return this;
    }

    public DrawContext translate(double x, double y) {
        if (this.state.ctm == null) {
            this.state.ctm = ST_Array.unitCTM();
        }
        ST_Array r = new ST_Array(new Serializable[]{Integer.valueOf(1), Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1), Double.valueOf(x), Double.valueOf(y)});
        this.state.ctm = r.mtxMul(this.state.ctm);
        if (this.workPathObj != null) {
            this.workPathObj.setCTM(this.state.ctm);
        }
        return this;
    }

    public DrawContext transform(double a, double b, double c, double d, double e, double f) {
        if (this.state.ctm == null) {
            this.state.ctm = ST_Array.unitCTM();
        }
        ST_Array r = new ST_Array(new Serializable[]{Double.valueOf(a), Double.valueOf(b), Double.valueOf(c), Double.valueOf(d), Double.valueOf(e), Double.valueOf(f)});
        this.state.ctm = r.mtxMul(this.state.ctm);
        if (this.workPathObj != null) {
            this.workPathObj.setCTM(this.state.ctm);
        }
        return this;
    }

    public DrawContext setTransform(double a, double b, double c, double d, double e, double f) {
        this.state.ctm = new ST_Array(new Serializable[]{Double.valueOf(a), Double.valueOf(b), Double.valueOf(c), Double.valueOf(d), Double.valueOf(e), Double.valueOf(f)});
        if (this.workPathObj != null) {
            this.workPathObj.setCTM(this.state.ctm);
        }
        return this;
    }

    public DrawContext drawImage(Path img, double x, double y, double width, double height) throws IOException {
        if (img == null || Files.notExists(img, new LinkOption[0])) {
            throw new IOException("\u56fe\u7247(img)\u4e0d\u5b58\u5728");
        }
        ST_ID id = this.resManager.addImage(img);
        ImageObject imgObj = new ImageObject((long)this.maxUnitID.incrementAndGet());
        imgObj.setResourceID(id.ref());
        imgObj.setBoundary(this.boundary.clone());
        ST_Array ctm = this.state.ctm == null ? ST_Array.unitCTM() : this.state.ctm;
        ctm = new ST_Array(new Serializable[]{Double.valueOf(width), Integer.valueOf(0), Integer.valueOf(0), Double.valueOf(height), Double.valueOf(x), Double.valueOf(y)}).mtxMul(ctm);
        imgObj.setCTM(ctm);
        if (this.state.globalAlpha != null) {
            imgObj.setAlpha(Integer.valueOf((int)(255.0 * this.state.globalAlpha)));
        }
        this.container.addPageBlock((PageBlockType)imgObj);
        return this;
    }

    public DrawContext save() {
        this.stack.push(this.state.clone());
        return this;
    }

    public DrawContext restore() {
        if (this.stack.isEmpty()) {
            return this;
        }
        this.state = this.stack.pop();
        return this;
    }

    public DrawContext fillText(String text, double x, double y) throws IOException {
        if (text == null || text.trim().isEmpty()) {
            return this;
        }
        int readDirection = this.state.font.getReadDirection();
        int charDirection = this.state.font.getCharDirection();
        Font font = this.state.font.getFont();
        Double fontSize = this.state.font.getFontSize();
        ST_ID id = this.resManager.addFont(font);
        TextObject txtObj = ((CT_Text)new CT_Text().setBoundary(this.boundary.clone())).setFont(id.ref()).setSize(fontSize).toObj(new ST_ID((long)this.maxUnitID.incrementAndGet()));
        if (this.state.font.getFontWeight() != null && this.state.font.getFontWeight() != 400) {
            txtObj.setWeight(Weight.getInstance((int)this.state.font.getFontWeight()));
        }
        if (this.state.font.isItalic()) {
            txtObj.setItalic(Boolean.valueOf(true));
        }
        if (this.state.fillColor != null) {
            txtObj.setFillColor(CT_Color.rgb((int[])this.state.fillColor));
        }
        if (this.state.ctm != null) {
            txtObj.setCTM(this.state.ctm.clone());
        }
        if (this.state.globalAlpha != null && this.state.globalAlpha != 1.0) {
            txtObj.setAlpha(Integer.valueOf((int)(255.0 * this.state.globalAlpha)));
        }
        if (readDirection != 0) {
            txtObj.setReadDirection(Direction.getInstance((Integer)readDirection));
        }
        if (charDirection != 0) {
            txtObj.setCharDirection(Direction.getInstance((Integer)charDirection));
        }
        MeasureBody measureBody = TextMeasureTool.measureWithWith(text, this.state.font);
        double xx = x + measureBody.firstCharOffsetX;
        double yy = y + measureBody.firstCharOffsetY;
        switch (readDirection) {
            case 0: 
            case 180: {
                xx += this.textFloatFactor(this.state.font.getTextAlign(), measureBody.width, readDirection);
                break;
            }
            case 90: 
            case 270: {
                yy += this.textFloatFactor(this.state.font.getTextAlign(), measureBody.width, readDirection);
            }
        }
        TextCode tcSTTxt = new TextCode().setContent(text).setX(Double.valueOf(xx)).setY(Double.valueOf(yy));
        if (readDirection == 90 || readDirection == 270) {
            tcSTTxt.setDeltaY(measureBody.offset);
        } else {
            tcSTTxt.setDeltaX(measureBody.offset);
        }
        txtObj.addTextCode(tcSTTxt);
        this.container.addPageBlock((PageBlockType)txtObj);
        return this;
    }

    private double textFloatFactor(TextAlign align, double width, int readDirection) {
        double factor = 0.0;
        switch (align) {
            case start: 
            case left: {
                factor = 0.0;
                break;
            }
            case end: 
            case right: {
                factor = -width;
                break;
            }
            case center: {
                factor = -width / 2.0;
            }
        }
        if (readDirection == 180 || readDirection == 270) {
            factor = -factor;
        }
        return factor;
    }

    public TextAlign getTextAlign() {
        return this.state.font.getTextAlign();
    }

    public DrawContext setTextAlign(TextAlign textAlign) {
        this.state.font.setTextAlign(textAlign);
        return this;
    }

    public TextMetrics measureText(String text) {
        TextMetrics tm = new TextMetrics();
        tm.readDirection = this.state.font.getReadDirection();
        tm.fontSize = this.state.font.getFontSize();
        Double[] offset = TextMeasureTool.measure(text, this.state.font);
        if (offset.length == 0) {
            tm.width = 0.0;
            return tm;
        }
        tm.width = TextMeasureTool.measureWithWith((String)text, (FontSetting)this.state.font).width;
        return tm;
    }

    public int[] getStrokeColor() {
        return (int[])this.state.strokeColor.clone();
    }

    public DrawContext setStrokeColor(int[] strokeColor) {
        if (strokeColor == null) {
            return this;
        }
        this.state.strokeColor = strokeColor;
        if (this.workPathObj != null) {
            this.workPathObj.setStrokeColor(CT_Color.rgb((int[])strokeColor));
        }
        return this;
    }

    public DrawContext setStrokeColor(int r, int g, int b) {
        return this.setStrokeColor(new int[]{r, g, b});
    }

    public int[] getFillColor() {
        return (int[])this.state.fillColor.clone();
    }

    public DrawContext setFillColor(int[] fillColor) {
        if (fillColor == null) {
            return this;
        }
        this.state.fillColor = fillColor;
        if (this.workPathObj != null) {
            this.workPathObj.setFillColor(CT_Color.rgb((int[])fillColor));
        }
        return this;
    }

    public DrawContext setFillColor(int r, int g, int b) {
        return this.setFillColor(new int[]{r, g, b});
    }

    public double getLineWidth() {
        return this.state.lineWidth;
    }

    public DrawContext setLineWidth(double lineWidth) {
        this.state.lineWidth = lineWidth;
        if (this.workPathObj != null) {
            this.workPathObj.setLineWidth(Double.valueOf(lineWidth));
        }
        return this;
    }

    public FontSetting getFont() {
        return this.state.font;
    }

    public DrawContext setFont(FontSetting font) {
        this.state.font = font;
        return this;
    }

    public Double getGlobalAlpha() {
        return this.state.globalAlpha;
    }

    public DrawContext setGlobalAlpha(Double globalAlpha) {
        if (globalAlpha == null || globalAlpha > 1.0) {
            globalAlpha = 1.0;
        } else if (globalAlpha < 0.0) {
            globalAlpha = 0.0;
        }
        this.state.globalAlpha = globalAlpha;
        return this;
    }

    public DrawContext setLineCap(LineCapType cap) {
        if (cap == null) {
            return this;
        }
        this.state.obtainDrawParamCache().setCap(cap);
        return this;
    }

    public LineCapType getLineCap() {
        if (this.state.drawParamCache == null) {
            return LineCapType.Butt;
        }
        LineCapType cap = this.state.drawParamCache.getCap();
        return cap == null ? LineCapType.Butt : cap;
    }

    public DrawContext setLineJoin(LineJoinType join) {
        if (join == null) {
            return this;
        }
        this.state.obtainDrawParamCache().setJoin(join);
        return this;
    }

    public LineJoinType getLineJoin() {
        if (this.state.drawParamCache == null) {
            return LineJoinType.Miter;
        }
        LineJoinType join = this.state.drawParamCache.getJoin();
        return join == null ? LineJoinType.Miter : join;
    }

    public DrawContext setMiterLimit(Double miterLimit) {
        if (miterLimit == null) {
            return this;
        }
        this.state.obtainDrawParamCache().setMiterLimit(miterLimit);
        return this;
    }

    public Double getMiterLimit() {
        if (this.state.drawParamCache == null) {
            return 3.528;
        }
        Double miterLimit = this.state.drawParamCache.getMiterLimit();
        return miterLimit == null ? 3.528 : miterLimit;
    }

    public DrawContext setLineDash(Double dashOffset, Double[] pattern) {
        if (pattern == null || pattern.length < 2) {
            throw new IllegalArgumentException("\u865a\u7ebf\u7684\u7ebf\u6bb5\u957f\u5ea6\u548c\u95f4\u9694\u957f\u5ea6(pattern)\uff0c\u4e0d\u80fd\u4e3a\u7a7a\u5e76\u4e14\u9700\u8981\u5927\u4e8e\u4e24\u4e2a\u4ee5\u4e0a\u7684\u503c");
        }
        DrawParamCache drawParam = this.state.obtainDrawParamCache().setDashPattern(new ST_Array((Serializable[])pattern));
        if (dashOffset != null) {
            drawParam.setDashOffset(dashOffset);
        }
        return this;
    }

    public DrawContext setLineDash(Double ... pattern) {
        return this.setLineDash((Double)null, pattern);
    }

    public ST_Array getDashPattern() {
        if (this.state.drawParamCache == null) {
            return null;
        }
        return this.state.drawParamCache.getDashPattern();
    }

    public Double getDashOffset() {
        if (this.state.drawParamCache == null) {
            return null;
        }
        return this.state.drawParamCache.getDashOffset();
    }

    private void flush2Canvas() {
        if (this.workPathObj == null) {
            return;
        }
        if (this.workPathObj.getStroke().booleanValue() || this.workPathObj.getFill().booleanValue()) {
            PathObject tbAdded = this.workPathObj.setAbbreviatedData(this.pathData).toObj(new ST_ID((long)this.maxUnitID.incrementAndGet()));
            if (this.state.drawParamCache != null) {
                ST_ID paramObjId = this.state.drawParamCache.addToResource(this.resManager);
                tbAdded.setDrawParam(paramObjId.ref());
            }
            this.container.addPageBlock((PageBlockType)tbAdded);
        }
        this.workPathObj = null;
        this.pathData = null;
    }

    @Override
    public void close() {
        if (this.workPathObj == null) {
            return;
        }
        this.flush2Canvas();
    }
}

