/*
 * Decompiled with CFR 0.152.
 */
package org.ofdrw.gm.cert;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class PKCS12Tools {
    public static PrivateKey ReadPrvKey(Path userP12, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
        try (InputStream rootKsIn = Files.newInputStream(userP12, new OpenOption[0]);){
            ks.load(rootKsIn, pwd.toCharArray());
            String alias = ks.aliases().nextElement();
            PrivateKey privateKey = (PrivateKey)ks.getKey(alias, pwd.toCharArray());
            return privateKey;
        }
    }

    public static PrivateKey ReadPrvKey(Path userP12, String alias, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
        try (InputStream rootKsIn = Files.newInputStream(userP12, new OpenOption[0]);){
            ks.load(rootKsIn, pwd.toCharArray());
            PrivateKey privateKey = (PrivateKey)ks.getKey(alias, pwd.toCharArray());
            return privateKey;
        }
    }

    public static Certificate[] ReadCertChain(Path userP12, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
        try (InputStream rootKsIn = Files.newInputStream(userP12, new OpenOption[0]);){
            ks.load(rootKsIn, pwd.toCharArray());
            String alias = ks.aliases().nextElement();
            Certificate[] certificateArray = ks.getCertificateChain(alias);
            return certificateArray;
        }
    }

    public static Certificate[] ReadCertChain(Path userP12, String alias, String pwd) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
        try (InputStream rootKsIn = Files.newInputStream(userP12, new OpenOption[0]);){
            ks.load(rootKsIn, pwd.toCharArray());
            Certificate[] certificateArray = ks.getCertificateChain(alias);
            return certificateArray;
        }
    }

    public static Certificate ReadUserCert(Path userP12, String pwd) throws GeneralSecurityException, IOException {
        return PKCS12Tools.ReadCertChain(userP12, pwd)[0];
    }

    public static Certificate ReadUserCert(Path userP12, String alias, String pwd) throws GeneralSecurityException, IOException {
        return PKCS12Tools.ReadCertChain(userP12, alias, pwd)[0];
    }
}

