/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.memory.cqengine.query;

import com.googlecode.cqengine.attribute.Attribute;
import com.googlecode.cqengine.attribute.SimpleAttribute;
import com.googlecode.cqengine.query.option.QueryOptions;
import com.googlecode.cqengine.query.simple.SimpleQuery;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;

public class Intersects<O, A extends Geometry>
extends SimpleQuery<O, A> {
    private final Attribute<O, A> attribute;
    private final A value;

    public Intersects(Attribute<O, A> attribute, A value) {
        super(attribute);
        this.attribute = attribute;
        this.value = value;
    }

    public Envelope getEnvelope() {
        return this.value.getEnvelopeInternal();
    }

    protected boolean matchesSimpleAttribute(SimpleAttribute<O, A> attribute, O object, QueryOptions queryOptions) {
        Geometry attributeValue = (Geometry)attribute.getValue(object, queryOptions);
        return this.matchesValue(attributeValue, queryOptions);
    }

    protected boolean matchesNonSimpleAttribute(Attribute<O, A> attribute, O object, QueryOptions queryOptions) {
        Iterable attributeValues = attribute.getValues(object, queryOptions);
        for (Geometry attributeValue : attributeValues) {
            if (!this.matchesValue(attributeValue, queryOptions)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesValue(A aValue, QueryOptions queryOptions) {
        return this.value.intersects(aValue);
    }

    public String toString() {
        return "intersects(" + this.attribute.getAttributeName() + ", " + this.value.toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Intersects that = (Intersects)((Object)o);
        if (!this.attribute.equals(that.attribute)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    protected int calcHashCode() {
        int result = this.attribute.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

