/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.analyzer;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;
import org.lionsoul.jcseg.tokenizer.core.SegmentFactory;

public class JcsegTokenizer
extends Tokenizer {
    private ISegment segmentor;
    private final CharTermAttributeImpl termAtt = (CharTermAttributeImpl)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private int fieldOffset = 0;

    public JcsegTokenizer(int mode, JcsegTaskConfig config, ADictionary dic) throws JcsegException, IOException {
        this.segmentor = SegmentFactory.createJcseg((int)mode, (Object[])new Object[]{config, dic});
        this.segmentor.reset(this.input);
    }

    public final boolean incrementToken() throws IOException {
        IWord word = this.segmentor.next();
        if (word == null) {
            this.fieldOffset = this.offsetAtt.endOffset();
            return false;
        }
        this.clearAttributes();
        this.termAtt.clear();
        this.termAtt.append(word.getValue());
        this.offsetAtt.setOffset(this.correctOffset(this.fieldOffset + word.getPosition()), this.correctOffset(this.fieldOffset + word.getPosition() + word.getLength()));
        this.typeAtt.setType("word");
        return true;
    }

    public void end() throws IOException {
        super.end();
        this.offsetAtt.setOffset(this.fieldOffset, this.fieldOffset);
        this.fieldOffset = 0;
    }

    public void reset() throws IOException {
        super.reset();
        this.segmentor.reset(this.input);
    }
}

