/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Service;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ClusterMetricsBuilder;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ReplicationPeerNotFoundException;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.ServerMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionStatesCount;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.ExecutorType;
import org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hadoop.hbase.favored.FavoredNodesPromoter;
import org.apache.hadoop.hbase.http.InfoServer;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.master.ActiveMasterManager;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.ClusterSchema;
import org.apache.hadoop.hbase.master.ClusterSchemaService;
import org.apache.hadoop.hbase.master.ClusterSchemaServiceImpl;
import org.apache.hadoop.hbase.master.ClusterStatusPublisher;
import org.apache.hadoop.hbase.master.DrainingServerTracker;
import org.apache.hadoop.hbase.master.ExpiredMobFileCleanerChore;
import org.apache.hadoop.hbase.master.HMasterCommandLine;
import org.apache.hadoop.hbase.master.HbckChore;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterDumpServlet;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterMetaBootstrap;
import org.apache.hadoop.hbase.master.MasterMobCompactionThread;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.MasterStatusServlet;
import org.apache.hadoop.hbase.master.MasterWalManager;
import org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hadoop.hbase.master.MetricsMasterWrapperImpl;
import org.apache.hadoop.hbase.master.MirroringTableStateManager;
import org.apache.hadoop.hbase.master.MobCompactionChore;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionServerTracker;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.SnapshotOfRegionAssignmentFromMeta;
import org.apache.hadoop.hbase.master.SplitOrMergeTracker;
import org.apache.hadoop.hbase.master.SplitWALManager;
import org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.MergeTableRegionsProcedure;
import org.apache.hadoop.hbase.master.assignment.MoveRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.master.assignment.UnassignProcedure;
import org.apache.hadoop.hbase.master.balancer.BalancerChore;
import org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import org.apache.hadoop.hbase.master.balancer.ClusterStatusChore;
import org.apache.hadoop.hbase.master.balancer.LoadBalancerFactory;
import org.apache.hadoop.hbase.master.cleaner.DirScanPool;
import org.apache.hadoop.hbase.master.cleaner.HFileCleaner;
import org.apache.hadoop.hbase.master.cleaner.LogCleaner;
import org.apache.hadoop.hbase.master.cleaner.ReplicationBarrierCleaner;
import org.apache.hadoop.hbase.master.locking.LockManager;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizer;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerChore;
import org.apache.hadoop.hbase.master.normalizer.RegionNormalizerFactory;
import org.apache.hadoop.hbase.master.procedure.CreateTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteNamespaceProcedure;
import org.apache.hadoop.hbase.master.procedure.DeleteTableProcedure;
import org.apache.hadoop.hbase.master.procedure.DisableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.EnableTableProcedure;
import org.apache.hadoop.hbase.master.procedure.InitMetaProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.ModifyTableProcedure;
import org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hadoop.hbase.master.procedure.RecoverMetaProcedure;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.master.procedure.TruncateTableProcedure;
import org.apache.hadoop.hbase.master.replication.AddPeerProcedure;
import org.apache.hadoop.hbase.master.replication.DisablePeerProcedure;
import org.apache.hadoop.hbase.master.replication.EnablePeerProcedure;
import org.apache.hadoop.hbase.master.replication.ModifyPeerProcedure;
import org.apache.hadoop.hbase.master.replication.RemovePeerProcedure;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.master.replication.UpdatePeerConfigProcedure;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.master.zksyncer.MasterAddressSyncer;
import org.apache.hadoop.hbase.master.zksyncer.MetaLocationSyncer;
import org.apache.hadoop.hbase.monitoring.MemoryBoundedLogMessageBuffer;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.procedure.MasterProcedureManagerHost;
import org.apache.hadoop.hbase.procedure.flush.MasterFlushTableProcedureManager;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.quotas.MasterQuotasObserver;
import org.apache.hadoop.hbase.quotas.QuotaObserverChore;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SnapshotQuotaObserverChore;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotNotifier;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotNotifierFactory;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationLoadSource;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.replication.master.ReplicationHFileCleaner;
import org.apache.hadoop.hbase.replication.master.ReplicationLogCleaner;
import org.apache.hadoop.hbase.replication.master.ReplicationPeerConfigUpgrader;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationStatus;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hadoop.hbase.util.Addressing;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.IdLock;
import org.apache.hadoop.hbase.util.ModifyRegionUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.RetryCounter;
import org.apache.hadoop.hbase.util.RetryCounterFactory;
import org.apache.hadoop.hbase.util.TableDescriptorChecker;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.LoadBalancerTracker;
import org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import org.apache.hadoop.hbase.zookeeper.RegionNormalizerTracker;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hadoop.util.VersionInfo;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
public class HMaster
extends HRegionServer
implements MasterServices {
    private static Logger LOG = LoggerFactory.getLogger(HMaster.class);
    public static final String MASTER = "master";
    private final ActiveMasterManager activeMasterManager;
    private RegionServerTracker regionServerTracker;
    private DrainingServerTracker drainingServerTracker;
    LoadBalancerTracker loadBalancerTracker;
    MetaLocationSyncer metaLocationSyncer;
    MasterAddressSyncer masterAddressSyncer;
    private SplitOrMergeTracker splitOrMergeTracker;
    private RegionNormalizerTracker regionNormalizerTracker;
    private ClusterSchemaService clusterSchemaService;
    public static final String HBASE_MASTER_WAIT_ON_SERVICE_IN_SECONDS = "hbase.master.wait.on.service.seconds";
    public static final int DEFAULT_HBASE_MASTER_WAIT_ON_SERVICE_IN_SECONDS = 300;
    final MetricsMaster metricsMaster;
    private MasterFileSystem fileSystemManager;
    private MasterWalManager walManager;
    private SplitWALManager splitWALManager;
    private volatile ServerManager serverManager;
    private AssignmentManager assignmentManager;
    private ReplicationPeerManager replicationPeerManager;
    MemoryBoundedLogMessageBuffer rsFatals;
    private volatile boolean activeMaster = false;
    private final ProcedureEvent<?> initialized = new ProcedureEvent((Object)"master initialized");
    volatile boolean serviceStarted = false;
    private final int maxBlancingTime;
    private final double maxRitPercent;
    private final LockManager lockManager = new LockManager(this);
    private LoadBalancer balancer;
    private RegionNormalizer normalizer;
    private BalancerChore balancerChore;
    private RegionNormalizerChore normalizerChore;
    private ClusterStatusChore clusterStatusChore;
    private ClusterStatusPublisher clusterStatusPublisherChore = null;
    private HbckChore hbckChore;
    CatalogJanitor catalogJanitorChore;
    private DirScanPool cleanerPool;
    private LogCleaner logCleaner;
    private HFileCleaner hfileCleaner;
    private ReplicationBarrierCleaner replicationBarrierCleaner;
    private ExpiredMobFileCleanerChore expiredMobFileCleanerChore;
    private MobCompactionChore mobCompactChore;
    private MasterMobCompactionThread mobCompactThread;
    private final IdLock mobCompactionLock = new IdLock();
    private Map<TableName, AtomicInteger> mobCompactionStates = Maps.newConcurrentMap();
    MasterCoprocessorHost cpHost;
    private final boolean preLoadTableDescriptors;
    private long masterActiveTime;
    private long masterFinishedInitializationTime;
    Map<String, Service> coprocessorServiceHandlers = Maps.newHashMap();
    SnapshotManager snapshotManager;
    private MasterProcedureManagerHost mpmHost;
    private volatile MasterQuotaManager quotaManager;
    private SpaceQuotaSnapshotNotifier spaceQuotaSnapshotNotifier;
    private QuotaObserverChore quotaObserverChore;
    private SnapshotQuotaObserverChore snapshotQuotaChore;
    private ProcedureExecutor<MasterProcedureEnv> procedureExecutor;
    private WALProcedureStore procedureStore;
    private TableStateManager tableStateManager;
    private long splitPlanCount;
    private long mergePlanCount;
    private FavoredNodesManager favoredNodesManager;
    private Server masterJettyServer;
    private final boolean maintenanceMode;
    static final String MAINTENANCE_MODE = "hbase.master.maintenance_mode";
    private static final ImmutableSet<Class<? extends Procedure>> UNSUPPORTED_PROCEDURES = ImmutableSet.of(RecoverMetaProcedure.class, AssignProcedure.class, UnassignProcedure.class, MoveRegionProcedure.class);

    public HMaster(Configuration conf) throws IOException, KeeperException {
        super(conf);
        TraceUtil.initTracer((Configuration)conf);
        try {
            if (conf.getBoolean(MAINTENANCE_MODE, false)) {
                LOG.info("Detected {}=true via configuration.", (Object)MAINTENANCE_MODE);
                this.maintenanceMode = true;
            } else if (Boolean.getBoolean(MAINTENANCE_MODE)) {
                LOG.info("Detected {}=true via environment variables.", (Object)MAINTENANCE_MODE);
                this.maintenanceMode = true;
            } else {
                this.maintenanceMode = false;
            }
            this.rsFatals = new MemoryBoundedLogMessageBuffer(conf.getLong("hbase.master.buffer.for.rs.fatals", 0x100000L));
            LOG.info("hbase.rootdir=" + this.getRootDir() + ", hbase.cluster.distributed=" + this.conf.getBoolean("hbase.cluster.distributed", false));
            this.conf.setBoolean("hbase.meta.replicas.use", false);
            HMaster.decorateMasterConfiguration(this.conf);
            if (this.conf.get("mapreduce.task.attempt.id") == null) {
                this.conf.set("mapreduce.task.attempt.id", "hb_m_" + this.serverName.toString());
            }
            this.metricsMaster = new MetricsMaster(new MetricsMasterWrapperImpl(this));
            this.preLoadTableDescriptors = conf.getBoolean("hbase.master.preload.tabledescriptors", true);
            this.maxBlancingTime = this.getMaxBalancingTime();
            this.maxRitPercent = conf.getDouble("hbase.master.balancer.maxRitPercent", 1.0);
            boolean shouldPublish = conf.getBoolean("hbase.status.published", false);
            Class publisherClass = conf.getClass("hbase.status.publisher.class", ClusterStatusPublisher.DEFAULT_STATUS_PUBLISHER_CLASS, ClusterStatusPublisher.Publisher.class);
            if (shouldPublish) {
                if (publisherClass == null) {
                    LOG.warn("hbase.status.published is true, but " + ClusterStatusPublisher.DEFAULT_STATUS_PUBLISHER_CLASS + " is not set - not publishing status");
                } else {
                    this.clusterStatusPublisherChore = new ClusterStatusPublisher(this, conf, publisherClass);
                    this.getChoreService().scheduleChore((ScheduledChore)this.clusterStatusPublisherChore);
                }
            }
            this.activeMasterManager = !conf.getBoolean("hbase.testing.nocluster", false) ? new ActiveMasterManager(this.zooKeeper, this.serverName, this) : null;
        }
        catch (Throwable t) {
            LOG.error("Failed construction of Master", t);
            throw t;
        }
    }

    @Override
    protected String getUseThisHostnameInstead(Configuration conf) {
        return conf.get("hbase.master.hostname");
    }

    @Override
    public void run() {
        try {
            if (!this.conf.getBoolean("hbase.testing.nocluster", false)) {
                Threads.setDaemonThreadRunning((Thread)new Thread(() -> {
                    block2: {
                        try {
                            int infoPort = this.putUpJettyServer();
                            this.startActiveMasterManager(infoPort);
                        }
                        catch (Throwable t) {
                            String error = "Failed to become Active Master";
                            LOG.error(error, t);
                            if (this.isAborted()) break block2;
                            this.abort(error, t);
                        }
                    }
                }), (String)(this.getName() + ":becomeActiveMaster"));
            }
            super.run();
        }
        finally {
            if (this.clusterSchemaService != null) {
                this.clusterSchemaService.stopAsync();
                try {
                    this.clusterSchemaService.awaitTerminated(this.getConfiguration().getInt(HBASE_MASTER_WAIT_ON_SERVICE_IN_SECONDS, 300), TimeUnit.SECONDS);
                }
                catch (TimeoutException te) {
                    LOG.warn("Failed shutdown of clusterSchemaService", (Throwable)te);
                }
            }
            this.activeMaster = false;
        }
    }

    private int putUpJettyServer() throws IOException {
        if (!this.conf.getBoolean("hbase.master.infoserver.redirect", true)) {
            return -1;
        }
        int infoPort = this.conf.getInt("hbase.master.info.port.orig", 16010);
        if (infoPort < 0 || this.infoServer == null) {
            return -1;
        }
        if (infoPort == this.infoServer.getPort()) {
            return infoPort;
        }
        String addr = this.conf.get("hbase.master.info.bindAddress", "0.0.0.0");
        if (!Addressing.isLocalAddress((InetAddress)InetAddress.getByName(addr))) {
            String msg = "Failed to start redirecting jetty server. Address " + addr + " does not belong to this host. Correct configuration parameter: hbase.master.info.bindAddress";
            LOG.error(msg);
            throw new IOException(msg);
        }
        this.masterJettyServer = new Server();
        ServerConnector connector = new ServerConnector(this.masterJettyServer);
        connector.setHost(addr);
        connector.setPort(infoPort);
        this.masterJettyServer.addConnector((Connector)connector);
        this.masterJettyServer.setStopAtShutdown(true);
        String redirectHostname = StringUtils.isBlank((CharSequence)this.useThisHostnameInstead) ? null : this.useThisHostnameInstead;
        RedirectServlet redirect = new RedirectServlet(this.infoServer, redirectHostname);
        WebAppContext context = new WebAppContext(null, "/", null, null, null, null, 0);
        context.addServlet(new ServletHolder((Servlet)redirect), "/*");
        context.setServer(this.masterJettyServer);
        try {
            this.masterJettyServer.start();
        }
        catch (Exception e) {
            throw new IOException("Failed to start redirecting jetty server", e);
        }
        return connector.getLocalPort();
    }

    @Override
    protected Function<TableDescriptorBuilder, TableDescriptorBuilder> getMetaTableObserver() {
        return builder -> builder.setRegionReplication(this.conf.getInt("hbase.meta.replica.count", 1));
    }

    @Override
    protected void login(UserProvider user, String host) throws IOException {
        try {
            super.login(user, host);
        }
        catch (IOException ie) {
            user.login("hbase.master.keytab.file", "hbase.master.kerberos.principal", host);
        }
    }

    @Override
    protected void waitForMasterActive() {
        if (this.maintenanceMode) {
            return;
        }
        boolean tablesOnMaster = LoadBalancer.isTablesOnMaster(this.conf);
        while (!(tablesOnMaster && this.activeMaster || this.isStopped() || this.isAborted())) {
            this.sleeper.sleep();
        }
    }

    @VisibleForTesting
    public MasterRpcServices getMasterRpcServices() {
        return (MasterRpcServices)this.rpcServices;
    }

    public boolean balanceSwitch(boolean b) throws IOException {
        return this.getMasterRpcServices().switchBalancer(b, MasterRpcServices.BalanceSwitchMode.ASYNC);
    }

    @Override
    protected String getProcessName() {
        return MASTER;
    }

    @Override
    protected boolean canCreateBaseZNode() {
        return true;
    }

    @Override
    protected boolean canUpdateTableDescriptor() {
        return true;
    }

    @Override
    protected RSRpcServices createRpcServices() throws IOException {
        return new MasterRpcServices(this);
    }

    @Override
    protected void configureInfoServer() {
        this.infoServer.addServlet("master-status", "/master-status", MasterStatusServlet.class);
        this.infoServer.setAttribute(MASTER, (Object)this);
        if (LoadBalancer.isTablesOnMaster(this.conf)) {
            super.configureInfoServer();
        }
    }

    @Override
    protected Class<? extends HttpServlet> getDumpServlet() {
        return MasterDumpServlet.class;
    }

    @Override
    public MetricsMaster getMasterMetrics() {
        return this.metricsMaster;
    }

    @VisibleForTesting
    protected void initializeZKBasedSystemTrackers() throws IOException, InterruptedException, KeeperException, ReplicationException {
        boolean wasUp;
        this.balancer = LoadBalancerFactory.getLoadBalancer(this.conf);
        this.normalizer = RegionNormalizerFactory.getRegionNormalizer(this.conf);
        this.normalizer.setMasterServices(this);
        this.normalizer.setMasterRpcServices((MasterRpcServices)this.rpcServices);
        this.loadBalancerTracker = new LoadBalancerTracker(this.zooKeeper, (Abortable)this);
        this.loadBalancerTracker.start();
        this.regionNormalizerTracker = new RegionNormalizerTracker(this.zooKeeper, (Abortable)this);
        this.regionNormalizerTracker.start();
        this.splitOrMergeTracker = new SplitOrMergeTracker(this.zooKeeper, this.conf, this);
        this.splitOrMergeTracker.start();
        this.replicationPeerManager = ReplicationPeerManager.create(this.zooKeeper, this.conf);
        this.drainingServerTracker = new DrainingServerTracker(this.zooKeeper, this, this.serverManager);
        this.drainingServerTracker.start();
        String clientQuorumServers = this.conf.get("hbase.client.zookeeper.quorum");
        boolean clientZkObserverMode = this.conf.getBoolean("hbase.client.zookeeper.observer.mode", false);
        if (clientQuorumServers != null && !clientZkObserverMode) {
            ZKWatcher clientZkWatcher = new ZKWatcher(this.conf, this.getProcessName() + ":" + this.rpcServices.getSocketAddress().getPort() + "-clientZK", (Abortable)this, false, true);
            this.metaLocationSyncer = new MetaLocationSyncer(this.zooKeeper, clientZkWatcher, this);
            this.metaLocationSyncer.start();
            this.masterAddressSyncer = new MasterAddressSyncer(this.zooKeeper, clientZkWatcher, this);
            this.masterAddressSyncer.start();
            ZKClusterId.setClusterId((ZKWatcher)clientZkWatcher, (ClusterId)this.fileSystemManager.getClusterId());
        }
        if (!(wasUp = this.clusterStatusTracker.isClusterUp())) {
            this.clusterStatusTracker.setClusterUp();
        }
        LOG.info("Active/primary master=" + this.serverName + ", sessionid=0x" + Long.toHexString(this.zooKeeper.getRecoverableZooKeeper().getSessionId()) + ", setting cluster-up flag (Was=" + wasUp + ")");
        this.snapshotManager = new SnapshotManager();
        this.mpmHost = new MasterProcedureManagerHost();
        this.mpmHost.register(this.snapshotManager);
        this.mpmHost.register(new MasterFlushTableProcedureManager());
        this.mpmHost.loadProcedures(this.conf);
        this.mpmHost.initialize(this, this.metricsMaster);
    }

    private void checkUnsupportedProcedure(Map<Class<? extends Procedure>, List<Procedure<MasterProcedureEnv>>> procsByType) throws HBaseIOException {
        for (Class clazz : UNSUPPORTED_PROCEDURES) {
            List<Procedure<MasterProcedureEnv>> procs = procsByType.get(clazz);
            if (procs == null) continue;
            LOG.error("Unsupported procedure type {} found, please rollback your master to the old version to finish them, and then try to upgrade again. The full procedure list: {}", (Object)clazz, procs);
            throw new HBaseIOException("Unsupported procedure type " + clazz + " found");
        }
        if (procsByType.getOrDefault(ServerCrashProcedure.class, Collections.emptyList()).stream().map(p -> (ServerCrashProcedure)p).anyMatch(ServerCrashProcedure::isInRecoverMetaState)) {
            LOG.error("At least one ServerCrashProcedure is going to schedule a RecoverMetaProcedure, which is not supported any more. Please rollback your master to the old version to finish them, and then try to upgrade again.");
            throw new HBaseIOException("Unsupported procedure state found for ServerCrashProcedure");
        }
    }

    @VisibleForTesting
    protected AssignmentManager createAssignmentManager(MasterServices master) {
        return new AssignmentManager(master);
    }

    private void finishActiveMasterInitialization(MonitoredTask status) throws IOException, InterruptedException, KeeperException, ReplicationException {
        status.setStatus("Initializing Master file system");
        this.masterActiveTime = System.currentTimeMillis();
        if (LoadBalancer.isTablesOnMaster(this.conf)) {
            this.initializeMemStoreChunkCreator();
        }
        this.fileSystemManager = new MasterFileSystem(this.conf);
        this.walManager = new MasterWalManager(this);
        this.tableDescriptors.setCacheOn();
        if (this.preLoadTableDescriptors) {
            status.setStatus("Pre-loading table descriptors");
            this.tableDescriptors.getAll();
        }
        ClusterId clusterId = this.fileSystemManager.getClusterId();
        status.setStatus("Publishing Cluster ID " + clusterId + " in ZooKeeper");
        ZKClusterId.setClusterId((ZKWatcher)this.zooKeeper, (ClusterId)this.fileSystemManager.getClusterId());
        this.clusterId = clusterId.toString();
        if (this.conf.getBoolean("hbase.write.hbck1.lock.file", true)) {
            HBaseFsck.checkAndMarkRunningHbck(this.conf, HBaseFsck.createLockRetryCounterFactory(this.conf).create());
        }
        status.setStatus("Initialize ServerManager and schedule SCP for crash servers");
        this.serverManager = this.createServerManager(this);
        if (!this.conf.getBoolean("hbase.split.wal.zk.coordinated", true)) {
            this.splitWALManager = new SplitWALManager(this);
        }
        this.createProcedureExecutor();
        Map<Class<? extends Procedure>, List<Procedure<MasterProcedureEnv>>> procsByType = this.procedureExecutor.getActiveProceduresNoCopy().stream().collect(Collectors.groupingBy(p -> p.getClass()));
        this.checkUnsupportedProcedure(procsByType);
        this.assignmentManager = this.createAssignmentManager(this);
        this.assignmentManager.start();
        List<TransitRegionStateProcedure> ritList = procsByType.getOrDefault(TransitRegionStateProcedure.class, Collections.emptyList()).stream().filter(p -> !p.isFinished()).map(p -> (TransitRegionStateProcedure)p).collect(Collectors.toList());
        this.assignmentManager.setupRIT(ritList);
        this.regionServerTracker = new RegionServerTracker(this.zooKeeper, this, this.serverManager);
        this.regionServerTracker.start(procsByType.getOrDefault(ServerCrashProcedure.class, Collections.emptyList()).stream().map(p -> (ServerCrashProcedure)p).map(p -> p.getServerName()).collect(Collectors.toSet()), this.walManager.getLiveServersFromWALDir(), this.walManager.getSplittingServersFromWALDir());
        this.tableStateManager = this.conf.getBoolean("hbase.mirror.table.state.to.zookeeper", true) ? new MirroringTableStateManager(this) : new TableStateManager(this);
        status.setStatus("Initializing ZK system trackers");
        this.initializeZKBasedSystemTrackers();
        this.activeMaster = true;
        Thread zombieDetector = new Thread((Runnable)((Object)new InitializationMonitor(this)), "ActiveMasterInitializationMonitor-" + System.currentTimeMillis());
        zombieDetector.setDaemon(true);
        zombieDetector.start();
        status.setStatus("Update TableCFs node in ZNode");
        ReplicationPeerConfigUpgrader tableCFsUpdater = new ReplicationPeerConfigUpgrader(this.zooKeeper, this.conf);
        tableCFsUpdater.copyTableCFs();
        if (!this.maintenanceMode) {
            if (QuotaUtil.isQuotaEnabled(this.conf)) {
                this.updateConfigurationForQuotasObserver(this.conf);
            }
            status.setStatus("Initializing master coprocessors");
            this.cpHost = new MasterCoprocessorHost(this, this.conf);
        }
        status.setStatus("Initializing meta table if this is a new deploy");
        InitMetaProcedure initMetaProc = null;
        RegionState rs = this.assignmentManager.getRegionStates().getRegionState(RegionInfoBuilder.FIRST_META_REGIONINFO);
        LOG.info("hbase:meta {}", (Object)rs);
        if (rs.isOffline()) {
            Optional<InitMetaProcedure> optProc = this.procedureExecutor.getProcedures().stream().filter(p -> p instanceof InitMetaProcedure).map(o -> (InitMetaProcedure)o).findAny();
            initMetaProc = optProc.orElseGet(() -> {
                InitMetaProcedure temp = new InitMetaProcedure();
                this.procedureExecutor.submitProcedure((Procedure)temp);
                return temp;
            });
        }
        if (this.balancer instanceof FavoredNodesPromoter) {
            this.favoredNodesManager = new FavoredNodesManager(this);
        }
        this.balancer.setMasterServices(this);
        this.balancer.setClusterMetrics(this.getClusterMetricsWithoutCoprocessor());
        this.balancer.initialize();
        status.setStatus("Initializing master service threads");
        this.startServiceThreads();
        if (initMetaProc != null) {
            initMetaProc.await();
        }
        this.sleeper.skipSleepCycle();
        String statusStr = "Wait for region servers to report in";
        status.setStatus(statusStr);
        LOG.info(Objects.toString(status));
        this.waitForRegionServers(status);
        if (this.isStopped()) {
            return;
        }
        status.setStatus("Starting assignment manager");
        if (!this.waitForMetaOnline()) {
            return;
        }
        this.assignmentManager.joinCluster();
        this.tableStateManager.start();
        this.assignmentManager.processOfflineRegions();
        if (this.favoredNodesManager != null && !this.maintenanceMode) {
            SnapshotOfRegionAssignmentFromMeta snapshotOfRegionAssignment = new SnapshotOfRegionAssignmentFromMeta(this.getConnection());
            snapshotOfRegionAssignment.initialize();
            this.favoredNodesManager.initialize(snapshotOfRegionAssignment);
        }
        this.balancer.setClusterMetrics(this.getClusterMetricsWithoutCoprocessor());
        status.setStatus("Starting balancer and catalog janitor");
        this.clusterStatusChore = new ClusterStatusChore(this, this.balancer);
        this.getChoreService().scheduleChore((ScheduledChore)this.clusterStatusChore);
        this.balancerChore = new BalancerChore(this);
        this.getChoreService().scheduleChore((ScheduledChore)this.balancerChore);
        this.normalizerChore = new RegionNormalizerChore(this);
        this.getChoreService().scheduleChore((ScheduledChore)this.normalizerChore);
        this.catalogJanitorChore = new CatalogJanitor(this);
        this.getChoreService().scheduleChore((ScheduledChore)this.catalogJanitorChore);
        this.hbckChore = new HbckChore(this);
        this.getChoreService().scheduleChore((ScheduledChore)this.hbckChore);
        if (!this.waitForNamespaceOnline()) {
            return;
        }
        status.setStatus("Starting cluster schema service");
        this.initClusterSchemaService();
        if (this.cpHost != null) {
            try {
                this.cpHost.preMasterInitialization();
            }
            catch (IOException e) {
                LOG.error("Coprocessor preMasterInitialization() hook failed", (Throwable)e);
            }
        }
        status.markComplete("Initialization successful");
        LOG.info(String.format("Master has completed initialization %.3fsec", Float.valueOf((float)(System.currentTimeMillis() - this.masterActiveTime) / 1000.0f)));
        this.masterFinishedInitializationTime = System.currentTimeMillis();
        this.configurationManager.registerObserver(this.balancer);
        this.configurationManager.registerObserver(this.cleanerPool);
        this.configurationManager.registerObserver(this.hfileCleaner);
        this.configurationManager.registerObserver(this.logCleaner);
        this.setInitialized(true);
        if (this.maintenanceMode) {
            LOG.info("Detected repair mode, skipping final initialization steps.");
            return;
        }
        this.assignmentManager.checkIfShouldMoveSystemRegionAsync();
        status.setStatus("Assign meta replicas");
        MasterMetaBootstrap metaBootstrap = this.createMetaBootstrap();
        metaBootstrap.assignMetaReplicas();
        status.setStatus("Starting quota manager");
        this.initQuotaManager();
        if (QuotaUtil.isQuotaEnabled(this.conf)) {
            this.spaceQuotaSnapshotNotifier = this.createQuotaSnapshotNotifier();
            this.spaceQuotaSnapshotNotifier.initialize((Connection)this.getClusterConnection());
            this.quotaObserverChore = new QuotaObserverChore(this, this.getMasterMetrics());
            this.getChoreService().scheduleChore((ScheduledChore)this.quotaObserverChore);
            this.snapshotQuotaChore = new SnapshotQuotaObserverChore(this, this.getMasterMetrics());
            this.getChoreService().scheduleChore((ScheduledChore)this.snapshotQuotaChore);
        }
        this.serverManager.clearDeadServersWithSameHostNameAndPortOfOnlineServer();
        status.setStatus("Checking ZNode ACLs");
        this.zooKeeper.checkAndSetZNodeAcls();
        status.setStatus("Initializing MOB Cleaner");
        this.initMobCleaner();
        status.setStatus("Calling postStartMaster coprocessors");
        if (this.cpHost != null) {
            try {
                this.cpHost.postStartMaster();
            }
            catch (IOException ioe) {
                LOG.error("Coprocessor postStartMaster() hook failed", (Throwable)ioe);
            }
        }
        zombieDetector.interrupt();
        long start = System.currentTimeMillis();
        this.balancer.postMasterStartupInitialize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Balancer post startup initialization complete, took " + (System.currentTimeMillis() - start) / 1000L + " seconds");
        }
    }

    @VisibleForTesting
    public boolean waitForMetaOnline() throws InterruptedException {
        return this.isRegionOnline(RegionInfoBuilder.FIRST_META_REGIONINFO);
    }

    private boolean isRegionOnline(RegionInfo ri) throws InterruptedException {
        RetryCounter rc = null;
        while (!this.isStopped()) {
            RegionState rs = this.assignmentManager.getRegionStates().getRegionState(ri);
            if (rs.isOpened() && this.getServerManager().isServerOnline(rs.getServerName())) {
                return true;
            }
            Optional<Procedure> optProc = this.procedureExecutor.getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure).findAny();
            LOG.warn("{} is NOT online; state={}; ServerCrashProcedures={}. Master startup cannot progress, in holding-pattern until region onlined.", new Object[]{ri.getRegionNameAsString(), rs, optProc.isPresent()});
            if (rc == null) {
                rc = new RetryCounterFactory(1000).create();
            }
            Threads.sleep((long)rc.getBackoffTimeAndIncrementAttempts());
        }
        return false;
    }

    @VisibleForTesting
    public boolean waitForNamespaceOnline() throws InterruptedException {
        List<RegionInfo> ris = this.assignmentManager.getRegionStates().getRegionsOfTable(TableName.NAMESPACE_TABLE_NAME);
        if (ris.isEmpty()) {
            return true;
        }
        for (RegionInfo ri : ris) {
            this.isRegionOnline(ri);
        }
        return true;
    }

    @VisibleForTesting
    public void updateConfigurationForQuotasObserver(Configuration conf) {
        if (!conf.getBoolean("hbase.quota.remove.on.table.delete", true)) {
            return;
        }
        String[] masterCoprocs = conf.getStrings("hbase.coprocessor.master.classes");
        int length = null == masterCoprocs ? 0 : masterCoprocs.length;
        String[] updatedCoprocs = new String[length + 1];
        if (length > 0) {
            System.arraycopy(masterCoprocs, 0, updatedCoprocs, 0, masterCoprocs.length);
        }
        updatedCoprocs[length] = MasterQuotasObserver.class.getName();
        conf.setStrings("hbase.coprocessor.master.classes", updatedCoprocs);
    }

    private void initMobCleaner() {
        this.expiredMobFileCleanerChore = new ExpiredMobFileCleanerChore(this);
        this.getChoreService().scheduleChore((ScheduledChore)this.expiredMobFileCleanerChore);
        int mobCompactionPeriod = this.conf.getInt("hbase.mob.compaction.chore.period", 604800);
        if (mobCompactionPeriod > 0) {
            this.mobCompactChore = new MobCompactionChore(this, mobCompactionPeriod);
            this.getChoreService().scheduleChore((ScheduledChore)this.mobCompactChore);
        } else {
            LOG.info("The period is " + mobCompactionPeriod + " seconds, MobCompactionChore is disabled");
        }
        this.mobCompactThread = new MasterMobCompactionThread(this);
    }

    @VisibleForTesting
    protected MasterMetaBootstrap createMetaBootstrap() {
        return new MasterMetaBootstrap(this);
    }

    @VisibleForTesting
    protected ServerManager createServerManager(MasterServices master) throws IOException {
        this.setupClusterConnection();
        return new ServerManager(master);
    }

    private void waitForRegionServers(MonitoredTask status) throws IOException, InterruptedException {
        this.serverManager.waitForRegionServers(status);
    }

    @VisibleForTesting
    protected void initClusterSchemaService() throws IOException, InterruptedException {
        this.clusterSchemaService = new ClusterSchemaServiceImpl(this);
        this.clusterSchemaService.startAsync();
        try {
            this.clusterSchemaService.awaitRunning(this.getConfiguration().getInt(HBASE_MASTER_WAIT_ON_SERVICE_IN_SECONDS, 300), TimeUnit.SECONDS);
        }
        catch (TimeoutException toe) {
            throw new IOException("Timedout starting ClusterSchemaService", toe);
        }
    }

    private void initQuotaManager() throws IOException {
        MasterQuotaManager quotaManager = new MasterQuotaManager(this);
        quotaManager.start();
        this.quotaManager = quotaManager;
    }

    private SpaceQuotaSnapshotNotifier createQuotaSnapshotNotifier() {
        SpaceQuotaSnapshotNotifier notifier = SpaceQuotaSnapshotNotifierFactory.getInstance().create(this.getConfiguration());
        return notifier;
    }

    boolean isCatalogJanitorEnabled() {
        return this.catalogJanitorChore != null ? this.catalogJanitorChore.getEnabled() : false;
    }

    boolean isCleanerChoreEnabled() {
        boolean hfileCleanerFlag = true;
        boolean logCleanerFlag = true;
        if (this.hfileCleaner != null) {
            hfileCleanerFlag = this.hfileCleaner.getEnabled();
        }
        if (this.logCleaner != null) {
            logCleanerFlag = this.logCleaner.getEnabled();
        }
        return hfileCleanerFlag && logCleanerFlag;
    }

    @Override
    public ServerManager getServerManager() {
        return this.serverManager;
    }

    @Override
    public MasterFileSystem getMasterFileSystem() {
        return this.fileSystemManager;
    }

    @Override
    public MasterWalManager getMasterWalManager() {
        return this.walManager;
    }

    @Override
    public SplitWALManager getSplitWALManager() {
        return this.splitWALManager;
    }

    @Override
    public TableStateManager getTableStateManager() {
        return this.tableStateManager;
    }

    private void startServiceThreads() throws IOException {
        this.executorService.startExecutorService(ExecutorType.MASTER_OPEN_REGION, this.conf.getInt("hbase.master.executor.openregion.threads", 5));
        this.executorService.startExecutorService(ExecutorType.MASTER_CLOSE_REGION, this.conf.getInt("hbase.master.executor.closeregion.threads", 5));
        this.executorService.startExecutorService(ExecutorType.MASTER_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.serverops.threads", 5));
        this.executorService.startExecutorService(ExecutorType.MASTER_META_SERVER_OPERATIONS, this.conf.getInt("hbase.master.executor.meta.serverops.threads", 5));
        this.executorService.startExecutorService(ExecutorType.M_LOG_REPLAY_OPS, this.conf.getInt("hbase.master.executor.logreplayops.threads", 10));
        this.executorService.startExecutorService(ExecutorType.MASTER_SNAPSHOT_OPERATIONS, this.conf.getInt("hbase.snapshot.master.threads", 1));
        this.executorService.startExecutorService(ExecutorType.MASTER_TABLE_OPERATIONS, 1);
        this.startProcedureExecutor();
        this.cleanerPool = new DirScanPool(this.conf);
        int cleanerInterval = this.conf.getInt("hbase.master.cleaner.interval", 600000);
        this.logCleaner = new LogCleaner(cleanerInterval, this, this.conf, this.getMasterWalManager().getFileSystem(), this.getMasterWalManager().getOldLogDir(), this.cleanerPool);
        this.getChoreService().scheduleChore((ScheduledChore)this.logCleaner);
        Path archiveDir = HFileArchiveUtil.getArchivePath(this.conf);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(MASTER, this);
        this.hfileCleaner = new HFileCleaner(cleanerInterval, this, this.conf, this.getMasterFileSystem().getFileSystem(), archiveDir, this.cleanerPool, params);
        this.getChoreService().scheduleChore((ScheduledChore)this.hfileCleaner);
        this.replicationBarrierCleaner = new ReplicationBarrierCleaner(this.conf, this, this.getConnection(), this.replicationPeerManager);
        this.getChoreService().scheduleChore((ScheduledChore)this.replicationBarrierCleaner);
        this.serviceStarted = true;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Started service threads");
        }
    }

    @Override
    protected void stopServiceThreads() {
        if (this.masterJettyServer != null) {
            LOG.info("Stopping master jetty server");
            try {
                this.masterJettyServer.stop();
            }
            catch (Exception e) {
                LOG.error("Failed to stop master jetty server", (Throwable)e);
            }
        }
        this.stopChores();
        if (this.mobCompactThread != null) {
            this.mobCompactThread.close();
        }
        super.stopServiceThreads();
        if (this.cleanerPool != null) {
            this.cleanerPool.shutdownNow();
            this.cleanerPool = null;
        }
        LOG.debug("Stopping service threads");
        if (this.quotaManager != null) {
            this.quotaManager.stop();
        }
        if (this.activeMasterManager != null) {
            this.activeMasterManager.stop();
        }
        if (this.serverManager != null) {
            this.serverManager.stop();
        }
        if (this.assignmentManager != null) {
            this.assignmentManager.stop();
        }
        this.stopProcedureExecutor();
        if (this.walManager != null) {
            this.walManager.stop();
        }
        if (this.fileSystemManager != null) {
            this.fileSystemManager.stop();
        }
        if (this.mpmHost != null) {
            this.mpmHost.stop("server shutting down.");
        }
        if (this.regionServerTracker != null) {
            this.regionServerTracker.stop();
        }
    }

    private void createProcedureExecutor() throws IOException {
        MasterProcedureEnv procEnv = new MasterProcedureEnv(this);
        this.procedureStore = new WALProcedureStore(this.conf, (WALProcedureStore.LeaseRecovery)new MasterProcedureEnv.WALStoreLeaseRecovery(this));
        this.procedureStore.registerListener(new ProcedureStore.ProcedureStoreListener(){

            public void abortProcess() {
                HMaster.this.abort("The Procedure Store lost the lease", null);
            }
        });
        MasterProcedureScheduler procedureScheduler = procEnv.getProcedureScheduler();
        this.procedureExecutor = new ProcedureExecutor(this.conf, (Object)procEnv, (ProcedureStore)this.procedureStore, (ProcedureScheduler)procedureScheduler);
        this.configurationManager.registerObserver(procEnv);
        int cpus = Runtime.getRuntime().availableProcessors();
        int numThreads = this.conf.getInt("hbase.master.procedure.threads", Math.max(cpus > 0 ? cpus / 4 : 0, 16));
        boolean abortOnCorruption = this.conf.getBoolean("hbase.procedure.abort.on.corruption", false);
        this.procedureStore.start(numThreads);
        this.procedureExecutor.init(numThreads, abortOnCorruption);
        procEnv.getRemoteDispatcher().start();
    }

    private void startProcedureExecutor() throws IOException {
        this.procedureExecutor.startWorkers();
    }

    private void stopProcedureExecutor() {
        if (this.procedureExecutor != null) {
            this.configurationManager.deregisterObserver((ConfigurationObserver)this.procedureExecutor.getEnvironment());
            ((MasterProcedureEnv)this.procedureExecutor.getEnvironment()).getRemoteDispatcher().stop();
            this.procedureExecutor.stop();
            this.procedureExecutor.join();
            this.procedureExecutor = null;
        }
        if (this.procedureStore != null) {
            this.procedureStore.stop(this.isAborted());
            this.procedureStore = null;
        }
    }

    private void stopChores() {
        ChoreService choreService = this.getChoreService();
        if (choreService != null) {
            choreService.cancelChore((ScheduledChore)this.expiredMobFileCleanerChore);
            choreService.cancelChore((ScheduledChore)this.mobCompactChore);
            choreService.cancelChore((ScheduledChore)this.balancerChore);
            choreService.cancelChore((ScheduledChore)this.normalizerChore);
            choreService.cancelChore((ScheduledChore)this.clusterStatusChore);
            choreService.cancelChore((ScheduledChore)this.catalogJanitorChore);
            choreService.cancelChore((ScheduledChore)this.clusterStatusPublisherChore);
            choreService.cancelChore((ScheduledChore)this.snapshotQuotaChore);
            choreService.cancelChore((ScheduledChore)this.logCleaner);
            choreService.cancelChore((ScheduledChore)this.hfileCleaner);
            choreService.cancelChore((ScheduledChore)this.replicationBarrierCleaner);
            choreService.cancelChore((ScheduledChore)this.hbckChore);
        }
    }

    InetAddress getRemoteInetAddress(int port, long serverStartCode) throws UnknownHostException {
        InetSocketAddress isa;
        InetAddress ia = RpcServer.getRemoteIp();
        if (ia == null && serverStartCode == this.startcode && (isa = this.rpcServices.getSocketAddress()) != null && isa.getPort() == port) {
            ia = isa.getAddress();
        }
        return ia;
    }

    private int getMaxBalancingTime() {
        int maxBalancingTime = this.getConfiguration().getInt("hbase.balancer.max.balancing", -1);
        if (maxBalancingTime == -1) {
            maxBalancingTime = this.getConfiguration().getInt("hbase.balancer.period", 300000);
        }
        return maxBalancingTime;
    }

    private int getMaxRegionsInTransition() {
        int numRegions = this.assignmentManager.getRegionStates().getRegionAssignments().size();
        return Math.max((int)Math.floor((double)numRegions * this.maxRitPercent), 1);
    }

    private void balanceThrottling(long nextBalanceStartTime, int maxRegionsInTransition, long cutoffTime) {
        boolean interrupted = false;
        while (!interrupted && System.currentTimeMillis() < nextBalanceStartTime && this.assignmentManager.getRegionStates().hasRegionsInTransition()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        while (!interrupted && maxRegionsInTransition > 0 && this.assignmentManager.getRegionStates().getRegionsInTransitionCount() >= maxRegionsInTransition && System.currentTimeMillis() <= cutoffTime) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public boolean balance() throws IOException {
        return this.balance(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean balance(boolean force) throws IOException {
        if (!this.isInitialized()) {
            LOG.debug("Master has not been initialized, don't run balancer.");
            return false;
        }
        if (this.isInMaintenanceMode()) {
            LOG.info("Master is in maintenanceMode mode, don't run balancer.");
            return false;
        }
        LoadBalancer loadBalancer = this.balancer;
        synchronized (loadBalancer) {
            if (!this.loadBalancerTracker.isBalancerOn()) {
                return false;
            }
            if (this.assignmentManager.hasRegionsInTransition()) {
                void var6_11;
                List<RegionStateNode> regionsInTransition = this.assignmentManager.getRegionsInTransition();
                boolean metaInTransition = this.assignmentManager.isMetaRegionInTransition();
                String prefix = force && !metaInTransition ? "R" : "Not r";
                List<RegionStateNode> list = regionsInTransition;
                int n = 5;
                boolean truncated = false;
                if (regionsInTransition.size() > n) {
                    List<RegionStateNode> list2 = regionsInTransition.subList(0, n);
                    truncated = true;
                }
                LOG.info((String)prefix + "unning balancer because " + regionsInTransition.size() + " region(s) in transition: " + var6_11 + (truncated ? "(truncated list)" : ""));
                if (!force || metaInTransition) {
                    return false;
                }
            }
            if (this.serverManager.areDeadServersInProgress()) {
                LOG.info("Not running balancer because processing dead regionserver(s): " + this.serverManager.getDeadServers());
                return false;
            }
            if (this.cpHost != null) {
                try {
                    if (this.cpHost.preBalance()) {
                        LOG.debug("Coprocessor bypassing balancer request");
                        return false;
                    }
                }
                catch (IOException ioe) {
                    LOG.error("Error invoking master coprocessor preBalance()", (Throwable)ioe);
                    return false;
                }
            }
            boolean isByTable = this.getConfiguration().getBoolean("hbase.master.loadbalance.bytable", false);
            Map<TableName, Map<ServerName, List<RegionInfo>>> assignments = this.assignmentManager.getRegionStates().getAssignmentsForBalancer(isByTable);
            for (Map map : assignments.values()) {
                map.keySet().removeAll(this.serverManager.getDrainingServersList());
            }
            this.balancer.setClusterMetrics(this.getClusterMetricsWithoutCoprocessor());
            this.balancer.setClusterLoad(assignments);
            ArrayList<RegionPlan> plans = new ArrayList<RegionPlan>();
            for (Map.Entry<TableName, Map<ServerName, List<RegionInfo>>> entry : assignments.entrySet()) {
                List<RegionPlan> partialPlans = this.balancer.balanceCluster(entry.getKey(), entry.getValue());
                if (partialPlans == null) continue;
                plans.addAll(partialPlans);
            }
            List<RegionPlan> list = this.executeRegionPlansWithThrottling(plans);
            if (this.cpHost != null) {
                try {
                    this.cpHost.postBalance(list);
                }
                catch (IOException iOException) {
                    LOG.error("Error invoking master coprocessor postBalance()", (Throwable)iOException);
                }
            }
        }
        return true;
    }

    @Override
    public List<RegionPlan> executeRegionPlansWithThrottling(List<RegionPlan> plans) {
        ArrayList<RegionPlan> sucRPs = new ArrayList<RegionPlan>();
        int maxRegionsInTransition = this.getMaxRegionsInTransition();
        long balanceStartTime = System.currentTimeMillis();
        long cutoffTime = balanceStartTime + (long)this.maxBlancingTime;
        int rpCount = 0;
        if (plans != null && !plans.isEmpty()) {
            int balanceInterval = this.maxBlancingTime / plans.size();
            LOG.info("Balancer plans size is " + plans.size() + ", the balance interval is " + balanceInterval + " ms, and the max number regions in transition is " + maxRegionsInTransition);
            for (RegionPlan plan : plans) {
                LOG.info("balance " + plan);
                try {
                    this.assignmentManager.moveAsync(plan);
                }
                catch (HBaseIOException hioe) {
                    LOG.warn("Failed balance plan: {}, just skip it", (Object)plan, (Object)hioe);
                }
                this.balanceThrottling(balanceStartTime + (long)(++rpCount * balanceInterval), maxRegionsInTransition, cutoffTime);
                if (rpCount >= plans.size() || System.currentTimeMillis() <= cutoffTime) continue;
                LOG.debug("No more balancing till next balance run; maxBalanceTime=" + this.maxBlancingTime);
                break;
            }
        }
        return sucRPs;
    }

    @Override
    @VisibleForTesting
    public RegionNormalizer getRegionNormalizer() {
        return this.normalizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean normalizeRegions() throws IOException {
        if (!this.isInitialized()) {
            LOG.debug("Master has not been initialized, don't run region normalizer.");
            return false;
        }
        if (this.getServerManager().isClusterShutdown()) {
            LOG.info("Cluster is shutting down, don't run region normalizer.");
            return false;
        }
        if (this.isInMaintenanceMode()) {
            LOG.info("Master is in maintenance mode, don't run region normalizer.");
            return false;
        }
        if (!this.regionNormalizerTracker.isNormalizerOn()) {
            LOG.debug("Region normalization is disabled, don't run region normalizer.");
            return false;
        }
        RegionNormalizer regionNormalizer = this.normalizer;
        synchronized (regionNormalizer) {
            ArrayList<TableName> allEnabledTables = new ArrayList<TableName>(this.tableStateManager.getTablesInStates(TableState.State.ENABLED));
            Collections.shuffle(allEnabledTables);
            for (TableName table : allEnabledTables) {
                if (this.isInMaintenanceMode()) {
                    LOG.debug("Master is in maintenance mode, stop running region normalizer.");
                    return false;
                }
                TableDescriptor tblDesc = this.getTableDescriptors().get(table);
                if (table.isSystemTable() || tblDesc != null && !tblDesc.isNormalizationEnabled()) {
                    LOG.trace("Skipping normalization for {}, as it's either system table or doesn't have auto normalization turned on", (Object)table);
                    continue;
                }
                List<NormalizationPlan> plans = this.normalizer.computePlanForTable(table);
                if (plans == null) continue;
                for (NormalizationPlan plan : plans) {
                    plan.execute(this.clusterConnection.getAdmin());
                    if (plan.getType() == NormalizationPlan.PlanType.SPLIT) {
                        ++this.splitPlanCount;
                        continue;
                    }
                    if (plan.getType() != NormalizationPlan.PlanType.MERGE) continue;
                    ++this.mergePlanCount;
                }
            }
        }
        return true;
    }

    @Override
    public String getClientIdAuditPrefix() {
        return "Client=" + (String)RpcServer.getRequestUserName().orElse(null) + "/" + RpcServer.getRemoteAddress().orElse(null);
    }

    public void setCatalogJanitorEnabled(boolean b) {
        this.catalogJanitorChore.setEnabled(b);
    }

    @Override
    public long mergeRegions(final RegionInfo[] regionsToMerge, final boolean forcible, long ng, long nonce) throws IOException {
        this.checkInitialized();
        final String mergeRegionsStr = Arrays.stream(regionsToMerge).map(r -> RegionInfo.getShortNameToLog((RegionInfo[])new RegionInfo[]{r})).collect(Collectors.joining(", "));
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, ng, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preMergeRegions(regionsToMerge);
                String aid = HMaster.this.getClientIdAuditPrefix();
                LOG.info("{} merge regions {}", (Object)aid, (Object)mergeRegionsStr);
                this.submitProcedure((Procedure<MasterProcedureEnv>)new MergeTableRegionsProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), regionsToMerge, forcible));
                this.getMaster().getMasterCoprocessorHost().postMergeRegions(regionsToMerge);
            }

            @Override
            protected String getDescription() {
                return "MergeTableProcedure";
            }
        });
    }

    @Override
    public long splitRegion(final RegionInfo regionInfo, final byte[] splitRow, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preSplitRegion(regionInfo.getTable(), splitRow);
                LOG.info(HMaster.this.getClientIdAuditPrefix() + " split " + regionInfo.getRegionNameAsString());
                this.submitProcedure((Procedure<MasterProcedureEnv>)HMaster.this.getAssignmentManager().createSplitProcedure(regionInfo, splitRow));
            }

            @Override
            protected String getDescription() {
                return "SplitTableProcedure";
            }
        });
    }

    @VisibleForTesting
    public void move(byte[] encodedRegionName, byte[] destServerName) throws HBaseIOException {
        ServerName dest;
        List<Object> exclude;
        RegionState regionState = this.assignmentManager.getRegionStates().getRegionState(Bytes.toString((byte[])encodedRegionName));
        if (regionState == null) {
            throw new UnknownRegionException(Bytes.toStringBinary((byte[])encodedRegionName));
        }
        RegionInfo hri = regionState.getRegion();
        List<Object> list = exclude = hri.getTable().isSystemTable() ? this.assignmentManager.getExcludedServersForSystemTable() : new ArrayList(1);
        if (destServerName != null && exclude.contains(ServerName.valueOf((String)Bytes.toString((byte[])destServerName)))) {
            LOG.info(Bytes.toString((byte[])encodedRegionName) + " can not move to " + Bytes.toString((byte[])destServerName) + " because the server is in exclude list");
            destServerName = null;
        }
        if (destServerName == null || destServerName.length == 0) {
            LOG.info("Passed destination servername is null/empty so choosing a server at random");
            exclude.add(regionState.getServerName());
            List<ServerName> destServers = this.serverManager.createDestinationServersList(exclude);
            dest = this.balancer.randomAssignment(hri, destServers);
            if (dest == null) {
                LOG.debug("Unable to determine a plan to assign " + hri);
                return;
            }
        } else {
            ServerName candidate = ServerName.valueOf((String)Bytes.toString((byte[])destServerName));
            dest = this.balancer.randomAssignment(hri, Lists.newArrayList((Object[])new ServerName[]{candidate}));
            if (dest == null) {
                LOG.debug("Unable to determine a plan to assign " + hri);
                return;
            }
            if (dest.equals((Object)this.serverName) && this.balancer instanceof BaseLoadBalancer && !((BaseLoadBalancer)this.balancer).shouldBeOnMaster(hri)) {
                LOG.debug("Skipping move of region " + hri.getRegionNameAsString() + " to avoid unnecessary region moving later by load balancer, because it should not be on master");
                return;
            }
        }
        if (dest.equals((Object)regionState.getServerName())) {
            LOG.debug("Skipping move of region " + hri.getRegionNameAsString() + " because region already assigned to the same server " + dest + ".");
            return;
        }
        RegionPlan rp = new RegionPlan(hri, regionState.getServerName(), dest);
        assert (rp.getDestination() != null) : rp.toString() + " " + dest;
        try {
            this.checkInitialized();
            if (this.cpHost != null) {
                this.cpHost.preMove(hri, rp.getSource(), rp.getDestination());
            }
            TransitRegionStateProcedure proc = this.assignmentManager.createMoveRegionProcedure(rp.getRegionInfo(), rp.getDestination());
            this.serverManager.sendRegionWarmup(rp.getDestination(), hri);
            LOG.info(this.getClientIdAuditPrefix() + " move " + rp + ", running balancer");
            Future<byte[]> future = ProcedureSyncWait.submitProcedure(this.procedureExecutor, (Procedure<MasterProcedureEnv>)proc);
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new HBaseIOException((Throwable)e);
            }
            if (this.cpHost != null) {
                this.cpHost.postMove(hri, rp.getSource(), rp.getDestination());
            }
        }
        catch (IOException ioe) {
            if (ioe instanceof HBaseIOException) {
                throw (HBaseIOException)((Object)ioe);
            }
            throw new HBaseIOException((Throwable)ioe);
        }
    }

    @Override
    public long createTable(TableDescriptor tableDescriptor, byte[][] splitKeys, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        final TableDescriptor desc = this.getMasterCoprocessorHost().preCreateTableRegionsInfos(tableDescriptor);
        if (desc == null) {
            throw new IOException("Creation for " + tableDescriptor + " is canceled by CP");
        }
        String namespace = desc.getTableName().getNamespaceAsString();
        this.clusterSchemaService.getNamespace(namespace);
        final RegionInfo[] newRegions = ModifyRegionUtils.createRegionInfos(desc, splitKeys);
        TableDescriptorChecker.sanityCheck(this.conf, desc);
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preCreateTable(desc, newRegions);
                LOG.info(HMaster.this.getClientIdAuditPrefix() + " create " + desc);
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createBlockingLatch();
                this.submitProcedure((Procedure<MasterProcedureEnv>)new CreateTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), desc, newRegions, latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postCreateTable(desc, newRegions);
            }

            @Override
            protected String getDescription() {
                return "CreateTableProcedure";
            }
        });
    }

    @Override
    public long createSystemTable(TableDescriptor tableDescriptor) throws IOException {
        if (this.isStopped()) {
            throw new MasterNotRunningException();
        }
        TableName tableName = tableDescriptor.getTableName();
        if (!tableName.isSystemTable()) {
            throw new IllegalArgumentException("Only system table creation can use this createSystemTable API");
        }
        RegionInfo[] newRegions = ModifyRegionUtils.createRegionInfos(tableDescriptor, null);
        LOG.info(this.getClientIdAuditPrefix() + " create " + tableDescriptor);
        long procId = this.procedureExecutor.submitProcedure((Procedure)new CreateTableProcedure((MasterProcedureEnv)this.procedureExecutor.getEnvironment(), tableDescriptor, newRegions));
        return procId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startActiveMasterManager(int infoPort) throws KeeperException {
        String backupZNode = ZNodePaths.joinZNode((String)this.zooKeeper.getZNodePaths().backupMasterAddressesZNode, (String)this.serverName.toString());
        LOG.info("Adding backup master ZNode " + backupZNode);
        if (!MasterAddressTracker.setMasterAddress((ZKWatcher)this.zooKeeper, (String)backupZNode, (ServerName)this.serverName, (int)infoPort)) {
            LOG.warn("Failed create of " + backupZNode + " by " + this.serverName);
        }
        this.activeMasterManager.setInfoPort(infoPort);
        int timeout = this.conf.getInt("zookeeper.session.timeout", 90000);
        if (this.conf.getBoolean("hbase.master.backup", false)) {
            LOG.debug("HMaster started in backup mode. Stalling until master znode is written.");
            while (!this.activeMasterManager.hasActiveMaster()) {
                LOG.debug("Waiting for master address and cluster state znode to be written.");
                Threads.sleep((long)timeout);
            }
        }
        MonitoredTask status = TaskMonitor.get().createStatus("Master startup");
        status.setDescription("Master startup");
        try {
            if (this.activeMasterManager.blockUntilBecomingActiveMaster(timeout, status)) {
                this.finishActiveMasterInitialization(status);
            }
        }
        catch (Throwable t) {
            status.setStatus("Failed to become active: " + t.getMessage());
            LOG.error(HBaseMarkers.FATAL, "Failed to become active master", t);
            if (t instanceof NoClassDefFoundError && t.getMessage().contains("org/apache/hadoop/hdfs/protocol/HdfsConstants$SafeModeAction")) {
                this.abort("HBase is having a problem with its Hadoop jars.  You may need to recompile HBase against Hadoop version " + VersionInfo.getVersion() + " or change your hadoop jars to start properly", t);
            } else {
                this.abort("Unhandled exception. Starting shutdown.", t);
            }
        }
        finally {
            status.cleanup();
        }
    }

    private static boolean isCatalogTable(TableName tableName) {
        return tableName.equals((Object)TableName.META_TABLE_NAME);
    }

    @Override
    public long deleteTable(final TableName tableName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preDeleteTable(tableName);
                LOG.info(HMaster.this.getClientIdAuditPrefix() + " delete " + tableName);
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createBlockingLatch();
                this.submitProcedure((Procedure<MasterProcedureEnv>)new DeleteTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableName, latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postDeleteTable(tableName);
            }

            @Override
            protected String getDescription() {
                return "DeleteTableProcedure";
            }
        });
    }

    @Override
    public long truncateTable(final TableName tableName, final boolean preserveSplits, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preTruncateTable(tableName);
                LOG.info(HMaster.this.getClientIdAuditPrefix() + " truncate " + tableName);
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createLatch(2, 0);
                this.submitProcedure((Procedure<MasterProcedureEnv>)new TruncateTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableName, preserveSplits, latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postTruncateTable(tableName);
            }

            @Override
            protected String getDescription() {
                return "TruncateTableProcedure";
            }
        });
    }

    @Override
    public long addColumn(final TableName tableName, final ColumnFamilyDescriptor column, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        this.checkTableExists(tableName);
        return this.modifyTable(tableName, new TableDescriptorGetter(){

            @Override
            public TableDescriptor get() throws IOException {
                TableDescriptor old = HMaster.this.getTableDescriptors().get(tableName);
                if (old.hasColumnFamily(column.getName())) {
                    throw new InvalidFamilyOperationException("Column family '" + column.getNameAsString() + "' in table '" + tableName + "' already exists so cannot be added");
                }
                return TableDescriptorBuilder.newBuilder((TableDescriptor)old).setColumnFamily(column).build();
            }
        }, nonceGroup, nonce, true);
    }

    @Override
    public long modifyColumn(final TableName tableName, final ColumnFamilyDescriptor descriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        this.checkTableExists(tableName);
        return this.modifyTable(tableName, new TableDescriptorGetter(){

            @Override
            public TableDescriptor get() throws IOException {
                TableDescriptor old = HMaster.this.getTableDescriptors().get(tableName);
                if (!old.hasColumnFamily(descriptor.getName())) {
                    throw new InvalidFamilyOperationException("Family '" + descriptor.getNameAsString() + "' does not exist, so it cannot be modified");
                }
                return TableDescriptorBuilder.newBuilder((TableDescriptor)old).modifyColumnFamily(descriptor).build();
            }
        }, nonceGroup, nonce, true);
    }

    @Override
    public long deleteColumn(final TableName tableName, final byte[] columnName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        this.checkTableExists(tableName);
        return this.modifyTable(tableName, new TableDescriptorGetter(){

            @Override
            public TableDescriptor get() throws IOException {
                TableDescriptor old = HMaster.this.getTableDescriptors().get(tableName);
                if (!old.hasColumnFamily(columnName)) {
                    throw new InvalidFamilyOperationException("Family '" + Bytes.toString((byte[])columnName) + "' does not exist, so it cannot be deleted");
                }
                if (old.getColumnFamilyCount() == 1) {
                    throw new InvalidFamilyOperationException("Family '" + Bytes.toString((byte[])columnName) + "' is the only column family in the table, so it cannot be deleted");
                }
                return TableDescriptorBuilder.newBuilder((TableDescriptor)old).removeColumnFamily(columnName).build();
            }
        }, nonceGroup, nonce, true);
    }

    @Override
    public long enableTable(final TableName tableName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preEnableTable(tableName);
                MasterQuotaManager quotaManager = HMaster.this.getMasterQuotaManager();
                if (quotaManager != null) {
                    if (quotaManager.isQuotaInitialized()) {
                        SpaceQuotaSnapshot.SpaceQuotaStatus quotaStatus;
                        SpaceQuotaSnapshot currSnapshotOfTable = QuotaTableUtil.getCurrentSnapshotFromQuotaTable((Connection)HMaster.this.getConnection(), (TableName)tableName);
                        if (currSnapshotOfTable != null && (quotaStatus = currSnapshotOfTable.getQuotaStatus()).isInViolation() && SpaceViolationPolicy.DISABLE == quotaStatus.getPolicy().orElse(null)) {
                            throw new AccessDeniedException("Enabling the table '" + tableName + "' is disallowed due to a violated space quota.");
                        }
                    } else if (LOG.isTraceEnabled()) {
                        LOG.trace("Unable to check for space quotas as the MasterQuotaManager is not enabled");
                    }
                }
                LOG.info(HMaster.this.getClientIdAuditPrefix() + " enable " + tableName);
                ProcedurePrepareLatch prepareLatch = ProcedurePrepareLatch.createLatch();
                this.submitProcedure((Procedure<MasterProcedureEnv>)new EnableTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableName, prepareLatch));
                prepareLatch.await();
                this.getMaster().getMasterCoprocessorHost().postEnableTable(tableName);
            }

            @Override
            protected String getDescription() {
                return "EnableTableProcedure";
            }
        });
    }

    @Override
    public long disableTable(final TableName tableName, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preDisableTable(tableName);
                LOG.info(HMaster.this.getClientIdAuditPrefix() + " disable " + tableName);
                ProcedurePrepareLatch prepareLatch = ProcedurePrepareLatch.createBlockingLatch();
                this.submitProcedure((Procedure<MasterProcedureEnv>)new DisableTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), tableName, false, prepareLatch));
                prepareLatch.await();
                this.getMaster().getMasterCoprocessorHost().postDisableTable(tableName);
            }

            @Override
            protected String getDescription() {
                return "DisableTableProcedure";
            }
        });
    }

    private long modifyTable(final TableName tableName, final TableDescriptorGetter newDescriptorGetter, long nonceGroup, long nonce, final boolean shouldCheckDescriptor) throws IOException {
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                TableDescriptor oldDescriptor = this.getMaster().getTableDescriptors().get(tableName);
                TableDescriptor newDescriptor = this.getMaster().getMasterCoprocessorHost().preModifyTable(tableName, oldDescriptor, newDescriptorGetter.get());
                TableDescriptorChecker.sanityCheck(HMaster.this.conf, newDescriptor);
                LOG.info("{} modify table {} from {} to {}", new Object[]{HMaster.this.getClientIdAuditPrefix(), tableName, oldDescriptor, newDescriptor});
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createBlockingLatch();
                this.submitProcedure((Procedure<MasterProcedureEnv>)new ModifyTableProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), newDescriptor, latch, oldDescriptor, shouldCheckDescriptor));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postModifyTable(tableName, oldDescriptor, newDescriptor);
            }

            @Override
            protected String getDescription() {
                return "ModifyTableProcedure";
            }
        });
    }

    @Override
    public long modifyTable(TableName tableName, final TableDescriptor newDescriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return this.modifyTable(tableName, new TableDescriptorGetter(){

            @Override
            public TableDescriptor get() throws IOException {
                return newDescriptor;
            }
        }, nonceGroup, nonce, false);
    }

    public long restoreSnapshot(final SnapshotProtos.SnapshotDescription snapshotDesc, long nonceGroup, long nonce, final boolean restoreAcl) throws IOException {
        this.checkInitialized();
        this.getSnapshotManager().checkSnapshotSupport();
        TableName dstTable = TableName.valueOf((String)snapshotDesc.getTable());
        this.getClusterSchema().getNamespace(dstTable.getNamespaceAsString());
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.setProcId(HMaster.this.getSnapshotManager().restoreOrCloneSnapshot(snapshotDesc, this.getNonceKey(), restoreAcl));
            }

            @Override
            protected String getDescription() {
                return "RestoreSnapshotProcedure";
            }
        });
    }

    private void checkTableExists(TableName tableName) throws IOException, TableNotFoundException {
        if (!MetaTableAccessor.tableExists((Connection)this.getConnection(), (TableName)tableName)) {
            throw new TableNotFoundException(tableName);
        }
    }

    @Override
    public void checkTableModifiable(TableName tableName) throws IOException, TableNotFoundException, TableNotDisabledException {
        if (HMaster.isCatalogTable(tableName)) {
            throw new IOException("Can't modify catalog tables");
        }
        this.checkTableExists(tableName);
        TableState ts = this.getTableStateManager().getTableState(tableName);
        if (!ts.isDisabled()) {
            throw new TableNotDisabledException("Not DISABLED; " + ts);
        }
    }

    public ClusterMetrics getClusterMetricsWithoutCoprocessor() throws InterruptedIOException {
        return this.getClusterMetricsWithoutCoprocessor(EnumSet.allOf(ClusterMetrics.Option.class));
    }

    public ClusterMetrics getClusterMetricsWithoutCoprocessor(EnumSet<ClusterMetrics.Option> options) throws InterruptedIOException {
        ClusterMetricsBuilder builder = ClusterMetricsBuilder.newBuilder();
        if (options.isEmpty()) {
            options = EnumSet.allOf(ClusterMetrics.Option.class);
        }
        for (ClusterMetrics.Option opt : options) {
            switch (opt) {
                case HBASE_VERSION: {
                    builder.setHBaseVersion(org.apache.hadoop.hbase.util.VersionInfo.getVersion());
                    break;
                }
                case CLUSTER_ID: {
                    builder.setClusterId(this.getClusterId());
                    break;
                }
                case MASTER: {
                    builder.setMasterName(this.getServerName());
                    break;
                }
                case BACKUP_MASTERS: {
                    builder.setBackerMasterNames(this.getBackupMasters());
                    break;
                }
                case LIVE_SERVERS: {
                    if (this.serverManager == null) break;
                    builder.setLiveServerMetrics(this.serverManager.getOnlineServers().entrySet().stream().collect(Collectors.toMap(e -> (ServerName)e.getKey(), e -> (ServerMetrics)e.getValue())));
                    break;
                }
                case DEAD_SERVERS: {
                    if (this.serverManager == null) break;
                    builder.setDeadServerNames(new ArrayList<ServerName>(this.serverManager.getDeadServers().copyServerNames()));
                    break;
                }
                case MASTER_COPROCESSORS: {
                    if (this.cpHost == null) break;
                    builder.setMasterCoprocessorNames(Arrays.asList(this.getMasterCoprocessors()));
                    break;
                }
                case REGIONS_IN_TRANSITION: {
                    if (this.assignmentManager == null) break;
                    builder.setRegionsInTransition(this.assignmentManager.getRegionStates().getRegionsStateInTransition());
                    break;
                }
                case BALANCER_ON: {
                    if (this.loadBalancerTracker == null) break;
                    builder.setBalancerOn(Boolean.valueOf(this.loadBalancerTracker.isBalancerOn()));
                    break;
                }
                case MASTER_INFO_PORT: {
                    if (this.infoServer == null) break;
                    builder.setMasterInfoPort(this.infoServer.getPort());
                    break;
                }
                case SERVERS_NAME: {
                    if (this.serverManager == null) break;
                    builder.setServerNames(this.serverManager.getOnlineServersList());
                    break;
                }
                case TABLE_TO_REGIONS_COUNT: {
                    if (!this.isActiveMaster() || !this.isInitialized() || this.assignmentManager == null) break;
                    try {
                        HashMap<TableName, RegionStatesCount> tableRegionStatesCountMap = new HashMap<TableName, RegionStatesCount>();
                        Map<String, TableDescriptor> tableDescriptorMap = this.getTableDescriptors().getAll();
                        for (TableDescriptor tableDescriptor : tableDescriptorMap.values()) {
                            TableName tableName = tableDescriptor.getTableName();
                            RegionStatesCount regionStatesCount = this.assignmentManager.getRegionStatesCount(tableName);
                            tableRegionStatesCountMap.put(tableName, regionStatesCount);
                        }
                        builder.setTableRegionStatesCount(tableRegionStatesCountMap);
                        break;
                    }
                    catch (IOException e2) {
                        LOG.error("Error while populating TABLE_TO_REGIONS_COUNT for Cluster Metrics..", (Throwable)e2);
                    }
                }
            }
        }
        return builder.build();
    }

    public ClusterMetrics getClusterMetrics() throws IOException {
        return this.getClusterMetrics(EnumSet.allOf(ClusterMetrics.Option.class));
    }

    public ClusterMetrics getClusterMetrics(EnumSet<ClusterMetrics.Option> options) throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preGetClusterMetrics();
        }
        ClusterMetrics status = this.getClusterMetricsWithoutCoprocessor(options);
        if (this.cpHost != null) {
            this.cpHost.postGetClusterMetrics(status);
        }
        return status;
    }

    private List<ServerName> getBackupMasters() throws InterruptedIOException {
        List backupMasterStrings;
        try {
            backupMasterStrings = ZKUtil.listChildrenNoWatch((ZKWatcher)this.zooKeeper, (String)this.zooKeeper.getZNodePaths().backupMasterAddressesZNode);
        }
        catch (KeeperException e) {
            LOG.warn(this.zooKeeper.prefix("Unable to list backup servers"), (Throwable)e);
            backupMasterStrings = null;
        }
        List<ServerName> backupMasters = Collections.emptyList();
        if (backupMasterStrings != null && !backupMasterStrings.isEmpty()) {
            backupMasters = new ArrayList<ServerName>(backupMasterStrings.size());
            for (String s : backupMasterStrings) {
                try {
                    ServerName sn;
                    byte[] bytes;
                    try {
                        bytes = ZKUtil.getData((ZKWatcher)this.zooKeeper, (String)ZNodePaths.joinZNode((String)this.zooKeeper.getZNodePaths().backupMasterAddressesZNode, (String)s));
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException();
                    }
                    if (bytes == null) continue;
                    try {
                        sn = ProtobufUtil.parseServerNameFrom((byte[])bytes);
                    }
                    catch (DeserializationException e) {
                        LOG.warn("Failed parse, skipping registering backup server", (Throwable)e);
                        continue;
                    }
                    backupMasters.add(sn);
                }
                catch (KeeperException e) {
                    LOG.warn(this.zooKeeper.prefix("Unable to get information about backup servers"), (Throwable)e);
                }
            }
            Collections.sort(backupMasters, new Comparator<ServerName>(){

                @Override
                public int compare(ServerName s1, ServerName s2) {
                    return s1.getServerName().compareTo(s2.getServerName());
                }
            });
        }
        return backupMasters;
    }

    public static String getLoadedCoprocessors() {
        return CoprocessorHost.getLoadedCoprocessors().toString();
    }

    public long getMasterStartTime() {
        return this.startcode;
    }

    public long getMasterActiveTime() {
        return this.masterActiveTime;
    }

    public long getMasterFinishedInitializationTime() {
        return this.masterFinishedInitializationTime;
    }

    public int getNumWALFiles() {
        return this.procedureStore != null ? this.procedureStore.getActiveLogs().size() : 0;
    }

    public WALProcedureStore getWalProcedureStore() {
        return this.procedureStore;
    }

    public int getRegionServerInfoPort(ServerName sn) {
        int port = this.serverManager.getInfoPort(sn);
        return port == 0 ? this.conf.getInt("hbase.regionserver.info.port", 16030) : port;
    }

    @Override
    public String getRegionServerVersion(ServerName sn) {
        return this.serverManager.getVersion(sn);
    }

    @Override
    public void checkIfShouldMoveSystemRegionAsync() {
        this.assignmentManager.checkIfShouldMoveSystemRegionAsync();
    }

    public String[] getMasterCoprocessors() {
        Set<String> masterCoprocessors = this.getMasterCoprocessorHost().getCoprocessors();
        return masterCoprocessors.toArray(new String[masterCoprocessors.size()]);
    }

    @Override
    public void abort(String reason, Throwable cause) {
        if (this.isAborted() || this.isStopped()) {
            return;
        }
        this.setAbortRequested();
        if (this.cpHost != null) {
            LOG.error(HBaseMarkers.FATAL, "Master server abort: loaded coprocessors are: " + HMaster.getLoadedCoprocessors());
        }
        String msg = "***** ABORTING master " + this + ": " + reason + " *****";
        if (cause != null) {
            LOG.error(HBaseMarkers.FATAL, msg, cause);
        } else {
            LOG.error(HBaseMarkers.FATAL, msg);
        }
        try {
            this.stopMaster();
        }
        catch (IOException e) {
            LOG.error("Exception occurred while stopping master", (Throwable)e);
        }
    }

    @Override
    public ZKWatcher getZooKeeper() {
        return this.zooKeeper;
    }

    @Override
    public MasterCoprocessorHost getMasterCoprocessorHost() {
        return this.cpHost;
    }

    @Override
    public MasterQuotaManager getMasterQuotaManager() {
        return this.quotaManager;
    }

    @Override
    public ProcedureExecutor<MasterProcedureEnv> getMasterProcedureExecutor() {
        return this.procedureExecutor;
    }

    @Override
    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public AssignmentManager getAssignmentManager() {
        return this.assignmentManager;
    }

    @Override
    public CatalogJanitor getCatalogJanitor() {
        return this.catalogJanitorChore;
    }

    public MemoryBoundedLogMessageBuffer getRegionServerFatalLogBuffer() {
        return this.rsFatals;
    }

    public void shutdown() throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preShutdown();
        }
        if (this.serverManager != null) {
            this.serverManager.shutdownCluster();
        }
        if (this.clusterStatusTracker != null) {
            try {
                this.clusterStatusTracker.setClusterDown();
            }
            catch (KeeperException e) {
                LOG.error("ZooKeeper exception trying to set cluster as down in ZK", (Throwable)e);
            }
        }
        if (this.procedureExecutor != null) {
            this.procedureExecutor.stop();
        }
        if (this.clusterConnection != null) {
            this.clusterConnection.close();
        }
    }

    public void stopMaster() throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preStopMaster();
        }
        this.stop("Stopped by " + Thread.currentThread().getName());
    }

    @Override
    public void stop(String msg) {
        if (!this.isStopped()) {
            super.stop(msg);
            if (this.activeMasterManager != null) {
                this.activeMasterManager.stop();
            }
        }
    }

    @VisibleForTesting
    protected void checkServiceStarted() throws ServerNotRunningYetException {
        if (!this.serviceStarted) {
            throw new ServerNotRunningYetException("Server is not running yet");
        }
    }

    void checkInitialized() throws PleaseHoldException, ServerNotRunningYetException, MasterNotRunningException, MasterStoppedException {
        this.checkServiceStarted();
        if (!this.isInitialized()) {
            throw new PleaseHoldException("Master is initializing");
        }
        if (this.isStopped()) {
            throw new MasterStoppedException();
        }
    }

    @Override
    public boolean isActiveMaster() {
        return this.activeMaster;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized.isReady();
    }

    @Override
    public boolean isInMaintenanceMode() {
        return this.maintenanceMode;
    }

    @VisibleForTesting
    public void setInitialized(boolean isInitialized) {
        ((MasterProcedureEnv)this.procedureExecutor.getEnvironment()).setEventReady(this.initialized, isInitialized);
    }

    @Override
    public ProcedureEvent<?> getInitializedEvent() {
        return this.initialized;
    }

    public double getAverageLoad() {
        if (this.assignmentManager == null) {
            return 0.0;
        }
        RegionStates regionStates = this.assignmentManager.getRegionStates();
        if (regionStates == null) {
            return 0.0;
        }
        return regionStates.getAverageLoad();
    }

    public long getSplitPlanCount() {
        return this.splitPlanCount;
    }

    public long getMergePlanCount() {
        return this.mergePlanCount;
    }

    @Override
    public boolean registerService(Service instance) {
        Descriptors.ServiceDescriptor serviceDesc = instance.getDescriptorForType();
        String serviceName = CoprocessorRpcUtils.getServiceName((Descriptors.ServiceDescriptor)serviceDesc);
        if (this.coprocessorServiceHandlers.containsKey(serviceName)) {
            LOG.error("Coprocessor service " + serviceName + " already registered, rejecting request from " + instance);
            return false;
        }
        this.coprocessorServiceHandlers.put(serviceName, instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registered master coprocessor service: service=" + serviceName);
        }
        return true;
    }

    public static HMaster constructMaster(Class<? extends HMaster> masterClass, Configuration conf) {
        try {
            Constructor<? extends HMaster> c = masterClass.getConstructor(Configuration.class);
            return c.newInstance(conf);
        }
        catch (Exception e) {
            Throwable error = e;
            if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() != null) {
                error = ((InvocationTargetException)e).getTargetException();
            }
            throw new RuntimeException("Failed construction of Master: " + masterClass.toString() + ". ", error);
        }
    }

    public static void main(String[] args) {
        LOG.info("STARTING service " + HMaster.class.getSimpleName());
        org.apache.hadoop.hbase.util.VersionInfo.logVersion();
        new HMasterCommandLine(HMaster.class).doMain(args);
    }

    public HFileCleaner getHFileCleaner() {
        return this.hfileCleaner;
    }

    public LogCleaner getLogCleaner() {
        return this.logCleaner;
    }

    @Override
    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    @Override
    public MasterProcedureManagerHost getMasterProcedureManagerHost() {
        return this.mpmHost;
    }

    @Override
    public ClusterSchema getClusterSchema() {
        return this.clusterSchemaService;
    }

    long createNamespace(final NamespaceDescriptor namespaceDescriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)namespaceDescriptor.getName()));
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preCreateNamespace(namespaceDescriptor);
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createBlockingLatch();
                LOG.info(HMaster.this.getClientIdAuditPrefix() + " creating " + namespaceDescriptor);
                this.setProcId(HMaster.this.getClusterSchema().createNamespace(namespaceDescriptor, this.getNonceKey(), latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postCreateNamespace(namespaceDescriptor);
            }

            @Override
            protected String getDescription() {
                return "CreateNamespaceProcedure";
            }
        });
    }

    long modifyNamespace(final NamespaceDescriptor newNsDescriptor, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        TableName.isLegalNamespaceName((byte[])Bytes.toBytes((String)newNsDescriptor.getName()));
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                NamespaceDescriptor oldNsDescriptor = HMaster.this.getNamespace(newNsDescriptor.getName());
                this.getMaster().getMasterCoprocessorHost().preModifyNamespace(oldNsDescriptor, newNsDescriptor);
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createBlockingLatch();
                LOG.info(HMaster.this.getClientIdAuditPrefix() + " modify " + newNsDescriptor);
                this.setProcId(HMaster.this.getClusterSchema().modifyNamespace(newNsDescriptor, this.getNonceKey(), latch));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postModifyNamespace(oldNsDescriptor, newNsDescriptor);
            }

            @Override
            protected String getDescription() {
                return "ModifyNamespaceProcedure";
            }
        });
    }

    long deleteNamespace(final String name, long nonceGroup, long nonce) throws IOException {
        this.checkInitialized();
        return MasterProcedureUtil.submitProcedure(new MasterProcedureUtil.NonceProcedureRunnable(this, nonceGroup, nonce){

            @Override
            protected void run() throws IOException {
                this.getMaster().getMasterCoprocessorHost().preDeleteNamespace(name);
                LOG.info(HMaster.this.getClientIdAuditPrefix() + " delete " + name);
                ProcedurePrepareLatch latch = ProcedurePrepareLatch.createBlockingLatch();
                this.setProcId(this.submitProcedure((Procedure<MasterProcedureEnv>)new DeleteNamespaceProcedure((MasterProcedureEnv)HMaster.this.procedureExecutor.getEnvironment(), name, latch)));
                latch.await();
                this.getMaster().getMasterCoprocessorHost().postDeleteNamespace(name);
            }

            @Override
            protected String getDescription() {
                return "DeleteNamespaceProcedure";
            }
        });
    }

    NamespaceDescriptor getNamespace(String name) throws IOException {
        this.checkInitialized();
        if (this.cpHost != null) {
            this.cpHost.preGetNamespaceDescriptor(name);
        }
        NamespaceDescriptor nsd = this.clusterSchemaService.getNamespace(name);
        if (this.cpHost != null) {
            this.cpHost.postGetNamespaceDescriptor(nsd);
        }
        return nsd;
    }

    List<NamespaceDescriptor> getNamespaces() throws IOException {
        this.checkInitialized();
        ArrayList<NamespaceDescriptor> nsds = new ArrayList<NamespaceDescriptor>();
        if (this.cpHost != null) {
            this.cpHost.preListNamespaceDescriptors(nsds);
        }
        nsds.addAll(this.clusterSchemaService.getNamespaces());
        if (this.cpHost != null) {
            this.cpHost.postListNamespaceDescriptors(nsds);
        }
        return nsds;
    }

    @Override
    public List<TableName> listTableNamesByNamespace(String name) throws IOException {
        this.checkInitialized();
        return this.listTableNames(name, null, true);
    }

    @Override
    public List<TableDescriptor> listTableDescriptorsByNamespace(String name) throws IOException {
        this.checkInitialized();
        return this.listTableDescriptors(name, null, null, true);
    }

    @Override
    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preAbortProcedure(this.procedureExecutor, procId);
        }
        boolean result = this.procedureExecutor.abort(procId, mayInterruptIfRunning);
        if (this.cpHost != null) {
            this.cpHost.postAbortProcedure();
        }
        return result;
    }

    @Override
    public List<Procedure<?>> getProcedures() throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preGetProcedures();
        }
        List procList = this.procedureExecutor.getProcedures();
        if (this.cpHost != null) {
            this.cpHost.postGetProcedures(procList);
        }
        return procList;
    }

    @Override
    public List<LockedResource> getLocks() throws IOException {
        if (this.cpHost != null) {
            this.cpHost.preGetLocks();
        }
        MasterProcedureScheduler procedureScheduler = ((MasterProcedureEnv)this.procedureExecutor.getEnvironment()).getProcedureScheduler();
        List<LockedResource> lockedResources = procedureScheduler.getLocks();
        if (this.cpHost != null) {
            this.cpHost.postGetLocks(lockedResources);
        }
        return lockedResources;
    }

    public List<TableDescriptor> listTableDescriptors(String namespace, String regex, List<TableName> tableNameList, boolean includeSysTables) throws IOException {
        List<TableDescriptor> htds = new ArrayList<TableDescriptor>();
        if (this.cpHost != null) {
            this.cpHost.preGetTableDescriptors(tableNameList, htds, regex);
        }
        htds = this.getTableDescriptors(htds, namespace, regex, tableNameList, includeSysTables);
        if (this.cpHost != null) {
            this.cpHost.postGetTableDescriptors(tableNameList, htds, regex);
        }
        return htds;
    }

    public List<TableName> listTableNames(String namespace, String regex, boolean includeSysTables) throws IOException {
        List<TableDescriptor> htds = new ArrayList<TableDescriptor>();
        if (this.cpHost != null) {
            this.cpHost.preGetTableNames(htds, regex);
        }
        htds = this.getTableDescriptors(htds, namespace, regex, null, includeSysTables);
        if (this.cpHost != null) {
            this.cpHost.postGetTableNames(htds, regex);
        }
        ArrayList<TableName> result = new ArrayList<TableName>(htds.size());
        for (TableDescriptor htd : htds) {
            result.add(htd.getTableName());
        }
        return result;
    }

    private List<TableDescriptor> getTableDescriptors(List<TableDescriptor> htds, String namespace, String regex, List<TableName> tableNameList, boolean includeSysTables) throws IOException {
        if (tableNameList == null || tableNameList.isEmpty()) {
            Collection<TableDescriptor> allHtds;
            if (namespace != null && namespace.length() > 0) {
                this.clusterSchemaService.getNamespace(namespace);
                allHtds = this.tableDescriptors.getByNamespace(namespace).values();
            } else {
                allHtds = this.tableDescriptors.getAll().values();
            }
            for (TableDescriptor desc : allHtds) {
                if (!this.tableStateManager.isTablePresent(desc.getTableName()) || !includeSysTables && desc.getTableName().isSystemTable()) continue;
                htds.add(desc);
            }
        } else {
            for (TableName s : tableNameList) {
                TableDescriptor desc;
                if (!this.tableStateManager.isTablePresent(s) || (desc = this.tableDescriptors.get(s)) == null) continue;
                htds.add(desc);
            }
        }
        if (regex != null) {
            HMaster.filterTablesByRegex(htds, Pattern.compile(regex));
        }
        return htds;
    }

    private static void filterTablesByRegex(Collection<TableDescriptor> descriptors, Pattern pattern) {
        String defaultNS = NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR;
        Iterator<TableDescriptor> itr = descriptors.iterator();
        while (itr.hasNext()) {
            TableDescriptor htd = itr.next();
            String tableName = htd.getTableName().getNameAsString();
            boolean matched = pattern.matcher(tableName).matches();
            if (!matched && htd.getTableName().getNamespaceAsString().equals(defaultNS)) {
                matched = pattern.matcher(defaultNS + ':' + tableName).matches();
            }
            if (matched) continue;
            itr.remove();
        }
    }

    @Override
    public long getLastMajorCompactionTimestamp(TableName table) throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLastMajorCompactionTimestamp(table);
    }

    @Override
    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
        return this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS)).getLastMajorCompactionTimestamp(regionName);
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getMobCompactionState(TableName tableName) {
        AtomicInteger compactionsCount = this.mobCompactionStates.get(tableName);
        if (compactionsCount != null && compactionsCount.get() != 0) {
            return AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR;
        }
        return AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMobCompactionStart(TableName tableName) throws IOException {
        IdLock.Entry lockEntry = null;
        try {
            lockEntry = this.mobCompactionLock.getLockEntry((long)tableName.hashCode());
            AtomicInteger compactionsCount = this.mobCompactionStates.get(tableName);
            if (compactionsCount == null) {
                compactionsCount = new AtomicInteger(0);
                this.mobCompactionStates.put(tableName, compactionsCount);
            }
            compactionsCount.incrementAndGet();
        }
        finally {
            if (lockEntry != null) {
                this.mobCompactionLock.releaseLockEntry(lockEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportMobCompactionEnd(TableName tableName) throws IOException {
        IdLock.Entry lockEntry = null;
        try {
            int count;
            lockEntry = this.mobCompactionLock.getLockEntry((long)tableName.hashCode());
            AtomicInteger compactionsCount = this.mobCompactionStates.get(tableName);
            if (compactionsCount != null && (count = compactionsCount.decrementAndGet()) == 0) {
                this.mobCompactionStates.remove(tableName);
            }
        }
        finally {
            if (lockEntry != null) {
                this.mobCompactionLock.releaseLockEntry(lockEntry);
            }
        }
    }

    public void requestMobCompaction(TableName tableName, List<ColumnFamilyDescriptor> columns, boolean allFiles) throws IOException {
        this.mobCompactThread.requestMobCompaction(this.conf, (FileSystem)this.fs, tableName, columns, allFiles);
    }

    public boolean isBalancerOn() {
        return !this.isInMaintenanceMode() && this.loadBalancerTracker != null && this.loadBalancerTracker.isBalancerOn();
    }

    public boolean isNormalizerOn() {
        return !this.isInMaintenanceMode() && this.regionNormalizerTracker != null && this.regionNormalizerTracker.isNormalizerOn();
    }

    @Override
    public boolean isSplitOrMergeEnabled(MasterSwitchType switchType) {
        return !this.isInMaintenanceMode() && this.splitOrMergeTracker != null && this.splitOrMergeTracker.isSplitOrMergeEnabled(switchType);
    }

    public String getLoadBalancerClassName() {
        return this.conf.get("hbase.master.loadbalancer.class", LoadBalancerFactory.getDefaultLoadBalancerClass().getName());
    }

    public RegionNormalizerTracker getRegionNormalizerTracker() {
        return this.regionNormalizerTracker;
    }

    public SplitOrMergeTracker getSplitOrMergeTracker() {
        return this.splitOrMergeTracker;
    }

    @Override
    public LoadBalancer getLoadBalancer() {
        return this.balancer;
    }

    @Override
    public FavoredNodesManager getFavoredNodesManager() {
        return this.favoredNodesManager;
    }

    private long executePeerProcedure(ModifyPeerProcedure procedure) throws IOException {
        long procId = this.procedureExecutor.submitProcedure((Procedure)procedure);
        procedure.getLatch().await();
        return procId;
    }

    @Override
    public long addReplicationPeer(String peerId, ReplicationPeerConfig peerConfig, boolean enabled) throws ReplicationException, IOException {
        LOG.info(this.getClientIdAuditPrefix() + " creating replication peer, id=" + peerId + ", config=" + peerConfig + ", state=" + (enabled ? "ENABLED" : "DISABLED"));
        return this.executePeerProcedure(new AddPeerProcedure(peerId, peerConfig, enabled));
    }

    @Override
    public long removeReplicationPeer(String peerId) throws ReplicationException, IOException {
        LOG.info(this.getClientIdAuditPrefix() + " removing replication peer, id=" + peerId);
        return this.executePeerProcedure(new RemovePeerProcedure(peerId));
    }

    @Override
    public long enableReplicationPeer(String peerId) throws ReplicationException, IOException {
        LOG.info(this.getClientIdAuditPrefix() + " enable replication peer, id=" + peerId);
        return this.executePeerProcedure(new EnablePeerProcedure(peerId));
    }

    @Override
    public long disableReplicationPeer(String peerId) throws ReplicationException, IOException {
        LOG.info(this.getClientIdAuditPrefix() + " disable replication peer, id=" + peerId);
        return this.executePeerProcedure(new DisablePeerProcedure(peerId));
    }

    @Override
    public ReplicationPeerConfig getReplicationPeerConfig(String peerId) throws ReplicationException, IOException {
        if (this.cpHost != null) {
            this.cpHost.preGetReplicationPeerConfig(peerId);
        }
        LOG.info(this.getClientIdAuditPrefix() + " get replication peer config, id=" + peerId);
        ReplicationPeerConfig peerConfig = this.replicationPeerManager.getPeerConfig(peerId).orElseThrow(() -> new ReplicationPeerNotFoundException(peerId));
        if (this.cpHost != null) {
            this.cpHost.postGetReplicationPeerConfig(peerId);
        }
        return peerConfig;
    }

    @Override
    public long updateReplicationPeerConfig(String peerId, ReplicationPeerConfig peerConfig) throws ReplicationException, IOException {
        LOG.info(this.getClientIdAuditPrefix() + " update replication peer config, id=" + peerId + ", config=" + peerConfig);
        return this.executePeerProcedure(new UpdatePeerConfigProcedure(peerId, peerConfig));
    }

    @Override
    public List<ReplicationPeerDescription> listReplicationPeers(String regex) throws ReplicationException, IOException {
        if (this.cpHost != null) {
            this.cpHost.preListReplicationPeers(regex);
        }
        LOG.info(this.getClientIdAuditPrefix() + " list replication peers, regex=" + regex);
        Pattern pattern = regex == null ? null : Pattern.compile(regex);
        List<ReplicationPeerDescription> peers = this.replicationPeerManager.listPeers(pattern);
        if (this.cpHost != null) {
            this.cpHost.postListReplicationPeers(regex);
        }
        return peers;
    }

    public void decommissionRegionServers(List<ServerName> servers, boolean offload) throws HBaseIOException {
        ArrayList<ServerName> serversAdded = new ArrayList<ServerName>(servers.size());
        String parentZnode = this.getZooKeeper().getZNodePaths().drainingZNode;
        for (ServerName server : servers) {
            try {
                String node = ZNodePaths.joinZNode((String)parentZnode, (String)server.getServerName());
                ZKUtil.createAndFailSilent((ZKWatcher)this.getZooKeeper(), (String)node);
            }
            catch (KeeperException ke) {
                throw new HBaseIOException(this.zooKeeper.prefix("Unable to decommission '" + server.getServerName() + "'."), (Throwable)ke);
            }
            if (!this.serverManager.addServerToDrainList(server)) continue;
            serversAdded.add(server);
        }
        if (offload) {
            List<ServerName> destServers = this.serverManager.createDestinationServersList();
            for (ServerName server : serversAdded) {
                List<RegionInfo> regionsOnServer = this.assignmentManager.getRegionsOnServer(server);
                for (RegionInfo hri : regionsOnServer) {
                    ServerName dest = this.balancer.randomAssignment(hri, destServers);
                    if (dest == null) {
                        throw new HBaseIOException("Unable to determine a plan to move " + hri);
                    }
                    RegionPlan rp = new RegionPlan(hri, server, dest);
                    this.assignmentManager.moveAsync(rp);
                }
            }
        }
    }

    public List<ServerName> listDecommissionedRegionServers() {
        return this.serverManager.getDrainingServersList();
    }

    public void recommissionRegionServer(ServerName server, List<byte[]> encodedRegionNames) throws IOException {
        String parentZnode = this.getZooKeeper().getZNodePaths().drainingZNode;
        String node = ZNodePaths.joinZNode((String)parentZnode, (String)server.getServerName());
        try {
            ZKUtil.deleteNodeFailSilent((ZKWatcher)this.getZooKeeper(), (String)node);
        }
        catch (KeeperException ke) {
            throw new HBaseIOException(this.zooKeeper.prefix("Unable to recommission '" + server.getServerName() + "'."), (Throwable)ke);
        }
        this.serverManager.removeServerFromDrainList(server);
        if (encodedRegionNames == null || encodedRegionNames.isEmpty()) {
            return;
        }
        if (!this.serverManager.isServerOnline(server)) {
            return;
        }
        for (byte[] encodedRegionName : encodedRegionNames) {
            RegionState regionState = this.assignmentManager.getRegionStates().getRegionState(Bytes.toString((byte[])encodedRegionName));
            if (regionState == null) {
                LOG.warn("Unknown region " + Bytes.toStringBinary((byte[])encodedRegionName));
                continue;
            }
            RegionInfo hri = regionState.getRegion();
            if (server.equals((Object)regionState.getServerName())) {
                LOG.info("Skipping move of region " + hri.getRegionNameAsString() + " because region already assigned to the same server " + server + ".");
                continue;
            }
            RegionPlan rp = new RegionPlan(hri, regionState.getServerName(), server);
            this.assignmentManager.moveAsync(rp);
        }
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    public QuotaObserverChore getQuotaObserverChore() {
        return this.quotaObserverChore;
    }

    public SpaceQuotaSnapshotNotifier getSpaceQuotaSnapshotNotifier() {
        return this.spaceQuotaSnapshotNotifier;
    }

    private RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ?> getRemoteProcedure(long procId) {
        Procedure procedure = this.procedureExecutor.getProcedure(procId);
        if (procedure == null) {
            return null;
        }
        assert (procedure instanceof RemoteProcedureDispatcher.RemoteProcedure);
        return (RemoteProcedureDispatcher.RemoteProcedure)procedure;
    }

    public void remoteProcedureCompleted(long procId) {
        LOG.debug("Remote procedure done, pid={}", (Object)procId);
        RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ?> procedure = this.getRemoteProcedure(procId);
        if (procedure != null) {
            procedure.remoteOperationCompleted(this.procedureExecutor.getEnvironment());
        }
    }

    public void remoteProcedureFailed(long procId, RemoteProcedureException error) {
        LOG.debug("Remote procedure failed, pid={}", (Object)procId, (Object)error);
        RemoteProcedureDispatcher.RemoteProcedure<MasterProcedureEnv, ?> procedure = this.getRemoteProcedure(procId);
        if (procedure != null) {
            procedure.remoteOperationFailed(this.procedureExecutor.getEnvironment(), error);
        }
    }

    @Override
    public ReplicationPeerManager getReplicationPeerManager() {
        return this.replicationPeerManager;
    }

    public HashMap<String, List<Pair<ServerName, ReplicationLoadSource>>> getReplicationLoad(ServerName[] serverNames) {
        List<ReplicationPeerDescription> peerList = this.getReplicationPeerManager().listPeers(null);
        if (peerList == null) {
            return null;
        }
        HashMap<String, List<Pair<ServerName, ReplicationLoadSource>>> replicationLoadSourceMap = new HashMap<String, List<Pair<ServerName, ReplicationLoadSource>>>(peerList.size());
        peerList.stream().forEach(peer -> {
            List cfr_ignored_0 = replicationLoadSourceMap.put(peer.getPeerId(), new ArrayList());
        });
        for (ServerName serverName : serverNames) {
            List replicationLoadSources = this.getServerManager().getLoad(serverName).getReplicationLoadSourceList();
            for (ReplicationLoadSource replicationLoadSource : replicationLoadSources) {
                replicationLoadSourceMap.get(replicationLoadSource.getPeerID()).add((Pair<ServerName, ReplicationLoadSource>)new Pair((Object)serverName, (Object)replicationLoadSource));
            }
        }
        for (List loads : replicationLoadSourceMap.values()) {
            if (loads.size() <= 0) continue;
            loads.sort(Comparator.comparingLong(load -> -1L * ((ReplicationLoadSource)load.getSecond()).getReplicationLag()));
        }
        return replicationLoadSourceMap;
    }

    @VisibleForTesting
    public static void decorateMasterConfiguration(Configuration conf) {
        String cleanerClass;
        String plugins = conf.get("hbase.master.logcleaner.plugins");
        if (!plugins.contains(cleanerClass = ReplicationLogCleaner.class.getCanonicalName())) {
            conf.set("hbase.master.logcleaner.plugins", plugins + "," + cleanerClass);
        }
        if (ReplicationUtils.isReplicationForBulkLoadDataEnabled((Configuration)conf) && !(plugins = conf.get("hbase.master.hfilecleaner.plugins")).contains(cleanerClass = ReplicationHFileCleaner.class.getCanonicalName())) {
            conf.set("hbase.master.hfilecleaner.plugins", plugins + "," + cleanerClass);
        }
    }

    @Override
    public Map<String, ReplicationStatus> getWalGroupsReplicationStatus() {
        if (!this.isOnline() || !LoadBalancer.isMasterCanHostUserRegions(this.conf)) {
            return new HashMap<String, ReplicationStatus>();
        }
        return super.getWalGroupsReplicationStatus();
    }

    public HbckChore getHbckChore() {
        return this.hbckChore;
    }

    public static class MasterStoppedException
    extends DoNotRetryIOException {
        MasterStoppedException() {
        }
    }

    protected static interface TableDescriptorGetter {
        public TableDescriptor get() throws IOException;
    }

    public static class RedirectServlet
    extends HttpServlet {
        private static final long serialVersionUID = 2894774810058302473L;
        private final int regionServerInfoPort;
        private final String regionServerHostname;

        public RedirectServlet(InfoServer infoServer, String hostname) {
            this.regionServerInfoPort = infoServer.getPort();
            this.regionServerHostname = hostname;
        }

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String redirectHost = this.regionServerHostname;
            if (redirectHost == null && !Addressing.isLocalAddress((InetAddress)InetAddress.getByName(redirectHost = request.getServerName()))) {
                LOG.warn("Couldn't resolve '" + redirectHost + "' as an address local to this node and '" + "hbase.master.hostname" + "' is not set; client will get an HTTP 400 response. If your HBase deployment relies on client accessible names that the region server process can't resolve locally, then you should set the previously mentioned configuration variable to an appropriate hostname.");
                response.sendError(400, "Request was to a host that I can't resolve for any of the network interfaces on this node. If this is due to an intermediary such as an HTTP load balancer or other proxy, your HBase administrator can set 'hbase.master.hostname' to point to the correct hostname.");
                return;
            }
            String redirectUrl = request.getScheme() + "://" + redirectHost + ":" + this.regionServerInfoPort + request.getRequestURI();
            response.sendRedirect(redirectUrl);
        }
    }

    private static class InitializationMonitor
    extends HasThread {
        public static final String TIMEOUT_KEY = "hbase.master.initializationmonitor.timeout";
        public static final long TIMEOUT_DEFAULT = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);
        public static final String HALT_KEY = "hbase.master.initializationmonitor.haltontimeout";
        public static final boolean HALT_DEFAULT = false;
        private final HMaster master;
        private final long timeout;
        private final boolean haltOnTimeout;

        InitializationMonitor(HMaster master) {
            super("MasterInitializationMonitor");
            this.master = master;
            this.timeout = master.getConfiguration().getLong(TIMEOUT_KEY, TIMEOUT_DEFAULT);
            this.haltOnTimeout = master.getConfiguration().getBoolean(HALT_KEY, false);
            this.setDaemon(true);
        }

        public void run() {
            try {
                while (!this.master.isStopped() && this.master.isActiveMaster()) {
                    Thread.sleep(this.timeout);
                    if (this.master.isInitialized()) {
                        LOG.debug("Initialization completed within allotted tolerance. Monitor exiting.");
                        continue;
                    }
                    LOG.error("Master failed to complete initialization after " + this.timeout + "ms. Please consider submitting a bug report including a thread dump of this process.");
                    if (!this.haltOnTimeout) continue;
                    LOG.error("Zombie Master exiting. Thread dump to stdout");
                    Threads.printThreadInfo((PrintStream)System.out, (String)"Zombie HMaster");
                    System.exit(-1);
                }
            }
            catch (InterruptedException ie) {
                LOG.trace("InitMonitor thread interrupted. Existing.");
            }
        }
    }
}

