/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.controller;

import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import net.sf.json.JSONException;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.coverage.metadata.RangeMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.ScalarMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.Statistic;
import uk.ac.rdg.resc.edal.coverage.metadata.StatisticsCollection;
import uk.ac.rdg.resc.edal.coverage.metadata.VectorComponent;
import uk.ac.rdg.resc.edal.coverage.metadata.VectorMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.impl.MetadataUtils;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.graphics.style.FeatureCollectionAndMemberName;
import uk.ac.rdg.resc.edal.graphics.style.Id2FeatureAndMember;
import uk.ac.rdg.resc.edal.graphics.style.StyleJSONParser;
import uk.ac.rdg.resc.edal.graphics.style.StyleXMLParser;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ArrowLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourMap;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourScale;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ColourScheme;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ConfidenceIntervalLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.ContourLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.Image;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.PaletteColourScheme;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.PatternScale;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.RasterLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.SmoothedContourLayer;
import uk.ac.rdg.resc.edal.graphics.style.datamodel.impl.StippleLayer;
import uk.ac.rdg.resc.edal.util.CollectionUtils;
import uk.ac.rdg.resc.edal.util.Extents;
import uk.ac.rdg.resc.ncwms.config.Dataset;
import uk.ac.rdg.resc.ncwms.config.FeaturePlottingMetadata;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;

public class GetMapStyleParams {
    private String[] layers;
    private String[] styles;
    private String xmlStyle;
    private boolean transparent = false;
    private Color backgroundColour = Color.white;
    private int opacity = 100;
    private int numColourBands = 254;
    private boolean logarithmic = false;
    private Extent<Float> colorScaleRange;
    private boolean autoScale = false;
    private boolean xmlSpecified = false;
    private Id2FeatureAndMember id2Feature;
    private Map<String, Dataset> datasets;
    private static StyleXMLParser.ColorAdapter cAdapter = new StyleXMLParser.ColorAdapter();

    public GetMapStyleParams(RequestParams params, Id2FeatureAndMember id2Feature, Map<String, Dataset> datasets) throws WmsException {
        this.id2Feature = id2Feature;
        this.datasets = datasets;
        String layersStr = params.getString("layers");
        this.layers = layersStr == null || layersStr.trim().isEmpty() ? null : layersStr.split(",");
        String stylesStr = params.getString("styles");
        this.styles = stylesStr == null ? null : (stylesStr.trim().isEmpty() ? new String[0] : stylesStr.split(","));
        this.xmlStyle = params.getString("XML_STYLE");
        String jsonStyle = params.getString("JSON_STYLE");
        if (jsonStyle != null && this.xmlStyle == null) {
            try {
                this.xmlStyle = StyleJSONParser.JSONtoXMLString((String)jsonStyle);
            }
            catch (JSONException e) {
                e.printStackTrace();
                throw new WmsException("Problem parsing JSON style to XML style.  Check logs for stack trace");
            }
        }
        if (this.xmlStyle == null) {
            this.xmlSpecified = false;
            if (this.layers == null) {
                throw new WmsException("You must specify either XML_STYLE, JSON_STYLE or LAYERS and STYLES");
            }
            if (this.styles.length != this.layers.length && this.styles.length != 0) {
                throw new WmsException("You must request exactly one STYLE per layer, or use the default style for each layer with STYLES=");
            }
        } else {
            this.xmlSpecified = true;
        }
        this.transparent = params.getBoolean("transparent", false);
        try {
            String bgc = params.getString("bgcolor", "0xFFFFFF");
            if (bgc.length() != 8 && bgc.length() != 10 || !bgc.startsWith("0x")) {
                throw new Exception();
            }
            this.backgroundColour = cAdapter.unmarshal(bgc);
        }
        catch (Exception e) {
            throw new WmsException("Invalid format for BGCOLOR");
        }
        this.opacity = params.getPositiveInt("opacity", 100);
        if (this.opacity > 100) {
            this.opacity = 100;
        }
        this.colorScaleRange = this.getColorScaleRange(params);
        if (this.colorScaleRange == null || this.colorScaleRange.isEmpty()) {
            this.autoScale = true;
        }
        this.logarithmic = params.getBoolean("logscale", false);
        this.numColourBands = params.getPositiveInt("numcolorbands", 254);
        if (this.numColourBands > 254) {
            this.numColourBands = 254;
        }
    }

    private Extent<Float> getColorScaleRange(RequestParams params) throws WmsException {
        String csr = params.getString("colorscalerange");
        if (csr == null || csr.equalsIgnoreCase("default")) {
            return null;
        }
        if (csr.equalsIgnoreCase("auto")) {
            return Extents.emptyExtent(Float.class);
        }
        String[] scaleEls = csr.split(",");
        if (scaleEls.length == 0) {
            return Extents.emptyExtent(Float.class);
        }
        Float scaleMin = Float.valueOf(Float.parseFloat(scaleEls[0]));
        Float scaleMax = Float.valueOf(Float.parseFloat(scaleEls[1]));
        if (scaleMin.floatValue() > scaleMax.floatValue()) {
            throw new WmsException("Min > Max in COLORSCALERANGE");
        }
        return Extents.newExtent((Object)scaleMin, (Object)scaleMax);
    }

    public Image getImageGenerator() throws WmsException {
        String[] styleParts;
        if (this.xmlStyle != null) {
            try {
                return StyleXMLParser.deserialise((String)this.xmlStyle);
            }
            catch (JAXBException e) {
                e.printStackTrace();
                throw new WmsException("Problem parsing XML style.  Check logs for stack trace");
            }
        }
        if (this.layers.length > 1) {
            throw new WmsException("Only 1 layer may be requested");
        }
        String layerName = this.layers[0];
        String style = "default/default";
        if (this.styles.length != 0) {
            style = this.styles[0];
        }
        if ((styleParts = style.split("/")).length == 0) {
            throw new WmsException("Style should be of the form STYLE/PALETTE ()");
        }
        String plotStyleName = styleParts[0];
        String paletteName = styleParts.length > 1 ? styleParts[1] : "default";
        Image image = new Image();
        ArrowLayer layer = null;
        if (plotStyleName.toLowerCase().startsWith("default")) {
            FeatureCollectionAndMemberName featureAndMemberName = this.id2Feature.getFeatureAndMemberName(layerName);
            String memberName = featureAndMemberName.getMemberName();
            String datasetName = featureAndMemberName.getFeatureCollection().getId();
            Collection findFeatures = featureAndMemberName.getFeatureCollection().findFeatures(null, null, null, CollectionUtils.setOf((Object[])new String[]{memberName}));
            Feature feature = null;
            Iterator i$ = findFeatures.iterator();
            while (i$.hasNext()) {
                Feature f;
                feature = f = (Feature)i$.next();
            }
            if (feature == null) {
                throw new WmsException("No features fit this description");
            }
            RangeMetadata topMetadata = feature.getCoverage().getRangeMetadata();
            RangeMetadata memberMetadata = MetadataUtils.getDescendantMetadata((RangeMetadata)topMetadata, (String)memberName);
            Dataset dataset = (Dataset)this.datasets.get(featureAndMemberName.getFeatureCollection().getId());
            if (memberMetadata instanceof ScalarMetadata) {
                plotStyleName = "boxfill";
            } else {
                if (memberMetadata instanceof VectorMetadata) {
                    VectorMetadata vectorMetadata = (VectorMetadata)memberMetadata;
                    List representativeChildren = vectorMetadata.getRepresentativeChildren();
                    String magnitudeFieldName = null;
                    String directionFieldName = null;
                    for (ScalarMetadata m : representativeChildren) {
                        if (m instanceof VectorComponent) {
                            VectorComponent vectorComponent = (VectorComponent)m;
                            if (vectorComponent.getComponentType() == VectorComponent.VectorComponentType.MAGNITUDE) {
                                magnitudeFieldName = vectorComponent.getName();
                                continue;
                            }
                            if (vectorComponent.getComponentType() != VectorComponent.VectorComponentType.DIRECTION) continue;
                            directionFieldName = vectorComponent.getName();
                            continue;
                        }
                        throw new WmsException("Vector Metadata must contain vector components");
                    }
                    if (magnitudeFieldName == null || directionFieldName == null) {
                        throw new WmsException("Vector Metadata must contain magnitude and direction");
                    }
                    ColourScale scaleRange = new ColourScale((Float)this.colorScaleRange.getLow(), (Float)this.colorScaleRange.getHigh(), Boolean.valueOf(this.logarithmic));
                    ColourMap colourPalette = new ColourMap(Color.black, Color.black, new Color(0, true), paletteName, Integer.valueOf(this.numColourBands));
                    PaletteColourScheme colourScheme = new PaletteColourScheme(scaleRange, colourPalette);
                    layer = new RasterLayer(datasetName + "/" + magnitudeFieldName, (ColourScheme)colourScheme);
                    image.getLayers().add(layer);
                    layer = new ArrowLayer(datasetName + "/" + directionFieldName, Integer.valueOf(8), Color.black);
                    image.getLayers().add(layer);
                    return image;
                }
                if (memberMetadata instanceof StatisticsCollection) {
                    StatisticsCollection statisticsCollection = (StatisticsCollection)memberMetadata;
                    List children = statisticsCollection.getRepresentativeChildren();
                    String meanFieldName = null;
                    String stddevFieldName = null;
                    String lowerFieldName = null;
                    String upperFieldName = null;
                    for (String childName : statisticsCollection.getMemberNames()) {
                        ScalarMetadata m = (ScalarMetadata)statisticsCollection.getMemberMetadata(childName);
                        if (m instanceof Statistic) {
                            Statistic statistic = (Statistic)m;
                            if (statistic.getStatisticType() == Statistic.StatisticType.MEAN) {
                                meanFieldName = statistic.getName();
                                continue;
                            }
                            if (statistic.getStatisticType() == Statistic.StatisticType.STANDARD_DEVIATION) {
                                stddevFieldName = statistic.getName();
                                continue;
                            }
                            if (statistic.getStatisticType() == Statistic.StatisticType.LOWER_CONFIDENCE_BOUND) {
                                lowerFieldName = statistic.getName();
                                continue;
                            }
                            if (statistic.getStatisticType() != Statistic.StatisticType.UPPER_CONFIDENCE_BOUND) continue;
                            upperFieldName = statistic.getName();
                            continue;
                        }
                        throw new WmsException("Statistics must (currently) contain mean and std dev");
                    }
                    if (meanFieldName == null || stddevFieldName == null || lowerFieldName == null || upperFieldName == null) {
                        throw new WmsException("Statistics must (currently) contain mean and std dev");
                    }
                    ColourScale scaleRange = new ColourScale((Float)this.colorScaleRange.getLow(), (Float)this.colorScaleRange.getHigh(), Boolean.valueOf(this.logarithmic));
                    ColourMap colourPalette = new ColourMap(Color.black, Color.black, new Color(0, true), paletteName, Integer.valueOf(this.numColourBands));
                    PaletteColourScheme colourScheme = new PaletteColourScheme(scaleRange, colourPalette);
                    layer = new RasterLayer(datasetName + "/" + meanFieldName, (ColourScheme)colourScheme);
                    image.getLayers().add(layer);
                    FeaturePlottingMetadata stddevPlottingMetadata = (FeaturePlottingMetadata)dataset.getPlottingMetadataMap().get(stddevFieldName);
                    Extent sdRange = stddevPlottingMetadata.getColorScaleRange();
                    if (plotStyleName.toLowerCase().endsWith("contour") || plotStyleName.equalsIgnoreCase("default")) {
                        layer = new ContourLayer(datasetName + "/" + stddevFieldName, new ColourScale((Float)sdRange.getLow(), (Float)sdRange.getHigh(), Boolean.valueOf(this.logarithmic)), this.autoScale, 8.0, Color.black, 1, ContourLayer.ContourLineStyle.SOLID, true);
                    } else if (plotStyleName.toLowerCase().endsWith("smooth")) {
                        layer = new SmoothedContourLayer(datasetName + "/" + stddevFieldName, new ColourScale((Float)sdRange.getLow(), (Float)sdRange.getHigh(), Boolean.valueOf(this.logarithmic)), this.autoScale, 8.0, Color.black, 1, ContourLayer.ContourLineStyle.SOLID, true);
                    } else if (plotStyleName.toLowerCase().endsWith("stipple")) {
                        float range = ((Float)sdRange.getHigh()).floatValue() - ((Float)sdRange.getLow()).floatValue();
                        float low = ((Float)sdRange.getLow()).floatValue() + 0.1f * range;
                        float high = ((Float)sdRange.getHigh()).floatValue() - 0.1f * range;
                        layer = new StippleLayer(datasetName + "/" + stddevFieldName, new PatternScale(5, Float.valueOf(low), Float.valueOf(high), Boolean.valueOf(false)));
                    } else if (plotStyleName.toLowerCase().endsWith("confidence")) {
                        image.getLayers().remove(0);
                        layer = new ConfidenceIntervalLayer(datasetName + "/" + lowerFieldName, datasetName + "/" + upperFieldName, 8, (ColourScheme)colourScheme);
                    } else if (plotStyleName.toLowerCase().endsWith("fade_black")) {
                        layer = new RasterLayer(datasetName + "/" + stddevFieldName, (ColourScheme)new PaletteColourScheme(new ColourScale((Float)sdRange.getLow(), (Float)sdRange.getHigh(), Boolean.valueOf(this.logarithmic)), new ColourMap(new Color(0, true), Color.black, new Color(0, true), "#00000000,#ff000000", Integer.valueOf(15))));
                    } else if (plotStyleName.toLowerCase().endsWith("fade_white")) {
                        layer = new RasterLayer(datasetName + "/" + stddevFieldName, (ColourScheme)new PaletteColourScheme(new ColourScale((Float)sdRange.getLow(), (Float)sdRange.getHigh(), Boolean.valueOf(this.logarithmic)), new ColourMap(new Color(0, true), Color.white, new Color(0, true), "#00ffffff,#ffffffff", Integer.valueOf(15))));
                    }
                    image.getLayers().add(layer);
                    return image;
                }
            }
        }
        if (plotStyleName.equalsIgnoreCase("boxfill")) {
            ColourScale scaleRange = new ColourScale((Float)this.colorScaleRange.getLow(), (Float)this.colorScaleRange.getHigh(), Boolean.valueOf(this.logarithmic));
            ColourMap colourPalette = new ColourMap(Color.black, Color.black, new Color(0, true), paletteName, Integer.valueOf(this.numColourBands));
            PaletteColourScheme colourScheme = new PaletteColourScheme(scaleRange, colourPalette);
            layer = new RasterLayer(layerName, (ColourScheme)colourScheme);
        } else if (plotStyleName.equalsIgnoreCase("contour")) {
            layer = new ContourLayer(layerName, new ColourScale((Float)this.colorScaleRange.getLow(), (Float)this.colorScaleRange.getHigh(), Boolean.valueOf(this.logarithmic)), this.autoScale, (double)this.numColourBands, Color.black, 1, ContourLayer.ContourLineStyle.SOLID, true);
        } else if (plotStyleName.equalsIgnoreCase("stipple")) {
            PatternScale scale = new PatternScale(this.numColourBands, (Float)this.colorScaleRange.getLow(), (Float)this.colorScaleRange.getHigh(), Boolean.valueOf(this.logarithmic));
            layer = new StippleLayer(layerName, scale);
        } else if (plotStyleName.equalsIgnoreCase("arrow")) {
            layer = new ArrowLayer(layerName, Integer.valueOf(8), Color.black);
        }
        if (layer == null) {
            throw new WmsException("Do not know how to plot the style: " + plotStyleName);
        }
        image.getLayers().add(layer);
        return image;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public int getOpacity() {
        return this.opacity;
    }

    public int getNumLayers() {
        return this.layers.length;
    }

    public boolean isXmlDefined() {
        return this.xmlSpecified;
    }
}

