/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.coverage.DiscreteCoverage;
import uk.ac.rdg.resc.edal.coverage.grid.HorizontalGrid;
import uk.ac.rdg.resc.edal.coverage.grid.RegularGrid;
import uk.ac.rdg.resc.edal.coverage.grid.VerticalAxis;
import uk.ac.rdg.resc.edal.coverage.metadata.impl.MetadataUtils;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.FeatureCollection;
import uk.ac.rdg.resc.edal.feature.GridFeature;
import uk.ac.rdg.resc.edal.feature.GridSeriesFeature;
import uk.ac.rdg.resc.edal.feature.PointSeriesFeature;
import uk.ac.rdg.resc.edal.feature.ProfileFeature;
import uk.ac.rdg.resc.edal.feature.UniqueMembersFeatureCollection;
import uk.ac.rdg.resc.edal.geometry.BoundingBox;
import uk.ac.rdg.resc.edal.graphics.ColorPalette;
import uk.ac.rdg.resc.edal.position.CalendarSystem;
import uk.ac.rdg.resc.edal.position.TimePeriod;
import uk.ac.rdg.resc.edal.position.TimePosition;
import uk.ac.rdg.resc.edal.position.VerticalCrs;
import uk.ac.rdg.resc.edal.position.VerticalPosition;
import uk.ac.rdg.resc.edal.position.impl.TimePeriodImpl;
import uk.ac.rdg.resc.edal.position.impl.TimePositionJoda;
import uk.ac.rdg.resc.edal.util.CollectionUtils;
import uk.ac.rdg.resc.edal.util.Extents;
import uk.ac.rdg.resc.edal.util.GISUtils;
import uk.ac.rdg.resc.edal.util.TimeUtils;
import uk.ac.rdg.resc.ncwms.config.Config;
import uk.ac.rdg.resc.ncwms.config.FeaturePlottingMetadata;
import uk.ac.rdg.resc.ncwms.controller.AbstractWmsController;
import uk.ac.rdg.resc.ncwms.controller.GetMapDataRequest;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.exceptions.MetadataException;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class AbstractMetadataController {
    private static final Logger log = LoggerFactory.getLogger(AbstractMetadataController.class);
    protected final AbstractWmsController.FeatureFactory featureFactory;
    protected Config config;

    protected AbstractMetadataController(Config config, AbstractWmsController.FeatureFactory featureFactory) {
        this.config = config;
        this.featureFactory = featureFactory;
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws MetadataException {
        try {
            RequestParams params = new RequestParams(request.getParameterMap());
            String item = params.getString("item");
            if (item == null) {
                throw new Exception("Must provide an ITEM parameter");
            }
            if (item.equals("menu")) {
                return this.showMenu(params);
            }
            if (item.equals("layerDetails")) {
                return this.showLayerDetails(params);
            }
            if (item.equals("timesteps")) {
                return this.showTimesteps(params);
            }
            if (item.equals("minmax")) {
                return this.showMinMax(params);
            }
            if (item.equals("animationTimesteps")) {
                return this.showAnimationTimesteps(params);
            }
            throw new Exception("Invalid value for ITEM parameter");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MetadataException(e);
        }
    }

    protected abstract ModelAndView showMenu(RequestParams var1) throws Exception;

    protected ModelAndView showLayerDetails(RequestParams params) throws Exception {
        String units;
        BoundingBox bbox;
        boolean multiFeature;
        String layerName = params.getMandatoryString("layerName");
        FeatureCollection featureCollection = this.featureFactory.getFeatureCollection(layerName);
        String memberName = WmsUtils.getMemberName((String)layerName);
        HashMap<String, Object> models = new HashMap<String, Object>();
        Set styles = new HashSet();
        if (featureCollection instanceof UniqueMembersFeatureCollection) {
            Feature feature = ((UniqueMembersFeatureCollection)featureCollection).getFeatureContainingMember(memberName);
            multiFeature = false;
            bbox = WmsUtils.getWmsBoundingBox((Feature)feature);
            styles = WmsUtils.getBaseStyles((Feature)feature, (String)memberName);
            VerticalAxis vAxis = GISUtils.getVerticalAxis((Feature)feature);
            List<TimePosition> timeValues = GISUtils.getTimes((Feature)feature, (boolean)false);
            CalendarSystem calendarSystem = null;
            if (timeValues != null && timeValues.size() > 0) {
                calendarSystem = ((TimePosition)timeValues.get(0)).getCalendarSystem();
            }
            TimePositionJoda targetDateTime = new TimePositionJoda(calendarSystem);
            String targetDateIso = params.getString("time");
            if (targetDateIso != null && !targetDateIso.trim().equals("")) {
                try {
                    targetDateTime = TimeUtils.iso8601ToDateTime((String)targetDateIso, (CalendarSystem)calendarSystem);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
            LinkedHashMap datesWithData = new LinkedHashMap();
            if (timeValues == null) {
                timeValues = Collections.emptyList();
            }
            TimePosition nearestDateTime = GISUtils.getClosestTimeTo((TimePosition)targetDateTime, timeValues);
            for (TimePosition dateTime : timeValues) {
                int day;
                int month;
                ArrayList<Integer> days;
                int year;
                LinkedHashMap months;
                long d1 = dateTime.differenceInMillis((TimePosition)targetDateTime);
                long d2 = nearestDateTime.differenceInMillis((TimePosition)targetDateTime);
                if (Math.abs(d1) < Math.abs(d2)) {
                    nearestDateTime = dateTime;
                }
                if ((months = (LinkedHashMap)datesWithData.get(year = dateTime.getYear())) == null) {
                    months = new LinkedHashMap();
                    datesWithData.put(year, months);
                }
                if ((days = (ArrayList<Integer>)months.get(month = dateTime.getMonthOfYear())) == null) {
                    days = new ArrayList<Integer>();
                    months.put(month, days);
                }
                if (days.contains(day = dateTime.getDayOfMonth())) continue;
                days.add(day);
            }
            units = MetadataUtils.getUnitsString((Feature)feature, (String)memberName);
            if (calendarSystem != null) {
                models.put("tAxisUnits", TimeUtils.getTimeAxisUnits((CalendarSystem)calendarSystem));
            } else {
                models.put("tAxisUnits", "none");
            }
            models.put("datesWithData", datesWithData);
            models.put("nearestTimeIso", TimeUtils.dateTimeToISO8601((TimePosition)nearestDateTime));
            models.put("vaxis", vAxis);
        } else {
            multiFeature = true;
            bbox = featureCollection.getCollectionBoundingBox();
            units = "";
            if (featureCollection.getFeatures() != null) {
                for (Feature feature : featureCollection.getFeatures()) {
                    if (!feature.getCoverage().getScalarMemberNames().contains(memberName)) continue;
                    units = MetadataUtils.getUnitsString((Feature)feature, (String)memberName);
                    styles = WmsUtils.getBaseStyles((Feature)feature, (String)memberName);
                    break;
                }
            }
            Extent verticalExtent = featureCollection.getCollectionVerticalExtent();
            Double startZ = ((VerticalPosition)verticalExtent.getLow()).getZ();
            Double endZ = ((VerticalPosition)verticalExtent.getHigh()).getZ();
            VerticalCrs verticalCrs = ((VerticalPosition)verticalExtent.getHigh()).getCoordinateReferenceSystem();
            models.put("startZ", startZ.toString());
            models.put("endZ", endZ.toString());
            models.put("verticalCrs", verticalCrs);
            TimePosition startTime = (TimePosition)featureCollection.getCollectionTimeExtent().getLow();
            TimePosition endTime = (TimePosition)featureCollection.getCollectionTimeExtent().getHigh();
            models.put("startTime", TimeUtils.dateTimeToISO8601((TimePosition)startTime));
            models.put("endTime", TimeUtils.dateTimeToISO8601((TimePosition)endTime));
            models.put("tAxisUnits", TimeUtils.getTimeAxisUnits((CalendarSystem)startTime.getCalendarSystem()));
            TimePositionJoda targetDateTime = new TimePositionJoda(startTime.getCalendarSystem());
            String targetDateIso = params.getString("time");
            if (targetDateIso != null && !targetDateIso.trim().equals("")) {
                try {
                    targetDateTime = TimeUtils.iso8601ToDateTime((String)targetDateIso, (CalendarSystem)startTime.getCalendarSystem());
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
            }
            if (targetDateTime.compareTo(startTime) < 0) {
                targetDateTime = startTime;
            } else if (targetDateTime.compareTo(endTime) > 0) {
                targetDateTime = endTime;
            }
            models.put("nearestTimeIso", TimeUtils.dateTimeToISO8601((TimePosition)targetDateTime));
        }
        models.put("bbox", bbox);
        models.put("multiFeature", multiFeature);
        models.put("units", units);
        models.put("styles", styles);
        FeaturePlottingMetadata plottingMetadata = WmsUtils.getMetadata((Config)this.config, (String)layerName);
        models.put("featureMetadata", plottingMetadata);
        models.put("memberName", memberName);
        models.put("dataset", WmsUtils.getDataset((Config)this.config, (String)layerName));
        models.put("paletteNames", ColorPalette.getAvailablePaletteNames());
        return new ModelAndView("showLayerDetails", models);
    }

    private ModelAndView showTimesteps(RequestParams params) throws Exception {
        String layerName = params.getMandatoryString("layerName");
        FeatureCollection featureCollection = this.featureFactory.getFeatureCollection(layerName);
        if (!(featureCollection instanceof UniqueMembersFeatureCollection)) {
            throw new WmsException("The method GetMetadata, item=timesteps is not valid for datasets with a continuous time axis");
        }
        String memberName = WmsUtils.getMemberName((String)layerName);
        Feature feature = ((UniqueMembersFeatureCollection)featureCollection).getFeatureContainingMember(memberName);
        List tValues = GISUtils.getTimes((Feature)feature, (boolean)false);
        if (tValues == null || tValues.isEmpty()) {
            return null;
        }
        String dayStr = params.getString("day");
        if (dayStr == null) {
            throw new Exception("Must provide a value for the day parameter");
        }
        TimePosition date = TimeUtils.iso8601ToDate((String)dayStr, (CalendarSystem)((TimePosition)tValues.get(0)).getCalendarSystem());
        ArrayList<TimePosition> timesteps = new ArrayList<TimePosition>();
        for (TimePosition tVal : tValues) {
            if (!AbstractMetadataController.onSameDay((TimePosition)tVal, (TimePosition)date)) continue;
            timesteps.add(tVal);
        }
        log.debug("Found {} timesteps on {}", (Object)timesteps.size(), (Object)dayStr);
        return new ModelAndView("showTimesteps", "timesteps", timesteps);
    }

    private static boolean onSameDay(TimePosition dt1, TimePosition dt2) {
        boolean onSameDay = dt1.getYear() == dt2.getYear() && dt1.getMonthOfYear() == dt2.getMonthOfYear() && dt1.getDayOfMonth() == dt2.getDayOfMonth();
        log.debug("onSameDay({}, {}) = {}", new Object[]{dt1, dt2, onSameDay});
        return onSameDay;
    }

    private ModelAndView showMinMax(RequestParams params) throws Exception {
        GetMapDataRequest dr = new GetMapDataRequest(params, params.getWmsVersion());
        String[] layerNames = dr.getLayers();
        if (layerNames == null || layerNames.length != 1) {
            throw new WmsException("Must request exactly one WMS layer to get min/max");
        }
        String layerName = layerNames[0];
        String memberName = WmsUtils.getMemberName((String)layerName);
        FeatureCollection featureCollection = this.featureFactory.getFeatureCollection(layerName);
        Extent valueRange = null;
        RegularGrid grid = WmsUtils.getImageGrid((GetMapDataRequest)dr);
        if (featureCollection instanceof UniqueMembersFeatureCollection) {
            Feature feature = ((UniqueMembersFeatureCollection)featureCollection).getFeatureContainingMember(memberName);
            memberName = MetadataUtils.getScalarMemberName((Feature)feature, (String)memberName);
            VerticalPosition zValue = GISUtils.getExactElevation((String)dr.getElevationString(), (VerticalAxis)GISUtils.getVerticalAxis((Feature)feature));
            List timeValues = WmsUtils.getTimePositionsForString((String)dr.getTimeString(), (Feature)feature);
            TimePosition tValue = timeValues.isEmpty() ? null : (TimePosition)timeValues.get(0);
            valueRange = this.getFeatureMinMax(feature, zValue, tValue, memberName, grid);
        } else {
            Extent tRange = TimeUtils.getTimeRangeForString((String)dr.getTimeString(), (CalendarSystem)CalendarSystem.CAL_ISO_8601);
            Extent zRange = WmsUtils.getElevationRangeForString((String)dr.getElevationString());
            Collection features = featureCollection.findFeatures(grid.getCoordinateExtent(), zRange, tRange, CollectionUtils.setOf((Object[])new String[]{memberName}));
            TimePosition colorByTime = null;
            if (dr.getColorbyTimeString() != null) {
                colorByTime = TimeUtils.iso8601ToDateTime((String)dr.getColorbyTimeString(), (CalendarSystem)CalendarSystem.CAL_ISO_8601);
            }
            Double colorByDepth = null;
            if (dr.getColorbyElevationString() != null) {
                colorByDepth = Double.parseDouble(dr.getColorbyElevationString());
            }
            float max = -3.4028235E38f;
            float min = Float.MAX_VALUE;
            for (Feature feature : features) {
                TimePosition tPos;
                memberName = MetadataUtils.getScalarMemberName((Feature)feature, (String)memberName);
                VerticalPosition vPos = GISUtils.getClosestElevationTo((Double)colorByDepth, (VerticalAxis)GISUtils.getVerticalAxis((Feature)feature));
                Extent minMax = this.getFeatureMinMax(feature, vPos, tPos = GISUtils.getClosestTimeTo((TimePosition)colorByTime, (List)GISUtils.getTimes((Feature)feature, (boolean)false)), memberName, null);
                if (minMax.getLow() != null && ((Float)minMax.getLow()).floatValue() < min) {
                    min = ((Float)minMax.getLow()).floatValue();
                }
                if (minMax.getHigh() == null || !(((Float)minMax.getHigh()).floatValue() > max)) continue;
                max = ((Float)minMax.getHigh()).floatValue();
            }
            valueRange = max < min ? Extents.emptyExtent(Float.class) : Extents.newExtent((Object)Float.valueOf(min), (Object)Float.valueOf(max));
        }
        if (valueRange.getLow() == null) {
            valueRange = Extents.emptyExtent(Float.class);
        } else if (((Float)valueRange.getLow()).equals(valueRange.getHigh())) {
            valueRange = Extents.newExtent((Object)Float.valueOf(((Float)valueRange.getLow()).floatValue() / 1.1f), (Object)Float.valueOf(((Float)valueRange.getHigh()).floatValue() * 1.1f));
        }
        return new ModelAndView("showMinMax", "valueRange", (Object)valueRange);
    }

    private Extent<Float> getFeatureMinMax(Feature feature, VerticalPosition zValue, TimePosition tValue, String memberName, RegularGrid grid) {
        Extent valueRange;
        memberName = MetadataUtils.getScalarMemberName((Feature)feature, (String)memberName);
        if (feature instanceof PointSeriesFeature) {
            PointSeriesFeature pointSeriesFeature = (PointSeriesFeature)feature;
            Object value = pointSeriesFeature.getCoverage().evaluate((Object)tValue, memberName);
            if (Number.class.isAssignableFrom(value.getClass())) {
                return Extents.newExtent((Object)Float.valueOf(((Number)value).floatValue()), (Object)Float.valueOf(((Number)value).floatValue()));
            }
            return Extents.emptyExtent(Float.class);
        }
        if (feature instanceof ProfileFeature) {
            ProfileFeature profileFeature = (ProfileFeature)feature;
            Object value = profileFeature.getCoverage().evaluate((Object)zValue, memberName);
            if (value == null || !Number.class.isAssignableFrom(value.getClass())) {
                return Extents.emptyExtent(Float.class);
            }
            return Extents.newExtent((Object)Float.valueOf(((Number)value).floatValue()), (Object)Float.valueOf(((Number)value).floatValue()));
        }
        if (feature instanceof GridSeriesFeature) {
            feature = ((GridSeriesFeature)feature).extractGridFeature((HorizontalGrid)grid, zValue, tValue, CollectionUtils.setOf((Object[])new String[]{memberName}));
        } else if (feature instanceof GridFeature) {
            feature = ((GridFeature)feature).extractGridFeature((HorizontalGrid)grid, CollectionUtils.setOf((Object[])new String[]{memberName}));
        }
        if (feature.getCoverage() instanceof DiscreteCoverage) {
            DiscreteCoverage discreteCoverage = (DiscreteCoverage)feature.getCoverage();
            Class clazz = discreteCoverage.getScalarMetadata(memberName).getValueType();
            List values = discreteCoverage.getValues(memberName);
            valueRange = Number.class.isAssignableFrom(clazz) ? Extents.findMinMax((Collection)new /* Unavailable Anonymous Inner Class!! */) : Extents.newExtent((Object)Float.valueOf(0.0f), (Object)Float.valueOf(100.0f));
        } else {
            return Extents.emptyExtent(Float.class);
        }
        return valueRange;
    }

    private ModelAndView showAnimationTimesteps(RequestParams params) throws WmsException {
        String layerName = params.getMandatoryString("layerName");
        String memberName = WmsUtils.getMemberName((String)layerName);
        FeatureCollection featureCollection = this.featureFactory.getFeatureCollection(layerName);
        if (featureCollection instanceof UniqueMembersFeatureCollection) {
            Feature feature = ((UniqueMembersFeatureCollection)featureCollection).getFeatureContainingMember(memberName);
            List tValues = GISUtils.getTimes((Feature)feature, (boolean)false);
            if (tValues == null) {
                throw new WmsException("There is no time axis - cannot create animation");
            }
            String startStr = params.getString("start");
            String endStr = params.getString("end");
            if (startStr == null || endStr == null) {
                throw new WmsException("Must provide values for start and end");
            }
            int startIndex = WmsUtils.findTIndex((String)startStr, (List)tValues);
            int endIndex = WmsUtils.findTIndex((String)endStr, (List)tValues);
            LinkedHashMap<String, String> timeStrings = new LinkedHashMap<String, String>();
            timeStrings.put("Full (" + (endIndex - startIndex + 1) + " frames)", startStr + "/" + endStr);
            AbstractMetadataController.addTimeString((String)"Daily", timeStrings, (List)tValues, (int)startIndex, (int)endIndex, (TimePeriod)new TimePeriodImpl().withDays(1));
            AbstractMetadataController.addTimeString((String)"Weekly", timeStrings, (List)tValues, (int)startIndex, (int)endIndex, (TimePeriod)new TimePeriodImpl().withWeeks(1));
            AbstractMetadataController.addTimeString((String)"Monthly", timeStrings, (List)tValues, (int)startIndex, (int)endIndex, (TimePeriod)new TimePeriodImpl().withMonths(1));
            AbstractMetadataController.addTimeString((String)"Bi-monthly", timeStrings, (List)tValues, (int)startIndex, (int)endIndex, (TimePeriod)new TimePeriodImpl().withMonths(2));
            AbstractMetadataController.addTimeString((String)"Twice-yearly", timeStrings, (List)tValues, (int)startIndex, (int)endIndex, (TimePeriod)new TimePeriodImpl().withMonths(6));
            AbstractMetadataController.addTimeString((String)"Yearly", timeStrings, (List)tValues, (int)startIndex, (int)endIndex, (TimePeriod)new TimePeriodImpl().withYears(1));
            return new ModelAndView("showAnimationTimesteps", "timeStrings", timeStrings);
        }
        throw new WmsException("Animations are not supported for this type of variable");
    }

    private static void addTimeString(String label, Map<String, String> timeStrings, List<TimePosition> tValues, int startIndex, int endIndex, TimePeriod resolution) {
        List timesteps = AbstractMetadataController.getAnimationTimesteps(tValues, (int)startIndex, (int)endIndex, (TimePeriod)resolution);
        if (timesteps.size() > 1) {
            String timeString = AbstractMetadataController.getTimeString((List)timesteps);
            timeStrings.put(label + " (" + timesteps.size() + " frames)", timeString);
        }
    }

    private static List<TimePosition> getAnimationTimesteps(List<TimePosition> tValues, int startIndex, int endIndex, TimePeriod resolution) {
        ArrayList<TimePosition> times = new ArrayList<TimePosition>();
        times.add(tValues.get(startIndex));
        for (int i = startIndex + 1; i <= endIndex; ++i) {
            TimePosition lastdt = (TimePosition)times.get(times.size() - 1);
            TimePosition thisdt = tValues.get(i);
            lastdt.plus(resolution);
            if (thisdt.getValue() < lastdt.plus(resolution).getValue()) continue;
            times.add(thisdt);
        }
        return times;
    }

    private static String getTimeString(List<TimePosition> timesteps) {
        if (timesteps.size() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(TimeUtils.dateTimeToISO8601((TimePosition)timesteps.get(0)));
        for (int i = 1; i < timesteps.size(); ++i) {
            builder.append("," + TimeUtils.dateTimeToISO8601((TimePosition)timesteps.get(i)));
        }
        return builder.toString();
    }
}

