/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.config;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import uk.ac.rdg.resc.edal.coverage.Coverage;
import uk.ac.rdg.resc.edal.coverage.metadata.RangeMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.ScalarMetadata;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.FeatureCollection;
import uk.ac.rdg.resc.edal.feature.UniqueMembersFeatureCollection;
import uk.ac.rdg.resc.godiva.shared.LayerMenuItem;
import uk.ac.rdg.resc.ncwms.config.Config;
import uk.ac.rdg.resc.ncwms.controller.AbstractMetadataController;
import uk.ac.rdg.resc.ncwms.controller.AbstractWmsController;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.exceptions.MetadataException;
import uk.ac.rdg.resc.ncwms.wms.Dataset;

/*
 * Exception performing whole class analysis ignored.
 */
public class NcwmsMetadataController
extends AbstractMetadataController {
    public NcwmsMetadataController(Config serverConfig, AbstractWmsController.FeatureFactory layerFactory) {
        super(serverConfig, layerFactory);
    }

    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws MetadataException {
        try {
            String url = request.getParameter("url");
            if (url != null && !url.trim().equals("")) {
                NcwmsMetadataController.proxyRequest((String)url, (HttpServletRequest)request, (HttpServletResponse)response);
                return null;
            }
        }
        catch (Exception e) {
            throw new MetadataException(e);
        }
        return super.handleRequest(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void proxyRequest(String url, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuffer fullURL = new StringBuffer(url);
        boolean firstTime = true;
        for (Object urlParamNameObj : request.getParameterMap().keySet()) {
            fullURL.append(firstTime ? "?" : "&");
            firstTime = false;
            String urlParamName = (String)urlParamNameObj;
            if (urlParamName.equalsIgnoreCase("url")) continue;
            fullURL.append(urlParamName + "=" + request.getParameter(urlParamName));
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            int len;
            URLConnection conn = new URL(fullURL.toString()).openConnection();
            response.setContentType(conn.getContentType());
            response.setContentLength(conn.getContentLength());
            in = conn.getInputStream();
            out = response.getOutputStream();
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    protected ModelAndView showMenu(RequestParams params) throws Exception {
        Map allDatasets = this.config.getAllDatasets();
        LinkedHashMap<Dataset, LayerMenuItem> datasets = new LinkedHashMap<Dataset, LayerMenuItem>();
        for (String datasetId : allDatasets.keySet()) {
            Dataset dataset = (Dataset)allDatasets.get(datasetId);
            if (dataset.isDisabled()) continue;
            FeatureCollection featureCollection = dataset.getFeatureCollection();
            LayerMenuItem datasetRoot = featureCollection instanceof UniqueMembersFeatureCollection ? new LayerMenuItem(dataset.getTitle(), null, false) : new LayerMenuItem(dataset.getTitle(), dataset.getId() + "/*", true);
            if (featureCollection != null && featureCollection.getFeatures() != null) {
                featureCollection.getMemberIdsInCollection();
                LinkedHashSet memberNamesUsed = new LinkedHashSet();
                for (Feature feature : featureCollection.getFeatures()) {
                    Coverage coverage = feature.getCoverage();
                    RangeMetadata topMetadata = coverage.getRangeMetadata();
                    this.addRangeMetadataToTree(datasetRoot, topMetadata, memberNamesUsed, datasetId);
                }
            }
            datasets.put(dataset, datasetRoot);
        }
        String menu = "default";
        String menuFromRequest = params.getString("menu");
        if (menuFromRequest != null && !menuFromRequest.trim().equals("")) {
            menu = menuFromRequest.toLowerCase();
        }
        HashMap<String, Object> models = new HashMap<String, Object>();
        models.put("serverTitle", this.config.getTitle());
        models.put("datasets", datasets);
        return new ModelAndView(menu + "Menu", models);
    }

    private void addRangeMetadataToTree(LayerMenuItem parentMenuItem, RangeMetadata topMetadata, Set<String> memberNamesUsed, String datasetId) {
        Set memberNames = topMetadata.getMemberNames();
        for (String memberName : memberNames) {
            if (memberNamesUsed.contains(memberName)) continue;
            memberNamesUsed.add(memberName);
            RangeMetadata memberMetadata = topMetadata.getMemberMetadata(memberName);
            String id = datasetId + "/" + memberName;
            if (memberMetadata instanceof ScalarMetadata) {
                ScalarMetadata scalarMetadata = (ScalarMetadata)memberMetadata;
                LayerMenuItem leafItem = new LayerMenuItem(scalarMetadata.getTitle(), id, true);
                parentMenuItem.addChildItem(leafItem);
                continue;
            }
            List representativeChildren = memberMetadata.getRepresentativeChildren();
            boolean plottable = true;
            if (representativeChildren == null || representativeChildren.size() == 0) {
                plottable = false;
            }
            LayerMenuItem nodeItem = new LayerMenuItem(memberMetadata.getTitle(), id, plottable);
            parentMenuItem.addChildItem(nodeItem);
            this.addRangeMetadataToTree(nodeItem, memberMetadata, memberNamesUsed, datasetId);
        }
    }
}

