/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.util.net.HttpClientManager;

public class NcwmsCredentialsProvider
implements CredentialsProvider {
    private static final Logger logger = LoggerFactory.getLogger(NcwmsCredentialsProvider.class);
    private Map<String, Credentials> creds = new HashMap();

    public void init() {
        HttpClientManager.init((CredentialsProvider)this, null);
        logger.debug("NcwmsCredentialsProvider initialized");
    }

    public void addCredentials(String host, int port, String usernamePassword) {
        logger.debug("Adding credentials for {}:{} - {}", new Object[]{host, port, usernamePassword});
        this.creds.put(host + ":" + port, new UsernamePasswordCredentials(usernamePassword));
    }

    public Credentials getCredentials(AuthScheme authScheme, String host, int port, boolean proxy) throws CredentialsNotAvailableException {
        Credentials cred = (Credentials)this.creds.get(host + ":" + port);
        if (cred == null) {
            logger.debug("No credentials available for ({},{})", (Object)host, (Object)port);
            throw new CredentialsNotAvailableException();
        }
        logger.debug("Returning credentials for ({},{})", (Object)host, (Object)port);
        return cred;
    }
}

