/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.config;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import uk.ac.rdg.resc.edal.position.TimePosition;
import uk.ac.rdg.resc.ncwms.cache.TileCache;
import uk.ac.rdg.resc.ncwms.config.Config;
import uk.ac.rdg.resc.ncwms.config.Dataset;
import uk.ac.rdg.resc.ncwms.config.NcwmsMetadataController;
import uk.ac.rdg.resc.ncwms.controller.AbstractMetadataController;
import uk.ac.rdg.resc.ncwms.controller.AbstractWmsController;
import uk.ac.rdg.resc.ncwms.controller.RequestParams;
import uk.ac.rdg.resc.ncwms.exceptions.OperationNotSupportedException;
import uk.ac.rdg.resc.ncwms.exceptions.WmsException;

public final class NcwmsController
extends AbstractWmsController {
    private AbstractMetadataController metadataController;
    private TileCache tileCache;
    private AbstractWmsController.FeatureFactory featureFactory;

    public void setMetadataController(AbstractMetadataController metadataController) {
        this.metadataController = metadataController;
    }

    public void setFeatureFactory(AbstractWmsController.FeatureFactory featureFactory) {
        this.featureFactory = featureFactory;
    }

    protected ModelAndView dispatchWmsRequest(String request, RequestParams params, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        if (request.equals("GetCapabilities")) {
            return this.getCapabilities(params, httpServletRequest);
        }
        if (request.equals("GetMap")) {
            return this.getMap(params, this.featureFactory, httpServletResponse);
        }
        if (request.equals("GetFeatureInfo")) {
            String url = params.getString("url");
            if (url != null && !url.trim().equals("")) {
                NcwmsMetadataController.proxyRequest((String)url, (HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse);
                return null;
            }
            return this.getFeatureInfo(params, this.featureFactory, httpServletRequest, httpServletResponse);
        }
        if (request.equals("GetMetadata")) {
            return this.metadataController.handleRequest(httpServletRequest, httpServletResponse);
        }
        if (request.equals("GetLegendGraphic")) {
            return this.getColorbar(params, this.featureFactory, httpServletResponse);
        }
        if (request.equals("GetTimeseries")) {
            return this.getTimeseries(params, this.featureFactory, httpServletResponse);
        }
        if (request.equals("GetTransect")) {
            return this.getTransect(params, this.featureFactory, httpServletResponse);
        }
        if (request.equals("GetVerticalProfile")) {
            return this.getVerticalProfile(params, this.featureFactory, httpServletResponse);
        }
        if (request.equals("GetVerticalSection")) {
            return this.getVerticalSection(params, this.featureFactory, httpServletResponse);
        }
        throw new OperationNotSupportedException(request);
    }

    private ModelAndView getCapabilities(RequestParams params, HttpServletRequest httpServletRequest) throws WmsException, IOException {
        TimePosition lastUpdate;
        Collection datasets;
        String datasetId = params.getString("dataset");
        if (datasetId == null || datasetId.trim().equals("")) {
            Map allDatasets = this.getConfig().getAllDatasets();
            if (!this.getConfig().getAllowsGlobalCapabilities()) {
                throw new WmsException("Cannot create a Capabilities document that includes all datasets on this server. You must specify a dataset identifier with &amp;DATASET=");
            }
            datasets = allDatasets.values();
            lastUpdate = this.getConfig().getLastUpdateTime();
        } else {
            Dataset ds = this.getConfig().getDatasetById(datasetId);
            if (ds == null) {
                throw new WmsException("There is no dataset with ID " + datasetId);
            }
            if (!ds.isReady()) {
                throw new WmsException("The dataset with ID " + datasetId + " is not ready for use");
            }
            datasets = Arrays.asList(ds);
            lastUpdate = ds.getLastUpdateTime();
        }
        return this.getCapabilities(datasets, lastUpdate, params, httpServletRequest);
    }

    public void shutdown() {
        if (this.tileCache != null) {
            this.tileCache.shutdown();
        }
    }

    Config getConfig() {
        return (Config)this.serverConfig;
    }

    public void setTileCache(TileCache tileCache) {
        this.tileCache = tileCache;
    }
}

