/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.config;

import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Validate;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.util.Extents;
import uk.ac.rdg.resc.ncwms.config.Dataset;

/*
 * Exception performing whole class analysis ignored.
 */
@Root(name="variable")
public class FeaturePlottingMetadata {
    @Attribute(name="id")
    private String id;
    @Attribute(name="title", required=false)
    private String title = null;
    @Attribute(name="colorScaleRange", required=false)
    private String colorScaleRangeStr = null;
    @Attribute(name="palette", required=false)
    private String paletteName = "rainbow";
    @Attribute(name="scaling", required=false)
    private String scaling = "linear";
    @Attribute(name="numColorBands", required=false)
    private int numColorBands = 254;
    private Dataset dataset;
    private Extent<Float> colorScaleRange = null;
    private boolean logScaling = false;

    @Validate
    public void validate() throws PersistenceException {
        if (this.colorScaleRangeStr != null) {
            try {
                this.colorScaleRange = FeaturePlottingMetadata.parseColorScaleRangeString((String)this.colorScaleRangeStr);
                this.colorScaleRangeStr = FeaturePlottingMetadata.formatColorScaleRange((Extent)this.colorScaleRange);
            }
            catch (Exception e) {
                throw new PersistenceException("Invalid colorScaleRange attribute for variable " + this.id, new Object[0]);
            }
        }
        try {
            this.setScaling(this.scaling);
        }
        catch (IllegalArgumentException iae) {
            throw new PersistenceException(iae.getMessage(), new Object[0]);
        }
        if (this.numColorBands > 254) {
            this.numColorBands = 254;
        }
    }

    private static Extent<Float> parseColorScaleRangeString(String colorScaleRangeStr) throws Exception {
        String[] els = (colorScaleRangeStr = colorScaleRangeStr.trim()).split(" ");
        if (els.length == 2) {
            return FeaturePlottingMetadata.parseColorScaleRangeStrings((String)els[0].replace(',', '.'), (String)els[1].replace(',', '.'));
        }
        if (els.length == 1) {
            els = colorScaleRangeStr.split(",");
            if (els.length == 2) {
                return FeaturePlottingMetadata.parseColorScaleRangeStrings((String)els[0], (String)els[1]);
            }
            if (els.length == 4) {
                return FeaturePlottingMetadata.parseColorScaleRangeStrings((String)(els[0] + "." + els[1]), (String)(els[2] + "." + els[3]));
            }
        }
        throw new Exception();
    }

    private static Extent<Float> parseColorScaleRangeStrings(String minStr, String maxStr) {
        float min = Float.parseFloat(minStr);
        float max = Float.parseFloat(maxStr);
        if (max < min) {
            max = min;
        }
        return Extents.newExtent((Object)Float.valueOf(min), (Object)Float.valueOf(max));
    }

    private static String formatColorScaleRange(Extent<Float> colorScaleRange) {
        return Float.toString(((Float)colorScaleRange.getLow()).floatValue()) + " " + Float.toString(((Float)colorScaleRange.getHigh()).floatValue());
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public Extent<Float> getColorScaleRange() {
        return this.colorScaleRange;
    }

    public void setColorScaleRange(Extent<Float> colorScaleRange) {
        this.colorScaleRange = colorScaleRange;
        this.colorScaleRangeStr = colorScaleRange == null ? null : FeaturePlottingMetadata.formatColorScaleRange(colorScaleRange);
    }

    public String getPaletteName() {
        return this.paletteName;
    }

    public void setPaletteName(String paletteName) {
        this.paletteName = paletteName;
    }

    public boolean isLogScaling() {
        return this.logScaling;
    }

    public int getNumColorBands() {
        return this.numColorBands;
    }

    public void setNumColorBands(int numColorBands) {
        this.numColorBands = numColorBands < 0 ? 5 : (numColorBands > 254 ? 254 : numColorBands);
    }

    public void setScaling(String scaling) {
        if (scaling.equalsIgnoreCase("linear")) {
            this.logScaling = false;
            this.scaling = scaling;
        } else if (scaling.equalsIgnoreCase("logarithmic")) {
            this.logScaling = true;
            this.scaling = scaling;
        } else {
            throw new IllegalArgumentException("Scaling must be \"linear\" or \"logarithmic\"");
        }
    }
}

