/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.cdm.feature.DefaultGridSeriesFeatureCollectionFactory;
import uk.ac.rdg.resc.edal.cdm.feature.FeatureCollectionFactory;
import uk.ac.rdg.resc.edal.coverage.metadata.RangeMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.impl.MetadataUtils;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.FeatureCollection;
import uk.ac.rdg.resc.edal.feature.UniqueMembersFeatureCollection;
import uk.ac.rdg.resc.edal.position.TimePosition;
import uk.ac.rdg.resc.edal.position.impl.TimePositionJoda;
import uk.ac.rdg.resc.edal.util.Extents;
import uk.ac.rdg.resc.edal.util.GISUtils;
import uk.ac.rdg.resc.ncwms.config.Config;
import uk.ac.rdg.resc.ncwms.config.Dataset;
import uk.ac.rdg.resc.ncwms.config.FeaturePlottingMetadata;

@Root(name="dataset")
public class Dataset
implements uk.ac.rdg.resc.ncwms.wms.Dataset {
    private static final Logger logger;
    @Attribute(name="id")
    private String id;
    @Attribute(name="location")
    private String location;
    @Attribute(name="queryable", required=false)
    private boolean queryable = true;
    @Attribute(name="dataReaderClass", required=false)
    private String featureCollectionFactoryClass = "";
    @Attribute(name="copyrightStatement", required=false)
    private String copyrightStatement = "";
    @Attribute(name="moreInfo", required=false)
    private String moreInfo = "";
    @Attribute(name="disabled", required=false)
    private boolean disabled = false;
    @Attribute(name="title")
    private String title;
    @Attribute(name="updateInterval", required=false)
    private int updateInterval = -1;
    @ElementList(name="variables", type=FeaturePlottingMetadata.class, required=false)
    private ArrayList<FeaturePlottingMetadata> variableList = new ArrayList();
    private Config config;
    private State state = State.NEEDS_REFRESH;
    private Exception err;
    private int numErrorsInARow = 0;
    private List<String> loadingProgress = new ArrayList();
    private Map<String, FeaturePlottingMetadata> metadata = new LinkedHashMap();
    private TimePosition lastSuccessfulUpdateTime = null;
    private TimePosition lastFailedUpdateTime = null;
    private FeatureCollection<? extends Feature> featureCollection;

    @Validate
    public void validate() throws PersistenceException {
        ArrayList<String> varIds = new ArrayList<String>();
        for (FeaturePlottingMetadata var : this.variableList) {
            String varId = var.getId();
            if (varIds.contains(varId)) {
                throw new PersistenceException("Duplicate variable id %s", new Object[]{varId});
            }
            varIds.add(varId);
        }
    }

    @Commit
    public void build() {
        for (FeaturePlottingMetadata var : this.variableList) {
            var.setDataset(this);
            this.metadata.put(var.getId(), var);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id.trim();
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location.trim();
    }

    void setConfig(Config config) {
        this.config = config;
    }

    public synchronized boolean isReady() {
        return !this.isDisabled() && (this.state == State.READY || this.state == State.UPDATING);
    }

    public synchronized boolean isLoading() {
        return !this.isDisabled() && (this.state == State.NEEDS_REFRESH || this.state == State.LOADING);
    }

    public boolean isError() {
        return this.err != null;
    }

    public Exception getException() {
        return this.err;
    }

    public State getState() {
        return this.state;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return "id: " + this.id + ", location: " + this.location;
    }

    public String getDataReaderClass() {
        return this.featureCollectionFactoryClass;
    }

    void setDataReaderClass(String dataReaderClass) {
        this.featureCollectionFactoryClass = dataReaderClass;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    public TimePosition getLastUpdateTime() {
        return this.lastSuccessfulUpdateTime;
    }

    public Feature getFeatureById(String featureId) {
        if (this.featureCollection == null) {
            return null;
        }
        return this.featureCollection.getFeatureById(featureId);
    }

    public FeatureCollection<? extends Feature> getFeatureCollection() {
        return this.featureCollection;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getCopyrightStatement() {
        if (this.copyrightStatement == null || this.copyrightStatement.trim().equals("")) {
            return "";
        }
        int currentYear = new TimePositionJoda().getYear();
        return this.copyrightStatement.replaceAll("\\$\\{year\\}", "" + currentYear);
    }

    public void setCopyrightStatement(String copyrightStatement) {
        this.copyrightStatement = copyrightStatement;
    }

    public String getMoreInfoUrl() {
        return this.moreInfo;
    }

    public void setMoreInfo(String moreInfo) {
        this.moreInfo = moreInfo;
    }

    public List<String> getLoadingProgress() {
        return this.loadingProgress;
    }

    private void appendLoadingProgress(String loadingProgress) {
        this.loadingProgress.add(loadingProgress);
    }

    public Map<String, FeaturePlottingMetadata> getPlottingMetadataMap() {
        return this.metadata;
    }

    public void addVariable(FeaturePlottingMetadata var) {
        var.setDataset(this);
        this.variableList.add(var);
        this.metadata.put(var.getId(), var);
    }

    void forceRefresh() {
        this.err = null;
        this.state = State.NEEDS_REFRESH;
    }

    void loadLayers() {
        this.loadingProgress = new ArrayList();
        Thread.currentThread().setName("load-metadata-" + this.id);
        if (!this.needsRefresh()) {
            return;
        }
        try {
            this.state = this.lastSuccessfulUpdateTime == null ? State.LOADING : State.UPDATING;
            this.doLoadLayers();
            this.err = null;
            this.numErrorsInARow = 0;
            this.state = State.READY;
            this.lastSuccessfulUpdateTime = new TimePositionJoda();
            logger.debug("Loaded metadata for {}", (Object)this.id);
            this.config.setLastUpdateTime(this.lastSuccessfulUpdateTime);
            this.config.save();
        }
        catch (Exception e) {
            this.state = State.ERROR;
            ++this.numErrorsInARow;
            this.lastFailedUpdateTime = new TimePositionJoda();
            if (this.err == null || this.err.getClass() != e.getClass()) {
                logger.error(e.getClass().getName() + " loading metadata for dataset " + this.id, (Throwable)e);
            }
            this.err = e;
        }
    }

    private boolean needsRefresh() {
        logger.debug("Last update time for dataset {} is {}", (Object)this.id, (Object)this.lastSuccessfulUpdateTime);
        logger.debug("State of dataset {} is {}", (Object)this.id, (Object)this.state);
        logger.debug("Disabled = {}", (Object)this.disabled);
        if (this.disabled || this.state == State.LOADING || this.state == State.UPDATING) {
            return false;
        }
        if (this.state == State.NEEDS_REFRESH) {
            return true;
        }
        if (this.state == State.ERROR) {
            double delaySeconds = Math.pow(2.0, this.numErrorsInARow);
            delaySeconds = Math.min(delaySeconds, 600.0);
            boolean needsRefresh = this.lastFailedUpdateTime == null ? true : new TimePositionJoda().getValue() > this.lastFailedUpdateTime.getValue() + 1000L * (long)delaySeconds;
            logger.debug("delay = {} seconds, needsRefresh = {}", (Object)delaySeconds, (Object)needsRefresh);
            return needsRefresh;
        }
        if (this.updateInterval < 0) {
            return false;
        }
        return new TimePositionJoda().getValue() > this.lastSuccessfulUpdateTime.getValue() + (long)(60000 * this.updateInterval);
    }

    private void doLoadLayers() throws Exception {
        logger.debug("Getting data reader of type {}", (Object)this.featureCollectionFactoryClass);
        FeatureCollectionFactory fcFactory = FeatureCollectionFactory.forName((String)this.featureCollectionFactoryClass);
        this.config.updateCredentialsProvider(this);
        this.featureCollection = fcFactory.read(this.location, this.id, this.title);
        this.appendLoadingProgress("loaded layers");
        this.readLayerConfig();
        this.appendLoadingProgress("attributes overridden");
        this.appendLoadingProgress("Finished loading metadata");
    }

    private void readLayerConfig() {
        boolean featureCollectionIsLayer;
        if (this.featureCollection == null) {
            return;
        }
        boolean bl = featureCollectionIsLayer = !(this.featureCollection instanceof UniqueMembersFeatureCollection);
        if (featureCollectionIsLayer) {
            HashMap<String, TitleMinMax> memberName2ScaleRange = new HashMap<String, TitleMinMax>();
            if (this.featureCollection.getFeatures() != null) {
                for (Feature feature : this.featureCollection.getFeatures()) {
                    for (RangeMetadata memberMetadata : MetadataUtils.getPlottableLayers((Feature)feature)) {
                        TitleMinMax minmax = (TitleMinMax)memberName2ScaleRange.get(memberMetadata.getName());
                        if (minmax == null) {
                            minmax = new TitleMinMax(this);
                        }
                        minmax.title = memberMetadata.getTitle();
                        Extent valueRange = GISUtils.estimateValueRange((Feature)feature, (String)memberMetadata.getName());
                        if (valueRange == null) continue;
                        minmax.maybeSetMin((Float)valueRange.getLow());
                        minmax.maybeSetMax((Float)valueRange.getHigh());
                        memberName2ScaleRange.put(memberMetadata.getName(), minmax);
                    }
                }
            }
            for (String memberName : memberName2ScaleRange.keySet()) {
                FeaturePlottingMetadata plottingMetadata = (FeaturePlottingMetadata)this.getPlottingMetadataMap().get(memberName);
                if (plottingMetadata == null) {
                    plottingMetadata = new FeaturePlottingMetadata();
                    plottingMetadata.setId(memberName);
                    this.addVariable(plottingMetadata);
                }
                TitleMinMax titleMinMax = (TitleMinMax)memberName2ScaleRange.get(memberName);
                plottingMetadata.setTitle(titleMinMax.title);
                plottingMetadata.setColorScaleRange(Extents.newExtent((Object)Float.valueOf(titleMinMax.getMin()), (Object)Float.valueOf(titleMinMax.getMax())));
            }
        } else {
            for (Feature feature : this.featureCollection.getFeatures()) {
                for (RangeMetadata memberMetadata : MetadataUtils.getPlottableLayers((Feature)feature)) {
                    Extent valueRange;
                    String memberId = memberMetadata.getName();
                    FeaturePlottingMetadata plottingMetadata = (FeaturePlottingMetadata)this.getPlottingMetadataMap().get(memberId);
                    if (plottingMetadata == null) {
                        plottingMetadata = new FeaturePlottingMetadata();
                        plottingMetadata.setId(memberId);
                        this.addVariable(plottingMetadata);
                    }
                    if (plottingMetadata.getTitle() == null) {
                        plottingMetadata.setTitle(memberMetadata.getTitle());
                    }
                    if (plottingMetadata.getColorScaleRange() != null) continue;
                    this.appendLoadingProgress("Reading min-max data for layer " + memberId);
                    try {
                        valueRange = GISUtils.estimateValueRange((Feature)feature, (String)memberMetadata.getName());
                        if (valueRange.isEmpty()) {
                            valueRange = Extents.newExtent((Object)Float.valueOf(-50.0f), (Object)Float.valueOf(50.0f));
                        } else if (((Float)valueRange.getLow()).equals(valueRange.getHigh())) {
                            valueRange = Extents.newExtent((Object)valueRange.getLow(), (Object)Float.valueOf(((Float)valueRange.getHigh()).floatValue() + 1.0f));
                        } else {
                            float diff = ((Float)valueRange.getHigh()).floatValue() - ((Float)valueRange.getLow()).floatValue();
                            valueRange = Extents.newExtent((Object)Float.valueOf(((Float)valueRange.getLow()).floatValue() - 0.05f * diff), (Object)Float.valueOf(((Float)valueRange.getHigh()).floatValue() + 0.05f * diff));
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error reading min-max from layer " + feature.getId() + " in dataset " + this.id, (Throwable)e);
                        valueRange = Extents.newExtent((Object)Float.valueOf(-50.0f), (Object)Float.valueOf(50.0f));
                    }
                    plottingMetadata.setColorScaleRange(valueRange);
                }
            }
        }
    }

    static {
        FeatureCollectionFactory.setDefaultClass(DefaultGridSeriesFeatureCollectionFactory.class);
        logger = LoggerFactory.getLogger(Dataset.class);
    }
}

