/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;
import org.simpleframework.xml.core.PersistenceException;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.core.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.unidata.io.RandomAccessFile;
import uk.ac.rdg.resc.edal.position.TimePosition;
import uk.ac.rdg.resc.edal.position.impl.TimePositionJoda;
import uk.ac.rdg.resc.ncwms.config.Cache;
import uk.ac.rdg.resc.ncwms.config.Config;
import uk.ac.rdg.resc.ncwms.config.Contact;
import uk.ac.rdg.resc.ncwms.config.Dataset;
import uk.ac.rdg.resc.ncwms.config.NcwmsCredentialsProvider;
import uk.ac.rdg.resc.ncwms.config.Server;
import uk.ac.rdg.resc.ncwms.controller.ServerConfig;
import uk.ac.rdg.resc.ncwms.security.Users;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Root(name="config")
public class Config
implements ServerConfig,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    @ElementList(name="datasets", type=Dataset.class)
    private ArrayList<Dataset> datasetList = new ArrayList();
    @Element(name="threddsCatalog", required=false)
    private String threddsCatalogLocation = " ";
    @Element(name="contact", required=false)
    private Contact contact = new Contact();
    @Element(name="server")
    private Server server = new Server();
    @Element(name="cache", required=false)
    private Cache cache = new Cache();
    private TimePosition lastUpdateTime;
    private File configFile;
    private NcwmsCredentialsProvider credentialsProvider;
    private Map<String, Dataset> datasets = new LinkedHashMap();
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(4);
    private Map<String, ScheduledFuture<?>> futures = new HashMap();

    private Config() {
    }

    public static Config readConfig(File configFile) throws Exception {
        Config config;
        if (configFile.exists()) {
            config = (Config)new Persister().read(Config.class, configFile);
            config.configFile = configFile;
            logger.debug("Loaded configuration from {}", (Object)configFile.getPath());
        } else {
            config = new Config();
            config.configFile = configFile;
            config.save();
            logger.debug("Created new configuration object and saved to {}", (Object)configFile.getPath());
        }
        config.lastUpdateTime = new TimePositionJoda();
        NetcdfDataset.initNetcdfFileCache((int)50, (int)500, (int)500, (int)300);
        logger.debug("NetcdfDatasetCache initialized");
        if (logger.isDebugEnabled()) {
            RandomAccessFile.setDebugLeaks((boolean)true);
        }
        for (Dataset ds : config.datasets.values()) {
            ds.setConfig(config);
            config.scheduleReloading(ds);
        }
        return config;
    }

    public synchronized void save() throws Exception {
        if (this.configFile == null) {
            throw new IllegalStateException("No location set for config file");
        }
        new Persister().write((Object)this, this.configFile);
        logger.debug("Config information saved to {}", (Object)this.configFile.getPath());
    }

    @Validate
    public void validate() throws PersistenceException {
        ArrayList<String> dsIds = new ArrayList<String>();
        for (Dataset ds : this.datasetList) {
            String dsId = ds.getId();
            if (dsIds.contains(dsId)) {
                throw new PersistenceException("Duplicate dataset id %s", new Object[]{dsId});
            }
            dsIds.add(dsId);
        }
    }

    @Commit
    public void build() {
        for (Dataset ds : this.datasetList) {
            this.datasets.put(ds.getId(), ds);
        }
    }

    void setLastUpdateTime(TimePosition date) {
        if (date.compareTo(this.lastUpdateTime) > 0) {
            this.lastUpdateTime = date;
        }
    }

    private void scheduleReloading(Dataset ds) {
        1 reloader = new /* Unavailable Anonymous Inner Class!! */;
        ScheduledFuture<?> future = this.scheduler.scheduleWithFixedDelay((Runnable)reloader, 0L, 1L, TimeUnit.SECONDS);
        this.futures.put(ds.getId(), future);
        logger.debug("Scheduled auto-reloading of dataset {}", (Object)ds.getId());
    }

    public TimePosition getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact contact) {
        this.contact = contact;
    }

    public Map<String, Dataset> getAllDatasets() {
        return Collections.unmodifiableMap(this.datasets);
    }

    public Dataset getDatasetById(String datasetId) {
        return (Dataset)this.datasets.get(datasetId);
    }

    public synchronized void addDataset(Dataset ds) {
        ds.setConfig(this);
        this.datasetList.add(ds);
        this.datasets.put(ds.getId(), ds);
        this.scheduleReloading(ds);
    }

    public synchronized void removeDataset(Dataset ds) {
        this.datasetList.remove(ds);
        this.datasets.remove(ds.getId());
        ScheduledFuture future = (ScheduledFuture)this.futures.remove(ds.getId());
        if (future != null) {
            future.cancel(true);
        }
    }

    public synchronized void changeDatasetId(Dataset ds, String newId) {
        String oldId = ds.getId();
        this.datasets.remove(oldId);
        ScheduledFuture future = (ScheduledFuture)this.futures.remove(oldId);
        ds.setId(newId);
        this.datasets.put(newId, ds);
        this.futures.put(newId, future);
        logger.debug("Changed dataset with ID {} to {}", (Object)oldId, (Object)newId);
    }

    static String checkEmpty(String s) {
        if (s == null) {
            return " ";
        }
        return (s = s.trim()).equals("") ? " " : s;
    }

    void updateCredentialsProvider(Dataset ds) {
        logger.debug("Called updateCredentialsProvider, {}", (Object)ds.getLocation());
        if (WmsUtils.isOpendapLocation((String)ds.getLocation())) {
            String newLoc = "http" + ds.getLocation().substring(4);
            try {
                URL url = new URL(newLoc);
                String userInfo = url.getUserInfo();
                logger.debug("user info = {}", (Object)userInfo);
                if (userInfo != null) {
                    this.credentialsProvider.addCredentials(url.getHost(), url.getPort() >= 0 ? url.getPort() : url.getDefaultPort(), userInfo);
                }
                ds.setLocation("dods" + newLoc.substring(4));
            }
            catch (MalformedURLException mue) {
                logger.warn(newLoc + " is not a valid url");
            }
        }
    }

    public void shutdown() {
        this.scheduler.shutdownNow();
        NetcdfDataset.shutdown();
        logger.info("Cleaned up Config object");
    }

    public String getTitle() {
        return this.server.getTitle();
    }

    public String getServerAbstract() {
        return this.server.getServerAbstract();
    }

    public int getMaxImageWidth() {
        return this.server.getMaxImageWidth();
    }

    public int getMaxImageHeight() {
        return this.server.getMaxImageHeight();
    }

    public Set<String> getKeywords() {
        String[] keysArray = this.server.getKeywords().split(",");
        LinkedHashSet<String> keywords = new LinkedHashSet<String>(keysArray.length);
        for (String keyword : keysArray) {
            keywords.add(keyword);
        }
        return keywords;
    }

    public boolean getAllowsGlobalCapabilities() {
        return this.server.isAllowGlobalCapabilities();
    }

    public String getServiceProviderUrl() {
        return this.server.getUrl();
    }

    public String getContactName() {
        return this.contact.getName();
    }

    public String getContactEmail() {
        return this.contact.getEmail();
    }

    public String getContactOrganization() {
        return this.contact.getOrg();
    }

    public String getContactTelephone() {
        return this.contact.getTel();
    }

    public String getThreddsCatalogLocation() {
        return this.threddsCatalogLocation;
    }

    public void setThreddsCatalogLocation(String threddsCatalogLocation) {
        this.threddsCatalogLocation = Config.checkEmpty((String)threddsCatalogLocation);
    }

    public void setCredentialsProvider(NcwmsCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Users users = (Users)applicationContext.getBean("users");
        if (users == null) {
            logger.error("Could not retrieve Users object from application context");
        } else {
            logger.debug("Setting admin password in Users object");
            users.setAdminPassword(this.server.getAdminPassword());
        }
    }

    public File getPaletteFilesLocation(ServletContext context) {
        return new File(context.getRealPath("/WEB-INF/conf/palettes"));
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

