/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.cache;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import org.geotoolkit.referencing.IdentifiedObjects;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import uk.ac.rdg.resc.edal.coverage.grid.RegularGrid;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.geometry.BoundingBox;
import uk.ac.rdg.resc.edal.util.GISUtils;
import uk.ac.rdg.resc.ncwms.util.WmsUtils;
import uk.ac.rdg.resc.ncwms.wms.Dataset;

public class TileCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String layerId;
    private String crsCode;
    private double[] bbox;
    private int width;
    private int height;
    private String filepath;
    private long lastModified = 0L;
    private long fileSize = 0L;
    private int tIndex;
    private int zIndex;
    private long datasetLastModified = 0L;
    private String str;
    private int hashCode;

    public TileCacheKey(String filepath, Feature feature, RegularGrid grid, int tIndex, int zIndex, Dataset dataset) {
        this.layerId = feature.getId();
        this.setGrid(grid);
        this.filepath = filepath;
        File f = new File(filepath);
        if (f.exists()) {
            if (f.isFile()) {
                this.lastModified = f.lastModified();
                this.fileSize = f.length();
            } else {
                throw new IllegalArgumentException(filepath + " exists but is not a valid file on this server");
            }
        }
        if (WmsUtils.isOpendapLocation((String)filepath) || WmsUtils.isNcmlAggregation((String)filepath)) {
            this.datasetLastModified = dataset.getLastUpdateTime().getValue();
        }
        this.tIndex = tIndex;
        this.zIndex = zIndex;
        StringBuffer buf = new StringBuffer();
        buf.append(this.layerId);
        buf.append(",");
        buf.append(this.crsCode);
        buf.append(",{");
        for (double bboxVal : this.bbox) {
            buf.append(bboxVal);
            buf.append(",");
        }
        buf.append("},");
        buf.append(this.width);
        buf.append(",");
        buf.append(this.height);
        buf.append(",");
        buf.append(this.filepath);
        buf.append(",");
        buf.append(this.lastModified);
        buf.append(",");
        buf.append(this.fileSize);
        buf.append(",");
        buf.append(this.tIndex);
        buf.append(",");
        buf.append(this.zIndex);
        buf.append(",");
        buf.append(this.datasetLastModified);
        this.str = buf.toString();
        this.hashCode = this.str.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TileCacheKey)) {
            return false;
        }
        TileCacheKey other = (TileCacheKey)o;
        return this.tIndex == other.tIndex && this.zIndex == other.zIndex && this.fileSize == other.fileSize && this.lastModified == other.lastModified && this.datasetLastModified == other.datasetLastModified && this.width == other.width && this.height == other.height && this.crsCode.equals(other.crsCode) && this.filepath.equals(other.filepath) && this.layerId.equals(other.layerId) && Arrays.equals(this.bbox, other.bbox);
    }

    private void setGrid(RegularGrid grid) {
        this.width = grid.getXAxis().size();
        this.height = grid.getYAxis().size();
        BoundingBox boundingBox = grid.getCoordinateExtent();
        this.bbox = new double[]{boundingBox.getMinX(), boundingBox.getMinY(), boundingBox.getMaxX(), boundingBox.getMaxY()};
        if (GISUtils.isWgs84LonLat((CoordinateReferenceSystem)grid.getCoordinateReferenceSystem())) {
            this.crsCode = "CRS:841";
            this.bbox[0] = GISUtils.constrainLongitude180((double)this.bbox[0]);
            this.bbox[2] = GISUtils.constrainLongitude180((double)this.bbox[2]);
        } else {
            this.crsCode = IdentifiedObjects.getIdentifier((IdentifiedObject)grid.getCoordinateReferenceSystem());
        }
    }
}

