/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SafeProperties {
    private final Properties props;
    private final LinkedHashMap<String, String> keyCommentMap = new LinkedHashMap();
    private static final String BLANK = "";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public SafeProperties() {
        this.props = new Properties();
    }

    public SafeProperties(Properties defaults) {
        this.props = new Properties(defaults);
    }

    public String setProperty(String key, String value) {
        return this.setProperty(key, value, BLANK);
    }

    public synchronized String setProperty(String key, String value, String comment) {
        Object oldValue = this.props.setProperty(key, value);
        if (BLANK.equals(comment)) {
            if (!this.keyCommentMap.containsKey(key)) {
                this.keyCommentMap.put(key, comment);
            }
        } else {
            this.keyCommentMap.put(key, comment);
        }
        return (String)oldValue;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.props.getProperty(key, defaultValue);
    }

    public synchronized void load(Reader reader) throws IOException {
        this.load0(new LineReader(reader));
    }

    public synchronized void load(InputStream inStream) throws IOException {
        this.load0(new LineReader(inStream));
    }

    public synchronized void load(InputStream inStream, String charset) throws IOException {
        InputStreamReader reader = new InputStreamReader(inStream, charset);
        this.load0(new LineReader(reader));
    }

    public synchronized void load(File file, String charset) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, charset);
        this.load0(new LineReader(reader));
    }

    public synchronized void load(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "utf-8");
        this.load0(new LineReader(reader));
    }

    public void store(Writer writer) throws IOException {
        this.store0(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), false);
    }

    public void store(OutputStream out) throws IOException {
        this.store0(new BufferedWriter(new OutputStreamWriter(out, "utf-8")), true);
    }

    public boolean containsValue(String value) {
        return this.props.containsValue(value);
    }

    public boolean containsKey(String key) {
        return this.props.containsKey(key);
    }

    public int size() {
        return this.props.size();
    }

    public boolean isEmpty() {
        return this.props.isEmpty();
    }

    public synchronized void clear() {
        this.props.clear();
        this.keyCommentMap.clear();
    }

    public Set<String> propertyNames() {
        return this.props.stringPropertyNames();
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator<Map.Entry<String, String>> kvIter = this.keyCommentMap.entrySet().iterator();
        buffer.append("[");
        while (kvIter.hasNext()) {
            buffer.append("{");
            Map.Entry<String, String> entry = kvIter.next();
            String key = entry.getKey();
            String val = this.getProperty(key);
            String comment = entry.getValue();
            buffer.append("key=" + key + ",value=" + val + ",comment=" + comment);
            buffer.append("}");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public boolean equals(Object o) {
        return this.props.equals(o);
    }

    public int hashCode() {
        return this.props.hashCode();
    }

    private void load0(LineReader lr) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        StringBuffer buffer = new StringBuffer();
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            c = lr.lineBuf[keyLen];
            if (c == '#' || c == '!') {
                String comment = this.loadConvert(lr.lineBuf, 1, limit - 1, convtBuf);
                if (buffer.length() > 0) {
                    buffer.append("\n");
                }
                buffer.append(comment);
                continue;
            }
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            this.setProperty(key, value, buffer.toString());
            buffer = new StringBuffer();
        }
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store0(BufferedWriter bw, boolean escUnicode) throws IOException {
        SafeProperties safeProperties = this;
        synchronized (safeProperties) {
            for (Map.Entry<String, String> entry : this.keyCommentMap.entrySet()) {
                String key = entry.getKey();
                String val = this.getProperty(key);
                String comment = entry.getValue();
                key = this.saveConvert(key, true, escUnicode);
                val = this.saveConvert(val, false, escUnicode);
                if (!comment.equals(BLANK)) {
                    SafeProperties.writeComments(bw, comment);
                }
                bw.write(key + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    private static void writeComments(BufferedWriter bw, String comments) throws IOException {
        int current;
        bw.write("#");
        int len = comments.length();
        int last = 0;
        for (current = 0; current < len; ++current) {
            char c = comments.charAt(current);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comments.substring(last, current));
            }
            if (c > '\u00ff') {
                bw.write(c);
            } else {
                bw.newLine();
                if (c == '\r' && current != len - 1 && comments.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comments.charAt(current + 1) != '#' && comments.charAt(current + 1) != '!') {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comments.substring(last, current));
        }
        bw.newLine();
    }

    private String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(SafeProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(SafeProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(SafeProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(SafeProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        Reader reader;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        public LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0) {
                            return -1;
                        }
                        return len;
                    }
                }
                c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (len == 0) {
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

