/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.util;

import com.koalii.kgsp.bc.crypto.Digest;
import com.koalii.kgsp.bc.crypto.signers.RSADigestSigner;
import com.koalii.kgsp.core.crypto.KcDigestUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class DigestUtlis {
    public static byte[] digest(byte[] oriData, String hashAlg) {
        Digest digest = KcDigestUtil.findDigest(hashAlg);
        return KcDigestUtil.digest(digest, oriData);
    }

    public static byte[] digest(String fileName, String hashAlg) {
        Digest digest = KcDigestUtil.findDigest(hashAlg);
        try {
            FileInputStream in = new FileInputStream(fileName);
            return DigestUtlis.digest(in, digest);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] digest(InputStream in, Digest digest) {
        byte[] hashedMsg = new byte[digest.getDigestSize()];
        byte[] temp = new byte[256];
        try {
            int byteread = 0;
            while ((byteread = in.read(temp)) != -1) {
                digest.update(temp, 0, byteread);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    digest.doFinal(hashedMsg, 0);
                }
                catch (IOException iOException) {}
            }
        }
        return hashedMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] verify(InputStream in, Digest digest) {
        RSADigestSigner signer = new RSADigestSigner(digest);
        byte[] hashedMsg = new byte[digest.getDigestSize()];
        byte[] temp = new byte[256];
        try {
            int byteread = 0;
            while ((byteread = in.read(temp)) != -1) {
                digest.update(temp, 0, byteread);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    digest.doFinal(hashedMsg, 0);
                }
                catch (IOException iOException) {}
            }
        }
        return hashedMsg;
    }
}

