/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.client.util.loadbalancer;

import com.koalii.kgsp.core.util.LogUtil;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.Server;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class KoalPingUrl
implements IPing {
    String pingAppendString = "/health";
    boolean isSecure = false;
    String expectedContent = null;

    public KoalPingUrl() {
    }

    public KoalPingUrl(boolean isSecure, String pingAppendString) {
        this.isSecure = isSecure;
        this.pingAppendString = pingAppendString != null ? pingAppendString : "";
    }

    public void setPingAppendString(String pingAppendString) {
        this.pingAppendString = pingAppendString != null ? pingAppendString : "";
    }

    public String getPingAppendString() {
        return this.pingAppendString;
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public void setSecure(boolean isSecure) {
        this.isSecure = isSecure;
    }

    public String getExpectedContent() {
        return this.expectedContent;
    }

    public void setExpectedContent(String expectedContent) {
        this.expectedContent = expectedContent;
    }

    public boolean isAlive(Server server) {
        boolean isAlive = false;
        String urlStr = "";
        urlStr = this.isSecure ? "https://" : "http://";
        urlStr = urlStr + server.getId();
        urlStr = urlStr + this.getPingAppendString();
        int status = this.getStatusCode(urlStr);
        LogUtil.debug("request url:" + urlStr + "\uff0cresponse code:" + status);
        if (status != -1) {
            isAlive = true;
        }
        return isAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStatusCode(String httpurl) {
        HttpURLConnection connection = null;
        int responseCode = -1;
        try {
            URL url = new URL(httpurl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(60000);
            connection.connect();
            responseCode = connection.getResponseCode();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            connection.disconnect();
        }
        return responseCode;
    }

    public static void main(String[] args) {
        KoalPingUrl p = new KoalPingUrl();
        Server s = new Server("svs.koal.com", 5000);
        boolean isAlive = p.isAlive(s);
        System.out.println("isAlive:" + isAlive);
    }
}

