/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.svs.client;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.koalii.crypto.DESUtil;
import com.koalii.kgsp.bc.asn1.ASN1InputStream;
import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.ASN1OctetString;
import com.koalii.kgsp.bc.asn1.ASN1Set;
import com.koalii.kgsp.bc.asn1.DERObjectIdentifier;
import com.koalii.kgsp.bc.asn1.pkcs.ContentInfo;
import com.koalii.kgsp.bc.asn1.pkcs.SignedData;
import com.koalii.kgsp.bc.asn1.pkcs.SignerInfo;
import com.koalii.kgsp.bc.asn1.x500.X500Name;
import com.koalii.kgsp.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.kgsp.bc.asn1.x509.X509CertificateStructure;
import com.koalii.kgsp.bc.asn1.x509.X509Extension;
import com.koalii.kgsp.bc.asn1.x509.X509Extensions;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.params.ECPublicKeyParameters;
import com.koalii.kgsp.bc.crypto.util.PublicKeyFactory;
import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.cert.KcCertStoreFactory;
import com.koalii.kgsp.core.cert.KcCertStoreImpl;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.pkcs.Pkcs7SignParser;
import com.koalii.kgsp.core.util.LogUtil;
import com.koalii.kgsp.core.util.StringUtil;
import com.koalii.kgsp.core.util.X500NameUtil;
import com.koalii.svs.bss.model.DecryptDataReqModel;
import com.koalii.svs.bss.model.EncryptDataReqModel;
import com.koalii.svs.bss.model.ExportAllowListCertReqModel;
import com.koalii.svs.bss.model.ExportMyCertReqModel;
import com.koalii.svs.bss.model.RawDecryptReqModel;
import com.koalii.svs.bss.model.RawEncryptReqModel;
import com.koalii.svs.bss.model.SignDataReqModel;
import com.koalii.svs.bss.model.VerifySignedDataReqModel;
import com.koalii.svs.client.Svs2ClientException;
import com.koalii.svs.client.rest.BssTemplate;
import com.koalii.util.FileUtil;
import com.koalii.util.SysUtil;
import com.koalii.util.digest.Sm3MessageDigest;
import com.koalii.util.digest.Sm3WithSm2;
import com.koalii.util.symmetric.SM4Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class Svs2ClientHelper {
    public static final int DIGEST_ALGO_NONE = -1;
    public static final int DIGEST_ALGO_MD5 = 1;
    public static final int DIGEST_ALGO_SHA1 = 2;
    public static final int DIGEST_ALGO_SHA256 = 3;
    public static final int DIGEST_ALGO_SHA512 = 4;
    public static final int DIGEST_ALGO_SM3 = 5;
    public static final int DIGEST_ALGO_SM3WITHSM2 = 6;
    public static final String DIGEST_NAME_NONE = "";
    public static final String DIGEST_NAME_MD5 = "MD5";
    public static final String DIGEST_NAME_SHA1 = "SHA1";
    public static final String DIGEST_NAME_SHA256 = "SHA256";
    public static final String DIGEST_NAME_SHA512 = "SHA512";
    public static final String DIGEST_NAME_SM3 = "SM3";
    public static final String DIGEST_NAME_SM3WITHSM2 = "SM3WITHSM2";
    public static final String DES3_CBC = "3DES_CBC";
    public static final String SM4_CBC = "SM4_CBC";
    public static final String PADDING_ZERO = "PADDING_ZERO";
    public static final String PADDING_PKCS7 = "PADDING_PKCS7";
    public static final int MAX_EVP_DATA_LEN = 0xA00000;
    public static BssTemplate bssTemplate = null;
    private String keyPin = "";
    private static Svs2ClientHelper m_helper = null;
    private static final Map<String, String> oidMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("1.2.840.113549.2.2", "MD2");
            this.put("1.2.840.113549.2.4", "MD4");
            this.put("1.2.840.113549.2.5", Svs2ClientHelper.DIGEST_NAME_MD5);
            this.put("1.3.14.3.2.26", Svs2ClientHelper.DIGEST_NAME_SHA1);
            this.put("2.16.840.1.101.3.4.2.1", Svs2ClientHelper.DIGEST_NAME_SHA256);
            this.put("2.16.840.1.101.3.4.2.2", "SHA384");
            this.put("2.16.840.1.101.3.4.2.3", Svs2ClientHelper.DIGEST_NAME_SHA512);
            this.put("1.2.840.113549.1.1.5", "RSA");
            this.put("1.2.840.113549.1.1.1", "RSA");
            this.put("1.2.156.10197.1.401", Svs2ClientHelper.DIGEST_NAME_SM3);
            this.put("1.2.156.10197.1.401.1", Svs2ClientHelper.DIGEST_NAME_SM3);
            this.put("1.2.156.10197.1.401.2", Svs2ClientHelper.DIGEST_NAME_SM3);
            this.put("1.2.156.10197.1.301", "SM2");
            this.put("1.2.156.10197.1.301.1", "SM2");
            this.put("1.2.156.10197.1.301.2", "SM2");
            this.put("1.2.156.10197.1.301.3", "SM2");
            this.put("1.2.156.10197.1.104", "SM4");
            this.put("1.2.840.10045.2.1", "ECC");
            this.put("1.2.156.10197.1.501", "SM2");
        }
    };

    public static String version() {
        return new String("3.0.4");
    }

    public SvsResultData getSvsResultData() {
        return new SvsResultData();
    }

    public void setLogFile(String filePath) {
        if (null == filePath) {
            LogUtil.clean();
        } else {
            try {
                FileUtil.mkdirs(new File(filePath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            LogUtil.init(filePath);
        }
    }

    public static Svs2ClientHelper getInstance() {
        if (m_helper == null) {
            m_helper = new Svs2ClientHelper();
        }
        return m_helper;
    }

    public boolean init(String remotehost, String port, String timeout_sec) {
        if (StringUtil.isEmpty(remotehost) || StringUtil.isEmpty(port) || StringUtil.isEmpty(timeout_sec)) {
            return false;
        }
        return this.initServers(remotehost + ":" + port, Integer.parseInt(timeout_sec));
    }

    public boolean init(String remotehost, int port, int timeout_sec) {
        return this.initServers(remotehost + ":" + port, timeout_sec);
    }

    public boolean init(String remotehost, int port, int timeout_sec, int nconcurrent) {
        return this.init(remotehost, port, timeout_sec);
    }

    public boolean init(String remotehost, int port, int timeout_sec, int nconcurrent, int nmax_size) {
        SysUtil.updateSysConfig("koalii-client.ribbon.MaxTotalConnections", nconcurrent + DIGEST_NAME_NONE);
        return this.init(remotehost, port, timeout_sec, nconcurrent);
    }

    public boolean initNoPool(String remotehost, int port, int timeout_sec) {
        SysUtil.updateSysConfig("koalii-client.ribbon.EnableConnectionPool", "FALSE");
        return this.init(remotehost, port, timeout_sec);
    }

    public void setRetry(int nretry, int retry_wait_sec) {
        if (nretry < 1 || retry_wait_sec < 1) {
            return;
        }
        int timeout_sec = retry_wait_sec * nretry * 1000;
        SysUtil.updateSysConfig("koalii-client.ribbon.MaxAutoRetries", nretry + DIGEST_NAME_NONE);
        SysUtil.updateSysConfig("koalii-client.ribbon.ConnectTimeout", timeout_sec + DIGEST_NAME_NONE);
        SysUtil.updateSysConfig("koalii-client.ribbon.ReadTimeout", timeout_sec + DIGEST_NAME_NONE);
    }

    public void setTimeout(int connectTimeout, int readTimeout) {
        if (connectTimeout >= 0 && readTimeout >= 0) {
            SysUtil.updateSysConfig("koalii-client.ribbon.ConnectTimeout", connectTimeout * 1000 + DIGEST_NAME_NONE);
            SysUtil.updateSysConfig("koalii-client.ribbon.ReadTimeout", readTimeout * 1000 + DIGEST_NAME_NONE);
        }
    }

    public void setRetry(int concurrent) {
    }

    public void clean() {
    }

    public void setMessageVersion(int ver) {
    }

    public boolean initServers(String ... remoteHost) {
        if (remoteHost.length == 0) {
            return false;
        }
        StringBuffer remoteHosts = new StringBuffer();
        for (int i = 0; i < remoteHost.length; ++i) {
            if (i > 0) {
                remoteHosts.append("," + remoteHost[i]);
                continue;
            }
            remoteHosts.append(remoteHost[i]);
        }
        return this.initServers(remoteHosts.toString());
    }

    public boolean initServers(String remoteHosts) {
        if (StringUtil.isEmpty(remoteHosts)) {
            return false;
        }
        String addrs = SysUtil.getSysProperties().getProperty("svs.service.addrs");
        if (null != addrs) {
            remoteHosts = remoteHosts + "," + addrs;
        }
        bssTemplate = BssTemplate.getInstance();
        bssTemplate.loadProperties(remoteHosts);
        return true;
    }

    public boolean initServers(String remoteHosts, int timeout_sec) {
        if (timeout_sec >= 0) {
            SysUtil.updateSysConfig("koalii-client.ribbon.ConnectTimeout", timeout_sec * 1000 + DIGEST_NAME_NONE);
            SysUtil.updateSysConfig("koalii-client.ribbon.ReadTimeout", timeout_sec * 1000 + DIGEST_NAME_NONE);
        }
        return this.initServers(remoteHosts);
    }

    public void setHttpHeader(String name, String value) {
        bssTemplate.setHeader(name, value);
    }

    public Map<String, String> getHttpHeaders() {
        return bssTemplate.getHeaders();
    }

    public SvsResultData cdbGetSignCertList() {
        return this.cdbGetSignCertList(256);
    }

    public SvsResultData cdbGetSignCertList(int maxCount) {
        try {
            throw new Svs2ClientException(1000);
        }
        catch (Svs2ClientException e) {
            e.printStackTrace();
            LogUtil.error("Failed to cdbGetSignCertList,because do not support this function");
            SvsResultData result = new SvsResultData();
            result.m_errno = 1000;
            return result;
        }
    }

    public SvsResultData cdbGetSignCertAliasList() {
        return this.cdbGetSignCertAliasList(256);
    }

    public SvsResultData cdbGetSignCertAliasList(int maxCount) {
        try {
            throw new Svs2ClientException(1000);
        }
        catch (Svs2ClientException e) {
            e.printStackTrace();
            LogUtil.error("Failed to cdbGetSignCertAliasList,because do not support this function");
            SvsResultData result = new SvsResultData();
            result.m_errno = 1000;
            return result;
        }
    }

    public SvsResultData cdbGetCertList() {
        return this.cdbGetCertList(256);
    }

    public SvsResultData cdbGetCertList(int maxCount) {
        try {
            throw new Svs2ClientException(1000);
        }
        catch (Svs2ClientException e) {
            e.printStackTrace();
            LogUtil.error("Failed to cdbGetCertList,because do not support this function");
            SvsResultData result = new SvsResultData();
            result.m_errno = 1000;
            return result;
        }
    }

    public SvsResultData cdbGetCertAliasList() {
        return this.cdbGetCertAliasList(256);
    }

    public SvsResultData cdbGetCertAliasList(int maxCount) {
        try {
            throw new Svs2ClientException(1000);
        }
        catch (Svs2ClientException e) {
            e.printStackTrace();
            LogUtil.error("Failed to cdbGetCertAliasList,because do not support this function");
            SvsResultData result = new SvsResultData();
            result.m_errno = 1000;
            return result;
        }
    }

    public SvsResultData cdbSignData(byte[] originData, int digestAlg, String certId) {
        SvsResultData result = null;
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do cdbSignData");
        LogUtil.info(loghead + "==>digestAlg:" + digestAlg);
        LogUtil.info(loghead + "==>certId:" + certId);
        if (StringUtil.isEmpty(originData)) {
            result = new SvsResultData();
            result.m_errno = 1208;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        LogUtil.info(loghead + "==>originData(base64):" + new String(Svs2ClientHelper.base64Encode(originData)));
        SignDataReqModel model = new SignDataReqModel();
        model.setB64OriginData(new String(Svs2ClientHelper.base64Encode(originData)));
        model.setHashType(Svs2ClientHelper.digestAlgID2Name(digestAlg));
        model.setKeyPin(this.keyPin);
        if (StringUtil.isEmpty(certId)) {
            model.setCertAlias(DIGEST_NAME_NONE);
        } else if (certId.indexOf(61) == -1) {
            model.setCertAlias(certId);
        } else {
            model.setCertDn(certId);
        }
        result = this.getSvsResultData(bssTemplate.signData(model));
        LogUtil.info(loghead + "<==errno:" + result.m_errno);
        LogUtil.info(loghead + "<==b64SignedData:" + result.m_b64SignedData);
        return result;
    }

    public SvsResultData cdbSignData(byte[] originData, String certId) {
        return this.cdbSignData(originData, -1, certId);
    }

    public SvsResultData cdbSignData(byte[] originData, int digestAlg) {
        return this.cdbSignData(originData, digestAlg, null);
    }

    public SvsResultData cdbSignData(byte[] originData) {
        return this.cdbSignData(originData, -1, null);
    }

    public SvsResultData cdbVerifySign(byte[] originData, int digestAlg, String b64SignedData, String certId) {
        return this.cdbVerifySign(originData, digestAlg, b64SignedData, certId, null);
    }

    public SvsResultData cdbVerifySign(byte[] originData, int digestAlg, String b64SignedData, String certId, String b64Cert) {
        SvsResultData result = null;
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do cdbVerifySign");
        LogUtil.info(loghead + "==>digestAlg:" + digestAlg);
        LogUtil.info(loghead + "==>b64SignedData:" + b64SignedData);
        LogUtil.info(loghead + "==>certId:" + certId);
        LogUtil.info(loghead + "==>b64Cert:" + b64Cert);
        if (StringUtil.isEmpty(originData) || StringUtil.isEmpty(b64SignedData)) {
            result = new SvsResultData();
            result.m_errno = 1209;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        LogUtil.info(loghead + "==>originData(base64):" + new String(Svs2ClientHelper.base64Encode(originData)));
        VerifySignedDataReqModel model = new VerifySignedDataReqModel();
        model.setB64OriginData(new String(Svs2ClientHelper.base64Encode(originData)));
        model.setB64SignedData(b64SignedData);
        model.setHashType(Svs2ClientHelper.digestAlgID2Name(digestAlg));
        if (StringUtil.isNotEmpty(certId)) {
            if (certId.indexOf(61) == -1) {
                model.setCertAlias(certId);
            } else {
                model.setCertDn(certId);
            }
        } else if (StringUtil.isNotEmpty(b64Cert)) {
            model.setB64Cert(b64Cert);
        } else {
            result = new SvsResultData();
            result.m_errno = 1209;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        result = this.getSvsResultData(bssTemplate.verifySignedData(model));
        LogUtil.info(loghead + "<==errno:" + result.m_errno);
        return result;
    }

    public SvsResultData cdbVerifySign(byte[] originData, String b64SignedData, String certId) {
        return this.cdbVerifySign(originData, -1, b64SignedData, certId);
    }

    public SvsResultData cdbVerifySignByCert(byte[] originData, int digestAlg, String b64SignedData, String b64CertData) {
        return this.cdbVerifySign(originData, digestAlg, b64SignedData, null, b64CertData);
    }

    public SvsResultData cdbVerifySignByCert(byte[] originData, String b64SignedData, String b64CertData) {
        return this.cdbVerifySign(originData, -1, b64SignedData, null, b64CertData);
    }

    public SvsResultData cdbSignDataByDigist(byte[] originDataDigist, String certId) {
        return this.cdbSignDataByDigist(originDataDigist, -1, certId);
    }

    public SvsResultData cdbSignDataByDigist(byte[] originDataDigist, int digestAlg, String certId) {
        try {
            throw new Svs2ClientException(1000);
        }
        catch (Svs2ClientException e) {
            e.printStackTrace();
            LogUtil.error("Failed to cdbSignDataByDigist,because do not support this function");
            SvsResultData result = new SvsResultData();
            result.m_errno = 1000;
            return result;
        }
    }

    public SvsResultData cdbVerifySignByDigist(byte[] originDataDigist, String b64SignedData, String certId) {
        return this.cdbVerifySignByDigist(originDataDigist, -1, b64SignedData, certId);
    }

    public SvsResultData cdbVerifySignByDigist(byte[] originDataDigist, int digestAlg, String b64SignedData, String certId) {
        try {
            throw new Svs2ClientException(1000);
        }
        catch (Svs2ClientException e) {
            e.printStackTrace();
            LogUtil.error("Failed to cdbSignDataByDigist,because do not support this function");
            SvsResultData result = new SvsResultData();
            result.m_errno = 1000;
            return result;
        }
    }

    public SvsResultData cdbPkcs7Sign(byte[] originData, String certId) {
        SvsResultData result = null;
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do cdbPkcs7Sign");
        LogUtil.info(loghead + "==>originData:" + originData);
        LogUtil.info(loghead + "==>certId:" + certId);
        if (StringUtil.isEmpty(originData) || StringUtil.isEmpty(certId)) {
            result = new SvsResultData();
            result.m_errno = 1208;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        SignDataReqModel model = new SignDataReqModel();
        model.setB64OriginData(new String(Svs2ClientHelper.base64Encode(originData)));
        model.setKeyPin(this.keyPin);
        if (certId.indexOf(61) == -1) {
            model.setCertAlias(certId);
        } else {
            model.setCertDn(certId);
        }
        result = this.getSvsResultData(bssTemplate.signMessage(model));
        return result;
    }

    protected SvsResultData cdbPkcs7Verify(String b64SignData, boolean history) {
        String loghead = Svs2ClientHelper.getRandom();
        SvsResultData result = null;
        LogUtil.info(loghead + "do cdbPkcs7Verify");
        LogUtil.info(loghead + "==>b64SignData:" + b64SignData);
        if (StringUtil.isEmpty(b64SignData)) {
            result = new SvsResultData();
            result.m_errno = 1209;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        VerifySignedDataReqModel model = new VerifySignedDataReqModel();
        model.setB64SignedMessage(b64SignData);
        result = history ? this.getSvsResultData(bssTemplate.verifySignedMessageOfhistory(model)) : this.getSvsResultData(bssTemplate.verifySignedMessage(model));
        LogUtil.info(loghead + "<==errno:" + result.m_errno);
        return result;
    }

    public SvsResultData cdbPkcs7VerifyOfHistory(String b64SignData) {
        return this.cdbPkcs7Verify(b64SignData, true);
    }

    public SvsResultData cdbPkcs7Verify(String b64SignData) {
        return this.cdbPkcs7Verify(b64SignData, false);
    }

    public SvsResultData cdbPkcs7Verify(String b64SignData, byte[] originData) {
        String loghead = Svs2ClientHelper.getRandom();
        SvsResultData result = null;
        LogUtil.info(loghead + "do cdbPkcs7Verify");
        LogUtil.info(loghead + "==>b64SignData:" + b64SignData);
        if (StringUtil.isEmpty(b64SignData) || StringUtil.isEmpty(originData)) {
            result = new SvsResultData();
            result.m_errno = 1209;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        LogUtil.info(loghead + "==>originData(base64):" + new String(Svs2ClientHelper.base64Encode(originData)));
        Pkcs7SignParser p7parser = new Pkcs7SignParser();
        try {
            p7parser.parse(Svs2ClientHelper.base64Decode(b64SignData.getBytes()));
        }
        catch (KcException e) {
            result = new SvsResultData();
            result.m_errno = 1106;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        if (!Arrays.equals(originData, p7parser.getOriData())) {
            result = new SvsResultData();
            result.m_errno = 1109;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        return this.cdbPkcs7Verify(b64SignData);
    }

    public SvsResultData cdbPkcs7DetachSignEx(byte[] originData, int digestAlg, String certId) {
        String loghead = Svs2ClientHelper.getRandom();
        SvsResultData result = null;
        LogUtil.info(loghead + "do cdbPkcs7DetachSignEx");
        LogUtil.info(loghead + "==>digestAlg:" + digestAlg);
        LogUtil.info(loghead + "==>certId:" + certId);
        if (StringUtil.isEmpty(originData) || StringUtil.isEmpty(certId)) {
            result = new SvsResultData();
            result.m_errno = 1208;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        LogUtil.info(loghead + "==>originData(base64):" + new String(Svs2ClientHelper.base64Encode(originData)));
        SignDataReqModel model = new SignDataReqModel();
        model.setB64OriginData(new String(Svs2ClientHelper.base64Encode(originData)));
        model.setHashType(Svs2ClientHelper.digestAlgID2Name(digestAlg));
        model.setKeyPin(this.keyPin);
        if (certId.indexOf(61) == -1) {
            model.setCertAlias(certId);
        } else {
            model.setCertDn(certId);
        }
        result = this.getSvsResultData(bssTemplate.signMessageDetach(model));
        LogUtil.info(loghead + "<==errno:" + result.m_errno);
        LogUtil.info(loghead + "<==b64SignedData:" + result.m_b64SignedData);
        return result;
    }

    public SvsResultData cdbPkcs7DetachSignEx(byte[] originData, String certId) {
        return this.cdbPkcs7DetachSignEx(originData, -1, certId);
    }

    protected SvsResultData cdbPkcs7DetachVerify(String b64SignData, int digestAlg, byte[] originData, boolean history) {
        String loghead = Svs2ClientHelper.getRandom();
        SvsResultData result = null;
        LogUtil.info(loghead + "do cdbPkcs7DetachVerifyEx");
        LogUtil.info(loghead + "==>b64SignData:" + b64SignData);
        LogUtil.info(loghead + "==>digestAlg:" + digestAlg);
        if (StringUtil.isEmpty(b64SignData) || StringUtil.isEmpty(originData)) {
            result = new SvsResultData();
            result.m_errno = 1209;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        LogUtil.info(loghead + "==>originData(base64):" + new String(Svs2ClientHelper.base64Encode(originData)));
        VerifySignedDataReqModel model = new VerifySignedDataReqModel();
        model.setB64SignedMessage(b64SignData);
        model.setB64OriginData(new String(Svs2ClientHelper.base64Encode(originData)));
        model.setHashType(Svs2ClientHelper.digestAlgID2Name(digestAlg));
        result = history ? this.getSvsResultData(bssTemplate.verifySignedMessageDetachOfHistory(model)) : this.getSvsResultData(bssTemplate.verifySignedMessageDetach(model));
        LogUtil.info(loghead + "<==errno:" + result.m_errno);
        return result;
    }

    public SvsResultData cdbPkcs7DetachVerifyOfHistory(String b64SignData, int digestAlg, byte[] originData) {
        return this.cdbPkcs7DetachVerify(b64SignData, digestAlg, originData, true);
    }

    public SvsResultData cdbPkcs7DetachVerifyOfHistory(String b64SignData, byte[] originData) {
        return this.cdbPkcs7DetachVerify(b64SignData, -1, originData, true);
    }

    public SvsResultData cdbPkcs7DetachVerifyEx(String b64SignData, int digestAlg, byte[] originData) {
        return this.cdbPkcs7DetachVerify(b64SignData, digestAlg, originData, false);
    }

    public SvsResultData cdbPkcs7DetachVerifyEx(String b64SignData, byte[] originData) {
        return this.cdbPkcs7DetachVerifyEx(b64SignData, -1, originData);
    }

    public SvsResultData cdbPkcs7EvpEncrypt(byte[] originData, String certId) {
        return this.cdbPkcs7EvpEncrypt(originData, certId, null, null);
    }

    public SvsResultData cdbPkcs7EvpEncrypt(byte[] originData, String certId, String ciphername) {
        return this.cdbPkcs7EvpEncrypt(originData, certId, ciphername, null);
    }

    public SvsResultData cdbPkcs7EvpEncryptByB64Cert(byte[] originData, String b64Cert, String ciphername) {
        return this.cdbPkcs7EvpEncrypt(originData, null, ciphername, b64Cert);
    }

    private SvsResultData cdbPkcs7EvpEncrypt(byte[] originData, String certId, String ciphername, String b64Cert) {
        String loghead = Svs2ClientHelper.getRandom();
        SvsResultData result = null;
        LogUtil.info(loghead + "do cdbPkcs7EvpEncrypt");
        LogUtil.info(loghead + "==>certId:" + certId);
        if (StringUtil.isEmpty(originData)) {
            result = new SvsResultData();
            result.m_errno = 1101;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        if (originData.length >= 0xA00000) {
            return this.cdbPkcs7EvpEncryptEx(originData, certId);
        }
        LogUtil.info(loghead + "==>originData(base64):" + new String(Svs2ClientHelper.base64Encode(originData)));
        EncryptDataReqModel model = new EncryptDataReqModel();
        model.setB64OriginData(new String(Svs2ClientHelper.base64Encode(originData)));
        if (StringUtil.isNotEmpty(certId)) {
            if (certId.indexOf(61) == -1) {
                model.setCertAlias(certId);
            } else {
                model.setCertDn(certId);
            }
        } else if (StringUtil.isNotEmpty(b64Cert)) {
            model.setB64Cert(b64Cert);
        } else {
            result = new SvsResultData();
            result.m_errno = 1101;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        if (StringUtil.isNotEmpty(ciphername)) {
            model.setEncryptAlg(ciphername);
        }
        result = this.getSvsResultData(bssTemplate.encryptData(model));
        LogUtil.info(loghead + "<==b64EvpData:" + result.m_b64EvpData);
        LogUtil.info(loghead + "<==errno:" + result.m_errno);
        return result;
    }

    public SvsResultData cdbPkcs7EvpEncryptEx(byte[] originData, String certId) {
        try {
            throw new Svs2ClientException(1000);
        }
        catch (Svs2ClientException e) {
            e.printStackTrace();
            LogUtil.error("Failed to cdbPkcs7EvpEncryptEx,because do not support this function");
            SvsResultData result = new SvsResultData();
            result.m_errno = 1000;
            return result;
        }
    }

    public SvsResultData cdbPkcs7EvpDecrypt(String b64EvpData) {
        String loghead = Svs2ClientHelper.getRandom();
        SvsResultData result = null;
        LogUtil.info(loghead + "do cdbPkcs7EvpDecrypt");
        LogUtil.info(loghead + "==>b64EvpData:" + b64EvpData);
        if (StringUtil.isEmpty(b64EvpData)) {
            result = new SvsResultData();
            result.m_errno = 1101;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        if (b64EvpData.length() >= 0xA00000) {
            return this.cdbPkcs7EvpDecryptEx(b64EvpData);
        }
        DecryptDataReqModel model = new DecryptDataReqModel();
        model.setB64EvpData(b64EvpData);
        model.setKeyPin(this.keyPin);
        result = this.getSvsResultData(bssTemplate.decryptData(model));
        LogUtil.info(loghead + "<==errno:" + result.m_errno);
        return result;
    }

    public SvsResultData cdbPkcs7EvpDecryptEx(String b64EvpData) {
        try {
            throw new Svs2ClientException(1000);
        }
        catch (Svs2ClientException e) {
            e.printStackTrace();
            LogUtil.error("Failed to cdbPkcs7EvpEncryptEx,because do not support this function");
            SvsResultData result = new SvsResultData();
            result.m_errno = 1000;
            return result;
        }
    }

    public SvsResultData cdbGetVerifyCert(String certId) {
        String loghead = Svs2ClientHelper.getRandom();
        SvsResultData result = null;
        LogUtil.info(loghead + "do cdbPkcs7DetachSignEx");
        LogUtil.info(loghead + "==>certId:" + certId);
        if (StringUtil.isEmpty(certId)) {
            result = new SvsResultData();
            result.m_errno = 1210;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        LogUtil.info(loghead + "==>certId:" + certId);
        ExportAllowListCertReqModel model = new ExportAllowListCertReqModel();
        if (certId.indexOf(61) == -1) {
            model.setCertAlias(certId);
        } else {
            model.setCertDn(certId);
        }
        result = this.getSvsResultData(bssTemplate.exportAllowListCert(model));
        LogUtil.info(loghead + "<==errno:" + result.m_errno);
        return result;
    }

    public SvsResultData cdbGetSignCert(String certId) {
        String loghead = Svs2ClientHelper.getRandom();
        SvsResultData result = null;
        LogUtil.info(loghead + "do cdbPkcs7DetachSignEx");
        LogUtil.info(loghead + "==>certId:" + certId);
        if (StringUtil.isEmpty(certId)) {
            result = new SvsResultData();
            result.m_errno = 1210;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        ExportMyCertReqModel model = new ExportMyCertReqModel();
        if (certId.indexOf(61) == -1) {
            model.setCertAlias(certId);
        } else {
            model.setCertDn(certId);
        }
        result = this.getSvsResultData(bssTemplate.exportMyCert(model));
        LogUtil.info(loghead + "<==errno:" + result.m_errno);
        return result;
    }

    public Cipher newCipher(String algName) {
        if (StringUtil.isEmpty(algName)) {
            return null;
        }
        return this.newCipher(algName, PADDING_ZERO);
    }

    public Cipher newCipher(String algName, String paddingType) {
        if (StringUtil.isEmpty(algName) || StringUtil.isEmpty(paddingType)) {
            return null;
        }
        String loghead = Svs2ClientHelper.getRandom();
        try {
            byte[] key = null;
            if (algName.equals(DES3_CBC)) {
                key = DESUtil.generateKey(null);
            } else if (algName.equals(SM4_CBC)) {
                key = new SM4Util().generateKey();
            } else {
                LogUtil.error(loghead + "Illegal algName:" + 1201);
            }
            return this.newCipher(key, algName, paddingType);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String msg = sw.toString();
            LogUtil.error(loghead + "newCipher:" + msg);
            return null;
        }
    }

    public Cipher newCipher(byte[] symcKey, String algName, String paddingType) {
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do newCipher");
        LogUtil.info(loghead + "==>algName: " + algName);
        LogUtil.info(loghead + "==>paddingType: " + paddingType);
        if (StringUtil.isEmpty(symcKey) || StringUtil.isEmpty(algName) || StringUtil.isEmpty(paddingType)) {
            return null;
        }
        LogUtil.info(loghead + "==>symcKey(base64): " + new String(Svs2ClientHelper.base64Encode(symcKey)));
        Cipher cipher = new Cipher();
        cipher.key = symcKey;
        cipher.name = algName;
        cipher.paddingType = paddingType;
        if (algName.equals(DES3_CBC)) {
            cipher.blockLen = 8;
        } else if (algName.equals(SM4_CBC)) {
            cipher.blockLen = 16;
        } else {
            LogUtil.error(loghead + "Illegal algName: " + 1201);
            return null;
        }
        LogUtil.info(loghead + "<==Cipher: " + cipher.toString());
        return cipher;
    }

    @Deprecated
    public Cipher newCipherById(String cipherId, String paddingType) {
        try {
            throw new Svs2ClientException(1000);
        }
        catch (Svs2ClientException e) {
            e.printStackTrace();
            LogUtil.error("Failed to cdbPkcs7EvpEncryptEx,because do not support this function");
            return null;
        }
    }

    @Deprecated
    public Cipher newCipherByCertId(String certId, String paddingType) {
        try {
            throw new Svs2ClientException(1000);
        }
        catch (Svs2ClientException e) {
            e.printStackTrace();
            LogUtil.error("Failed to cdbPkcs7EvpEncryptEx,because do not support this function");
            return null;
        }
    }

    public SvsResultData cipherEncrypt(Cipher cipher, byte[] plainTxt) {
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do cipherEncrypt");
        SvsResultData result = new SvsResultData();
        if (StringUtil.isEmpty(plainTxt) || cipher == null) {
            result.m_errno = 1204;
            return result;
        }
        LogUtil.info(loghead + "==>cipher name:" + cipher.name);
        LogUtil.info(loghead + "==>cipher key(base64):" + new String(Svs2ClientHelper.base64Encode(cipher.key)));
        LogUtil.info(loghead + "==>plainTxt(base64)" + new String(Svs2ClientHelper.base64Encode(plainTxt)));
        byte[] oriData = null;
        try {
            if (!cipher.paddingType.equals(PADDING_ZERO) && !cipher.paddingType.equals(PADDING_PKCS7)) {
                LogUtil.error("ERROR_KNOWN_PADDING_TYPE: 1206");
                LogUtil.error("PADDING_TYPE: Svs2ClientCupHelper.PADDING_ZERO OR Svs2ClientCupHelper.PADDING_PKCS7");
                result.m_errno = 1206;
                return result;
            }
            oriData = this.padding(plainTxt, cipher.blockLen, cipher.paddingType);
            if (cipher.name.equals(DES3_CBC)) {
                DESUtil.DESResulte encdata = DESUtil.encrypt(cipher.key, oriData);
                result.m_b64EncData = new String(Svs2ClientHelper.base64Encode(encdata.m_encrypt));
            } else if (cipher.name.equals(SM4_CBC)) {
                SM4Util sm4 = new SM4Util();
                byte[] encdata = sm4.encryptCbc(cipher.key, oriData);
                result.m_b64EncData = new String(Svs2ClientHelper.base64Encode(encdata));
            } else {
                LogUtil.error(loghead + "cipher param:" + 1205);
                result.m_errno = 1205;
                return result;
            }
            result.m_errno = 0;
            LogUtil.info(loghead + "<==b64EncData : " + result.m_b64EncData);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String msg = sw.toString();
            LogUtil.error(loghead + "cipherEncrypt:" + msg);
            result.m_errno = 1202;
            return result;
        }
    }

    public SvsResultData cipherEncrypt(Cipher cipher, InputStream inputStream, OutputStream outputStream) {
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do cipherEncrypt");
        LogUtil.info(loghead + "==>cipher name:" + cipher.name);
        LogUtil.info(loghead + "==>cipher key(base64):" + new String(Svs2ClientHelper.base64Encode(cipher.key)));
        SvsResultData result = new SvsResultData();
        if (cipher == null || inputStream == null || outputStream == null) {
            result.m_errno = 1204;
            return result;
        }
        try {
            if (!cipher.paddingType.equals(PADDING_ZERO) && !cipher.paddingType.equals(PADDING_PKCS7)) {
                LogUtil.error("ERROR_KNOWN_PADDING_TYPE: 1206");
                LogUtil.error("PADDING_TYPE: Svs2ClientCupHelper.PADDING_ZERO OR Svs2ClientCupHelper.PADDING_PKCS7");
                result.m_errno = 1206;
                return result;
            }
            boolean isEnc = true;
            if (cipher.name.equals(DES3_CBC)) {
                DESUtil.encAndDec(cipher.key, inputStream, outputStream, cipher.paddingType, isEnc);
            } else if (cipher.name.equals(SM4_CBC)) {
                SM4Util sm4 = new SM4Util();
                sm4.encAndDec(cipher.key, inputStream, outputStream, cipher.paddingType, isEnc);
            } else {
                LogUtil.error(loghead + "cipher param:" + 1205);
                result.m_errno = 1205;
                return result;
            }
            result.m_errno = 0;
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String msg = sw.toString();
            LogUtil.error(loghead + "cipherEncrypt:" + msg);
            result.m_errno = 1202;
            return result;
        }
    }

    public SvsResultData cipherDecrypt(Cipher cipher, String b64EncData, String ciphername) {
        if (StringUtil.isEmpty(b64EncData) || cipher == null || StringUtil.isEmpty(cipher.name)) {
            cipher.name = ciphername;
        }
        return this.cipherDecrypt(cipher, b64EncData);
    }

    private SvsResultData cipherDecrypt(Cipher cipher, String b64EncData) {
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do cipherDecrypt");
        LogUtil.info(loghead + "==>b64EncData" + b64EncData);
        SvsResultData result = new SvsResultData();
        if (StringUtil.isEmpty(b64EncData) || cipher == null || StringUtil.isEmpty(cipher.key)) {
            result.m_errno = 1204;
            LogUtil.error(loghead + "errno :" + result.m_errno);
            return result;
        }
        LogUtil.info(loghead + "==>cipher name:" + cipher.name);
        LogUtil.info(loghead + "==>cipher key(base64):" + new String(Svs2ClientHelper.base64Encode(cipher.key)));
        try {
            b64EncData = Svs2ClientHelper.b64SignedDataFormat(b64EncData);
        }
        catch (Svs2ClientException e) {
            result.m_errno = e.getErrorNo();
            LogUtil.error(loghead + "b64SignedDataFormat :" + result.m_errno);
            return result;
        }
        try {
            byte[] decrypt = null;
            if (cipher.name.equals(DES3_CBC)) {
                decrypt = DESUtil.decrypt(cipher.key, Svs2ClientHelper.base64Decode(b64EncData.getBytes()));
            } else if (cipher.name.equals(SM4_CBC)) {
                SM4Util sm4 = new SM4Util();
                decrypt = sm4.decryptCbc(cipher.key, Svs2ClientHelper.base64Decode(b64EncData.getBytes()));
            } else {
                LogUtil.error(loghead + "cipher name:" + 1205);
                result.m_errno = 1205;
                return result;
            }
            if (!cipher.paddingType.equals(PADDING_ZERO) && !cipher.paddingType.equals(PADDING_PKCS7)) {
                LogUtil.error("ERROR_KNOWN_PADDING_TYPE: 1206");
                LogUtil.error("PADDING_TYPE: Svs2ClientCupHelper.PADDING_ZERO OR Svs2ClientCupHelper.PADDING_PKCS7");
                result.m_errno = 1206;
                return result;
            }
            result.m_errno = 0;
            result.m_originData = this.unpadding(decrypt, cipher.paddingType);
            LogUtil.info(loghead + "<==b64OriData : " + new String(Svs2ClientHelper.base64Encode(result.m_originData)));
            return result;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String msg = sw.toString();
            LogUtil.error("cipherDecrypt:" + msg);
            result.m_errno = 1203;
            return result;
        }
    }

    public SvsResultData cipherDecrypt(Cipher cipher, InputStream inputStream, OutputStream outputStream) {
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do cipherDecrypt");
        SvsResultData result = new SvsResultData();
        if (cipher == null || inputStream == null || outputStream == null || cipher.name == null) {
            result.m_errno = 1204;
            return result;
        }
        LogUtil.info(loghead + "==>cipher name:" + cipher.name);
        LogUtil.info(loghead + "==>cipher key(base64):" + new String(Svs2ClientHelper.base64Encode(cipher.key)));
        try {
            boolean isEnc = false;
            if (cipher.name.equals(DES3_CBC)) {
                DESUtil.encAndDec(cipher.key, inputStream, outputStream, cipher.paddingType, isEnc);
            } else if (cipher.name.equals(SM4_CBC)) {
                SM4Util sm4 = new SM4Util();
                sm4.encAndDec(cipher.key, inputStream, outputStream, cipher.paddingType, isEnc);
            } else {
                LogUtil.error(loghead + "cipher name:" + 1205);
                result.m_errno = 1205;
                return result;
            }
            if (!cipher.paddingType.equals(PADDING_ZERO) && !cipher.paddingType.equals(PADDING_PKCS7)) {
                LogUtil.error("ERROR_KNOWN_PADDING_TYPE: 1206");
                LogUtil.error("PADDING_TYPE: Svs2ClientCupHelper.PADDING_ZERO OR Svs2ClientCupHelper.PADDING_PKCS7");
                result.m_errno = 1206;
                return result;
            }
            result.m_errno = 0;
            return result;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            String msg = sw.toString();
            LogUtil.error("cipherDecrypt:" + msg);
            result.m_errno = 1203;
            return result;
        }
    }

    public SvsResultData publicKeyEncrypt(Cipher cipher, String certId) {
        if (cipher == null || StringUtil.isEmpty(cipher.key)) {
            SvsResultData result = new SvsResultData();
            result.m_errno = 1204;
            return result;
        }
        return this.publicKeyEncryptEx(cipher.key, certId);
    }

    public SvsResultData publicKeyEncryptEx(byte[] oriData, String certId) {
        return this.publicKeyEncryptEx(oriData, certId, null);
    }

    private SvsResultData publicKeyEncryptEx(byte[] oriData, String certId, String b64Cert) {
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do publicKeyEncryptEx");
        LogUtil.info(loghead + "==>certId:" + certId);
        SvsResultData result = new SvsResultData();
        if (StringUtil.isEmpty(oriData)) {
            result.m_errno = 1204;
            LogUtil.error(loghead + "publicKeyEncryptEx : " + 1204);
            return result;
        }
        LogUtil.info(loghead + "bytes(base64)" + new String(Svs2ClientHelper.base64Encode(oriData)));
        RawEncryptReqModel model = new RawEncryptReqModel();
        model.setB64OriginData(new String(Svs2ClientHelper.base64Encode(oriData)));
        if (StringUtil.isNotEmpty(certId)) {
            if (certId.indexOf(61) == -1) {
                model.setCertAlias(certId);
            } else {
                model.setCertDn(certId);
            }
        } else if (StringUtil.isNotEmpty(b64Cert)) {
            model.setB64Cert(b64Cert);
        } else {
            result.m_errno = 1101;
            LogUtil.error(loghead + "<==errno:" + result.m_errno);
            return result;
        }
        result = this.getSvsResultData(bssTemplate.rawEncrypt(model));
        result.m_b64EvpData = result.m_b64EncData;
        LogUtil.info(loghead + "<==errno:" + result.m_errno);
        LogUtil.info(loghead + "<==b64EvpData:" + result.m_b64EncData);
        return result;
    }

    public Cipher privateKeyDecrypt(String b64EvpData, String certId) {
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do privateKeyDecrypt");
        LogUtil.info(loghead + "==>b64EvpData:" + b64EvpData);
        LogUtil.info(loghead + "==>certId:" + certId);
        if (StringUtil.isEmpty(b64EvpData) || StringUtil.isEmpty(certId)) {
            return null;
        }
        Cipher cipher = new Cipher();
        cipher.key = this.privateKeyDecryptEx(b64EvpData, certId);
        LogUtil.info(loghead + "<==Cipher:" + cipher.toString());
        return cipher;
    }

    public byte[] privateKeyDecryptEx(String b64EvpData, String certId) {
        SvsResultData result = this.privateKeyDecryptEx1(b64EvpData, certId);
        return result.m_originData;
    }

    public SvsResultData privateKeyDecryptEx1(String b64EvpData, String certId) {
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do privateKeyDecryptEx1");
        LogUtil.info(loghead + "==>b64EvpData:" + b64EvpData);
        LogUtil.info(loghead + "==>certId:" + certId);
        if (StringUtil.isEmpty(b64EvpData) || StringUtil.isEmpty(certId)) {
            return null;
        }
        RawDecryptReqModel model = new RawDecryptReqModel();
        model.setB64EncData(b64EvpData);
        if (certId.indexOf(61) == -1) {
            model.setCertAlias(certId);
        } else {
            model.setCertDn(certId);
        }
        SvsResultData result = this.getSvsResultData(bssTemplate.rawDecrypt(model));
        LogUtil.info(loghead + "<==errno:" + result.m_errno);
        if (StringUtil.isEmpty(result.m_originData)) {
            return result;
        }
        LogUtil.info(loghead + "<==b64OriginData:" + new String(Svs2ClientHelper.base64Encode(result.m_originData)));
        return result;
    }

    public SvsResultData parsePkcs7Sign(String b64P7Data) {
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do parsePkcs7Sign");
        LogUtil.info(loghead + "==>b64P7Data:" + b64P7Data);
        SvsResultData result = new SvsResultData();
        int keyLen = -1;
        if (null == b64P7Data) {
            result.m_errno = 1101;
            return result;
        }
        byte[] derData = Svs2ClientHelper.base64Decode(b64P7Data.getBytes());
        ASN1InputStream bIn = new ASN1InputStream(new ByteArrayInputStream(derData));
        try {
            Enumeration ec;
            ASN1Set certs;
            ASN1OctetString oct;
            ContentInfo cinfo = ContentInfo.getInstance(bIn.readObject());
            SignedData sdata = SignedData.getInstance(cinfo.getContent());
            ContentInfo content = sdata.getContentInfo();
            if (null != content.getContent() && (oct = ASN1OctetString.getInstance(content.getContent())).getOctets().length > 0) {
                result.m_originData = oct.getOctets();
            }
            if (null != (certs = sdata.getCertificates()) && (ec = certs.getObjects()).hasMoreElements()) {
                byte[] dercert = X509CertificateStructure.getInstance(ec.nextElement()).getEncoded();
                result.m_b64SignedCert = new String(Svs2ClientHelper.base64Encode(dercert));
                result.m_b64Cert = new String(Svs2ClientHelper.base64Encode(dercert));
            }
            SignerInfo signer = SignerInfo.getInstance(sdata.getSignerInfos().getObjectAt(0));
            String digestAlg = signer.getDigestAlgorithm().getAlgorithm().getId();
            result.m_digestAlg = oidMap.get(digestAlg);
            if (null != digestAlg && null == result.m_digestAlg) {
                result.m_digestAlg = digestAlg;
            }
            String encDigestAlg = signer.getDigestEncryptionAlgorithm().getAlgorithm().getId();
            String signAlg = oidMap.get(encDigestAlg);
            if (null == result.m_b64Cert || "RSA".equals(signAlg)) {
                // empty if block
            }
            result.m_signAlg = "RSA".equals(signAlg) && keyLen != -1 ? signAlg + String.valueOf(keyLen) : signAlg;
            if (null != encDigestAlg && null == result.m_signAlg) {
                result.m_signAlg = encDigestAlg;
            }
            byte[] signedData = signer.getEncryptedDigest().getOctets();
            result.m_b64SignedData = new String(Svs2ClientHelper.base64Encode(signedData));
        }
        catch (Exception exp) {
            result.m_errno = 1106;
            try {
                bIn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }
        try {
            bIn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        result.m_errno = 0;
        return result;
    }

    public CertInfo parseX509Cert(byte[] cert) {
        ASN1ObjectIdentifier[] oids;
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do parseX509Cert");
        LogUtil.info(loghead + "==>b64cert:" + Svs2ClientHelper.base64Encode(cert));
        KcCertStoreImpl certStore = null;
        try {
            certStore = KcCertStoreFactory.createCertStore(cert);
        }
        catch (KcException e) {
            LogUtil.error("parseX509Cert error: " + e.getMessage());
            return null;
        }
        X509CertificateHolder x509cert = certStore.getCert();
        CertInfo cr = new CertInfo();
        X500Name certDn = x509cert.getSubject();
        String[] cns = X500NameUtil.getCn(certDn);
        cr.dn = certDn.toString();
        cr.cn = cns[0];
        cr.sn = x509cert.getSerialNumber().toString();
        cr.snHex = Svs2ClientHelper.bytesToHex(x509cert.getSerialNumber().toByteArray());
        cr.issuer = x509cert.getIssuer().toString();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        cr.start = sf.format(x509cert.getNotBefore());
        cr.end = sf.format(x509cert.getNotAfter());
        cr.keyAlg = certStore.getKeyAlgName();
        for (ASN1ObjectIdentifier oid : oids = x509cert.getExtensions().getExtensionOIDs()) {
            String key = oid.getId();
            byte[] value = x509cert.getExtension(oid).getExtnValue().getOctets();
            cr.extension.put(key, value);
        }
        return cr;
    }

    public String parseX509Cert(String b64cert, String tag) {
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do parseX509Cert");
        if (b64cert == null || tag == null) {
            return null;
        }
        LogUtil.info(loghead + "==>b64cert:" + b64cert);
        LogUtil.info(loghead + "==>tag:" + tag);
        CertInfo cr = this.parseX509Cert(b64cert.getBytes());
        if (cr == null) {
            return null;
        }
        if (tag.equalsIgnoreCase("DN")) {
            return cr.dn;
        }
        if (tag.equalsIgnoreCase("CN")) {
            return cr.cn;
        }
        if (tag.equalsIgnoreCase("SN")) {
            return cr.sn;
        }
        if (tag.equalsIgnoreCase("SN_HEX")) {
            return cr.snHex;
        }
        if (tag.equalsIgnoreCase("ISSUER")) {
            return cr.issuer;
        }
        if (tag.equalsIgnoreCase("START")) {
            return cr.start;
        }
        if (tag.equalsIgnoreCase("END")) {
            return cr.end;
        }
        if (tag.equalsIgnoreCase("KEYALG")) {
            return cr.keyAlg;
        }
        return null;
    }

    public byte[] parseX509CertExtensionByOid(String b64cert, String oid) {
        String loghead = Svs2ClientHelper.getRandom();
        LogUtil.info(loghead + "do parseX509CertExtensionByOid");
        if (b64cert == null || oid == null) {
            return null;
        }
        LogUtil.info(loghead + "==>b64cert:" + b64cert);
        LogUtil.info(loghead + "==>oid:" + oid);
        CertInfo cr = this.parseX509Cert(b64cert.getBytes());
        if (cr == null) {
            return null;
        }
        return cr.extension.get(oid);
    }

    public int verifyCert(String b64cert) {
        try {
            throw new Svs2ClientException(1000);
        }
        catch (Svs2ClientException e) {
            e.printStackTrace();
            LogUtil.error("Failed to verifyCert,because do not support this function");
            return -2;
        }
    }

    public static String byteToHex(byte b) {
        String hex = Integer.toHexString(b & 0xFF);
        if (hex.length() < 2) {
            hex = "0" + hex;
        }
        return hex;
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() < 2) {
                sb.append(0);
            }
            sb.append(hex);
        }
        return sb.toString();
    }

    public byte[] parseX509CertExt(String b64cert, String oid) throws Svs2ClientException {
        byte[] derData = Svs2ClientHelper.base64Decode(b64cert.getBytes());
        ASN1InputStream bIn = new ASN1InputStream(new ByteArrayInputStream(derData));
        X509CertificateStructure x509cert = null;
        try {
            x509cert = X509CertificateStructure.getInstance(bIn.readObject());
        }
        catch (Exception exp) {
            throw new Svs2ClientException(1107);
        }
        X509Extensions exts = x509cert.getTBSCertificate().getExtensions();
        X509Extension ext = exts.getExtension(new DERObjectIdentifier(oid));
        return ext.getValue().getOctets();
    }

    public static String getRandom() {
        return "[" + System.currentTimeMillis() + String.valueOf(Math.round(1.0E7 * Math.random())) + "]";
    }

    private byte[] padding(byte[] data, int paddingLength, String paddingType) {
        byte tmpb = 0;
        int num = paddingLength - data.length % paddingLength;
        if (paddingType.equals(PADDING_PKCS7)) {
            tmpb = (byte)num;
        }
        byte[] formatdata = new byte[data.length + num];
        System.arraycopy(data, 0, formatdata, 0, data.length);
        Arrays.fill(formatdata, data.length, formatdata.length, tmpb);
        return formatdata;
    }

    private byte[] unpadding(byte[] data, String paddingType) {
        int patchLength = 0;
        if (paddingType.equals(PADDING_ZERO)) {
            for (int i = data.length - 1; i >= 0 && data[i] == 0; --i) {
                ++patchLength;
            }
            if (patchLength == 0) {
                return data;
            }
        } else if (paddingType.equals(PADDING_PKCS7)) {
            patchLength = data[data.length - 1];
        }
        byte[] formatdata = new byte[data.length - patchLength];
        System.arraycopy(data, 0, formatdata, 0, formatdata.length);
        return formatdata;
    }

    public static byte[] base64Encode(byte[] originData) {
        return Base64.encode(originData);
    }

    public static byte[] base64Decode(byte[] base64Data) {
        String temp = new String(base64Data);
        temp = temp.replaceAll("\\s*", DIGEST_NAME_NONE);
        base64Data = temp.getBytes();
        return Base64.decode(base64Data);
    }

    public static String b64SignedDataFormat(String b64SignedData) throws Svs2ClientException {
        int i;
        char[] b64SignedDataChars = b64SignedData.toCharArray();
        int b64count = 0;
        for (i = 0; i < b64SignedDataChars.length; ++i) {
            if (b64SignedDataChars[i] >= '0' & b64SignedDataChars[i] <= '9' || b64SignedDataChars[i] >= 'A' & b64SignedDataChars[i] <= 'Z' || b64SignedDataChars[i] >= 'a' & b64SignedDataChars[i] <= 'z' || b64SignedDataChars[i] == '+' || b64SignedDataChars[i] == '/' || b64SignedDataChars[i] == '=') {
                ++b64count;
                continue;
            }
            if (b64SignedDataChars[i] == '\t' || b64SignedDataChars[i] == '\n' || b64SignedDataChars[i] == '\r' || b64SignedDataChars[i] == ' ') continue;
            throw new Svs2ClientException(1112);
        }
        if (b64count % 4 != 0) {
            for (i = 0; i < 4 - b64count % 4; ++i) {
                b64SignedData = b64SignedData + "=";
            }
        }
        return b64SignedData;
    }

    public static byte[] digest(byte[] originData) throws Svs2ClientException {
        return Svs2ClientHelper.digest(originData, 2);
    }

    public static byte[] digest(byte[] originData, int digestAlg) throws Svs2ClientException {
        if (null == originData) {
            throw new Svs2ClientException(1101);
        }
        MessageDigest messageDigest = Svs2ClientHelper.createDigest(digestAlg);
        messageDigest.update(originData, 0, originData.length);
        return messageDigest.digest();
    }

    public static String digestAlgID2Name(int algId) {
        if (-1 == algId) {
            return DIGEST_NAME_NONE;
        }
        if (1 == algId) {
            return DIGEST_NAME_MD5;
        }
        if (2 == algId) {
            return DIGEST_NAME_SHA1;
        }
        if (3 == algId) {
            return DIGEST_NAME_SHA256;
        }
        if (4 == algId) {
            return DIGEST_NAME_SHA512;
        }
        if (5 == algId) {
            return DIGEST_NAME_SM3;
        }
        if (6 == algId) {
            return DIGEST_NAME_SM3WITHSM2;
        }
        LogUtil.warn("Unknow digest algorithm id:" + algId + ".Therefore, the server default digest algorithm will be used");
        return DIGEST_NAME_NONE;
    }

    private SvsResultData getSvsResultData(JSONObject obj) {
        String serviceVersion;
        String message;
        String signAlg;
        String b64OriginData;
        Integer msgId;
        Integer errno;
        String digestAlg;
        JSONArray certs;
        Integer certCnt;
        String b64EncData;
        String b64SignedMessage;
        String b64SignedData;
        String b64EvpData;
        String b64CipherData;
        SvsResultData result = new SvsResultData();
        if (StringUtil.isEmpty(obj)) {
            return result;
        }
        String b64Cert = obj.getString("b64Cert");
        if (null != b64Cert) {
            result.m_b64Cert = b64Cert;
        }
        if (null != (b64CipherData = obj.getString("b64CipherData"))) {
            result.m_b64CipherData = b64CipherData;
        }
        if (null != (b64EvpData = obj.getString("b64EvpData"))) {
            result.m_b64EvpData = b64EvpData;
        }
        if (null != (b64SignedData = obj.getString("b64SignedData"))) {
            result.m_b64SignedData = b64SignedData;
        }
        if (null != (b64SignedMessage = obj.getString("b64SignedMessage"))) {
            result.m_b64SignedData = b64SignedMessage;
        }
        if (null != (b64EncData = obj.getString("b64EncData"))) {
            result.m_b64EncData = b64EncData;
        }
        if (null != (certCnt = obj.getInteger("Integer"))) {
            result.m_certCnt = certCnt;
        }
        if (null != (certs = obj.getJSONArray("certs"))) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < certs.size(); ++i) {
                list.add(certs.getString(i));
            }
            result.m_certs = list;
        }
        if (null != (digestAlg = obj.getString("digestAlg"))) {
            result.m_digestAlg = digestAlg;
        }
        if (null != (errno = obj.getInteger("errorCode"))) {
            result.m_errno = errno;
        }
        if (null != (msgId = obj.getInteger("msgId"))) {
            result.m_msgId = msgId;
        }
        if (null != (b64OriginData = obj.getString("b64OriginData"))) {
            result.m_originData = Base64.decode(b64OriginData);
        }
        if (null != (signAlg = obj.getString("signAlg"))) {
            result.m_signAlg = signAlg;
        }
        if (null != (message = obj.getString("message"))) {
            result.m_message = message;
        }
        if (null != (serviceVersion = obj.getString("serviceVersion"))) {
            result.m_serviceVersion = serviceVersion;
        }
        result.m_clientVersion = Svs2ClientHelper.version();
        return result;
    }

    public static byte[] readFile(String filename) {
        FileInputStream fin = null;
        byte[] fdata = null;
        try {
            fin = new FileInputStream(filename);
            fdata = new byte[fin.available()];
            fin.read(fdata);
        }
        catch (Exception e) {
            fdata = null;
        }
        try {
            fin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fdata;
    }

    @Deprecated
    public SvsResultData signDataBySM2(byte[] originData) {
        Properties props = SysUtil.getSysProperties();
        String certId = props.getProperty("svs.service.cert.alias");
        return this.cdbSignData(originData, certId);
    }

    @Deprecated
    public SvsResultData pkcs7DetachSign(byte[] originData) {
        return this.pkcs7DetachSign(originData, -1);
    }

    @Deprecated
    public SvsResultData pkcs7DetachSign(byte[] originData, int digestAlg) {
        Properties props = SysUtil.getSysProperties();
        String certId = props.getProperty("svs.service.cert.alias");
        return this.cdbPkcs7DetachSignEx(originData, digestAlg, certId);
    }

    @Deprecated
    public SvsResultData pkcs7DetachVerify(String b64Pkcs7Data, byte[] originData) {
        return this.pkcs7DetachVerify(b64Pkcs7Data, originData, -1);
    }

    @Deprecated
    public SvsResultData pkcs7DetachVerify(String b64Pkcs7Data, byte[] originData, int digestAlg) {
        return this.cdbPkcs7DetachVerifyEx(b64Pkcs7Data, digestAlg, originData);
    }

    @Deprecated
    public SvsResultData pkcs7DetachSignFile(String filename) {
        return this.pkcs7DetachSignFile(filename, -1);
    }

    @Deprecated
    public SvsResultData pkcs7DetachSignFile(String filename, int digestAlg) {
        SvsResultData result = null;
        byte[] fdata = Svs2ClientHelper.readFile(filename);
        if (null == fdata) {
            result = new SvsResultData();
            result.m_errno = 1103;
            return result;
        }
        return this.pkcs7DetachSign(fdata, digestAlg);
    }

    public static MessageDigest createDigest(int algorithm) throws Svs2ClientException {
        return Svs2ClientHelper.createDigest(algorithm, null);
    }

    public static MessageDigest createDigest(String algorithm) throws Svs2ClientException {
        return Svs2ClientHelper.createDigest(algorithm, null);
    }

    public static MessageDigest createDigest(int algorithm, String b64SignCert) throws Svs2ClientException {
        String alg = Svs2ClientHelper.digestAlgID2Name(algorithm);
        return Svs2ClientHelper.createDigest(alg, b64SignCert);
    }

    public static MessageDigest createDigest(String algorithm, String b64SignCert) throws Svs2ClientException {
        if ("sm3WithSm2".equalsIgnoreCase(algorithm)) {
            if (null == b64SignCert) {
                throw new Svs2ClientException(1101);
            }
            return Svs2ClientHelper.createSM3SignDigest(b64SignCert);
        }
        if ("sm3".equalsIgnoreCase(algorithm)) {
            return new Sm3MessageDigest();
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Svs2ClientException(1105, "not such digest algorithm " + algorithm, e);
        }
        return digest;
    }

    public static MessageDigest createSM3SignDigest(String b64SignCert) throws Svs2ClientException {
        KcCertStoreImpl certStore;
        Sm3WithSm2 digest = null;
        try {
            certStore = KcCertStoreFactory.createCertStore(b64SignCert.getBytes());
        }
        catch (KcException e1) {
            LogUtil.error("parse certificate data error.\r\n" + b64SignCert);
            throw new Svs2ClientException(1107, "parse certificate data error\r\n" + b64SignCert, e1);
        }
        if (!certStore.getKeyAlgName().equalsIgnoreCase("SM2")) {
            throw new Svs2ClientException(1113, "not sm2 cert type\r\n" + b64SignCert, null);
        }
        SubjectPublicKeyInfo pubKeyInfo = certStore.getCert().getSubjectPublicKeyInfo();
        ECPublicKeyParameters ecPubKeyParam = null;
        try {
            ecPubKeyParam = (ECPublicKeyParameters)PublicKeyFactory.createKey(pubKeyInfo);
        }
        catch (IOException e) {
            throw new Svs2ClientException(1115, "parse public key info" + b64SignCert, e);
        }
        try {
            String userId = System.getProperty("KOALII.SM2.USERID");
            digest = null != userId ? new Sm3WithSm2(userId, ecPubKeyParam) : new Sm3WithSm2(ecPubKeyParam);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Svs2ClientException(1105, "no such sm2 curve or sm3 messageDigest not available", e);
        }
        return digest;
    }

    public static void updateDigestData(MessageDigest digest, byte[] data, int offset, int len) {
        digest.update(data, offset, len);
    }

    public class CertInfo {
        public String cn;
        public String dn;
        public String sn;
        public String snHex;
        public String issuer;
        public String start;
        public String end;
        public String keyAlg;
        public Map<String, byte[]> extension = new HashMap<String, byte[]>();
    }

    public class Cipher {
        public int id = 0;
        public String name = null;
        public byte[] key = null;
        public byte[] iv = null;
        public String paddingType = null;
        public int blockLen = 0;

        public byte[] encode() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.id);
            sb.append(",");
            sb.append(this.name);
            sb.append(",");
            if (StringUtil.isNotEmpty(this.key)) {
                sb.append(new String(Svs2ClientHelper.base64Encode(this.key)));
            }
            sb.append(",");
            if (StringUtil.isNotEmpty(this.iv)) {
                sb.append(new String(Svs2ClientHelper.base64Encode(this.iv)));
            }
            sb.append(",");
            sb.append(this.paddingType);
            sb.append(",");
            sb.append(this.blockLen);
            return Svs2ClientHelper.base64Encode(sb.toString().getBytes());
        }

        public Cipher decode(byte[] encData) {
            String blockLenStr;
            String paddingTypeStr;
            String ivStr;
            String keyStr;
            String nameStr;
            if (StringUtil.isEmpty(encData)) {
                return null;
            }
            byte[] oriData = Svs2ClientHelper.base64Decode(encData);
            String[] list = new String(oriData).split(",");
            Cipher cipher = new Cipher();
            String idStr = list[0];
            if (StringUtil.isNotEmpty(idStr)) {
                cipher.id = Integer.parseInt(idStr);
            }
            if (StringUtil.isNotEmpty(nameStr = list[1])) {
                cipher.name = nameStr;
            }
            if (StringUtil.isNotEmpty(keyStr = list[2])) {
                cipher.key = Svs2ClientHelper.base64Decode(keyStr.getBytes());
            }
            if (StringUtil.isNotEmpty(ivStr = list[3])) {
                cipher.iv = Svs2ClientHelper.base64Decode(ivStr.getBytes());
            }
            if (StringUtil.isNotEmpty(paddingTypeStr = list[4])) {
                cipher.paddingType = paddingTypeStr;
            }
            if (StringUtil.isNotEmpty(blockLenStr = list[5])) {
                cipher.blockLen = Integer.parseInt(blockLenStr);
            }
            return cipher;
        }

        public String toString() {
            return "Cipher [id=" + this.id + ", name=" + this.name + ", key=" + new String(Svs2ClientHelper.base64Encode(this.key)) + ", iv=" + Arrays.toString(this.iv) + ", paddingType=" + this.paddingType + ", blockLen=" + this.blockLen + "]";
        }
    }

    public class SvsResultData {
        public int m_msgId = 0;
        public int m_errno = -1;
        public String m_message = null;
        public byte[] m_originData = null;
        public String m_b64SignedData = null;
        public String m_b64SignedCert = null;
        public String m_encryptData = null;
        public String m_decryptData = null;
        public String m_b64EvpData = null;
        public String m_b64EncData = null;
        public String m_b64CipherData = null;
        public String m_b64Cert = null;
        public int m_certCnt = 0;
        public ArrayList<String> m_certs = null;
        public String m_digestAlg = null;
        public String m_signAlg = null;
        public ArrayList<String> m_certDns = null;
        public ArrayList<String> m_certAlias = null;
        public String m_serviceVersion = null;
        public String m_clientVersion = null;
    }
}

