/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.util;

import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.openssl.PEMParser;
import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.exception.KcException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class X509CertUtil {
    public static X509CertificateHolder parseCertData(byte[] certData) throws KcException {
        try {
            byte[] derData = null;
            if (48 == certData[0]) {
                derData = certData;
            } else if (77 == certData[0]) {
                derData = Base64.decode(certData);
            } else if (45 == certData[0]) {
                InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(certData), "US-ASCII");
                PEMParser parser = new PEMParser(reader);
                X509CertificateHolder cert = (X509CertificateHolder)parser.readObject();
                parser.close();
                return cert;
            }
            X509CertificateHolder cert = new X509CertificateHolder(derData);
            return cert;
        }
        catch (Exception e) {
            throw new KcException(100111, (Throwable)e);
        }
    }
}

