/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.util;

import com.koalii.kgsp.bc.asn1.ASN1Encodable;
import com.koalii.kgsp.bc.asn1.ASN1EncodableVector;
import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.DERSequence;
import com.koalii.kgsp.bc.asn1.DERSet;
import com.koalii.kgsp.bc.asn1.x500.AttributeTypeAndValue;
import com.koalii.kgsp.bc.asn1.x500.RDN;
import com.koalii.kgsp.bc.asn1.x500.X500Name;
import com.koalii.kgsp.bc.asn1.x500.X500NameStyle;
import com.koalii.kgsp.bc.asn1.x500.style.BCStyle;
import com.koalii.kgsp.bc.asn1.x500.style.IETFUtils;
import com.koalii.kgsp.bc.asn1.x500.style.RFC4519Style;
import com.koalii.kgsp.bc.asn1.x500.style.X500NameTokenizer;
import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.exception.KcException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;

public class X500NameUtil {
    private static final X500NameStyle x500nameStyle = BCStyle.INSTANCE;

    public static X500Name toX500Name(Principal dirName) throws KcException {
        return X500NameUtil.toX500Name(dirName.getName());
    }

    public static boolean isX500Name(String dirName) {
        X500NameTokenizer nTok = new X500NameTokenizer(dirName);
        if (nTok.hasMoreTokens()) {
            String token = nTok.nextToken();
            int index = token.indexOf(61);
            if (index == -1) {
                return false;
            }
            X500Name n = new X500Name(x500nameStyle, dirName);
            return null != n;
        }
        return false;
    }

    public static X500Name toX500Name(String dirName) throws KcException {
        X500NameTokenizer nTok = new X500NameTokenizer(dirName);
        if (nTok.hasMoreTokens()) {
            String token = nTok.nextToken();
            int index = token.indexOf(61);
            if (index == -1) {
                throw new KcException(100119, "badly formated directory string");
            }
            return new X500Name(x500nameStyle, dirName);
        }
        throw new KcException(100119, "badly formated directory string");
    }

    public static String toString(X500Name dn) {
        X500Name tmpDn = new X500Name(x500nameStyle, dn.toString());
        return tmpDn.toString();
    }

    public static X500Name formatX500Name(X500Name x500name) throws KcException {
        RDN[] rdns = x500name.getRDNs();
        ArrayList<String> list = new ArrayList<String>();
        for (RDN rdn : rdns) {
            String oidDisplayName = X500Name.getDefaultStyle().oidToDisplayName(rdn.getFirst().getType()).toLowerCase();
            String value = rdn.getFirst().getValue().toString();
            String attrbuteValue = oidDisplayName + "=" + value;
            list.add(attrbuteValue);
        }
        Collections.sort(list, String.CASE_INSENSITIVE_ORDER);
        StringBuffer formatedDn = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                formatedDn.append(",");
            }
            formatedDn.append((String)list.get(i));
        }
        return X500NameUtil.toX500Name(formatedDn.toString());
    }

    public static String toB64Dn(X500Name dn) throws KcException {
        return X500NameUtil.toB64Dn(dn.toString());
    }

    public static String toB64Dn(String dirName) throws KcException {
        X500Name name = X500NameUtil.toX500Name(dirName);
        ASN1EncodableVector vector = new ASN1EncodableVector();
        for (RDN rdn : name.getRDNs()) {
            for (AttributeTypeAndValue attribute : rdn.getTypesAndValues()) {
                vector.add(attribute);
            }
        }
        DERSet set = new DERSet(vector);
        DERSequence sequence = new DERSequence(set);
        try {
            return new String(Base64.encode(sequence.getEncoded()));
        }
        catch (Exception e) {
            throw new KcException(100119, "badly encoded directory string");
        }
    }

    public static String[] getCn(X500Name dn) {
        return X500NameUtil.getRdn(dn, RFC4519Style.cn);
    }

    public static String[] getOu(X500Name dn) {
        return X500NameUtil.getRdn(dn, RFC4519Style.ou);
    }

    public static String[] getO(X500Name dn) {
        return X500NameUtil.getRdn(dn, RFC4519Style.o);
    }

    public static String[] getRdn(X500Name dn, ASN1ObjectIdentifier oid) {
        RDN[] cns = dn.getRDNs(oid);
        String[] ss = new String[cns.length];
        for (int i = 0; i < cns.length; ++i) {
            ASN1Encodable edl = cns[i].getFirst().getValue();
            ss[i] = IETFUtils.valueToString(edl);
        }
        return ss;
    }

    public static void main(String[] args) throws Exception {
        X500Name dn = X500NameUtil.toX500Name("CN=root, e=www, o=eav, OU=lily, ST=test ");
        System.out.println(X500NameUtil.toB64Dn(dn));
        dn = X500NameUtil.toX500Name("CN=root, e=www, OU=lily, ST=test, o=eav ");
        System.out.println(X500NameUtil.toB64Dn(dn));
        dn = X500NameUtil.toX500Name("cn=root, OU=lily, ST=test, o=eav, e=www ");
        System.out.println(X500NameUtil.toB64Dn(dn));
        dn = X500NameUtil.toX500Name("CN=root, o=eav, e=www, ST=test, OU=lily ");
        System.out.println(X500NameUtil.toB64Dn(dn));
    }
}

