/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.util;

import com.koalii.kgsp.bc.openssl.PEMDecryptorProvider;
import com.koalii.kgsp.bc.openssl.PEMEncryptedKeyPair;
import com.koalii.kgsp.bc.openssl.PEMKeyPair;
import com.koalii.kgsp.bc.openssl.PEMParser;
import com.koalii.kgsp.bc.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import com.koalii.kgsp.core.exception.KcException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class PemKeyPairUtil {
    public static PEMKeyPair parsePemKeyPair(byte[] keyData, char[] password) throws KcException {
        Object keyObj;
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new ByteArrayInputStream(keyData), "US-ASCII");
            PEMParser parser = new PEMParser(reader);
            keyObj = parser.readObject();
            parser.close();
        }
        catch (IOException e) {
            throw new KcException(100132, (Throwable)e);
        }
        if (keyObj instanceof PEMEncryptedKeyPair) {
            JcePEMDecryptorProviderBuilder builder = new JcePEMDecryptorProviderBuilder();
            PEMDecryptorProvider decryptor = builder.build(password);
            try {
                return ((PEMEncryptedKeyPair)keyObj).decryptKeyPair(decryptor);
            }
            catch (Exception e) {
                throw new KcException(100122, (Throwable)e);
            }
        }
        if (keyObj instanceof PEMKeyPair) {
            return (PEMKeyPair)keyObj;
        }
        throw new KcException(100122);
    }
}

