/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.util;

import com.koalii.kgsp.core.util.CustomFormatter;
import java.util.UUID;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogUtil {
    private static Logger fileLogger = null;
    private static int fileMaxSize = 102400;
    private static int fileRotate = 10;

    public static synchronized void init(String filePath) {
        LogUtil.init(filePath, fileMaxSize, fileRotate);
    }

    public static synchronized void init(String filePath, int nMaxSizeKb, int nrotate) {
        FileHandler fh;
        LogUtil.clean();
        if (null == filePath || 0 == filePath.length()) {
            return;
        }
        fileLogger = Logger.getLogger(LogUtil.class.getName());
        fileLogger.setLevel(Level.INFO);
        int nsize = fileMaxSize;
        if (nMaxSizeKb > 0) {
            nsize = nMaxSizeKb * 1024;
        }
        int nr = fileRotate;
        if (nrotate > 0) {
            nr = nrotate;
        }
        try {
            fh = new FileHandler(filePath, nsize, nr, true);
            fh.setEncoding("UTF-8");
        }
        catch (Exception e) {
            return;
        }
        fh.setFormatter(new CustomFormatter());
        fileLogger.setUseParentHandlers(false);
        fileLogger.addHandler(fh);
    }

    public static synchronized void clean() {
        if (null != fileLogger) {
            Handler[] hs;
            for (Handler h : hs = fileLogger.getHandlers()) {
                h.close();
                fileLogger.removeHandler(h);
            }
            fileLogger = null;
        }
    }

    public static void info(String msg) {
        if (null != fileLogger) {
            fileLogger.log(Level.INFO, msg);
        }
    }

    public static void warn(String msg) {
        if (null != fileLogger) {
            fileLogger.log(Level.WARNING, msg);
        }
    }

    public static void error(String msg) {
        if (null != fileLogger) {
            fileLogger.log(Level.SEVERE, msg);
        }
    }

    public static void debug(String msg) {
        if (null != fileLogger) {
            fileLogger.log(Level.FINE, msg);
        }
    }

    public synchronized Logger getFileLogger() {
        return fileLogger;
    }

    public static String getLogMark() {
        return "[" + String.valueOf(Math.abs(UUID.randomUUID().hashCode())) + "]";
    }

    public static void main(String[] args) {
        LogUtil.init("d:/svsc.log");
        for (int i = 0; i < 10; ++i) {
            LogUtil.info("\u6211\u88ab\u8bb0\u5f55\u4e86\u5417?");
        }
    }
}

