/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.util;

import com.koalii.kgsp.bc.asn1.DERBitString;
import com.koalii.kgsp.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.Digest;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.util.SubjectPublicKeyInfoFactory;
import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.cert.KcCertStoreFactory;
import com.koalii.kgsp.core.cert.KcCertStoreImpl;
import com.koalii.kgsp.core.crypto.KcDigestUtil;
import com.koalii.kgsp.core.exception.KcException;
import java.io.IOException;

public class ImprintUtil {
    public static final String DEFAULT_CERT_IMPRINT_ALG = "SHA1";

    public static byte[] genImprintBytes(byte[] data, String alg) {
        Digest d = KcDigestUtil.findDigest(alg);
        return KcDigestUtil.digest(d, data);
    }

    public static byte[] genPublicKeyImprintBytes(AsymmetricKeyParameter publicKey) {
        try {
            SubjectPublicKeyInfo subjectKeyInfo = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(publicKey);
            DERBitString pubKeyBitStr = subjectKeyInfo.getPublicKeyData();
            byte[] pubKeyDer = pubKeyBitStr.getOctets();
            return ImprintUtil.genImprintBytes(pubKeyDer, DEFAULT_CERT_IMPRINT_ALG);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static byte[] genPublicKeyImprintBytes(byte[] certData) throws KcException {
        KcCertStoreImpl kcKcCertStore = KcCertStoreFactory.createCertStore(certData);
        return ImprintUtil.genPublicKeyImprintBytes(kcKcCertStore.getPublicKey());
    }

    public static byte[] genCertImprintBytes(X509CertificateHolder cert) {
        try {
            return ImprintUtil.genImprintBytes(cert.getEncoded(), DEFAULT_CERT_IMPRINT_ALG);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static byte[] genCertImprintBytes(byte[] certData) throws KcException {
        KcCertStoreImpl kcKcCertStore = KcCertStoreFactory.createCertStore(certData);
        return ImprintUtil.genCertImprintBytes(kcKcCertStore.getCert());
    }

    public static String genImprint(byte[] data) {
        return ImprintUtil.genImprint(data, DEFAULT_CERT_IMPRINT_ALG);
    }

    public static String genImprint(byte[] data, String alg) {
        return new String(Base64.encode(ImprintUtil.genImprintBytes(data, alg)));
    }

    public static String genCertImprint(X509CertificateHolder cert) {
        return new String(Base64.encode(ImprintUtil.genCertImprintBytes(cert)));
    }

    public static String genCertImprint(byte[] certData) throws KcException {
        return new String(Base64.encode(ImprintUtil.genCertImprintBytes(certData)));
    }

    public static String genPublicKeyImprint(AsymmetricKeyParameter publicKey) {
        return new String(Base64.encode(ImprintUtil.genPublicKeyImprintBytes(publicKey)));
    }

    public static String genPublicKeyImprint(byte[] certData) throws KcException {
        return new String(Base64.encode(ImprintUtil.genPublicKeyImprintBytes(certData)));
    }

    public static void main(String[] args) {
    }
}

