/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class CustomFileStreamHandler
extends StreamHandler {
    private MeteredStream msOut;
    private int limit = 50000;
    private boolean append;
    private LinkedList<File> files;
    private String fileUrl;
    private int dateInter = 1;
    private File indexFile;

    public CustomFileStreamHandler(String fileUrl, int limit, int dateInter, boolean append) throws Exception {
        this.fileUrl = fileUrl;
        if (dateInter <= 0) {
            throw new IllegalArgumentException("\u65f6\u95f4\u95f4\u9694\u5fc5\u987b\u5927\u4e8e0");
        }
        if (limit <= 0) {
            throw new IllegalArgumentException("\u5199\u5165\u65e5\u5fd7\u6587\u4ef6\u7684\u6700\u5927\u5b57\u8282\u6570\u5fc5\u987b\u5927\u4e8e0");
        }
        this.limit = limit;
        this.dateInter = dateInter;
        this.append = append;
        this.openWriteFiles();
    }

    public CustomFileStreamHandler(String fileUrl, boolean append) throws Exception {
        this.fileUrl = fileUrl;
        this.append = append;
        this.openWriteFiles();
    }

    private synchronized void openWriteFiles() throws Exception {
        if (this.fileUrl == null) {
            throw new IllegalArgumentException("\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3anull");
        }
        this.files = this.getWritedLog();
        this.checkLogFile();
        if (this.append) {
            this.openFile(this.files.getLast(), this.append);
        } else {
            this.getLastFile();
        }
    }

    private void openFile(File file, boolean append) throws Exception {
        int len = 0;
        if (append) {
            len = (int)file.length();
        }
        FileOutputStream fout = new FileOutputStream(file.toString(), append);
        BufferedOutputStream bout = new BufferedOutputStream(fout);
        this.msOut = new MeteredStream(bout, len);
        this.setOutputStream(this.msOut);
    }

    private void getLastFile() {
        try {
            super.close();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String trace = sdf.format(new Date().getTime());
            int maxLogCount = 0;
            for (File file : this.files) {
                String fileName = file.toString();
                if (fileName.indexOf(trace) == -1) continue;
                int last = fileName.lastIndexOf(95);
                int beforeLast = fileName.lastIndexOf(95, last - 1);
                maxLogCount = Integer.valueOf(fileName.substring(beforeLast + 1, last));
            }
            File file = new File(this.fileUrl);
            String logIndex = maxLogCount + 1 + "_" + trace;
            if (file.isDirectory()) {
                this.files.add(new File(this.fileUrl + File.separator + "\u672a\u547d\u540d_" + logIndex + ".log"));
            } else {
                this.files.add(new File(this.fileUrl + "_" + logIndex + ".log"));
            }
            this.writeLogIndex(logIndex, true);
            this.openFile(this.files.getLast(), false);
        }
        catch (Exception ex) {
            Logger.getLogger(CustomFileStreamHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList<File> getWritedLog() {
        LinkedList<File> fileList = new LinkedList<File>();
        BufferedReader br = null;
        try {
            File file = new File(this.fileUrl);
            if ((this.fileUrl.endsWith("/") || this.fileUrl.endsWith("/")) && !file.exists()) {
                file.mkdirs();
            }
            this.indexFile = file.isDirectory() ? new File(file.toString() + File.separator + "logindex") : new File(file.getParent() + File.separator + "logindex");
            if (!this.indexFile.exists()) {
                this.indexFile.createNewFile();
            }
            FileReader fr = null;
            fr = new FileReader(this.indexFile);
            br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (file.isDirectory()) {
                    fileList.add(new File(this.fileUrl + File.separator + "\u672a\u547d\u540d_" + line + ".log"));
                    continue;
                }
                fileList.add(new File(this.fileUrl + "_" + line + ".log"));
            }
            LinkedList<File> linkedList = fileList;
            return linkedList;
        }
        catch (Exception ex) {
            Logger.getLogger(CustomFileStreamHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ex) {
                Logger.getLogger(CustomFileStreamHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLogIndex(String logIndex, boolean isAppend) {
        File file = new File(this.fileUrl);
        BufferedWriter bw = null;
        try {
            FileWriter fw = null;
            fw = file.isDirectory() ? new FileWriter(new File(file.toString() + File.separator + "logindex"), isAppend) : new FileWriter(new File(file.getParent() + File.separator + "logindex"), isAppend);
            bw = new BufferedWriter(fw);
            bw.newLine();
            bw.write(logIndex, 0, logIndex.length());
            bw.flush();
        }
        catch (Exception ex) {
            Logger.getLogger(CustomFileStreamHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(CustomFileStreamHandler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void checkLogFile() {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String trace = sdf.format(new Date().getTime());
            boolean isIncludeNow = false;
            LinkedList<File> overdueLog = new LinkedList<File>();
            long nowDate = sdf.parse(trace).getTime();
            for (File file : this.files) {
                if (file.toString().indexOf(trace) != -1) {
                    isIncludeNow = true;
                }
                if ((nowDate - sdf.parse(file.toString(), new ParsePosition(file.toString().lastIndexOf(95) + 1)).getTime()) / 86400000L <= 5L) continue;
                overdueLog.add(file);
            }
            if (overdueLog.size() != 0) {
                this.files.removeAll(overdueLog);
                this.indexFile.delete();
                this.indexFile.createNewFile();
                String fileStr = null;
                for (File file : this.files) {
                    fileStr = file.toString();
                    this.writeLogIndex(fileStr.substring(fileStr.lastIndexOf(95) - 1, fileStr.lastIndexOf(46)), true);
                }
                for (File file : overdueLog) {
                    file.delete();
                }
            }
            if (!isIncludeNow && this.append) {
                File file = new File(this.fileUrl);
                String string = "1_" + trace;
                if (file.isDirectory()) {
                    this.files.add(new File(this.fileUrl + File.separator + "\u672a\u547d\u540d_" + string + ".log"));
                } else {
                    this.files.add(new File(this.fileUrl + "_" + string + ".log"));
                }
                this.writeLogIndex(string, true);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(CustomFileStreamHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        super.publish(record);
        super.flush();
        if (this.limit > 0 && this.msOut.written >= this.limit) {
            this.getLastFile();
        }
    }

    private class MeteredStream
    extends OutputStream {
        private OutputStream out;
        private int written;

        MeteredStream(OutputStream out, int written) {
            this.out = out;
            this.written = written;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.written;
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            this.written += buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            this.written += len;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

