/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.pkcs;

import com.koalii.kgsp.bc.asn1.pkcs.PrivateKeyInfo;
import com.koalii.kgsp.bc.crypto.util.PrivateKeyInfoFactory;
import com.koalii.kgsp.bc.openssl.PKCS8Generator;
import com.koalii.kgsp.bc.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import com.koalii.kgsp.bc.operator.OutputEncryptor;
import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.crypto.KcAsymmetricKeyPair;
import com.koalii.kgsp.core.crypto.KcSM2;
import com.koalii.kgsp.core.exception.KcException;
import java.io.IOException;

public class Pkcs8Builder {
    private KcAsymmetricKeyPair keyPair;

    public Pkcs8Builder(KcAsymmetricKeyPair keyPair) {
        this.keyPair = keyPair;
    }

    private PrivateKeyInfo getPrivateKeyInfo(KcAsymmetricKeyPair keyPair) throws KcException {
        try {
            return PrivateKeyInfoFactory.createPrivateKeyInfo(keyPair.getPrivateKey());
        }
        catch (IOException e) {
            throw new KcException(100122, (Throwable)e);
        }
    }

    public byte[] build() throws KcException {
        try {
            PrivateKeyInfo key = this.getPrivateKeyInfo(this.keyPair);
            PKCS8Generator pkcs8Generator = new PKCS8Generator(key, null);
            return pkcs8Generator.generate().getContent();
        }
        catch (Exception e) {
            throw new KcException(100190, "build unencrypted pkcs8 failed", e);
        }
    }

    public byte[] buildEncrypted(char[] password) throws KcException {
        try {
            PrivateKeyInfo key = this.getPrivateKeyInfo(this.keyPair);
            JceOpenSSLPKCS8EncryptorBuilder encryptorBuilder = new JceOpenSSLPKCS8EncryptorBuilder(PKCS8Generator.PBE_SHA1_RC4_128);
            encryptorBuilder.setPasssword(password);
            OutputEncryptor encryptor = encryptorBuilder.build();
            PKCS8Generator pkcs8Generator = new PKCS8Generator(key, encryptor);
            return pkcs8Generator.generate().getContent();
        }
        catch (Exception e) {
            throw new KcException(100191, "build pbe encrypted pkcs8 failed", e);
        }
    }

    public static void main(String[] args) {
        String password = "123456";
        try {
            KcSM2 sm2 = new KcSM2();
            KcAsymmetricKeyPair keypair = sm2.generateKeyPair();
            Pkcs8Builder p8b = new Pkcs8Builder(keypair);
            System.out.println("pkcs8: " + new String(Base64.encode(p8b.build())));
            System.out.println("encrypted pkcs8: " + new String(Base64.encode(p8b.buildEncrypted(password.toCharArray()))));
        }
        catch (KcException e) {
            System.out.println(e.getErrorNo());
        }
    }
}

