/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.pkcs;

import com.koalii.kgsp.bc.asn1.ASN1EncodableVector;
import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.DEROctetString;
import com.koalii.kgsp.bc.asn1.DERSet;
import com.koalii.kgsp.bc.asn1.cms.CMSObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.cms.ContentInfo;
import com.koalii.kgsp.bc.asn1.cms.EncryptedContentInfo;
import com.koalii.kgsp.bc.asn1.cms.EnvelopedData;
import com.koalii.kgsp.bc.asn1.cms.IssuerAndSerialNumber;
import com.koalii.kgsp.bc.asn1.cms.KeyTransRecipientInfo;
import com.koalii.kgsp.bc.asn1.cms.RecipientIdentifier;
import com.koalii.kgsp.bc.asn1.cms.RecipientInfo;
import com.koalii.kgsp.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.cms.CMSAlgorithm;
import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.crypto.KcTripleDES;
import com.koalii.kgsp.core.exception.KcException;
import java.io.IOException;

public class Pkcs7EnvelopBuilder {
    public static void main(String[] args) throws KcException, IOException {
        Pkcs7EnvelopBuilder peb = new Pkcs7EnvelopBuilder();
        KcTripleDES des = new KcTripleDES("ECB");
        byte[] key = des.generateKey();
        String b64Cert = "MIIFNjCCBB6gAwIBAgIQTJ4Y2ztNvP5wSa9H7fLmvDANBgkqhkiG9w0BAQsFADAzMQswCQYDVQQGEwJDTjERMA8GA1UECgwIVW5pVHJ1c3QxETAPBgNVBAMMCFNIRUNBIEcyMB4XDTIwMDkyNDA4MzEwNFoXDTIzMDkyNDE1NTk1OVowge8xQjBABgNVBAMMOea1i+ivleS4reWbveW3peWVhumTtuihjOiCoeS7veaciemZkOWFrOWPuOS4iua1t+W4guWIhuihjDE8MDoGA1UECwwz5Lit5Zu95bel5ZWG6ZO26KGM6IKh5Lu95pyJ6ZmQ5YWs5Y+45LiK5rW35biC5YiG6KGMMTwwOgYDVQQKDDPkuK3lm73lt6XllYbpk7booYzogqHku73mnInpmZDlhazlj7jkuIrmtbfluILliIbooYwxDzANBgNVBAcMBuS4iua1tzEPMA0GA1UECAwG5LiK5rW3MQswCQYDVQQGEwJDTjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJv6Gzspx/uNNmKU6Dh5XXVcH2eBcRHa9unRtnrYZNwAXgYNa96Jmi0i452bzw/GixbKYc4UX35gASmHOBb9PSqrd0jurpDQy0cMQdYoZGfcaDKhRXn4dYD5+qZrGYu9FDZpZa1Y0D10Ce71lhKwM1/vzfASrcw6a0cMMfqPhuL8WnIvRyacAjK8xsqEFD47rNsbvt6Hb2s4M+qXiObgJp1igviuzcKCFE4mqxwW6ucq4Va0fG4egQ98SwhTzPbMNKuJdoru25WzhHrIHL/By9CPWCVXPai0Fv/vjI/opaje3l9maIjYywsP1yNfGrVCcY91kVhQiHBHW9UVYy7fSd8CAwEAAaOCAYcwggGDMB8GA1UdIwQYMBaAFFaI3uMYQ4K3cqQm60SpYtCHxKwmMB0GA1UdDgQWBBRCZQWGU+Z8cF6FC6y1L1a0n73CLDAOBgNVHQ8BAf8EBAMCBsAwFAYDVR0lBA0wCwYJKoZIhvcvAQEFMCIGA1UdIAQbMBkwCgYIKoEchu86AQMwCwYJKoEchu86AQIEMAwGA1UdEwEB/wQCMAAwfQYIKwYBBQUHAQEEcTBvMDgGCCsGAQUFBzABhixodHRwOi8vb2NzcDMuc2hlY2EuY29tL29jc3Avc2hlY2Evc2hlY2Eub2NzcDAzBggrBgEFBQcwAoYnaHR0cDovL2xkYXAyLnNoZWNhLmNvbS9yb290L3NoZWNhZzIuZGVyMCEGCSqBHIbvOguBUgQUExI5MTMxMDAwMDEzMjIwNjA0M1AwRwYDVR0fBEAwPjA8oDqgOIY2aHR0cDovL2xkYXAyLnNoZWNhLmNvbS9DQTIwMDExL1JBMTIwNTAxMDAvQ1JMNjM1MjkuY3JsMA0GCSqGSIb3DQEBCwUAA4IBAQAaXXHmb1KI29ZXJ1Kr9L6y5Qa+gwpvqGA+lj67o8eo0yJ8O+O1X3yrM2njDjy4PHtXEskHH1RLeIp4jmv8+k5h/Hv2MFAhzVWMcH9EMCyBC8o2IcE2EIHnc1ftGZrA9cuBKPV49C1s/UegIakVQXieW20mXpsxMZ2HK+5LElExBtqewFmw6h4ubAk9jtMKizR2y4tGc+ekAA9KMgMfdVZPDNns1dAU3qSNTtauH43Smc5EDSIHHAgVsuNDQmyBvCnS/EIdo3wCrCqyAPzr9255CPEcto2z/HEAAsd0xzGSoUcKgDPXNj+wtF5iqU/H+J+vN7bQLBYi49NKEgjP+bO3";
        X509CertificateHolder certHolder = new X509CertificateHolder(Base64.decode(b64Cert));
        byte[] encryptData = peb.build("abc".getBytes(), certHolder, key, key);
        System.out.println(new String(Base64.encode(encryptData)));
    }

    public byte[] build(byte[] oriData, X509CertificateHolder encrypCert, byte[] key, byte[] encryptKey) throws KcException {
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(encrypCert.getIssuer(), encrypCert.getSerialNumber());
        KeyTransRecipientInfo recinfo = new KeyTransRecipientInfo(new RecipientIdentifier(isn), new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption), new DEROctetString(encryptKey));
        ASN1EncodableVector recinfos = new ASN1EncodableVector();
        recinfos.add(new RecipientInfo(recinfo));
        KcTripleDES des = new KcTripleDES("CBC");
        byte[] iv = des.generateIV();
        byte[] encdata = des.encrypt(oriData, key, iv);
        EncryptedContentInfo einfo = new EncryptedContentInfo(this.getDataContentType(), new AlgorithmIdentifier(CMSAlgorithm.DES_EDE3_CBC, new DEROctetString(iv)), new DEROctetString(encdata));
        EnvelopedData edata = new EnvelopedData(null, new DERSet(recinfos), einfo, null);
        ContentInfo p7 = new ContentInfo(this.getContentType(), edata);
        try {
            return p7.getEncoded("DER");
        }
        catch (IOException e) {
            throw new KcException(100158, "p7 envelop build failed", e);
        }
    }

    protected ASN1ObjectIdentifier getContentType() {
        return CMSObjectIdentifiers.envelopedData;
    }

    protected ASN1ObjectIdentifier getDataContentType() {
        return CMSObjectIdentifiers.data;
    }
}

