/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.pkcs;

import com.koalii.kgsp.bc.asn1.ASN1Set;
import com.koalii.kgsp.bc.asn1.DERBitString;
import com.koalii.kgsp.bc.asn1.pkcs.CertificationRequest;
import com.koalii.kgsp.bc.asn1.pkcs.CertificationRequestInfo;
import com.koalii.kgsp.bc.asn1.x500.X500Name;
import com.koalii.kgsp.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.util.SubjectPublicKeyInfoFactory;
import com.koalii.kgsp.core.crypto.KcAsymmetricKeyPair;
import com.koalii.kgsp.core.crypto.KcSigner;
import com.koalii.kgsp.core.crypto.KcSignerFactory;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.util.StringUtil;

public class Pkcs10Builder {
    private KcAsymmetricKeyPair keyPair;
    private KcSigner signer;
    private ASN1Set attributes;

    public Pkcs10Builder(KcAsymmetricKeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public ASN1Set getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ASN1Set attributes) {
        this.attributes = attributes;
    }

    public KcSigner getSigner() {
        return this.signer;
    }

    public void setSigner(KcSigner signer) {
        this.signer = signer;
    }

    public byte[] generateTbs(String subject, AsymmetricKeyParameter publicKey) throws KcException {
        try {
            X500Name subjectName = new X500Name(subject);
            SubjectPublicKeyInfo spki = SubjectPublicKeyInfoFactory.createSubjectPublicKeyInfo(publicKey);
            CertificationRequestInfo tbsinfo = new CertificationRequestInfo(subjectName, spki, this.getAttributes());
            return tbsinfo.getEncoded();
        }
        catch (Exception e) {
            throw new KcException(100183, "create p10 tbs data failed: " + subject);
        }
    }

    public byte[] build(String subject) throws KcException {
        if (StringUtil.isEmpty(subject)) {
            throw new KcException(100185, "create p10 request: subject is empty");
        }
        if (null == this.keyPair) {
            throw new KcException(100186, "create p10 request: kc key pair is empty");
        }
        if (this.keyPair.isKeyEmpty()) {
            this.keyPair.generateKeyPair();
        }
        byte[] tbs = this.generateTbs(subject, this.keyPair.getPublicKey());
        KcSigner p10Signer = null;
        p10Signer = null == this.getSigner() ? KcSignerFactory.createSignerByPrivateKey(this.keyPair.getPrivateKey()) : this.getSigner();
        if (null == p10Signer) {
            throw new KcException(100188, "create p10 request: signer is empty");
        }
        byte[] signData = p10Signer.sign(tbs);
        CertificationRequest certRequest = new CertificationRequest(CertificationRequestInfo.getInstance(tbs), p10Signer.getSignAlgId(), new DERBitString(signData));
        try {
            return certRequest.getEncoded();
        }
        catch (Exception e) {
            throw new KcException(100184, "create p10 request failed", e);
        }
    }
}

