/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.pkcs;

import com.koalii.kgsp.bc.asn1.ASN1EncodableVector;
import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.DEROctetString;
import com.koalii.kgsp.bc.asn1.DERSet;
import com.koalii.kgsp.bc.asn1.cms.ContentInfo;
import com.koalii.kgsp.bc.asn1.cms.EncryptedContentInfo;
import com.koalii.kgsp.bc.asn1.cms.EnvelopedData;
import com.koalii.kgsp.bc.asn1.cms.IssuerAndSerialNumber;
import com.koalii.kgsp.bc.asn1.cms.KeyTransRecipientInfo;
import com.koalii.kgsp.bc.asn1.cms.RecipientIdentifier;
import com.koalii.kgsp.bc.asn1.cms.RecipientInfo;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.cms.CMSAlgorithm;
import com.koalii.kgsp.bc.util.encoders.Base64;
import com.koalii.kgsp.core.crypto.KcSM4;
import com.koalii.kgsp.core.crypto.KcTripleDES;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.util.SM2PKCSObjectIdentifiers;
import java.io.IOException;

public class GMPkcs7EnvelopBuilder {
    public static void main(String[] args) throws KcException, IOException {
        byte[] key;
        GMPkcs7EnvelopBuilder peb = new GMPkcs7EnvelopBuilder();
        KcTripleDES des = new KcTripleDES("CBC");
        byte[] encryptKey = key = des.generateKey();
        String b64Cert = "MIID7TCCA5KgAwIBAgIMG08AAAAAAiPBICVbMAwGCCqBHM9VAYN1BQAwKDELMAkGA1UEBhMCQ04xGTAXBgNVBAMMEFN1YkNBX1NNMl8xOTA3MTAwHhcNMjAxMTEwMTYwMDAwWhcNMjUxMTEwMTU1OTU5WjA5MQswCQYDVQQGEwJjbjENMAsGA1UECgwEa29hbDENMAsGA1UECwwEdGVzdDEMMAoGA1UEAwwDc20yMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEyusKZDisWedHhICG5rCT7pDP7p3n9huakJz07F7BWL51VdMYXZBSpSP4qzoB3JrUQlm/vDki093n4bYAlI1GBqOCAo0wggKJMBMGA1UdJQQMMAoGCCsGAQUFBwMBMA4GA1UdDwEB/wQEAwIAwDARBglghkgBhvhCAQEEBAMCAEAwHwYDVR0jBBgwFoAU7XEmyhuOfMrs5gJgvFBOTO8N6kAwgfIGA1UdHwSB6jCB5zCBqKCBpaCBooaBn2xkYXA6Ly8xMC4xLjEuMjUxOjM4OS9DTj1TdWJDQV9TTTJfMTkwNzEwLENOPVN1YkNBX1NNMl8xOTA3MTAsIE9VPUNSTERpc3RyaWJ1dGVQb2ludHMsIG89a29hbGNhP2NlcnRpZmljYXRlUmV2b2NhdGlvbkxpc3Q/YmFzZT9vYmplY3RjbGFzcz1jUkxEaXN0cmlidXRpb25Qb2ludDA6oDigNoY0aHR0cDovLzEwLjEuMS4yNTI6ODg4MC9kb3dubG9hZC9TdWJDQV9TTTJfMTkwNzEwLmNybDCCARgGCCsGAQUFBwEBBIIBCjCCAQYwIgYIKwYBBQUHMAGGFmh0dHA6Ly8xMC4xLjEuMjUyOjMwMTkwgZ0GCCsGAQUFBzAChoGQbGRhcDovLzEwLjEuMS4yNTE6Mzg5L0NOPVN1YkNBX1NNMl8xOTA3MTAsQ049U3ViQ0FfU00yXzE5MDcxMCwgT1U9Y0FDZXJ0aWZpY2F0ZXMsIG89a29hbGNhP2NBQ2VydGlmaWNhdGU/YmFzZT9vYmplY3RDbGFzcz1jZXJ0aWZpY2F0aW9uQXV0aG9yaXR5MEAGCCsGAQUFBzAChjRodHRwOi8vMTAuMS4xLjI1Mjo4ODgwL2Rvd25sb2FkL1N1YkNBX1NNMl8xOTA3MTAuY2VyMB0GA1UdDgQWBBS4hbcdjYk9zwPFqIEk67ehQE/VWDAMBggqgRzPVQGDdQUAA0cAMEQCIGD9K917CYqOWj+3vaveYg/JveyTR7q+VkbhKnw2Gp/mAiBdQOHB4cQVsUVnbb5dggCQewVcKz+O8Pdt0i1V2LkdkA==";
        X509CertificateHolder certHolder = new X509CertificateHolder(Base64.decode(b64Cert));
        byte[] encryptData = peb.build("abc".getBytes(), certHolder, key, encryptKey);
        System.out.println(new String(Base64.encode(encryptData)));
    }

    public byte[] build(byte[] oriData, X509CertificateHolder encrypCert, byte[] key, byte[] encryptKey) throws KcException {
        IssuerAndSerialNumber isn = new IssuerAndSerialNumber(encrypCert.getIssuer(), encrypCert.getSerialNumber());
        KeyTransRecipientInfo recinfo = new KeyTransRecipientInfo(new RecipientIdentifier(isn), new AlgorithmIdentifier(SM2PKCSObjectIdentifiers.sm2Encryption), new DEROctetString(encryptKey));
        ASN1EncodableVector recinfos = new ASN1EncodableVector();
        recinfos.add(new RecipientInfo(recinfo));
        KcSM4 des = new KcSM4("CBC");
        byte[] iv = des.generateIV();
        byte[] encdata = des.encrypt(oriData, key, iv);
        EncryptedContentInfo einfo = new EncryptedContentInfo(this.getDataContentType(), new AlgorithmIdentifier(CMSAlgorithm.SMS4_CBC, new DEROctetString(iv)), new DEROctetString(encdata));
        EnvelopedData edata = new EnvelopedData(null, new DERSet(recinfos), einfo, null);
        ContentInfo p7 = new ContentInfo(this.getContentType(), edata);
        try {
            return p7.getEncoded("DER");
        }
        catch (IOException e) {
            throw new KcException(100158, "p7 envelop build failed", e);
        }
    }

    protected ASN1ObjectIdentifier getContentType() {
        return SM2PKCSObjectIdentifiers.sm2EncryptData;
    }

    protected ASN1ObjectIdentifier getDataContentType() {
        return SM2PKCSObjectIdentifiers.sm2Data;
    }
}

