/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.io;

import com.koalii.kgsp.bc.crypto.Digest;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class KcDigestOutputStream
extends FilterOutputStream {
    private boolean on = true;
    protected Digest digest;

    public KcDigestOutputStream(OutputStream stream, Digest digest) {
        super(stream);
        this.setDigest(digest);
    }

    public Digest getDigest() {
        return this.digest;
    }

    public void setDigest(Digest digest) {
        this.digest = digest;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        if (this.on) {
            this.digest.update((byte)b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.on) {
            this.digest.update(b, off, len);
        }
    }

    public void on(boolean on) {
        this.on = on;
    }

    public String toString() {
        return "[Digest Output Stream] " + this.digest.toString();
    }
}

