/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.generator;

import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.generator.IntegerGenerator;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class PrngRandomIntegerGenerator
implements IntegerGenerator {
    private static final String ErrPrefix = "Prng Random Generator: ";
    private int byteLen = 10;
    private int signum = 1;
    private SecureRandom secureRandom = null;

    public PrngRandomIntegerGenerator() throws KcException {
        try {
            this.secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            throw new KcException(100006, "Prng Random Generator: unkown alg name NativePRNGNonBlocking", e);
        }
    }

    public PrngRandomIntegerGenerator(int signum, int byteLen, String generatorAlg) throws KcException {
        this.signum = signum;
        this.byteLen = byteLen;
        try {
            this.secureRandom = SecureRandom.getInstance(generatorAlg);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KcException(100006, "Prng Random Generator: unkown alg name " + generatorAlg, e);
        }
    }

    @Override
    public BigInteger next() {
        byte[] rndBytes = new byte[this.byteLen];
        this.secureRandom.nextBytes(rndBytes);
        return new BigInteger(this.signum, rndBytes);
    }
}

