/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto.padding;

import com.koalii.kgsp.bc.crypto.BlockCipher;
import com.koalii.kgsp.bc.crypto.DataLengthException;
import com.koalii.kgsp.bc.crypto.InvalidCipherTextException;
import com.koalii.kgsp.bc.crypto.OutputLengthException;
import com.koalii.kgsp.bc.crypto.paddings.BlockCipherPadding;
import com.koalii.kgsp.bc.crypto.paddings.PaddedBufferedBlockCipher;

public class KcPaddedBufferedBlockCipher
extends PaddedBufferedBlockCipher {
    BlockCipherPadding padding;

    public KcPaddedBufferedBlockCipher(BlockCipher cipher, BlockCipherPadding padding) {
        super(cipher, padding);
        this.padding = padding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] out, int outOff) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        int blockSize = this.cipher.getBlockSize();
        int resultLen = 0;
        if (this.forEncryption) {
            int len;
            if (this.bufOff == blockSize) {
                if (outOff + 2 * blockSize > out.length) {
                    this.reset();
                    throw new OutputLengthException("output buffer too short");
                }
                resultLen = this.cipher.processBlock(this.buf, 0, out, outOff);
                this.bufOff = 0;
            }
            if ((len = this.padding.addPadding(this.buf, this.bufOff)) != -1) {
                resultLen += this.cipher.processBlock(this.buf, 0, out, outOff + resultLen);
            }
            this.reset();
        } else {
            if (this.bufOff != blockSize) {
                this.reset();
                throw new DataLengthException("last block incomplete in decryption");
            }
            resultLen = this.cipher.processBlock(this.buf, 0, this.buf, 0);
            this.bufOff = 0;
            try {
                System.arraycopy(this.buf, 0, out, outOff, resultLen -= this.padding.padCount(this.buf));
            }
            finally {
                this.reset();
            }
        }
        return resultLen;
    }
}

