/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.ECPrivateKeyParameters;
import com.koalii.kgsp.bc.crypto.params.RSAPrivateCrtKeyParameters;
import com.koalii.kgsp.core.cert.KcRSACertStore;
import com.koalii.kgsp.core.cert.KcSM2CertStore;
import com.koalii.kgsp.core.crypto.KcRSASigner;
import com.koalii.kgsp.core.crypto.KcSM2Signer;
import com.koalii.kgsp.core.crypto.KcSigner;
import com.koalii.kgsp.core.exception.KcException;

public class KcSignerFactory {
    public static KcSigner createSignerByPrivateKey(AsymmetricKeyParameter privateKey) throws KcException {
        if (privateKey instanceof RSAPrivateCrtKeyParameters) {
            return new KcRSASigner(null, privateKey);
        }
        if (privateKey instanceof ECPrivateKeyParameters) {
            return new KcSM2Signer(null, privateKey);
        }
        throw new KcException(100130, "create signer: unknown key alg - " + privateKey.toString());
    }

    public static KcSigner createSignerByCert(X509CertificateHolder cert) throws KcException {
        if (KcRSACertStore.isRsaCert(cert)) {
            return new KcRSASigner(new KcRSACertStore(cert));
        }
        if (KcSM2CertStore.isSM2Cert(cert)) {
            return new KcSM2Signer(new KcSM2CertStore(cert));
        }
        throw new KcException(100130, "create signer: unknown cert alg - " + cert.getSubject().toString());
    }
}

