/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.asn1.ASN1EncodableVector;
import com.koalii.kgsp.bc.asn1.ASN1Integer;
import com.koalii.kgsp.bc.asn1.ASN1Object;
import com.koalii.kgsp.bc.asn1.ASN1OctetString;
import com.koalii.kgsp.bc.asn1.ASN1Primitive;
import com.koalii.kgsp.bc.asn1.ASN1Sequence;
import com.koalii.kgsp.bc.asn1.DEROctetString;
import com.koalii.kgsp.bc.asn1.DERSequence;
import com.koalii.kgsp.bc.crypto.engines.SM2Engine;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.ParametersWithRandom;
import com.koalii.kgsp.bc.util.Arrays;
import com.koalii.kgsp.core.cert.KcCertStore;
import com.koalii.kgsp.core.cert.KcKeyStore;
import com.koalii.kgsp.core.crypto.KcAsymmetricKeyPair;
import com.koalii.kgsp.core.crypto.KcEncryptor;
import com.koalii.kgsp.core.exception.KcException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class KcSM2Encryptor
extends KcEncryptor {
    public KcSM2Encryptor() {
    }

    public KcSM2Encryptor(KcAsymmetricKeyPair keyPair) {
        super(keyPair);
    }

    public KcSM2Encryptor(AsymmetricKeyParameter publicKey, AsymmetricKeyParameter privateKey) {
        super(publicKey, privateKey);
    }

    public KcSM2Encryptor(KcKeyStore store) {
        super(store);
    }

    public KcSM2Encryptor(KcCertStore store) {
        super(store);
    }

    @Override
    public byte[] encrypt(byte[] data) throws KcException {
        if (null == this.encPublicKey) {
            throw new KcException(100125, "sm2 encrypt: public key empty");
        }
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, new ParametersWithRandom(this.encPublicKey, new SecureRandom()));
        try {
            return sm2Engine.processBlock(data, 0, data.length);
        }
        catch (Exception e) {
            throw new KcException(100145, "sm2 encrypt failed", e);
        }
    }

    @Override
    public byte[] decrypt(byte[] data) throws KcException {
        if (null == this.encPrivateKey) {
            throw new KcException(100120, "sm2 decrypt: private key empty");
        }
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, this.encPrivateKey);
        try {
            return sm2Engine.processBlock(data, 0, data.length);
        }
        catch (Exception e) {
            throw new KcException(100146, "sm2 decrypt failed", e);
        }
    }

    public static byte[] gmToOpl(byte[] gmEnc) throws KcException {
        SM2OplEncData sm2OplEncData = new SM2OplEncData();
        byte[] bx = Arrays.copyOfRange(gmEnc, 1, 33);
        byte[] by = Arrays.copyOfRange(gmEnc, 33, 65);
        byte[] bc3 = Arrays.copyOfRange(gmEnc, 65, 97);
        byte[] bc2 = Arrays.copyOfRange(gmEnc, 97, gmEnc.length);
        sm2OplEncData.setX(new ASN1Integer(new BigInteger(bx)));
        sm2OplEncData.setY(new ASN1Integer(new BigInteger(by)));
        sm2OplEncData.setC3(new DEROctetString(bc3));
        sm2OplEncData.setC2(new DEROctetString(bc2));
        return sm2OplEncData.toDer();
    }

    public static byte[] oplToGm(byte[] oplEnc) throws KcException {
        SM2OplEncData oplObj = new SM2OplEncData(DERSequence.getInstance(oplEnc));
        byte[] gmEnc = null;
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(4);
            BigInteger bi = oplObj.getX().getValue();
            byte[] biarray = null;
            biarray = bi.toByteArray();
            os.write(biarray, biarray.length - 32, 32);
            bi = oplObj.getY().getValue();
            biarray = bi.toByteArray();
            os.write(biarray, biarray.length - 32, 32);
            os.write(oplObj.getC3().getOctets());
            os.write(oplObj.getC2().getOctets());
            gmEnc = os.toByteArray();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return gmEnc;
    }

    private static class SM2OplEncData
    extends ASN1Object {
        private ASN1Integer x;
        private ASN1Integer y;
        private ASN1OctetString c3;
        private ASN1OctetString c2;

        public SM2OplEncData() {
        }

        public SM2OplEncData(ASN1Sequence seq) {
            this.x = (ASN1Integer)seq.getObjectAt(0);
            this.y = (ASN1Integer)seq.getObjectAt(1);
            this.c3 = (ASN1OctetString)seq.getObjectAt(2);
            this.c2 = (ASN1OctetString)seq.getObjectAt(3);
        }

        @Override
        public ASN1Primitive toASN1Primitive() {
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add(this.x);
            v.add(this.y);
            v.add(this.c3);
            v.add(this.c2);
            DERSequence seq = new DERSequence(v);
            return seq;
        }

        public byte[] toDer() throws KcException {
            DERSequence seq = (DERSequence)this.toASN1Primitive();
            byte[] derBytes = null;
            try {
                derBytes = seq.getEncoded("DER");
            }
            catch (IOException e) {
                throw new KcException(100008, "Sm2OplEncData der encoding", e);
            }
            return derBytes;
        }

        public ASN1Integer getX() {
            return this.x;
        }

        public void setX(ASN1Integer x) {
            this.x = x;
        }

        public ASN1Integer getY() {
            return this.y;
        }

        public void setY(ASN1Integer y) {
            this.y = y;
        }

        public ASN1OctetString getC3() {
            return this.c3;
        }

        public void setC3(ASN1OctetString c3) {
            this.c3 = c3;
        }

        public ASN1OctetString getC2() {
            return this.c2;
        }

        public void setC2(ASN1OctetString c2) {
            this.c2 = c2;
        }
    }
}

