/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.asn1.gm.GMNamedCurves;
import com.koalii.kgsp.bc.asn1.x9.X9ECParameters;
import com.koalii.kgsp.bc.crypto.AsymmetricCipherKeyPair;
import com.koalii.kgsp.bc.crypto.engines.SM2Engine;
import com.koalii.kgsp.bc.crypto.generators.ECKeyPairGenerator;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.ECDomainParameters;
import com.koalii.kgsp.bc.crypto.params.ECKeyGenerationParameters;
import com.koalii.kgsp.bc.crypto.params.ECPrivateKeyParameters;
import com.koalii.kgsp.bc.crypto.params.ECPublicKeyParameters;
import com.koalii.kgsp.bc.crypto.params.ParametersWithRandom;
import com.koalii.kgsp.bc.math.ec.ECCurve;
import com.koalii.kgsp.bc.util.encoders.Hex;
import com.koalii.kgsp.core.cert.KcSM2CertStore;
import com.koalii.kgsp.core.cert.KcSM2KeyStore;
import com.koalii.kgsp.core.crypto.KcAsymmetricKeyPair;
import com.koalii.kgsp.core.exception.KcException;
import java.security.SecureRandom;

public class KcSM2
implements KcAsymmetricKeyPair {
    private AsymmetricCipherKeyPair keyPair;
    private ECPublicKeyParameters publicKey;
    private ECPrivateKeyParameters privateKey;

    public KcSM2() {
    }

    public KcSM2(KcSM2CertStore store) {
        this.publicKey = (ECPublicKeyParameters)store.getPublicKey();
    }

    public KcSM2(KcSM2KeyStore store) {
        this.publicKey = (ECPublicKeyParameters)store.getPublicKey();
        this.privateKey = (ECPrivateKeyParameters)store.getPrivateKey();
    }

    @Override
    public String getKeyAlg() {
        return "SM2";
    }

    @Override
    public boolean isKeyEmpty() {
        return null == this.publicKey || null == this.privateKey;
    }

    @Override
    public KcAsymmetricKeyPair generateKeyPair(int keySize) {
        return this.generateKeyPair();
    }

    @Override
    public KcAsymmetricKeyPair generateKeyPair() {
        X9ECParameters ecParams = GMNamedCurves.getByName("sm2p256v1");
        ECCurve curve = ecParams.getCurve();
        ECDomainParameters domainParams = new ECDomainParameters(curve, ecParams.getG(), ecParams.getN());
        ECKeyGenerationParameters aKeyGenParams = new ECKeyGenerationParameters(domainParams, new SecureRandom());
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init(aKeyGenParams);
        this.keyPair = keyPairGenerator.generateKeyPair();
        this.publicKey = (ECPublicKeyParameters)this.keyPair.getPublic();
        this.privateKey = (ECPrivateKeyParameters)this.keyPair.getPrivate();
        return this;
    }

    @Override
    public AsymmetricKeyParameter getPublicKey() {
        return this.publicKey;
    }

    @Override
    public AsymmetricKeyParameter getPrivateKey() {
        return this.privateKey;
    }

    public byte[] encrypt(byte[] data) throws KcException {
        if (null == this.publicKey) {
            throw new KcException(100125, "sm2 encrypt: public key empty");
        }
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(true, new ParametersWithRandom(this.publicKey, new SecureRandom()));
        try {
            return sm2Engine.processBlock(data, 0, data.length);
        }
        catch (Exception e) {
            throw new KcException(100145, "sm2 encrypt failed", e);
        }
    }

    public byte[] decrypt(byte[] data) throws KcException {
        if (null == this.privateKey) {
            throw new KcException(100120, "sm2 decrypt: private key empty");
        }
        SM2Engine sm2Engine = new SM2Engine();
        sm2Engine.init(false, this.privateKey);
        try {
            return sm2Engine.processBlock(data, 0, data.length);
        }
        catch (Exception e) {
            throw new KcException(100146, "sm2 decrypt failed", e);
        }
    }

    public static void main(String[] args) throws Exception {
        String s = "Hello,world!";
        byte[] oriData = s.getBytes();
        System.out.println(Hex.toHexString(oriData));
        KcSM2 sm2 = new KcSM2();
        sm2.generateKeyPair();
        byte[] secData = sm2.encrypt(oriData);
        System.out.println("SM2 public key encrypt:" + secData.length);
        System.out.println(Hex.toHexString(secData));
        oriData = sm2.decrypt(secData);
        System.out.println("SM2 private key decrypt:" + oriData.length);
        System.out.println(Hex.toHexString(oriData));
    }
}

