/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.crypto.Digest;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.RSAKeyParameters;
import com.koalii.kgsp.bc.crypto.params.RSAPrivateCrtKeyParameters;
import com.koalii.kgsp.bc.crypto.signers.RSADigestSigner;
import com.koalii.kgsp.core.cert.KcCertStore;
import com.koalii.kgsp.core.cert.KcKeyStore;
import com.koalii.kgsp.core.crypto.KcAsymmetricKeyPair;
import com.koalii.kgsp.core.crypto.KcDigestUtil;
import com.koalii.kgsp.core.crypto.KcSigner;
import com.koalii.kgsp.core.exception.KcException;

public class KcRSASigner
extends KcSigner {
    private static String DEFAULT_DIGEST_ALG = "SHA256";

    public KcRSASigner() {
        this.setDigestAlg(DEFAULT_DIGEST_ALG);
    }

    public KcRSASigner(KcAsymmetricKeyPair keyPair) {
        super(keyPair);
        this.setDigestAlg(DEFAULT_DIGEST_ALG);
    }

    public KcRSASigner(AsymmetricKeyParameter publicKey, AsymmetricKeyParameter privateKey) {
        super(publicKey, privateKey);
        this.setDigestAlg(DEFAULT_DIGEST_ALG);
    }

    public KcRSASigner(KcKeyStore store) {
        super(store);
        this.setDigestAlg(DEFAULT_DIGEST_ALG);
    }

    public KcRSASigner(KcCertStore store) {
        super(store);
        this.setDigestAlg(DEFAULT_DIGEST_ALG);
    }

    @Override
    public byte[] sign(byte[] oriData) throws KcException {
        if (null == this.signerPrivateKey) {
            throw new KcException(100120, "rsa sign: private key empty");
        }
        if (!(this.signerPrivateKey instanceof RSAPrivateCrtKeyParameters)) {
            throw new KcException(100121, "rsa sign: private key alg error");
        }
        Digest digest = KcDigestUtil.findDigest(this.getDigestAlg());
        RSADigestSigner signer = new RSADigestSigner(digest);
        signer.init(true, this.signerPrivateKey);
        signer.update(oriData, 0, oriData.length);
        try {
            return signer.generateSignature();
        }
        catch (Exception e) {
            throw new KcException(100142, "rsa sign failed", e);
        }
    }

    @Override
    public boolean verify(byte[] oriData, byte[] signData) throws KcException {
        if (null == this.signerPublicKey) {
            throw new KcException(100125, "rsa verify: public key empty");
        }
        if (!(this.signerPublicKey instanceof RSAKeyParameters)) {
            throw new KcException(100126, "rsa verify: public key alg error");
        }
        Digest digest = KcDigestUtil.findDigest(this.getDigestAlg());
        RSADigestSigner signer = new RSADigestSigner(digest);
        signer.init(false, this.signerPublicKey);
        signer.update(oriData, 0, oriData.length);
        return signer.verifySignature(signData);
    }

    @Override
    public String getSignAlg() {
        return this.getDigestAlg() + "WithRSAEncryption";
    }

    @Override
    public AlgorithmIdentifier getEncryptAlgId() {
        return new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption);
    }

    @Override
    public String getEncryptAlg() {
        return "RSA";
    }
}

