/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.crypto;

import com.koalii.kgsp.bc.crypto.AsymmetricBlockCipher;
import com.koalii.kgsp.bc.crypto.AsymmetricCipherKeyPair;
import com.koalii.kgsp.bc.crypto.encodings.PKCS1Encoding;
import com.koalii.kgsp.bc.crypto.engines.RSAEngine;
import com.koalii.kgsp.bc.crypto.generators.RSAKeyPairGenerator;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.RSAKeyGenerationParameters;
import com.koalii.kgsp.bc.crypto.params.RSAKeyParameters;
import com.koalii.kgsp.bc.crypto.params.RSAPrivateCrtKeyParameters;
import com.koalii.kgsp.bc.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import com.koalii.kgsp.bc.util.encoders.Hex;
import com.koalii.kgsp.core.cert.KcRSACertStore;
import com.koalii.kgsp.core.cert.KcRSAKeyStore;
import com.koalii.kgsp.core.crypto.KcAsymmetricKeyPair;
import com.koalii.kgsp.core.crypto.KcDigestUtil;
import com.koalii.kgsp.core.exception.KcException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class KcRSA
implements KcAsymmetricKeyPair {
    public static final int RSA_PADDING_PKCS1 = 0;
    public static final int RSA_PADDING_NONE = 1;
    public static final int DEFAULT_KEY_SIZE = 2048;
    private static final BigInteger defaultPublicExponent = BigInteger.valueOf(65537L);
    private RSAKeyParameters publicKey;
    private RSAPrivateCrtKeyParameters privateKey;
    private AsymmetricCipherKeyPair keyPair;
    private int paddingMode = 0;

    public KcRSA() {
    }

    public KcRSA(KcRSACertStore store) {
        this.publicKey = (RSAKeyParameters)store.getPublicKey();
    }

    public KcRSA(KcRSAKeyStore store) {
        this.publicKey = (RSAKeyParameters)store.getPublicKey();
        this.privateKey = (RSAPrivateCrtKeyParameters)store.getPrivateKey();
    }

    @Override
    public KcAsymmetricKeyPair generateKeyPair(int keySize) {
        RSAKeyPairGenerator gentor = new RSAKeyPairGenerator();
        RSAKeyGenerationParameters param = new RSAKeyGenerationParameters(defaultPublicExponent, new SecureRandom(), keySize, PrimeCertaintyCalculator.getDefaultCertainty(keySize));
        gentor.init(param);
        this.keyPair = gentor.generateKeyPair();
        this.publicKey = (RSAKeyParameters)this.keyPair.getPublic();
        this.privateKey = (RSAPrivateCrtKeyParameters)this.keyPair.getPrivate();
        return this;
    }

    @Override
    public KcAsymmetricKeyPair generateKeyPair() {
        return this.generateKeyPair(2048);
    }

    @Override
    public String getKeyAlg() {
        return "RSA";
    }

    @Override
    public boolean isKeyEmpty() {
        return null == this.publicKey || null == this.privateKey;
    }

    @Override
    public AsymmetricKeyParameter getPublicKey() {
        return this.publicKey;
    }

    @Override
    public AsymmetricKeyParameter getPrivateKey() {
        return this.privateKey;
    }

    public void setPaddingMode(int mode) {
        if (mode == 0 || mode == 1) {
            this.paddingMode = mode;
        }
    }

    public int getPaddingMode() {
        return this.paddingMode;
    }

    protected AsymmetricBlockCipher createEngine() {
        switch (this.paddingMode) {
            case 0: {
                return new PKCS1Encoding(new RSAEngine());
            }
            case 1: {
                return new RSAEngine();
            }
        }
        return new PKCS1Encoding(new RSAEngine());
    }

    public byte[] encryptByPubKey(byte[] data) throws KcException {
        if (null == this.publicKey) {
            throw new KcException(100125, "rsa encrypt by public key: key empty");
        }
        AsymmetricBlockCipher rsaEngine = this.createEngine();
        rsaEngine.init(true, this.publicKey);
        try {
            return rsaEngine.processBlock(data, 0, data.length);
        }
        catch (Exception e) {
            throw new KcException(100140, (Throwable)e);
        }
    }

    public byte[] encryptByPrivKey(byte[] data) throws KcException {
        if (null == this.privateKey) {
            throw new KcException(100120, "rsa encrypt by private key: key empty");
        }
        AsymmetricBlockCipher rsaEngine = this.createEngine();
        rsaEngine.init(true, this.privateKey);
        try {
            return rsaEngine.processBlock(data, 0, data.length);
        }
        catch (Exception e) {
            throw new KcException(100140, "rsa encrypt by private key failed", e);
        }
    }

    public byte[] decryptByPubKey(byte[] data) throws KcException {
        if (null == this.publicKey) {
            throw new KcException(100125, "rsa decrypt by public key: key empty");
        }
        AsymmetricBlockCipher rsaEngine = this.createEngine();
        rsaEngine.init(false, this.publicKey);
        try {
            return rsaEngine.processBlock(data, 0, data.length);
        }
        catch (Exception e) {
            throw new KcException(100141, "rsa decrypt by public key failed", e);
        }
    }

    public byte[] decryptByPrivKey(byte[] data) throws KcException {
        if (null == this.privateKey) {
            throw new KcException(100125, "rsa decrypt by private key: key empty");
        }
        AsymmetricBlockCipher rsaEngine = this.createEngine();
        rsaEngine.init(false, this.privateKey);
        try {
            return rsaEngine.processBlock(data, 0, data.length);
        }
        catch (Exception e) {
            throw new KcException(100141, "rsa decrypt by private key faied", e);
        }
    }

    public static void main(String[] args) throws Exception {
        String s = "Hello,world!";
        byte[] oriData = KcDigestUtil.sha1(s.getBytes());
        System.out.println(Hex.toHexString(oriData));
        KcRSA rsa = new KcRSA();
        rsa.generateKeyPair(2048);
        byte[] secData = rsa.encryptByPubKey(oriData);
        System.out.println("RSA public key encrypt:" + secData.length);
        System.out.println(Hex.toHexString(secData));
        oriData = rsa.decryptByPrivKey(secData);
        System.out.println("RSA private key decrypt:" + oriData.length);
        System.out.println(Hex.toHexString(oriData));
        secData = rsa.encryptByPrivKey(oriData);
        System.out.println("RSA private key encrypt:" + secData.length);
        System.out.println(Hex.toHexString(secData));
        oriData = rsa.decryptByPubKey(secData);
        System.out.println("RSA pub key decrypt:" + secData.length);
        System.out.println(Hex.toHexString(oriData));
    }
}

