/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cms;

import com.koalii.kgsp.bc.asn1.ASN1OctetString;
import com.koalii.kgsp.bc.asn1.DERNull;
import com.koalii.kgsp.bc.asn1.gm.GMObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.kgsp.bc.asn1.x9.X9ECPoint;
import com.koalii.kgsp.bc.asn1.x9.X9ObjectIdentifiers;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.CryptoException;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.ECPublicKeyParameters;
import com.koalii.kgsp.bc.crypto.signers.SM2Signer;
import com.koalii.kgsp.bc.operator.ContentSigner;
import com.koalii.kgsp.bc.operator.RuntimeOperatorException;
import com.koalii.kgsp.bc.operator.bc.BcSignerOutputStream;
import com.koalii.kgsp.bc.util.encoders.Hex;
import com.koalii.kgsp.core.cms.CertIssue;
import com.koalii.kgsp.core.crypto.KcSM2;
import com.koalii.kgsp.core.exception.KcException;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class SM2CertIssue
extends CertIssue {
    private AlgorithmIdentifier signAid = new AlgorithmIdentifier(GMObjectIdentifiers.sm2sign_with_sm3, DERNull.INSTANCE);

    @Override
    protected SubjectPublicKeyInfo generateSubjectPublicKeyInfo(AsymmetricKeyParameter publicKey) throws KcException {
        if (!(publicKey instanceof ECPublicKeyParameters)) {
            throw new KcException(100126, "issuer sm2 cert: create subject public key info");
        }
        ECPublicKeyParameters ecPublicKey = (ECPublicKeyParameters)publicKey;
        AlgorithmIdentifier aid = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, GMObjectIdentifiers.sm2p256v1);
        ASN1OctetString p = (ASN1OctetString)new X9ECPoint(ecPublicKey.getQ()).toASN1Primitive();
        return new SubjectPublicKeyInfo(aid, p.getOctets());
    }

    @Override
    protected ContentSigner buildSigner() throws KcException {
        final SM2Signer signer = new SM2Signer();
        signer.init(true, this.issuerPrivateKey);
        return new ContentSigner(){
            private BcSignerOutputStream stream;
            {
                this.stream = new BcSignerOutputStream(signer);
            }

            @Override
            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return SM2CertIssue.this.signAid;
            }

            @Override
            public OutputStream getOutputStream() {
                return this.stream;
            }

            @Override
            public byte[] getSignature() {
                try {
                    return this.stream.getSignature();
                }
                catch (CryptoException e) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), e);
                }
            }
        };
    }

    public static void main(String[] args) throws Exception {
        KcSM2 sm2 = new KcSM2();
        sm2.generateKeyPair();
        SM2CertIssue issuer = new SM2CertIssue();
        issuer.setCertDn("CN=Test, C=CN");
        issuer.setIssuerKeyPair(sm2);
        X509CertificateHolder certHolder = issuer.issueSelfSignedCert();
        System.out.println(Hex.toHexString(certHolder.getEncoded()));
        FileOutputStream fout = new FileOutputStream("rootca.cer");
        fout.write(certHolder.getEncoded());
        fout.close();
        KcSM2 sm2User = new KcSM2();
        sm2User.generateKeyPair();
        issuer.resetForIssueCert();
        issuer.setCertDn("CN=liqy, C=CN");
        issuer.setCertPublicKey(sm2User.getPublicKey());
        certHolder = issuer.issueSignCert();
        System.out.println(Hex.toHexString(certHolder.getEncoded()));
        fout = new FileOutputStream("user.cer");
        fout.write(certHolder.getEncoded());
        fout.close();
    }
}

