/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cert;

import com.koalii.kgsp.bc.asn1.gm.GMNamedCurves;
import com.koalii.kgsp.bc.asn1.gm.GMObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.kgsp.bc.asn1.x509.TBSCertificate;
import com.koalii.kgsp.bc.asn1.x9.X9ECParameters;
import com.koalii.kgsp.bc.asn1.x9.X9ECPoint;
import com.koalii.kgsp.bc.asn1.x9.X9ObjectIdentifiers;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.params.AsymmetricKeyParameter;
import com.koalii.kgsp.bc.crypto.params.ECDomainParameters;
import com.koalii.kgsp.bc.crypto.params.ECPublicKeyParameters;
import com.koalii.kgsp.bc.math.ec.ECPoint;
import com.koalii.kgsp.core.cert.KcCertStoreImpl;
import com.koalii.kgsp.core.crypto.KcSM2Signer;
import com.koalii.kgsp.core.exception.KcException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class KcSM2CertStore
extends KcCertStoreImpl {
    protected static final String keyAlgName = "SM2";

    public KcSM2CertStore() {
    }

    public KcSM2CertStore(X509CertificateHolder cert) throws KcException {
        this.setCert(cert);
    }

    @Override
    public void setCert(X509CertificateHolder cert) throws KcException {
        this.cert = cert;
        this.publicKey = KcSM2CertStore.parseEcPublicKey(cert);
    }

    @Override
    public X509Certificate getJcaCert() throws KcException {
        throw new KcException(100144, "sm2 cert to jca cert failed: unsupported");
    }

    @Override
    public PublicKey getJcaPublicKey() throws KcException {
        throw new KcException(100149, "sm2 public key to jca failed: unsupported");
    }

    @Override
    public AsymmetricKeyParameter getPublicKey() {
        return this.publicKey;
    }

    @Override
    public String getKeyAlgName() {
        return keyAlgName;
    }

    @Override
    public int getKeyBitLength() throws KcException {
        return 256;
    }

    @Override
    public boolean isIssuerOf(X509CertificateHolder child) {
        try {
            TBSCertificate tbsCert = child.toASN1Structure().getTBSCertificate();
            KcSM2CertStore kcSm2CertStore = new KcSM2CertStore(this.getCert());
            KcSM2Signer kcSm2Signer = new KcSM2Signer(kcSm2CertStore);
            return kcSm2Signer.verify(tbsCert.getEncoded(), child.getSignature());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isSM2Cert(X509CertificateHolder cert) {
        AlgorithmIdentifier algId = cert.getSubjectPublicKeyInfo().getAlgorithm();
        return KcSM2CertStore.isSM2Aid(algId);
    }

    public static boolean isSM2Aid(AlgorithmIdentifier algId) {
        return false != algId.getAlgorithm().equals(X9ObjectIdentifiers.id_ecPublicKey);
    }

    public static ECPublicKeyParameters parseEcPublicKey(X509CertificateHolder cert) throws KcException {
        if (!KcSM2CertStore.isSM2Cert(cert)) {
            throw new KcException(100116);
        }
        SubjectPublicKeyInfo keyInfo = cert.getSubjectPublicKeyInfo();
        byte[] pubKeyData = keyInfo.getPublicKeyData().getBytes();
        X9ECParameters gmParams = GMNamedCurves.getByOID(GMObjectIdentifiers.sm2p256v1);
        ECDomainParameters gmDomainParams = new ECDomainParameters(gmParams.getCurve(), gmParams.getG(), gmParams.getN(), gmParams.getH(), gmParams.getSeed());
        X9ECPoint x9Point = new X9ECPoint(gmParams.getCurve(), pubKeyData);
        ECPoint pubKeyPoint = x9Point.getPoint();
        ECPublicKeyParameters pubKeyParams = new ECPublicKeyParameters(pubKeyPoint, gmDomainParams);
        return pubKeyParams;
    }
}

