/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cert;

import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.pkcs.RSAPublicKey;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.asn1.x509.SubjectPublicKeyInfo;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.params.RSAKeyParameters;
import com.koalii.kgsp.bc.jcajce.provider.asymmetric.rsa.KeyFactorySpi;
import com.koalii.kgsp.bc.jcajce.provider.asymmetric.rsa.RSAUtil;
import com.koalii.kgsp.bc.operator.ContentVerifierProvider;
import com.koalii.kgsp.bc.operator.DefaultDigestAlgorithmIdentifierFinder;
import com.koalii.kgsp.bc.operator.bc.BcRSAContentVerifierProviderBuilder;
import com.koalii.kgsp.core.cert.KcCertStoreImpl;
import com.koalii.kgsp.core.exception.KcException;
import java.security.PublicKey;

public class KcRSACertStore
extends KcCertStoreImpl {
    public static final String keyAlgName = "RSA";

    public KcRSACertStore() {
    }

    public KcRSACertStore(X509CertificateHolder cert) throws KcException {
        this.setCert(cert);
    }

    @Override
    public void setCert(X509CertificateHolder cert) throws KcException {
        this.cert = cert;
        this.publicKey = KcRSACertStore.parseRsaPublicKey(cert);
    }

    @Override
    public PublicKey getJcaPublicKey() throws KcException {
        try {
            SubjectPublicKeyInfo keyInfo = this.cert.getSubjectPublicKeyInfo();
            KeyFactorySpi rsaKeyFactory = new KeyFactorySpi();
            return rsaKeyFactory.generatePublic(keyInfo);
        }
        catch (Exception e) {
            throw new KcException(100127, (Throwable)e);
        }
    }

    @Override
    public boolean isIssuerOf(X509CertificateHolder child) {
        try {
            DefaultDigestAlgorithmIdentifierFinder digestAlgFinder = new DefaultDigestAlgorithmIdentifierFinder();
            ContentVerifierProvider contentVerifierProvider = new BcRSAContentVerifierProviderBuilder(digestAlgFinder).build(this.getCert());
            return child.isSignatureValid(contentVerifierProvider);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public String getKeyAlgName() {
        return keyAlgName;
    }

    @Override
    public int getKeyBitLength() throws KcException {
        if (null == this.publicKey) {
            throw new KcException(100125);
        }
        RSAKeyParameters keyParams = (RSAKeyParameters)this.publicKey;
        return keyParams.getModulus().bitLength();
    }

    public static boolean isRsaCert(X509CertificateHolder cert) {
        return KcRSACertStore.isRsaKey(cert.getSubjectPublicKeyInfo());
    }

    public static boolean isRsaKey(SubjectPublicKeyInfo pubKeyInfo) {
        AlgorithmIdentifier algId = pubKeyInfo.getAlgorithm();
        ASN1ObjectIdentifier aid = algId.getAlgorithm();
        return RSAUtil.isRsaOid(aid);
    }

    public static RSAKeyParameters parseRsaPublicKey(X509CertificateHolder cert) throws KcException {
        if (!KcRSACertStore.isRsaCert(cert)) {
            throw new KcException(100116);
        }
        return KcRSACertStore.parseRsaPublicKey(cert.getSubjectPublicKeyInfo());
    }

    public static RSAKeyParameters parseRsaPublicKey(SubjectPublicKeyInfo pubKeyInfo) throws KcException {
        if (!KcRSACertStore.isRsaKey(pubKeyInfo)) {
            throw new KcException(100121, "parse rsa private key failed");
        }
        try {
            RSAPublicKey pubKey = RSAPublicKey.getInstance(pubKeyInfo.parsePublicKey());
            return new RSAKeyParameters(false, pubKey.getModulus(), pubKey.getPublicExponent());
        }
        catch (Exception e) {
            throw new KcException(100127, (Throwable)e);
        }
    }
}

