/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cert;

import com.koalii.kgsp.bc.asn1.ASN1InputStream;
import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.ASN1OctetString;
import com.koalii.kgsp.bc.asn1.ASN1Primitive;
import com.koalii.kgsp.bc.asn1.ASN1Sequence;
import com.koalii.kgsp.bc.asn1.ASN1Set;
import com.koalii.kgsp.bc.asn1.DERBMPString;
import com.koalii.kgsp.bc.asn1.pkcs.AuthenticatedSafe;
import com.koalii.kgsp.bc.asn1.pkcs.CertBag;
import com.koalii.kgsp.bc.asn1.pkcs.ContentInfo;
import com.koalii.kgsp.bc.asn1.pkcs.EncryptedData;
import com.koalii.kgsp.bc.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.koalii.kgsp.bc.asn1.pkcs.MacData;
import com.koalii.kgsp.bc.asn1.pkcs.PKCS12PBEParams;
import com.koalii.kgsp.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.pkcs.Pfx;
import com.koalii.kgsp.bc.asn1.pkcs.PrivateKeyInfo;
import com.koalii.kgsp.bc.asn1.pkcs.SafeBag;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.asn1.x509.BasicConstraints;
import com.koalii.kgsp.bc.asn1.x509.Extension;
import com.koalii.kgsp.bc.asn1.x509.X509ObjectIdentifiers;
import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.bc.crypto.CipherParameters;
import com.koalii.kgsp.bc.crypto.Digest;
import com.koalii.kgsp.bc.crypto.ExtendedDigest;
import com.koalii.kgsp.bc.crypto.PBEParametersGenerator;
import com.koalii.kgsp.bc.crypto.engines.DESedeEngine;
import com.koalii.kgsp.bc.crypto.engines.RC2Engine;
import com.koalii.kgsp.bc.crypto.generators.PKCS12ParametersGenerator;
import com.koalii.kgsp.bc.crypto.macs.HMac;
import com.koalii.kgsp.bc.crypto.params.KeyParameter;
import com.koalii.kgsp.bc.crypto.util.DigestFactory;
import com.koalii.kgsp.bc.operator.bc.BcDefaultDigestProvider;
import com.koalii.kgsp.bc.util.Arrays;
import com.koalii.kgsp.bc.util.Strings;
import com.koalii.kgsp.bc.util.encoders.Hex;
import com.koalii.kgsp.core.cert.KcRSAKeyStore;
import com.koalii.kgsp.core.crypto.KcBlockCipher;
import com.koalii.kgsp.core.crypto.KcRC2;
import com.koalii.kgsp.core.crypto.KcTripleDES;
import com.koalii.kgsp.core.exception.KcException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class KcPKCS12Store
extends KcRSAKeyStore
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private String privateKeyAlias;
    private ArrayList<X509CertificateHolder> certChain = new ArrayList();

    public KcPKCS12Store(byte[] derPfxData, byte[] pass) throws KcException {
        this.load(derPfxData, pass);
    }

    public KcPKCS12Store(byte[] derPfxData, char[] pass) throws KcException {
        this.load(derPfxData, pass);
    }

    public void load(byte[] derPfxData, byte[] pass) throws KcException {
        if (pass == null || pass.length == 0) {
            throw new KcException(100170);
        }
        this.load(derPfxData, Strings.asCharArray(pass));
    }

    public void load(byte[] derPfxData, char[] password) throws KcException {
        Pfx pfx = Pfx.getInstance(derPfxData);
        boolean result = this.isMacValid(pfx, password);
        if (!result) {
            throw new KcException(100172);
        }
        ContentInfo info = pfx.getAuthSafe();
        if (info.getContentType().equals(data)) {
            AuthenticatedSafe authSafe = AuthenticatedSafe.getInstance(((ASN1OctetString)info.getContent()).getOctets());
            this.loadWithPassword(authSafe, password);
        }
    }

    public String getPrivateKeyAlias() {
        return this.privateKeyAlias;
    }

    protected byte[] generateMac(ExtendedDigest digest, PKCS12PBEParams pbeParams, char[] password, byte[] content) {
        PKCS12ParametersGenerator pGen = new PKCS12ParametersGenerator(digest);
        pGen.init(PKCS12ParametersGenerator.PKCS12PasswordToBytes(password), pbeParams.getIV(), pbeParams.getIterations().intValue());
        KeyParameter keyParam = (KeyParameter)pGen.generateDerivedMacParameters(digest.getDigestSize() * 8);
        HMac hMac = new HMac(digest);
        hMac.init(keyParam);
        hMac.update(content, 0, content.length);
        byte[] res = new byte[hMac.getMacSize()];
        hMac.doFinal(res, 0);
        return res;
    }

    protected boolean isMacValid(Pfx pfx, char[] password) throws KcException {
        if (pfx.getMacData() != null) {
            try {
                MacData pfxmData = pfx.getMacData();
                AlgorithmIdentifier macAlgId = new AlgorithmIdentifier(pfxmData.getMac().getAlgorithmId().getAlgorithm(), new PKCS12PBEParams(pfxmData.getSalt(), pfxmData.getIterationCount().intValue()));
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(macAlgId.getParameters());
                ExtendedDigest digest = BcDefaultDigestProvider.INSTANCE.get(pfxmData.getMac().getAlgorithmId());
                byte[] content = ASN1OctetString.getInstance(pfx.getAuthSafe().getContent()).getOctets();
                byte[] mac = this.generateMac(digest, pbeParams, password, content);
                return Arrays.constantTimeAreEqual(mac, pfx.getMacData().getMac().getDigest());
            }
            catch (Exception e) {
                throw new KcException(100172, (Throwable)e);
            }
        }
        return true;
    }

    protected KcBlockCipher getPbeCipher(ASN1ObjectIdentifier algorithm) throws KcException {
        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC) || algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            return new KcTripleDES("CBC");
        }
        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC) || algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC)) {
            return new KcRC2("CBC");
        }
        throw new KcException(100173, algorithm.getId());
    }

    protected Digest getPbeDigest(ASN1ObjectIdentifier algorithm) throws KcException {
        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC) || algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC) || algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC) || algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC)) {
            return DigestFactory.createSHA1();
        }
        throw new KcException(100173, algorithm.getId());
    }

    protected int getPbeIVSize(ASN1ObjectIdentifier algorithm) {
        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC) || algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            return new DESedeEngine().getBlockSize() * 8;
        }
        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC) || algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC)) {
            return new RC2Engine().getBlockSize() * 8;
        }
        return 0;
    }

    protected int getPbeKeySize(ASN1ObjectIdentifier algorithm) throws KcException {
        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd3_KeyTripleDES_CBC)) {
            return 192;
        }
        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd2_KeyTripleDES_CBC)) {
            return 128;
        }
        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC)) {
            return 128;
        }
        if (algorithm.equals(PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC)) {
            return 40;
        }
        throw new KcException(100173, algorithm.getId());
    }

    protected byte[] unwrapPbeData(AlgorithmIdentifier algId, byte[] secData, char[] password) throws KcException {
        ASN1ObjectIdentifier algorithm = algId.getAlgorithm();
        if (algorithm.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
            PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algId.getParameters());
            int keySize = this.getPbeKeySize(algorithm);
            int ivSize = this.getPbeIVSize(algorithm);
            Digest digest = this.getPbeDigest(algorithm);
            PKCS12ParametersGenerator paramsGentor = new PKCS12ParametersGenerator(digest);
            paramsGentor.init(PBEParametersGenerator.PKCS12PasswordToBytes(password), pbeParams.getIV(), pbeParams.getIterations().intValue());
            CipherParameters params = ivSize > 0 ? paramsGentor.generateDerivedParameters(keySize, ivSize) : paramsGentor.generateDerivedParameters(keySize);
            KcBlockCipher cipher = this.getPbeCipher(algorithm);
            return cipher.decrypt(secData, params);
        }
        throw new KcException(100174, algorithm.toString());
    }

    protected void unwrapPrivateKey(AlgorithmIdentifier algId, byte[] secData, char[] password) throws KcException {
        this.privateKey = null;
        byte[] keyData = this.unwrapPbeData(algId, secData, password);
        ASN1InputStream bIn = new ASN1InputStream(keyData);
        try {
            PrivateKeyInfo keyInfo = PrivateKeyInfo.getInstance(bIn.readObject());
            bIn.close();
            if (KcRSAKeyStore.isRsaKey(keyInfo)) {
                this.privateKey = KcRSAKeyStore.parseRsaPrivateKey(keyInfo);
            }
        }
        catch (Exception e) {
            throw new KcException(100175, (Throwable)e);
        }
        if (null == this.privateKey) {
            throw new KcException(100175, "no private key");
        }
    }

    protected void unwrapCertData(AlgorithmIdentifier algId, byte[] secData, char[] password) throws KcException {
        this.certChain.clear();
        this.cert = null;
        byte[] oriData = this.unwrapPbeData(algId, secData, password);
        try {
            ASN1Sequence seq = (ASN1Sequence)ASN1Primitive.fromByteArray(oriData);
            for (int j = 0; j != seq.size(); ++j) {
                SafeBag b = SafeBag.getInstance(seq.getObjectAt(j));
                if (!b.getBagId().equals(certBag)) continue;
                CertBag cbag = CertBag.getInstance(b.getBagValue());
                ASN1OctetString certData = (ASN1OctetString)cbag.getCertValue();
                this.certChain.add(new X509CertificateHolder(certData.getOctets()));
            }
        }
        catch (Exception e) {
            throw new KcException(100176, (Throwable)e);
        }
        if (1 == this.certChain.size()) {
            this.cert = this.certChain.get(0);
        } else if (this.certChain.size() > 0) {
            for (int i = 0; i < this.certChain.size(); ++i) {
                X509CertificateHolder cert = this.certChain.get(i);
                List oids = cert.getExtensionOIDs();
                if (oids.contains(Extension.basicConstraints)) {
                    Extension ext = cert.getExtension(Extension.basicConstraints);
                    BasicConstraints basic = BasicConstraints.getInstance(ext.getExtnValue().getOctets());
                    if (basic.isCA()) continue;
                    this.cert = cert;
                    break;
                }
                this.cert = cert;
                break;
            }
        }
        if (null == this.cert) {
            throw new KcException(100176, "no cert");
        }
        this.certChain.remove(this.cert);
    }

    protected void parseBagAttrs(ASN1Set bagAttributes) throws KcException {
        String alias = null;
        ASN1OctetString localId = null;
        Enumeration e = bagAttributes.getObjects();
        while (e.hasMoreElements()) {
            ASN1Sequence sq = ASN1Sequence.getInstance(e.nextElement());
            ASN1ObjectIdentifier aOid = ASN1ObjectIdentifier.getInstance(sq.getObjectAt(0));
            ASN1Set attrSet = ASN1Set.getInstance(sq.getObjectAt(1));
            ASN1Primitive attr = null;
            if (attrSet.size() <= 0) continue;
            attr = (ASN1Primitive)attrSet.getObjectAt(0);
            if (aOid.equals(pkcs_9_at_friendlyName)) {
                alias = ((DERBMPString)attr).getString();
                continue;
            }
            if (!aOid.equals(pkcs_9_at_localKeyId)) continue;
            localId = (ASN1OctetString)attr;
        }
        String name = new String(Hex.encode(localId.getOctets()));
        this.privateKeyAlias = alias == null ? name : alias;
    }

    protected void loadWithPassword(AuthenticatedSafe authSafe, char[] password) throws KcException {
        ContentInfo[] c = authSafe.getContentInfo();
        for (int i = 0; i != c.length; ++i) {
            if (c[i].getContentType().equals(data)) {
                ASN1Sequence seq = ASN1Sequence.getInstance(((ASN1OctetString)c[i].getContent()).getOctets());
                for (int j = 0; j != seq.size(); ++j) {
                    SafeBag b = SafeBag.getInstance(seq.getObjectAt(j));
                    if (!b.getBagId().equals(pkcs8ShroudedKeyBag)) continue;
                    EncryptedPrivateKeyInfo eIn = EncryptedPrivateKeyInfo.getInstance(b.getBagValue());
                    this.unwrapPrivateKey(eIn.getEncryptionAlgorithm(), eIn.getEncryptedData(), password);
                    if (null == b.getBagAttributes()) continue;
                    this.parseBagAttrs(b.getBagAttributes());
                }
                continue;
            }
            if (!c[i].getContentType().equals(encryptedData)) continue;
            EncryptedData d = EncryptedData.getInstance(c[i].getContent());
            this.unwrapCertData(d.getEncryptionAlgorithm(), d.getContent().getOctets(), password);
        }
    }
}

