/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cert;

import com.koalii.kgsp.bc.cert.X509CertificateHolder;
import com.koalii.kgsp.core.cert.KcCertStoreImpl;
import com.koalii.kgsp.core.cert.KcKeyStore;
import com.koalii.kgsp.core.cert.KcPKCS12Store;
import com.koalii.kgsp.core.cert.KcRSACertStore;
import com.koalii.kgsp.core.cert.KcRSAKeyStore;
import com.koalii.kgsp.core.cert.KcSDFKeyStore;
import com.koalii.kgsp.core.cert.KcSM2CertStore;
import com.koalii.kgsp.core.cert.KcSM2KeyStore;
import com.koalii.kgsp.core.exception.KcException;
import com.koalii.kgsp.core.util.X509CertUtil;
import java.io.FileInputStream;

public class KcKeyStoreFactory {
    public static KcKeyStore createKeyStoreByFile(String certFilename, String pemKeyFilename, char[] password) throws KcException {
        try {
            FileInputStream fin = new FileInputStream(certFilename);
            int ndata = fin.available();
            byte[] certData = new byte[ndata];
            fin.read(certData);
            fin.close();
            fin = new FileInputStream(pemKeyFilename);
            ndata = fin.available();
            byte[] keyData = new byte[ndata];
            fin.read(keyData);
            fin.close();
            return KcKeyStoreFactory.createKeyStore(certData, keyData, password);
        }
        catch (Exception e) {
            throw new KcException(100003, (Throwable)e);
        }
    }

    public static KcKeyStore createKeyStore(byte[] certData, byte[] keyData, char[] password) throws KcException {
        X509CertificateHolder cert = null;
        cert = X509CertUtil.parseCertData(certData);
        return KcKeyStoreFactory.createKeyStore(cert, keyData, password);
    }

    public static KcKeyStore createKeyStoreByPfx(String pfxFilename, char[] password) throws KcException {
        try {
            FileInputStream fin = new FileInputStream(pfxFilename);
            int ndata = fin.available();
            byte[] pfxData = new byte[ndata];
            fin.read(pfxData);
            fin.close();
            return KcKeyStoreFactory.createKeyStoreByPfx(pfxData, password);
        }
        catch (Exception e) {
            throw new KcException(100003, (Throwable)e);
        }
    }

    public static KcKeyStore createKeyStoreByPfx(byte[] derPfxData, char[] password) throws KcException {
        return new KcPKCS12Store(derPfxData, password);
    }

    public static KcKeyStore createKeyStore(X509CertificateHolder cert, byte[] keyData, char[] password) throws KcException {
        KcCertStoreImpl keyStore = null;
        if (KcSDFKeyStore.isSdfKey(keyData)) {
            keyStore = new KcSDFKeyStore();
        } else if (KcRSACertStore.isRsaCert(cert)) {
            keyStore = new KcRSAKeyStore();
        } else if (KcSM2CertStore.isSM2Cert(cert)) {
            keyStore = new KcSM2KeyStore();
        } else {
            throw new KcException(100116);
        }
        keyStore.setCert(cert);
        keyStore.loadKeyData(keyData, password);
        if (!keyStore.isKeyMatched()) {
            throw new KcException(100131);
        }
        return keyStore;
    }

    public static void main(String[] args) {
    }
}

