/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.core.cert;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;

public class JcaJcePfxStore {
    protected X509Certificate signCert;
    protected PrivateKey privKey;

    public JcaJcePfxStore() {
    }

    public JcaJcePfxStore(String pfxFileName, String passwd) {
        this.setCertAndKey(pfxFileName, passwd);
    }

    public void setCert(X509Certificate cert) {
        this.signCert = cert;
    }

    public void setKey(PrivateKey pkey) {
        this.privKey = pkey;
    }

    public X509Certificate getCert() {
        return this.signCert;
    }

    public PrivateKey getPrivKey() {
        return this.privKey;
    }

    public String getAlgorithm() {
        if (null != this.privKey) {
            return this.privKey.getAlgorithm();
        }
        return "";
    }

    public void setCertAndKey(String pfxFileName, String passwd) {
        boolean bRet;
        String alias;
        KeyStore ks;
        if (null == passwd || passwd.length() <= 0) {
            throw new IllegalArgumentException("Password cannot be empty");
        }
        try {
            ks = KeyStore.getInstance("PKCS12");
            FileInputStream fin = new FileInputStream(pfxFileName);
            ks.load(fin, passwd.toCharArray());
            Enumeration<String> en = ks.aliases();
            alias = en.nextElement();
            bRet = ks.isKeyEntry(alias);
        }
        catch (Exception exp) {
            System.out.println("load pfx file " + pfxFileName + " - " + exp);
            return;
        }
        if (!bRet) {
            System.out.println("No key is found in pfx file");
            return;
        }
        try {
            this.privKey = (PrivateKey)ks.getKey(alias, passwd.toCharArray());
            this.signCert = (X509Certificate)ks.getCertificate(alias);
        }
        catch (Exception exp) {
            System.out.println(exp.toString());
            return;
        }
    }

    public void toPfxFile(String filename, String passwd) {
        try {
            Certificate[] certs = new Certificate[]{this.signCert};
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(null, null);
            ks.setKeyEntry("koalii", this.privKey, passwd.toCharArray(), certs);
            FileOutputStream fout = new FileOutputStream(filename);
            ks.store(fout, passwd.toCharArray());
            fout.close();
        }
        catch (Exception exp) {
            System.out.println("Save cert and key to pfx file - " + exp.toString());
        }
    }
}

