/*
 * Decompiled with CFR 0.152.
 */
package com.koalii.kgsp.bc.util;

import com.koalii.kgsp.bc.asn1.ASN1Null;
import com.koalii.kgsp.bc.asn1.ASN1ObjectIdentifier;
import com.koalii.kgsp.bc.asn1.ASN1OctetString;
import com.koalii.kgsp.bc.asn1.ASN1Primitive;
import com.koalii.kgsp.bc.asn1.kisa.KISAObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.misc.CAST5CBCParameters;
import com.koalii.kgsp.bc.asn1.misc.MiscObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.nist.NISTObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.ntt.NTTObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.oiw.OIWObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.pkcs.PKCSObjectIdentifiers;
import com.koalii.kgsp.bc.asn1.pkcs.RC2CBCParameter;
import com.koalii.kgsp.bc.asn1.x509.AlgorithmIdentifier;
import com.koalii.kgsp.bc.crypto.BufferedBlockCipher;
import com.koalii.kgsp.bc.crypto.CipherParameters;
import com.koalii.kgsp.bc.crypto.StreamCipher;
import com.koalii.kgsp.bc.crypto.engines.AESEngine;
import com.koalii.kgsp.bc.crypto.engines.CAST5Engine;
import com.koalii.kgsp.bc.crypto.engines.DESEngine;
import com.koalii.kgsp.bc.crypto.engines.DESedeEngine;
import com.koalii.kgsp.bc.crypto.engines.RC2Engine;
import com.koalii.kgsp.bc.crypto.engines.RC4Engine;
import com.koalii.kgsp.bc.crypto.io.CipherOutputStream;
import com.koalii.kgsp.bc.crypto.modes.AEADBlockCipher;
import com.koalii.kgsp.bc.crypto.modes.CBCBlockCipher;
import com.koalii.kgsp.bc.crypto.paddings.PKCS7Padding;
import com.koalii.kgsp.bc.crypto.paddings.PaddedBufferedBlockCipher;
import com.koalii.kgsp.bc.crypto.params.KeyParameter;
import com.koalii.kgsp.bc.crypto.params.ParametersWithIV;
import com.koalii.kgsp.bc.crypto.params.RC2Parameters;
import com.koalii.kgsp.bc.crypto.util.AlgorithmIdentifierFactory;
import java.io.OutputStream;

public class CipherFactory {
    private static final short[] rc2Ekb = new short[]{93, 190, 155, 139, 17, 153, 110, 77, 89, 243, 133, 166, 63, 183, 131, 197, 228, 115, 107, 58, 104, 90, 192, 71, 160, 100, 52, 12, 241, 208, 82, 165, 185, 30, 150, 67, 65, 216, 212, 44, 219, 248, 7, 119, 42, 202, 235, 239, 16, 28, 22, 13, 56, 114, 47, 137, 193, 249, 128, 196, 109, 174, 48, 61, 206, 32, 99, 254, 230, 26, 199, 184, 80, 232, 36, 23, 252, 37, 111, 187, 106, 163, 68, 83, 217, 162, 1, 171, 188, 182, 31, 152, 238, 154, 167, 45, 79, 158, 142, 172, 224, 198, 73, 70, 41, 244, 148, 138, 175, 225, 91, 195, 179, 123, 87, 209, 124, 156, 237, 135, 64, 140, 226, 203, 147, 20, 201, 97, 46, 229, 204, 246, 94, 168, 92, 214, 117, 141, 98, 149, 88, 105, 118, 161, 74, 181, 85, 9, 120, 51, 130, 215, 221, 121, 245, 27, 11, 222, 38, 33, 40, 116, 4, 151, 86, 223, 60, 240, 55, 57, 220, 255, 6, 164, 234, 66, 8, 218, 180, 113, 176, 207, 18, 122, 78, 250, 108, 29, 132, 0, 200, 127, 145, 69, 170, 43, 194, 177, 143, 213, 186, 242, 173, 25, 178, 103, 54, 247, 15, 10, 146, 125, 227, 157, 233, 144, 62, 35, 39, 102, 19, 236, 129, 21, 189, 34, 191, 159, 126, 169, 81, 75, 76, 251, 2, 211, 112, 134, 49, 231, 59, 5, 3, 84, 96, 72, 101, 24, 210, 205, 95, 50, 136, 14, 53, 253};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object createContentCipher(boolean forEncryption, CipherParameters encKey, AlgorithmIdentifier encryptionAlgID) throws IllegalArgumentException {
        ASN1ObjectIdentifier encAlg = encryptionAlgID.getAlgorithm();
        if (encAlg.equals(PKCSObjectIdentifiers.rc4)) {
            RC4Engine cipher = new RC4Engine();
            cipher.init(forEncryption, encKey);
            return cipher;
        }
        BufferedBlockCipher cipher = CipherFactory.createCipher(encryptionAlgID.getAlgorithm());
        ASN1Primitive sParams = encryptionAlgID.getParameters().toASN1Primitive();
        if (sParams != null && !(sParams instanceof ASN1Null)) {
            if (encAlg.equals(PKCSObjectIdentifiers.des_EDE3_CBC) || encAlg.equals(AlgorithmIdentifierFactory.IDEA_CBC) || encAlg.equals(NISTObjectIdentifiers.id_aes128_CBC) || encAlg.equals(NISTObjectIdentifiers.id_aes192_CBC) || encAlg.equals(NISTObjectIdentifiers.id_aes256_CBC) || encAlg.equals(NTTObjectIdentifiers.id_camellia128_cbc) || encAlg.equals(NTTObjectIdentifiers.id_camellia192_cbc) || encAlg.equals(NTTObjectIdentifiers.id_camellia256_cbc) || encAlg.equals(KISAObjectIdentifiers.id_seedCBC) || encAlg.equals(OIWObjectIdentifiers.desCBC)) {
                cipher.init(forEncryption, new ParametersWithIV(encKey, ASN1OctetString.getInstance(sParams).getOctets()));
                return cipher;
            } else if (encAlg.equals(AlgorithmIdentifierFactory.CAST5_CBC)) {
                CAST5CBCParameters cbcParams = CAST5CBCParameters.getInstance(sParams);
                cipher.init(forEncryption, new ParametersWithIV(encKey, cbcParams.getIV()));
                return cipher;
            } else {
                if (!encAlg.equals(PKCSObjectIdentifiers.RC2_CBC)) throw new IllegalArgumentException("cannot match parameters");
                RC2CBCParameter cbcParams = RC2CBCParameter.getInstance(sParams);
                cipher.init(forEncryption, new ParametersWithIV(new RC2Parameters(((KeyParameter)encKey).getKey(), rc2Ekb[cbcParams.getRC2ParameterVersion().intValue()]), cbcParams.getIV()));
            }
            return cipher;
        } else if (encAlg.equals(PKCSObjectIdentifiers.des_EDE3_CBC) || encAlg.equals(AlgorithmIdentifierFactory.IDEA_CBC) || encAlg.equals(AlgorithmIdentifierFactory.CAST5_CBC)) {
            cipher.init(forEncryption, new ParametersWithIV(encKey, new byte[8]));
            return cipher;
        } else {
            cipher.init(forEncryption, encKey);
        }
        return cipher;
    }

    private static BufferedBlockCipher createCipher(ASN1ObjectIdentifier algorithm) throws IllegalArgumentException {
        CBCBlockCipher cipher;
        if (NISTObjectIdentifiers.id_aes128_CBC.equals(algorithm) || NISTObjectIdentifiers.id_aes192_CBC.equals(algorithm) || NISTObjectIdentifiers.id_aes256_CBC.equals(algorithm)) {
            cipher = new CBCBlockCipher(new AESEngine());
        } else if (PKCSObjectIdentifiers.des_EDE3_CBC.equals(algorithm)) {
            cipher = new CBCBlockCipher(new DESedeEngine());
        } else if (OIWObjectIdentifiers.desCBC.equals(algorithm)) {
            cipher = new CBCBlockCipher(new DESEngine());
        } else if (PKCSObjectIdentifiers.RC2_CBC.equals(algorithm)) {
            cipher = new CBCBlockCipher(new RC2Engine());
        } else if (MiscObjectIdentifiers.cast5CBC.equals(algorithm)) {
            cipher = new CBCBlockCipher(new CAST5Engine());
        } else {
            throw new IllegalArgumentException("cannot recognise cipher: " + algorithm);
        }
        return new PaddedBufferedBlockCipher(cipher, new PKCS7Padding());
    }

    public static CipherOutputStream createOutputStream(OutputStream dOut, Object cipher) {
        if (cipher instanceof BufferedBlockCipher) {
            return new CipherOutputStream(dOut, (BufferedBlockCipher)cipher);
        }
        if (cipher instanceof StreamCipher) {
            return new CipherOutputStream(dOut, (StreamCipher)cipher);
        }
        if (cipher instanceof AEADBlockCipher) {
            return new CipherOutputStream(dOut, (AEADBlockCipher)cipher);
        }
        throw new IllegalArgumentException("unknown cipher object: " + cipher);
    }
}

